/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.utils.SystemInfo;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;

public abstract class NumberConverter
implements ObjectConverter {
    private NumberFormat \u0102;
    private boolean \u0103;
    public static final ConverterContext CONTEXT_FRACTION_NUMBER = new ConverterContext("Fraction Number");
    private static boolean \u0104 = true;

    public NumberConverter() {
    }

    public NumberConverter(NumberFormat numberFormat) {
        this.\u0102 = numberFormat;
        if (this.\u0102 != null) {
            this.\u0102.setGroupingUsed(NumberConverter.isGroupingUsed());
        }
    }

    private String \u0101(String string) {
        int n2;
        if (string.indexOf(45) != 0) {
            return string;
        }
        for (n2 = 49; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
            if (string.indexOf(n2) < 0) continue;
            return string;
        }
        for (n2 = 97; n2 <= 102; n2 = (int)((char)(n2 + 1))) {
            if (string.indexOf(n2) < 0) continue;
            return string;
        }
        for (n2 = 65; n2 <= 70; n2 = (int)((char)(n2 + 1))) {
            if (string.indexOf(n2) < 0) continue;
            return string;
        }
        if (string.indexOf(48) < 0) {
            return string;
        }
        return string.substring(1);
    }

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        try {
            if (converterContext == null || converterContext.getUserObject() == null || !(converterContext.getUserObject() instanceof NumberFormat)) {
                if (object instanceof Number && ((Number)object).doubleValue() == Double.NaN) {
                    return "";
                }
                String string = this.getNumberFormat().format(object);
                if (this.isAvoidNegativeZero()) {
                    string = this.\u0101(string);
                }
                return string;
            }
            NumberFormat numberFormat = (NumberFormat)converterContext.getUserObject();
            String string = numberFormat.format(object);
            if (this.isAvoidNegativeZero()) {
                string = this.\u0101(string);
            }
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.\u0102 = numberFormat;
    }

    protected NumberFormat getNumberFormat() {
        if (this.\u0102 == null) {
            this.\u0102 = DecimalFormat.getInstance();
            this.\u0102.setGroupingUsed(NumberConverter.isGroupingUsed());
        }
        return this.\u0102;
    }

    protected NumberFormat getDefaultNumberFormat() {
        NumberFormat numberFormat = DecimalFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(NumberConverter.isGroupingUsed());
        return numberFormat;
    }

    protected Number parseNumber(String string) {
        Number number;
        try {
            number = this.getNumberFormat().parse(string);
        }
        catch (ParseException parseException) {
            try {
                number = this.getDefaultNumberFormat().parse(string);
            }
            catch (ParseException parseException2) {
                number = null;
            }
        }
        return number;
    }

    public static boolean isGroupingUsed() {
        return \u0104;
    }

    public static void setGroupingUsed(boolean bl) {
        \u0104 = bl;
    }

    public void setFractionDigits(int n2, int n3) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setMinimumFractionDigits(n2);
        numberFormat.setMaximumFractionDigits(n3);
    }

    public void setCurrency(Currency currency) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setCurrency(currency);
    }

    public void setIntegerDigits(int n2, int n3) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setMinimumIntegerDigits(n2);
        numberFormat.setMaximumIntegerDigits(n3);
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        if (SystemInfo.isJdk6Above()) {
            NumberFormat numberFormat = this.getNumberFormat();
            numberFormat.setRoundingMode(roundingMode);
        }
    }

    public boolean isAvoidNegativeZero() {
        return this.\u0103;
    }

    public void setAvoidNegativeZero(boolean bl) {
        this.\u0103 = bl;
    }
}

