/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.AlphanumComparator;
import com.jidesoft.comparator.BooleanComparator;
import com.jidesoft.comparator.CalendarComparator;
import com.jidesoft.comparator.CharSequenceComparator;
import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.DateComparator;
import com.jidesoft.comparator.DefaultComparator;
import com.jidesoft.comparator.FastComparableComparator;
import com.jidesoft.comparator.NumberComparator;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.RegistrationListener;
import java.text.Collator;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

public class ObjectComparatorManager {
    private static final CacheMap<Comparator<?>, ComparatorContext> \u0105 = new CacheMap(new ComparatorContext(""));
    private static final Comparator<Object> \u0102 = new DefaultComparator();
    private static boolean \u0103 = false;
    private static boolean \u0101 = false;
    private static boolean \u0104 = true;

    public static void registerComparator(Class<?> clazz, Comparator comparator) {
        ObjectComparatorManager.registerComparator(clazz, comparator, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static void registerComparator(Class<?> clazz, Comparator comparator, ComparatorContext comparatorContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        if (ObjectComparatorManager.isAutoInit() && !\u0103 && !\u0101) {
            ObjectComparatorManager.initDefaultComparator();
        }
        \u0105.register(clazz, comparator, comparatorContext);
    }

    public static void unregisterComparator(Class<?> clazz) {
        ObjectComparatorManager.unregisterComparator(clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static void unregisterComparator(Class<?> clazz, ComparatorContext comparatorContext) {
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        if (ObjectComparatorManager.isAutoInit() && !\u0103 && !\u0101) {
            ObjectComparatorManager.initDefaultComparator();
        }
        \u0105.unregister(clazz, comparatorContext);
    }

    public static void unregisterAllComparators(Class<?> clazz) {
        \u0105.remove(clazz);
    }

    public static void unregisterAllComparators() {
        \u0105.clear();
    }

    public static Comparator getComparator(Class<?> clazz) {
        return ObjectComparatorManager.getComparator(clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static Comparator getComparator(Class<?> clazz, ComparatorContext comparatorContext) {
        Comparator<?> comparator;
        if (ObjectComparatorManager.isAutoInit() && !\u0103 && !\u0101) {
            ObjectComparatorManager.initDefaultComparator();
        }
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        if ((comparator = \u0105.getRegisteredObject(clazz, comparatorContext)) != null) {
            return comparator;
        }
        return \u0102;
    }

    public static int compare(Object object, Object object2) {
        return ObjectComparatorManager.compare(object, object2, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static int compare(Object object, Object object2, ComparatorContext comparatorContext) {
        Class<?> clazz;
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Class<?> clazz2 = object.getClass();
        Class<Object> clazz3 = clazz2 == (clazz = object2.getClass()) ? clazz2 : (clazz2.isAssignableFrom(clazz) ? clazz2 : (clazz.isAssignableFrom(clazz2) ? clazz : (Comparable.class.isAssignableFrom(clazz2) && Comparable.class.isAssignableFrom(clazz) ? Comparable.class : Object.class)));
        return ObjectComparatorManager.compare(object, object2, clazz3, comparatorContext);
    }

    public static int compare(Object object, Object object2, Class<?> clazz) {
        return ObjectComparatorManager.compare(object, object2, clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static int compare(Object object, Object object2, Class<?> clazz, ComparatorContext comparatorContext) {
        Comparator comparator = ObjectComparatorManager.getComparator(clazz, comparatorContext);
        if (comparator != null) {
            try {
                return comparator.compare(object, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return object.toString().compareTo(object2.toString());
    }

    public static boolean isAutoInit() {
        return \u0104;
    }

    public static void setAutoInit(boolean bl) {
        \u0104 = bl;
    }

    public static void addRegistrationListener(RegistrationListener registrationListener) {
        \u0105.addRegistrationListener(registrationListener);
    }

    public static void removeRegistrationListener(RegistrationListener registrationListener) {
        \u0105.removeRegistrationListener(registrationListener);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return \u0105.getRegistrationListeners();
    }

    public static ComparatorContext[] getComparatorContexts(Class<?> clazz) {
        return \u0105.getKeys(clazz, (ComparatorContext[])new ComparatorContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultComparator() {
        if (\u0103) {
            return;
        }
        \u0101 = true;
        try {
            ObjectComparatorManager.registerComparator(Object.class, new DefaultComparator());
            ObjectComparatorManager.registerComparator(Boolean.class, new BooleanComparator());
            ObjectComparatorManager.registerComparator(Calendar.class, new CalendarComparator());
            ObjectComparatorManager.registerComparator(Date.class, new DateComparator());
            NumberComparator numberComparator = new NumberComparator();
            ObjectComparatorManager.registerComparator(Number.class, numberComparator);
            ObjectComparatorManager.registerComparator(Double.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Float.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Long.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Integer.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Short.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Byte.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Double.class, numberComparator);
            ObjectComparatorManager.registerComparator(Float.class, numberComparator);
            ObjectComparatorManager.registerComparator(Long.class, numberComparator);
            ObjectComparatorManager.registerComparator(Integer.class, numberComparator);
            ObjectComparatorManager.registerComparator(Short.class, numberComparator);
            ObjectComparatorManager.registerComparator(Byte.class, numberComparator);
            NumberComparator numberComparator2 = new NumberComparator();
            numberComparator2.setAbsolute(true);
            ObjectComparatorManager.registerComparator(Number.class, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Double.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Float.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Long.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Integer.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Short.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Byte.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Double.class, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Float.class, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Long.class, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Integer.class, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Short.class, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Byte.class, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Comparable.class, new FastComparableComparator());
            ObjectComparatorManager.registerComparator(String.class, Collator.getInstance());
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            ObjectComparatorManager.registerComparator(String.class, collator, new ComparatorContext("Ignorecase"));
            Collator collator2 = Collator.getInstance();
            collator2.setStrength(1);
            ObjectComparatorManager.registerComparator(String.class, collator2, new ComparatorContext("Secondary"));
            ObjectComparatorManager.registerComparator(CharSequence.class, new CharSequenceComparator(), CharSequenceComparator.CONTEXT);
            ObjectComparatorManager.registerComparator(CharSequence.class, new CharSequenceComparator(false), CharSequenceComparator.CONTEXT_IGNORE_CASE);
            ObjectComparatorManager.registerComparator(CharSequence.class, new AlphanumComparator(), AlphanumComparator.CONTEXT);
            ObjectComparatorManager.registerComparator(CharSequence.class, new AlphanumComparator(false), AlphanumComparator.CONTEXT_IGNORE_CASE);
        }
        finally {
            \u0101 = false;
            \u0103 = true;
        }
    }

    public static void resetInit() {
        \u0103 = false;
    }

    public static void clear() {
        ObjectComparatorManager.resetInit();
        \u0105.clear();
    }
}

