/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.FontChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class FontExComboBox
extends ExComboBox {
    public FontExComboBox() {
        super(0);
        this.setType(Font.class);
    }

    public FontExComboBox(Font font) {
        super(0);
        this.setType(Font.class);
        this.setSelectedFont(font);
    }

    @Override
    public PopupPanel createPopupComponent() {
        PopupPanel popupPanel = this.createFontChooserPanel();
        popupPanel.addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = FontExComboBox.this.getSelectedItem();
                FontExComboBox.this.setSelectedItem(propertyChangeEvent.getNewValue(), false);
                FontExComboBox.this.fireItemStateChanged(new ItemEvent(FontExComboBox.this, 701, object, 2));
                FontExComboBox.this.fireItemStateChanged(new ItemEvent(FontExComboBox.this, 701, propertyChangeEvent.getNewValue(), 1));
            }
        });
        return popupPanel;
    }

    protected PopupPanel createFontChooserPanel() {
        return new FontChooserPanel(this.getDefaultOKAction(), this.getDefaultCancelAction());
    }

    public Font getSelectedFont() {
        this.updateFontFromEditorComponent();
        if (this.getSelectedItem() instanceof Font) {
            return (Font)this.getSelectedItem();
        }
        return null;
    }

    protected void updateFontFromEditorComponent() {
        Object object = this.getEditor().getItem();
        Object object2 = this.getSelectedItem();
        if (object instanceof Font && !object.equals(object2)) {
            this.setSelectedItem(object, false);
        } else if (object == null && object2 != null) {
            this.setSelectedItem(null, false);
        }
    }

    public void setSelectedFont(Font font) {
        this.setSelectedItem(font);
    }

    @Override
    protected boolean isUpdateFromPopupOnFly() {
        return false;
    }
}

