/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DateFilter;
import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DateModelEvent;
import com.jidesoft.combobox.DateModelListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.event.EventListenerList;

public class DefaultDateModel
implements DateModel {
    private EventListenerList \u0102 = new EventListenerList();
    private final DateFormat \u010b = DateFormat.getDateInstance(3);
    private Calendar \u0107;
    private Calendar \u0109;
    private Map<String, Calendar> \u0108 = new HashMap<String, Calendar>();
    private List<DateFilter> \u0101 = new ArrayList<DateFilter>();
    private Calendar \u0104;
    private Calendar \u0106;
    private String \u010a;
    private DateFormat \u0105;
    private boolean \u0103 = false;
    public static final DateFilter WEEKDAY_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            int n2 = calendar.get(7);
            return n2 != 1 && n2 != 7;
        }

        @Override
        public Calendar getMinDate() {
            return null;
        }

        @Override
        public Calendar getMaxDate() {
            return null;
        }
    };
    public static final DateFilter THIS_WEEK = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            return calendar.get(3) == calendar2.get(3) && calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(7, calendar.getActualMaximum(7));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(7, calendar.getActualMinimum(7));
            return calendar;
        }
    };
    public static final DateFilter THIS_MONTH_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            return calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMaximum(5));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMinimum(5));
            return calendar;
        }
    };
    public static final DateFilter LATER_THIS_MONTH = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            return calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1) && calendar.get(5) > calendar2.get(5);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMaximum(5));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            return Calendar.getInstance();
        }
    };
    public static final DateFilter WEEKEND_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            int n2 = calendar.get(7);
            return n2 == 1 || n2 == 7;
        }

        @Override
        public Calendar getMinDate() {
            return null;
        }

        @Override
        public Calendar getMaxDate() {
            return null;
        }
    };
    public static final DateFilter THIS_YEAR_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            return calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.getActualMaximum(6));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.getActualMinimum(6));
            return calendar;
        }
    };
    public static final DateFilter NEXT_YEAR_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 1);
            return calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, 1);
            calendar.set(6, calendar.getActualMaximum(6));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, 1);
            calendar.set(6, calendar.getActualMinimum(6));
            return calendar;
        }
    };
    public static final DateFilter PREVIOUS_YEAR_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, -1);
            return calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -1);
            calendar.set(6, calendar.getActualMaximum(6));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -1);
            calendar.set(6, calendar.getActualMinimum(6));
            return calendar;
        }
    };

    public DefaultDateModel() {
        this(null, null);
    }

    public DefaultDateModel(Calendar calendar, Calendar calendar2) {
        this.\u0107 = calendar;
        this.\u0109 = calendar2;
    }

    private Calendar \u0104() {
        Calendar calendar = null;
        for (DateFilter dateFilter : this.\u0101) {
            Calendar calendar2 = dateFilter.getMinDate();
            if (calendar2 == null || calendar != null && DefaultDateModel.\u0101(calendar2, calendar) != -1) continue;
            calendar = calendar2;
        }
        return calendar;
    }

    private Calendar \u0103() {
        Calendar calendar = null;
        for (DateFilter dateFilter : this.\u0101) {
            Calendar calendar2 = dateFilter.getMaxDate();
            if (calendar2 == null || calendar != null && DefaultDateModel.\u0101(calendar, calendar2) != -1) continue;
            calendar = calendar2;
        }
        return calendar;
    }

    @Override
    public Calendar getMinDate() {
        Calendar calendar = this.\u0104();
        if (calendar != null && this.\u0107 != null && DefaultDateModel.\u0101(calendar, this.\u0107) == 1) {
            return (Calendar)calendar.clone();
        }
        if (this.\u0107 == null) {
            return null;
        }
        return (Calendar)this.\u0107.clone();
    }

    @Override
    public void setMinDate(Calendar calendar) {
        if (calendar == null) {
            this.\u0107 = null;
        } else {
            if (this.\u0109 != null && DefaultDateModel.\u0101(calendar, this.\u0109) > 0) {
                throw new IllegalArgumentException("Minimum date cannot be greater than Maximum date");
            }
            this.\u0107 = (Calendar)calendar.clone();
        }
        this.\u0101();
        this.fireDateModelChanged(new DateModelEvent(this, 2));
    }

    @Override
    public Calendar getMaxDate() {
        Calendar calendar = this.\u0103();
        if (calendar != null && this.\u0109 != null && DefaultDateModel.\u0101(calendar, this.\u0109) == -1) {
            return (Calendar)calendar.clone();
        }
        if (this.\u0109 == null) {
            return null;
        }
        return (Calendar)this.\u0109.clone();
    }

    @Override
    public void setMaxDate(Calendar calendar) {
        if (calendar == null) {
            this.\u0109 = calendar;
        } else {
            if (this.\u0107 != null && DefaultDateModel.\u0101(this.\u0107, calendar) > 0) {
                throw new IllegalArgumentException("Maximum date cannot be less than minimum date");
            }
            this.\u0109 = (Calendar)calendar.clone();
        }
        this.\u0101();
        this.fireDateModelChanged(new DateModelEvent(this, 2));
    }

    private static int \u0101(Calendar calendar, Calendar calendar2) {
        return DefaultDateModel.\u0101(calendar, calendar2, 5);
    }

    private static int \u0101(Calendar calendar, Calendar calendar2, int n2) {
        if (calendar.get(1) > calendar2.get(1)) {
            return 1;
        }
        if (calendar.get(1) < calendar2.get(1)) {
            return -1;
        }
        if (n2 == 1) {
            return 0;
        }
        if (calendar.get(2) > calendar2.get(2)) {
            return 1;
        }
        if (calendar.get(2) < calendar2.get(2)) {
            return -1;
        }
        if (n2 == 2) {
            return 0;
        }
        if (calendar.get(5) > calendar2.get(5)) {
            return 1;
        }
        if (calendar.get(5) < calendar2.get(5)) {
            return -1;
        }
        if (n2 == 5) {
            return 0;
        }
        if (calendar.get(11) > calendar2.get(11)) {
            return 1;
        }
        if (calendar.get(11) < calendar2.get(11)) {
            return -1;
        }
        if (n2 == 11) {
            return 0;
        }
        if (calendar.get(12) > calendar2.get(12)) {
            return 1;
        }
        if (calendar.get(12) < calendar2.get(12)) {
            return -1;
        }
        if (n2 == 12) {
            return 0;
        }
        if (calendar.get(13) > calendar2.get(13)) {
            return 1;
        }
        if (calendar.get(13) < calendar2.get(13)) {
            return -1;
        }
        return 0;
    }

    private void \u0102() {
        if (this.\u0104 == null) {
            this.\u0104 = this.getMinDate();
        }
        if (this.\u0106 == null) {
            this.\u0106 = this.getMaxDate();
        }
    }

    private void \u0101() {
        this.\u0104 = null;
        this.\u0106 = null;
    }

    @Override
    public boolean timeInRange(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.\u0102();
        if (this.\u0104 != null && DefaultDateModel.\u0101(this.\u0104, calendar, 13) == 1) {
            return false;
        }
        return this.\u0106 == null || DefaultDateModel.\u0101(calendar, this.\u0106, 13) != 1;
    }

    @Override
    public boolean dayInRange(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.\u0102();
        if (this.\u0104 != null && DefaultDateModel.\u0101(this.\u0104, calendar) == 1) {
            return false;
        }
        return this.\u0106 == null || DefaultDateModel.\u0101(calendar, this.\u0106) != 1;
    }

    @Override
    public boolean monthInRange(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.\u0102();
        if (this.\u0104 != null && DefaultDateModel.\u0101(this.\u0104, calendar, 2) == 1) {
            return false;
        }
        return this.\u0106 == null || DefaultDateModel.\u0101(calendar, this.\u0106, 2) != 1;
    }

    @Override
    public boolean yearInRange(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.\u0102();
        if (this.\u0104 != null && DefaultDateModel.\u0101(this.\u0104, calendar, 1) == 1) {
            return false;
        }
        return this.\u0106 == null || DefaultDateModel.\u0101(calendar, this.\u0106, 1) != 1;
    }

    public void clearDateFilters() {
        this.\u0101.clear();
        this.\u0101();
        this.fireDateModelChanged(new DateModelEvent(this, 1));
    }

    public void addDateFilter(DateFilter dateFilter) {
        this.\u0101.add(dateFilter);
        this.\u0101();
        this.fireDateModelChanged(new DateModelEvent(this, 1));
    }

    public void removeDateFilter(DateFilter dateFilter) {
        this.\u0101.remove(dateFilter);
        this.\u0101();
        this.fireDateModelChanged(new DateModelEvent(this, 1));
    }

    @Override
    public boolean isValidDate(Calendar calendar) {
        if (calendar == null) {
            return true;
        }
        if (this.isCompareTime() ? !this.timeInRange(calendar) : !this.dayInRange(calendar)) {
            return false;
        }
        if (this.\u0108.containsKey(this.\u010b.format(calendar.getTime()))) {
            return false;
        }
        for (DateFilter dateFilter : this.\u0101) {
            if (dateFilter.isDateValid(calendar)) continue;
            return false;
        }
        return true;
    }

    public void clearInvalidDates() {
        this.\u0108.clear();
        this.fireDateModelChanged(new DateModelEvent(this, 0));
    }

    public void addInvalidDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("null is not allowed at blackout date");
        }
        this.\u0108.put(this.\u010b.format(calendar.getTime()), calendar);
        this.fireDateModelChanged(new DateModelEvent(this, 0));
    }

    public void removeInvalidDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("null is not allowed at blackout date");
        }
        this.\u0108.remove(this.\u010b.format(calendar.getTime()));
        this.fireDateModelChanged(new DateModelEvent(this, 0));
    }

    @Override
    public String getTimeFormat() {
        return this.\u010a;
    }

    @Override
    public void setTimeFormat(String string) {
        this.\u010a = string;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.getDateFormat() == null) {
            return TimeZone.getDefault();
        }
        return this.getDateFormat().getTimeZone();
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (this.getDateFormat() == null) {
            this.setDateFormat(DateFormat.getDateInstance());
        }
        this.getDateFormat().setTimeZone(timeZone);
    }

    @Override
    public DateFormat getDateFormat() {
        return this.\u0105;
    }

    @Override
    public void setDateFormat(DateFormat dateFormat) {
        this.\u0105 = dateFormat;
    }

    @Override
    public Calendar createCalendarInstance() {
        if (this.getDateFormat() == null) {
            return Calendar.getInstance();
        }
        return Calendar.getInstance(this.getDateFormat().getTimeZone());
    }

    @Override
    public void addDateModelListener(DateModelListener dateModelListener) {
        DateModelListener[] dateModelListenerArray;
        for (DateModelListener dateModelListener2 : dateModelListenerArray = this.getDateModelListeners()) {
            if (dateModelListener2 != dateModelListener) continue;
            return;
        }
        this.\u0102.add(DateModelListener.class, dateModelListener);
    }

    @Override
    public void removeDateModelListener(DateModelListener dateModelListener) {
        this.\u0102.remove(DateModelListener.class, dateModelListener);
    }

    public DateModelListener[] getDateModelListeners() {
        return (DateModelListener[])this.\u0102.getListeners(DateModelListener.class);
    }

    public void fireDateModelChanged(DateModelEvent dateModelEvent) {
        Object[] objectArray = this.\u0102.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != DateModelListener.class) continue;
            ((DateModelListener)objectArray[i2 + 1]).dateModelChanged(dateModelEvent);
        }
    }

    @Override
    public boolean isCompareTime() {
        return this.\u0103;
    }

    @Override
    public void setCompareTime(boolean bl) {
        this.\u0103 = bl;
    }
}

