/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.LineSmoother;
import com.jidesoft.chart.render.AbstractLineRenderer;
import com.jidesoft.chart.render.LineRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.LineFillExtent;
import com.jidesoft.chart.style.LineStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;

public class SmoothLineRenderer
extends AbstractLineRenderer
implements LineRenderer2D {
    private static final Logger \u0107 = Logger.getLogger(SmoothLineRenderer.class.getName());
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_SMOOTHNESS = "Smoothness";
    private PropertyChangeSupport \u0109 = new PropertyChangeSupport(this);
    private WeakReference<Chart> \u0108;
    private double \u010a = 0.5;

    public SmoothLineRenderer(Chart chart) {
        this.setChart(chart);
    }

    public Chart getChart() {
        if (this.\u0108 == null) {
            return null;
        }
        return (Chart)this.\u0108.get();
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.getChart();
        this.\u0108 = new WeakReference<Chart>(chart);
        this.\u0109.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public double getSmoothness() {
        return this.\u010a;
    }

    public void setSmoothness(double d2) {
        double d3 = this.\u010a;
        this.\u010a = d2;
        this.\u0109.firePropertyChange(PROPERTY_SMOOTHNESS, d3, d2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0109.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0109.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Shape renderLine(Graphics2D graphics2D, ChartModel chartModel, double[] dArray, double[] dArray2, ChartStyle chartStyle) {
        assert (dArray.length == dArray2.length);
        Chart chart = this.getChart();
        if (chart == null) {
            \u0107.warning("Chart property is null in SmoothLineRenderer " + this);
            return null;
        }
        BasicStroke basicStroke = chartStyle == null ? LineStyle.DEFAULT_STROKE : chartStyle.getLineStroke();
        graphics2D.setStroke(basicStroke);
        if (dArray.length < 2) {
            return null;
        }
        if (dArray.length == 2) {
            return this.\u0102(graphics2D, chartModel, dArray, dArray2, chartStyle);
        }
        return this.\u0101(graphics2D, chartModel, dArray, dArray2, chartStyle);
    }

    private Shape \u0102(Graphics2D graphics2D, ChartModel chartModel, double[] dArray, double[] dArray2, ChartStyle chartStyle) {
        LineStyle lineStyle;
        Line2D.Double double_ = new Line2D.Double(dArray[0], dArray2[0], dArray[1], dArray2[1]);
        Chart chart = this.getChart();
        Axis axis = chart.getXAxis();
        Axis axis2 = chart.getYAxis();
        Color color = chartStyle == null ? Color.BLACK : chartStyle.getLineColor();
        LineStyle lineStyle2 = lineStyle = chartStyle == null ? new LineStyle() : chartStyle.getLineStyle();
        if (lineStyle.getFill() != null) {
            GeneralPath generalPath = LineSmoother.preparePath(this.getChart(), dArray, dArray2, this.\u010a);
            Rectangle rectangle = generalPath.getBounds();
            Paint paint = this.createLineFillPaint(chartModel, chartStyle, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setPaint(paint);
            UserToPixelTransform userToPixelTransform = chart.getTransformForModel(chartModel);
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.append(generalPath, true);
            generalPath.closePath();
            graphics2D.fill(generalPath);
            if (chartModel == null || !chartModel.isCyclical()) {
                if (lineStyle.getFillOrientation() == Orientation.vertical || chartModel == null) {
                    LineFillExtent lineFillExtent = lineStyle.getFillExtent();
                    float f2 = this.calculateYVerticalExtent(chart, chartModel, lineFillExtent);
                    generalPath2.lineTo((float)dArray[dArray.length - 1], f2);
                    generalPath2.lineTo((float)dArray[0], f2);
                } else {
                    LineFillExtent lineFillExtent = lineStyle.getFillExtent();
                    float f3 = this.calculateXHorizontalExtent(chart, chartModel, lineFillExtent);
                    generalPath2.lineTo(f3, (float)dArray2[dArray2.length - 1]);
                    generalPath2.lineTo(f3, (float)dArray2[0]);
                }
            }
            generalPath2.closePath();
            graphics2D.draw(generalPath2);
            graphics2D.fill(generalPath2);
        }
        graphics2D.setColor(color);
        graphics2D.draw(double_);
        return double_;
    }

    private Shape \u0101(Graphics2D graphics2D, ChartModel chartModel, double[] dArray, double[] dArray2, ChartStyle chartStyle) {
        Chart chart = this.getChart();
        Axis axis = chart.getXAxis();
        Axis axis2 = chart.getYAxis();
        Color color = chartStyle == null ? Color.BLACK : chartStyle.getLineColor();
        LineStyle lineStyle = chartStyle == null ? new LineStyle() : chartStyle.getLineStyle();
        GeneralPath generalPath = chartModel != null && chartModel.isCyclical() ? LineSmoother.prepareCyclicPath(this.getChart(), dArray, dArray2, this.\u010a) : LineSmoother.preparePath(this.getChart(), dArray, dArray2, this.\u010a);
        if (chartStyle != null && dArray.length > 0 && lineStyle.getFill() != null) {
            Object object;
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.append(generalPath, true);
            if (chartModel == null || !chartModel.isCyclical()) {
                float f2;
                if (lineStyle.getFillOrientation() == Orientation.vertical || chartModel == null) {
                    object = lineStyle.getFillExtent();
                    f2 = this.calculateYVerticalExtent(chart, chartModel, (LineFillExtent)((Object)object));
                    generalPath2.lineTo((float)dArray[dArray.length - 1], f2);
                    generalPath2.lineTo((float)dArray[0], f2);
                } else {
                    object = lineStyle.getFillExtent();
                    f2 = this.calculateXHorizontalExtent(chart, chartModel, (LineFillExtent)((Object)object));
                    generalPath2.lineTo(f2, (float)dArray2[dArray.length - 1]);
                    generalPath2.lineTo(f2, (float)dArray2[0]);
                }
            }
            generalPath2.closePath();
            object = generalPath.getBounds();
            Paint paint = this.createLineFillPaint(chartModel, chartStyle, ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics2D.setPaint(paint);
            graphics2D.draw(generalPath2);
            graphics2D.fill(generalPath2);
        }
        graphics2D.setColor(color);
        graphics2D.draw(generalPath);
        return generalPath;
    }

    @Override
    public Shape renderLine(Graphics graphics, ChartModel chartModel, int[] nArray, int[] nArray2, ChartStyle chartStyle) {
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray2.length];
        assert (nArray.length == nArray2.length);
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dArray[i2] = nArray[i2];
            dArray2[i2] = nArray2[i2];
        }
        return this.renderLine(graphics2D, chartModel, dArray, dArray2, chartStyle);
    }
}

