/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.ChartableND;
import com.jidesoft.chart.render.AbstractPointRenderer;
import com.jidesoft.chart.render.CandlestickChartType;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CandlestickPointRenderer
extends AbstractPointRenderer {
    public static final String PROPERTY_CANDLESTICK_TYPE = "Candlestick Type";
    private CandlestickChartType \u0131 = CandlestickChartType.BAR;
    private double \u0130 = 0.5;
    private Integer \u0132 = null;

    public CandlestickPointRenderer() {
        this.setOutlineColor(Color.black);
    }

    public CandlestickPointRenderer(CandlestickChartType candlestickChartType) {
        this.setCandlestickType(candlestickChartType);
        this.setOutlineColor(Color.black);
    }

    public CandlestickChartType getCandlestickType() {
        return this.\u0131;
    }

    public double getLineTickLengthProportion() {
        return this.\u0130;
    }

    public void setLineTickLengthProportion(double d2) {
        this.\u0130 = d2;
    }

    public Integer getTickLength() {
        return this.\u0132;
    }

    public void setTickLength(Integer n2) {
        this.\u0132 = n2;
    }

    public void setCandlestickType(CandlestickChartType candlestickChartType) {
        CandlestickChartType candlestickChartType2 = this.\u0131;
        this.\u0131 = candlestickChartType;
        this.support.firePropertyChange(PROPERTY_CANDLESTICK_TYPE, (Object)candlestickChartType2, (Object)candlestickChartType);
    }

    @Override
    public Shape renderPoint(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        ChartStyle chartStyle = this.getStyle(chart, chartModel, chartable, bl, bl2, bl3);
        if (!chartStyle.isPointsVisible()) {
            return null;
        }
        if (chartable == null || !(chartable instanceof ChartableND)) {
            return null;
        }
        ChartableND chartableND = (ChartableND)chartable;
        double d2 = chartableND.get(0).position();
        double d3 = chartableND.get(1).position();
        double d4 = chartableND.get(2).position();
        double d5 = chartableND.get(3).position();
        Point2D point2D = chart.calculatePixelPoint2D(new Point2D.Double(d2 - d4 / 2.0, d3 - d5 / 2.0));
        Point2D point2D2 = chart.calculatePixelPoint2D(new Point2D.Double(d2 + d4 / 2.0, d3 + d5 / 2.0));
        double d6 = chartableND.get(4).position();
        double d7 = chartableND.get(5).position();
        Point point = chart.calculatePixelPoint(new Point2D.Double(d2, d6));
        Point point2 = chart.calculatePixelPoint(new Point2D.Double(d2, d7));
        Shape shape = this.\u0131 == CandlestickChartType.LINE ? this.\u0102(graphics2D, chart, n2, n3, point2D, point2D2, point2, point, chartStyle) : this.\u0101(graphics2D, chart, n2, n3, point2D, point2D2, point2, point, chartStyle);
        return shape;
    }

    private Shape \u0102(Graphics2D graphics2D, Chart chart, int n2, int n3, Point2D point2D, Point2D point2D2, Point point, Point point2, ChartStyle chartStyle) {
        double d2 = point2D2.getX() - point2D.getX();
        double d3 = this.\u0132 != null ? (double)this.\u0132.intValue() : d2 * this.\u0130;
        BasicStroke basicStroke = chartStyle.getLineStroke();
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        Color color = chartStyle.getPointColor();
        graphics2D.setColor(color);
        graphics2D.drawLine(n2, point.y, n2, point2.y);
        Line2D.Double double_ = new Line2D.Double((double)n2 - d3, point2D.getY(), n2, point2D.getY());
        graphics2D.draw(double_);
        Line2D.Double double_2 = new Line2D.Double(n2, point2D2.getY(), (double)n2 + d3, point2D2.getY());
        graphics2D.draw(double_2);
        return null;
    }

    private Shape \u0101(Graphics2D graphics2D, Chart chart, int n2, int n3, Point2D point2D, Point2D point2D2, Point point, Point point2, ChartStyle chartStyle) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = Math.abs(point2D.getY() - point2D2.getY());
        double d9 = Math.abs(point2D2.getX() - point2D.getX());
        double d10 = point2D.getY() > point2D2.getY() ? point2D.getY() : point2D2.getY();
        double d11 = d7 = point2D.getY() > point2D2.getY() ? point2D2.getY() : point2D.getY();
        assert (d10 >= d7);
        graphics2D.setColor(this.getOutlineColor());
        if (chart.getAnimationPosition() == 1.0) {
            d6 = d7;
            d5 = d7;
            d4 = d10;
            d3 = point.y;
            d2 = point2.y;
        } else {
            double d12 = chart.getAnimationPosition();
            d6 = (int)((double)n3 - d12 * ((d8 - 1.0) / 2.0));
            d5 = (int)((double)n3 + d12 * (d7 - (double)n3));
            d4 = (int)((double)n3 + d12 * (d10 - (double)n3));
            d3 = (int)((double)n3 + d12 * (double)(point.y - n3));
            d2 = (int)((double)n3 + d12 * (double)(point2.y - n3));
        }
        Line2D.Double double_ = new Line2D.Double(n2, d5, n2, d2);
        graphics2D.draw(double_);
        Line2D.Double double_2 = new Line2D.Double(n2, d4, n2, d3);
        graphics2D.draw(double_2);
        Color color = chartStyle.getPointColor();
        graphics2D.setColor(color);
        double d13 = (double)n2 - (d9 - 1.0) / 2.0;
        graphics2D.setColor(chartStyle.getPointColor());
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d13, d6, d9, d8);
        graphics2D.fill(double_3);
        graphics2D.setColor(this.getOutlineColor());
        graphics2D.draw(double_3);
        return double_3;
    }
}

