/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.commons.math.linear.RealMatrixImpl;

public class PolynomialFitter
implements CurveFitter {
    private int \u0104;

    public PolynomialFitter(int n2) {
        this.setOrder(n2);
    }

    public void setOrder(int n2) {
        assert (n2 >= 0);
        this.\u0104 = n2;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        double d2;
        int n2;
        double[][] dArray = new double[this.\u0104 + 1][this.\u0104 + 1];
        for (int i2 = 0; i2 <= this.\u0104; ++i2) {
            for (n2 = 0; n2 <= this.\u0104; ++n2) {
                dArray[i2][n2] = d2 = this.\u0102(chartModel, i2 + n2, 0);
            }
        }
        double[] dArray2 = new double[this.\u0104 + 1];
        for (n2 = 0; n2 <= this.\u0104; ++n2) {
            dArray2[n2] = d2 = this.\u0102(chartModel, n2, 1);
        }
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl(dArray);
        double[] dArray3 = realMatrixImpl.solve(dArray2);
        return new Polynomial(dArray3);
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n2) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, range, n2);
    }

    @Override
    public AnnotatedChartModel createModel(Polynomial polynomial, Range<?> range, int n2) {
        return this.createModel(null, polynomial, range, n2);
    }

    @Override
    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n2) {
        double d2 = range.minimum();
        double d3 = range.maximum();
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        double d4 = (d3 - d2) / (double)(n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d5 = d2 + (double)i2 * d4;
            double d6 = polynomial.eval(d5);
            defaultChartModel.addPoint(d5, d6);
        }
        return defaultChartModel;
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        for (Double d2 : doubleArray) {
            double d3 = polynomial.eval(d2);
            defaultChartModel.addPoint((double)d2, d3);
        }
        return defaultChartModel;
    }

    public Polynomial performRegression(List<? extends Point2D> list) {
        throw new UnsupportedOperationException();
    }

    private double \u0102(ChartModel chartModel, int n2, int n3) {
        double d2 = 0.0;
        for (Chartable chartable : chartModel) {
            d2 += Math.pow(chartable.getX().position(), n2) * Math.pow(chartable.getY().position(), n3);
        }
        return d2;
    }
}

