/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartException;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.event.PointSelection;
import com.jidesoft.chart.fit.FunctionMap;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ChartCrossHair
implements MouseListener,
MouseMotionListener,
ComponentListener,
Drawable {
    public static final String PROPERTY_COLOR = "Color";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_CIRCLE_DIAMETER = "Circle Diameter";
    public static final String PROPERTY_MODEL = "Model";
    public static final String PROPERTY_OBSERVED_MODEL = "Model Observed";
    public static final String PROPERTY_POSITION = "Position";
    public static final String PROPERTY_SNAP_TO_POINTS = "Snap to Points";
    public static final String PROPERTY_STROKE = "Stroke";
    public static final String PROPERTY_UPDATE_FROM_MODEL = "Update From Model";
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_HORIZONTAL_LINE_VISIBLE = "Horizontal Line Visible";
    public static final String PROPERTY_VERTICAL_LINE_VISIBLE = "Vertical Line Visible";
    private int \u01d1 = 10;
    private Chart \u01cf;
    private Point \u01d6 = null;
    private ChartModel \u01ca = null;
    private boolean \u01d3 = true;
    private ChartModel \u01cb = null;
    private Color \u01d2 = Color.orange.darker();
    private Stroke \u01cc = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{5.0f}, 0.0f);
    private boolean \u01c9 = false;
    private boolean \u01d4 = true;
    private boolean \u01cd = true;
    private Point \u01d0 = null;
    private Point \u01d8 = null;
    private boolean \u01d5 = false;
    private PropertyChangeSupport \u01ce = new PropertyChangeSupport(this);
    private Chartable \u01d7;

    public ChartCrossHair() {
    }

    public ChartCrossHair(Chart chart) {
        this(chart, false);
    }

    public ChartCrossHair(Chart chart, boolean bl) {
        if (bl) {
            chart.addMouseListener(this);
            chart.addMouseMotionListener(this);
            chart.addDrawable(this);
        }
        this.setChart(chart);
    }

    public void detach() {
        if (this.\u01cf != null) {
            this.\u01cf.removeMouseListener(this);
            this.\u01cf.removeMouseMotionListener(this);
            this.\u01cf.removeComponentListener(this);
            this.\u01cf.removeDrawable(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u01ce.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u01ce.removePropertyChangeListener(propertyChangeListener);
    }

    public Chart getChart() {
        return this.\u01cf;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.\u01cf;
        if (chart2 != null) {
            chart2.removeComponentListener(this);
        }
        this.\u01cf = chart;
        if (chart != null) {
            chart.addComponentListener(this);
        }
        this.\u01ce.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public boolean isVerticalLineVisible() {
        return this.\u01d4;
    }

    public void setVerticalLineVisible(boolean bl) {
        boolean bl2 = this.\u01d4;
        this.\u01d4 = bl;
        this.\u01ce.firePropertyChange(PROPERTY_VERTICAL_LINE_VISIBLE, bl2, bl);
    }

    public boolean isHorizontalLineVisible() {
        return this.\u01cd;
    }

    public void setHorizontalLineVisible(boolean bl) {
        boolean bl2 = this.\u01cd;
        this.\u01cd = bl;
        this.\u01ce.firePropertyChange(PROPERTY_HORIZONTAL_LINE_VISIBLE, bl2, bl);
    }

    public boolean isSnapToPoints() {
        return this.\u01d5;
    }

    public void setSnapToPoints(boolean bl) {
        boolean bl2 = this.\u01d5;
        this.\u01d5 = bl;
        this.\u01ce.firePropertyChange(PROPERTY_SNAP_TO_POINTS, bl2, bl);
    }

    public boolean isUpdateFromModel() {
        return this.\u01d3;
    }

    public void setUpdateFromModel(boolean bl) {
        boolean bl2 = this.\u01d3;
        this.\u01d3 = bl;
        this.\u01ce.firePropertyChange(PROPERTY_UPDATE_FROM_MODEL, bl2, bl);
    }

    public Stroke getStroke() {
        return this.\u01cc;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.\u01cc;
        this.\u01cc = stroke;
        this.\u01ce.firePropertyChange(PROPERTY_STROKE, stroke2, stroke);
    }

    public Point getXAxisPoint() {
        return this.\u01d0;
    }

    public Point getYAxisPoint() {
        return this.\u01d8;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.\u01d6 = mouseEvent.getPoint();
        this.update();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.\u0101(true);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.\u01d6 = null;
        this.\u0101(false);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.\u01d6 = mouseEvent.getPoint();
        this.update();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.update();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public ChartModel getModel() {
        return this.\u01ca;
    }

    public void setModel(ChartModel chartModel) {
        ChartModel chartModel2 = this.\u01ca;
        this.\u01ca = chartModel;
        this.\u01ce.firePropertyChange(PROPERTY_MODEL, chartModel2, chartModel);
    }

    public Color getColor() {
        return this.\u01d2;
    }

    public void setColor(Color color) {
        Color color2 = this.\u01d2;
        this.\u01d2 = color;
        this.\u01ce.firePropertyChange(PROPERTY_COLOR, color2, color);
    }

    private void \u0101(boolean bl) {
        boolean bl2 = this.\u01c9;
        this.\u01c9 = bl;
        this.\u01ce.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
    }

    public ChartModel getObservedModel() {
        return this.\u01cb;
    }

    private void \u0105(ChartModel chartModel) {
        ChartModel chartModel2 = this.\u01cb;
        this.\u01cb = chartModel;
        this.\u01ce.firePropertyChange(PROPERTY_OBSERVED_MODEL, chartModel2, chartModel);
    }

    public void update() {
        if (this.\u01cf == null) {
            throw new NullPointerException("Chart property is null");
        }
        if (!this.\u01d3) {
            if (this.\u01d7 != null) {
                this.\u01d0 = this.\u01cf.calculatePixelPoint((Point2D)new Point2D.Double(this.\u01d7.getX().position(), 0.0), this.\u01cf.getXAxis());
                this.\u01d8 = this.\u01cf.calculatePixelPoint((Point2D)new Point2D.Double(0.0, this.\u01d7.getY().position()), this.\u01cf.getYAxis());
                this.\u0101(true);
            } else {
                this.\u0101(false);
            }
            return;
        }
        ChartModel chartModel = this.\u01ca == null ? this.\u01cf.nearestModel(this.\u01d6) : this.\u01ca;
        this.\u0105(chartModel);
        Axis axis = this.\u01cf.getAxisForModel(chartModel);
        if (this.\u01d6 != null && chartModel != null && chartModel.getPointCount() >= 1) {
            if (this.\u01d5) {
                PointSelection pointSelection = this.\u01cf.nearestPoint(this.\u01d6, chartModel);
                if (pointSelection == null) {
                    this.setPosition(null);
                    this.\u0101(false);
                } else {
                    Chartable chartable = pointSelection.getSelected();
                    this.\u01d0 = this.\u01cf.calculatePixelPoint((Point2D)new Point2D.Double(chartable.getX().position(), 0.0), axis);
                    this.\u01d8 = this.\u01cf.calculatePixelPoint((Point2D)new Point2D.Double(0.0, chartable.getY().position()), axis);
                    this.setPosition(chartable);
                    this.\u0101(true);
                }
            } else {
                try {
                    Point2D point2D = this.\u01cf.calculateUserPoint(this.\u01d6);
                    if (point2D != null) {
                        double d2 = FunctionMap.getYApproximately(chartModel, point2D.getX());
                        double d3 = point2D.getX();
                        this.\u01d0 = this.\u01cf.calculatePixelPoint((Point2D)new Point2D.Double(d3, 0.0), axis);
                        this.\u01d8 = this.\u01cf.calculatePixelPoint((Point2D)new Point2D.Double(0.0, d2), axis);
                        this.setPosition(new ChartPoint(d3, d2));
                        this.\u0101(true);
                    }
                }
                catch (ChartException chartException) {
                    this.setPosition(null);
                    this.\u0101(false);
                }
            }
        }
        this.\u01cf.repaint();
    }

    public void setPosition(Chartable chartable) {
        Chartable chartable2 = this.\u01d7;
        this.\u01d7 = chartable;
        if (!this.\u01d3) {
            this.update();
        }
        this.\u01ce.firePropertyChange(PROPERTY_POSITION, chartable2, chartable);
    }

    public Chartable getPosition() {
        return this.\u01d7;
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.\u01c9 && this.\u01d0 != null && this.\u01d8 != null) {
            int n2;
            int n3;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setColor(this.\u01d2);
            Dimension dimension = this.\u01cf.getSize();
            graphics2D.setClip(0, 0, dimension.width, dimension.height);
            graphics2D.setStroke(this.\u01cc);
            int n4 = this.\u01d0.x;
            int n5 = this.\u01d8.y;
            if (this.isVerticalLineVisible() && this.\u01d0.x >= this.\u01cf.getXStart() && this.\u01d0.x <= this.\u01cf.getXEnd()) {
                n3 = n5 + this.\u01d1 / 2;
                if (n3 > this.\u01cf.getYStart()) {
                    n3 = this.\u01cf.getYStart();
                }
                if ((n2 = n5 - this.\u01d1 / 2) < this.\u01cf.getYEnd()) {
                    n2 = this.\u01cf.getYEnd();
                }
                graphics2D.drawLine(this.\u01d0.x, this.\u01cf.getYStart(), this.\u01d0.x, n3);
                graphics2D.drawLine(this.\u01d0.x, n2, this.\u01d0.x, this.\u01cf.getYEnd());
            }
            if (this.isHorizontalLineVisible() && this.\u01d8.y <= this.\u01cf.getYStart() && this.\u01d8.y >= this.\u01cf.getYEnd()) {
                n3 = n4 - this.\u01d1 / 2;
                if (n3 > this.\u01cf.getXEnd()) {
                    n3 = this.\u01cf.getXEnd();
                }
                if ((n2 = n4 + this.\u01d1 / 2) < this.\u01cf.getXStart()) {
                    n2 = this.\u01cf.getXStart();
                }
                graphics2D.drawLine(this.\u01cf.getXStart(), this.\u01d8.y, n3, this.\u01d8.y);
                graphics2D.drawLine(n2, this.\u01d8.y, this.\u01cf.getXEnd(), this.\u01d8.y);
            }
            graphics2D.drawOval(n4 - this.\u01d1 / 2, n5 - this.\u01d1 / 2, this.\u01d1, this.\u01d1);
            graphics2D.dispose();
        }
    }

    public int getCircleDiameter() {
        return this.\u01d1;
    }

    public void setCircleDiameter(int n2) {
        int n3 = this.\u01d1;
        this.\u01d1 = n2;
        this.\u01ce.firePropertyChange(PROPERTY_CIRCLE_DIAMETER, n3, n2);
    }
}

