/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.AbstractTimeTickCalculator;
import com.jidesoft.chart.axis.DefaultTimeTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.range.Range;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SimpleTimeTickCalculator
extends AbstractTimeTickCalculator {
    private int \u0108;
    private int \u0107 = 1;

    public SimpleTimeTickCalculator(int n2) {
        this.\u0108 = n2;
        this.setDateFormat(this.createDateFormat(n2));
    }

    public SimpleTimeTickCalculator(int n2, int n3) {
        this.\u0108 = n2;
        this.\u0107 = n3;
        this.setDateFormat(this.createDateFormat(n2));
    }

    protected DateFormat createDateFormat(int n2) {
        switch (n2) {
            case 9: {
                return new SimpleDateFormat("dd-MMM HH:mm");
            }
            case 5: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 7: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 8: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 6: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 10: {
                return new SimpleDateFormat("dd-MMM HH:mm");
            }
            case 11: {
                return new SimpleDateFormat("dd-MMM HH:mm");
            }
            case 14: {
                throw new UnsupportedOperationException("Sorry, milliseconds not supported");
            }
            case 12: {
                return new SimpleDateFormat("dd-MMM HH:mm");
            }
            case 2: {
                return new SimpleDateFormat("MMM-yy");
            }
            case 13: {
                return new SimpleDateFormat("HH:mm:ss");
            }
            case 4: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 3: {
                return new SimpleDateFormat("dd-MMM");
            }
            case 1: {
                return new SimpleDateFormat("yyyy");
            }
        }
        throw new UnsupportedOperationException("Unexpected field while creating Date format");
    }

    @Override
    public Tick[] calculateTicks(Range<Date> range) {
        TimeZone timeZone = this.getTimeZone();
        DateFormat dateFormat = this.getDateFormat();
        if (dateFormat != null) {
            timeZone = dateFormat.getTimeZone();
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar.setTime(range.lower());
        calendar2.setTime(range.upper());
        Calendar calendar3 = DefaultTimeTickCalculator.min(calendar, calendar2);
        calendar2.add(this.\u0108, 1);
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        while (calendar3.before(calendar2)) {
            long l2 = calendar3.getTimeInMillis();
            String string = dateFormat.format(calendar3.getTime());
            arrayList.add(new Tick((double)l2, string));
            calendar3.add(this.\u0108, this.\u0107);
        }
        return arrayList.toArray(new Tick[arrayList.size()]);
    }
}

