/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.util.ShapeFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public enum PointShape {
    CIRCLE,
    DISC,
    SQUARE,
    BOX,
    DIAMOND,
    DOWN_TRIANGLE,
    UP_TRIANGLE,
    HORIZONTAL_LINE,
    VERTICAL_LINE,
    UPRIGHT_CROSS,
    DIAGONAL_CROSS;

    private static final int \u0101 = 1;

    public Shape paint(Graphics graphics, double d2, double d3, double d4, Paint paint, boolean bl, Color color, float f2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setPaint(paint);
        try {
            switch (this) {
                case CIRCLE: {
                    Shape shape = this.\u0108(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case DISC: {
                    Shape shape = this.\u0107(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case SQUARE: {
                    Shape shape = this.\u0102(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case BOX: {
                    Shape shape = this.\u010a(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case DIAMOND: {
                    Shape shape = this.\u0104(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case DOWN_TRIANGLE: {
                    Shape shape = this.\u010b(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case UP_TRIANGLE: {
                    Shape shape = this.\u0105(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case HORIZONTAL_LINE: {
                    Shape shape = this.\u0109(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case VERTICAL_LINE: {
                    Shape shape = this.\u0103(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case UPRIGHT_CROSS: {
                    Shape shape = this.\u0101(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
                case DIAGONAL_CROSS: {
                    Shape shape = this.\u0106(graphics2D, d2, d3, d4, bl, color, f2);
                    return shape;
                }
            }
            throw new IllegalArgumentException("Unexpected shape");
        }
        finally {
            graphics2D.dispose();
        }
    }

    private Shape \u0102(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        double d5 = d2 - d4 / 2.0;
        double d6 = d3 - d4 / 2.0;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, d4, d4);
        graphics2D.draw(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d5 - (double)f2 / 2.0, d6 - (double)f2 / 2.0, d4 + 1.0 + (double)f2, d4 + 1.0 + (double)f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape \u0108(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        double d5 = d2 - (d4 - 1.0) / 2.0;
        double d6 = d3 - (d4 - 1.0) / 2.0;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d5, d6, d4, d4);
        graphics2D.draw(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d5 - (double)(f2 + 1.0f) / 2.0 - 0.5, d6 - (double)(f2 + 1.0f) / 2.0 - 0.5, d4 + 1.5 + (double)f2, d4 + 1.5 + (double)f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape \u0107(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        double d5 = d2 - d4 / 2.0;
        double d6 = d3 - d4 / 2.0;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d5, d6, d4, d4);
        graphics2D.fill(double_);
        graphics2D.draw(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Ellipse2D.Double double_2 = new Ellipse2D.Double(d5 - (double)f2 / 2.0, d6 - (double)f2 / 2.0, d4 + (double)f2, d4 + (double)f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape \u010a(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        double d5 = d2 - (d4 - 1.0) / 2.0;
        double d6 = d3 - (d4 - 1.0) / 2.0;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, d4, d4);
        graphics2D.fill(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d5 - (double)f2 / 2.0, d6 - (double)f2 / 2.0, d4 - 1.0 + (double)f2 / 2.0, d4 - 1.0 + (double)f2 / 2.0);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape \u0104(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Shape shape = ShapeFactory.createDiamond2D(d2, d3, d4);
        graphics2D.fill(shape);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Shape shape2 = ShapeFactory.createDiamond2D(d2, d3, d4 + (double)f2 - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape \u010b(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Shape shape = ShapeFactory.createDownTriangle2D(d2, d3, d4);
        graphics2D.fill(shape);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Shape shape2 = ShapeFactory.createDownTriangle2D(d2, d3, d4 + (double)((int)f2) - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape \u0105(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        Shape shape = ShapeFactory.createUpTriangle2D(d2, d3, d4);
        graphics2D.fill(shape);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Shape shape2 = ShapeFactory.createUpTriangle2D(d2, d3, d4 + (double)((int)f2) - 1.0);
            graphics2D.draw(shape2);
        }
        return shape;
    }

    private Shape \u0109(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d5 = d2 - (d4 - 1.0) / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d3 + 1.0 - 0.5, d4, 1.0);
        graphics2D.fill(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d5 - (double)(f2 / 2.0f), d3 + 1.0 - 0.5 - (double)(f2 + 1.0f) / 2.0, d4 - 1.0 + (double)f2, 1.0f + f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape \u0103(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d5 = d3 - (d4 - 1.0) / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2 + 1.0 - 0.5, d5, 1.0, d4);
        graphics2D.fill(double_);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2 + 1.0 - 0.5 - (double)(f2 + 1.0f) / 2.0, d5 - (double)(f2 / 2.0f), 1.0f + f2, d4 - 1.0 + (double)f2);
            graphics2D.draw(double_2);
        }
        return double_;
    }

    private Shape \u0101(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d5 = d2 - (d4 - 1.0) / 2.0;
        double d6 = d3 - (d4 - 1.0) / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d3 + 1.0 - 0.5, d4, 1.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d2 + 1.0 - 0.5, d6, 1.0, d4);
        graphics2D.fill(double_);
        graphics2D.fill(double_2);
        double_.add(double_2);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Rectangle2D.Double double_3 = new Rectangle2D.Double(d5 - (double)f2 / 2.0, d6 - (double)(f2 / 2.0f), d4 - 1.0 + (double)f2, d4 - 1.0 + (double)f2);
            graphics2D.draw(double_3);
        }
        return double_;
    }

    private Shape \u0106(Graphics2D graphics2D, double d2, double d3, double d4, boolean bl, Color color, float f2) {
        double d5 = 2.0 * Math.sqrt(2.0);
        double d6 = (d4 - 1.0) / 2.0;
        double d7 = d2 - d6;
        double d8 = d3 - d6;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2 + 0.5 - d6 + 1.0 / d5, d3 + 0.5 - d6 - 1.0 / d5);
        generalPath.lineTo(d2 + 0.5 + d6 + 1.0 / d5, d3 + 0.5 + d6 - 1.0 / d5);
        generalPath.lineTo(d2 + 0.5 + d6 - 1.0 / d5, d3 + 0.5 + d6 + 1.0 / d5);
        generalPath.lineTo(d2 + 0.5 - d6 - 1.0 / d5, d3 + 0.5 - d6 + 1.0 / d5);
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(d2 + 0.5 + d6 - 1.0 / d5, d3 + 0.5 - d6 - 1.0 / d5);
        generalPath2.lineTo(d2 + 0.5 - d6 - 1.0 / d5, d3 + 0.5 + d6 - 1.0 / d5);
        generalPath2.lineTo(d2 + 0.5 - d6 + 1.0 / d5, d3 + 0.5 + d6 + 1.0 / d5);
        generalPath2.lineTo(d2 + 0.5 + d6 - 1.0 / d5, d3 + 0.5 - d6 + 1.0 / d5);
        generalPath2.closePath();
        generalPath.append(generalPath2, false);
        graphics2D.fill(generalPath);
        if (bl) {
            graphics2D.setColor(color);
            graphics2D.setStroke(new BasicStroke(f2));
            Rectangle2D.Double double_ = new Rectangle2D.Double(d7 - (double)f2 / 2.0, d8 - (double)(f2 / 2.0f), d4 - 1.0 + (double)f2, d4 - 1.0 + (double)f2);
            graphics2D.draw(double_);
        }
        return generalPath;
    }

    public static PointShape fromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create PointShape from null");
        }
        String string2 = string.trim().toUpperCase();
        return PointShape.valueOf(string2);
    }
}

