/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.DefaultRuntime;
import sqlj.runtime.ExecutionContext;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.ref.ProfileGroup;
import sqlj.runtime.util.SqljTrace;

public abstract class ConnectionContextImpl {
    private ExecutionContext m_execCtx = new ExecutionContext();
    private boolean m_closeRTStmtsNotDrivenByFinalizer = true;
    protected boolean m_isT2ZosCachedDefaultContext = false;
    private PrintWriter driverLogWriter_ = null;
    private String consTraceMsg_ = null;
    private long consTraceTimeStamp_;
    static SimpleDateFormat simpleDateFormat__ = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
    private ProfileGroup.ConnectedGroup m_connProfiles;
    private boolean m_isClosed = false;
    private Connection m_conn;

    protected ConnectionContextImpl(ProfileGroup profileGroup, Connection connection) throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ConnectionContextImpl Constructor Called :" + this + " for Connection :" + connection);
        }
        if (connection == null) {
            RuntimeRefErrors.raise_NULL_CONNECTION();
        }
        this.consTraceTimeStamp_ = System.currentTimeMillis();
        this.m_conn = connection;
        this.m_connProfiles = profileGroup.addConnection(connection);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string) throws SQLException {
        this(profileGroup, DefaultRuntime.getConnect(string));
    }

    public void setConnection(Connection connection) {
        if (connection != null) {
            this.m_conn = connection;
        }
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, String string2, String string3) throws SQLException {
        this(profileGroup, DefaultRuntime.getConnect(string, string2, string3));
    }

    protected static Map loadTypeMap(Class clazz, String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        String string2 = null;
        ResourceBundle resourceBundle = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            resourceBundle = null;
            resourceBundle = ResourceBundle.getBundle(string2);
            if (resourceBundle == null) continue;
            Enumeration<String> enumeration = resourceBundle.getKeys();
            String string3 = null;
            String string4 = null;
            while (enumeration.hasMoreElements()) {
                string3 = enumeration.nextElement();
                string4 = resourceBundle.getString(string3);
                hashtable.put(string3, string4);
            }
        }
        return hashtable;
    }

    private ConnectionContextImpl(ProfileGroup profileGroup, Connection connection, boolean bl2) throws SQLException {
        this(profileGroup, ConnectionContextImpl.initAutoCommit(connection, bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection initAutoCommit(Connection connection, boolean bl2) throws SQLException {
        try {
            connection.setAutoCommit(bl2);
        }
        catch (SQLException sQLException) {
            try {
                connection.close();
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
            finally {
                throw sQLException;
            }
        }
        return connection;
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, String string2, String string3, boolean bl2) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string, string2, string3), bl2);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, Properties properties, boolean bl2) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string, properties), bl2);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, boolean bl2) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string), bl2);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, ConnectionContext connectionContext) throws SQLException {
        this(profileGroup, connectionContext.getConnection());
    }

    public ConnectedProfile getConnectedProfile(Object object) throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ConnectionContextImpl.getConnectedProfile() is called ");
        }
        this.m_connProfiles.setIsT2ZosCachedDefaultContext(this.m_isT2ZosCachedDefaultContext);
        ConnectedProfile connectedProfile = this.m_connProfiles.getProfile(object);
        if (connectedProfile != null) {
            this.driverLogWriter_ = connectedProfile.getDriverLogWriter();
            if (this.driverLogWriter_ != null) {
                this.consTraceMsg_ = "[jcc][sqlj]ConnectionContextImpl <constructor> called at: " + this.composeTraceMsg(this.m_conn, "", this.consTraceTimeStamp_);
                this.driverLogWriter_.println(this.consTraceMsg_);
            }
            this.consTraceMsg_ = null;
        }
        return connectedProfile;
    }

    public void close() throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ConnectionContextImpl.close called :" + this);
        }
        this.close(true);
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void close(boolean bl2) throws SQLException {
        if (this.driverLogWriter_ != null) {
            String string = this.composeTraceMsg(this.m_conn, "ConnectionContextImpl close() called ");
            this.driverLogWriter_.println(string);
        }
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ConnectionContextImpl.close() is called :" + this);
        }
        this.m_isClosed = true;
        try {
            this.m_connProfiles.setCloseRTStmtsNotDrivenByFinalizer(this.m_closeRTStmtsNotDrivenByFinalizer);
            this.m_connProfiles.close();
        }
        finally {
            this.driverLogWriter_ = null;
            if (bl2) {
                this.m_conn.close();
            }
        }
    }

    public ExecutionContext getExecutionContext() {
        return this.m_execCtx;
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (!this.m_isClosed) {
                this.m_closeRTStmtsNotDrivenByFinalizer = false;
                this.close(false);
            }
        }
    }

    public Map getTypeMap() {
        return null;
    }

    private String composeTraceMsg(Connection connection, String string, long l8) {
        String string2 = "[jcc][Time:" + this.getTimeFormatted(l8) + "][Thread:" + Thread.currentThread().getName() + "] ";
        String string3 = string2 + string + this + "[" + connection + "]";
        return string3;
    }

    private String composeTraceMsg(Connection connection, String string) {
        return this.composeTraceMsg(connection, string, System.currentTimeMillis());
    }

    private String getTimeFormatted(long l8) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.setTimeInMillis(l8);
        return simpleDateFormat__.format(calendar.getTime());
    }

    static {
        simpleDateFormat__.setTimeZone(TimeZone.getDefault());
    }
}

