/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.controller;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.Database;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.impl.Utils;
import com.ibm.db2.cmx.internal.Service;
import com.ibm.db2.cmx.internal.controller.ControlDataSource;
import com.ibm.db2.cmx.internal.controller.ControlDataSourcePool;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcDataSource;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ControlDataSourceImpl
implements ControlDataSource {
    private static Logger logger__ = Log.getCMXClientLogger();
    private String logicalName_;
    private String monitoredServerName_;
    private String monitoredServerHostname_;
    private String monitoredPortNumber_;
    private String monitoredDatabaseName_;
    public String monitoredLocationName_;
    private int matchingKeySet_ = -1;
    private Properties defaults_ = null;
    private Properties overrides_ = null;
    private Map<String, Object> dataSourceDescriptorMap_ = null;
    private Profile.DataSource dataSourceProfile_ = null;
    private int lookupReplyFlag_ = 0;
    private ProxiedJdbcDataSource registeredDatasource_ = null;
    public ProxiedJdbcDataSource registeredDatasourceOPM_ = null;
    private int version_ = 0;
    private long lastKnownDriverProfileVersion_ = -1L;
    private long lastKnownDataSourceProfileVersion_ = -1L;
    private long lastKnownDatabaseVersion_ = -1L;
    private long lastKnownDatabaseProfileVersion_ = -1L;
    private String lastKnownDriverProfileName_ = null;
    private String lastKnownDataSourceProfileName_ = null;
    private String lastKnownDatabaseLogicalName_ = null;
    private String lastKnownDatabaseProfileName_ = null;
    private ControllerAgent controllerAgent_;
    private int lookupInterval_;
    private TimerTask dataSourceLookupTimerTask_;
    private boolean initialLookupOccurred_ = false;
    private Service.ControllerType controllerType_ = Service.ControllerType.OPM;
    private ReentrantLock lock_ = new ReentrantLock();
    private static Pattern spResultMonitorURLPattern__ = Pattern.compile(".*?M:([^;]+).*");
    private static Pattern monitorServerPattern__ = Pattern.compile(".*monitorServer=([^\\?]+).*");
    private static Pattern monitorPortPattern__ = Pattern.compile(".*monitorPort=([0-9]+)\\??.*");
    private static Pattern keyTypesPattern__ = Pattern.compile(".*keyTypes=([^\\?]+).*");
    private static Pattern dispatchTokenPattern__ = Pattern.compile(".*dispatchToken=([^\\?]+).*");
    private static Pattern monitorEnabledPattern__ = Pattern.compile(".*monitorEnabled==([0-1]+)\\??.*");

    public ControlDataSourceImpl(Service.ControllerType controllerType, Map<String, Object> map, String string, String string2, String string3, String string4, boolean bl2, String string5, ProxiedJdbcDataSource proxiedJdbcDataSource) {
        Boolean bl3 = false;
        this.controllerType_ = controllerType;
        this.dataSourceDescriptorMap_ = map;
        this.logicalName_ = string;
        this.monitoredServerName_ = Configuration.resolveToIPAddress(string2);
        this.monitoredServerHostname_ = Configuration.resolveHostname(string2);
        this.monitoredPortNumber_ = string3;
        this.monitoredDatabaseName_ = string4;
        this.monitoredLocationName_ = string5;
        this.lookupInterval_ = Integer.parseInt(DataProperties.getProperty("pdq.cmx.dataSourceLookupInterval"));
        this.dataSourceProfile_ = ControlDataSourceImpl.getEmptyDataSourceProfile();
        if (bl2) {
            String string6;
            if (controllerType == Service.ControllerType.OCM) {
                string6 = DataProperties.getProperty("pdq.cmx.http.controllerURL");
                if (string6 == null) {
                    controllerType = Service.ControllerType.NPX;
                }
            } else {
                string6 = DataProperties.getProperty("pdq.cmx.controllerURL");
                bl3 = DataProperties.getPropertyBoolean("pdq.cmx.server");
                this.registeredDatasourceOPM_ = proxiedJdbcDataSource;
            }
            this.controllerAgent_ = Service.getControllerAgent(string6, false);
            if (controllerType == Service.ControllerType.OPM && string6 != null && !bl3.booleanValue()) {
                this.initializeDataSourceLookupTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCDSWithMonitorDataFromSP(String string) {
        ReentrantLock reentrantLock = this.lock_;
        synchronized (reentrantLock) {
            Properties properties = new Properties();
            if (ControlDataSourceImpl.parseMonitorProperties(string, properties)) {
                int n2 = -1;
                this.init(new Properties(), properties, n2);
                this.initialLookupOccurred();
            }
        }
    }

    static Profile.DataSource getEmptyDataSourceProfile() {
        return new Profile.DataSource(null, -1L, null, null, null, null, null, null, null, null, ControlDataSourceImpl.getEmptyDatabase(), null, null);
    }

    static Database getEmptyDatabase() {
        return new Database(null, -1L, null, -1, null, -1L, null);
    }

    public Service.ControllerType getControllerType() {
        return this.controllerType_;
    }

    void setLookupReplyFlag(int n2) {
        this.lookupReplyFlag_ = n2;
    }

    int getLookupReplyFlag() {
        return this.lookupReplyFlag_;
    }

    public void initializeDataSourceLookupTask() {
        if (this.dataSourceLookupTimerTask_ != null) {
            return;
        }
        if (this.lookupInterval_ > 0) {
            this.dataSourceLookupTimerTask_ = new DataSourcePropertyLookup();
            long l8 = this.lookupInterval_ * 60 * 1000;
            ControlDataSourcePool.getInstance().scheduleLookupTask(this.dataSourceLookupTimerTask_, 0L, l8);
        } else {
            this.dataSourceLookupTimerTask_ = new DataSourcePropertyLookup();
            ControlDataSourcePool.getInstance().scheduleLookupTask(this.dataSourceLookupTimerTask_, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasInitialLookupOccurred() {
        ReentrantLock reentrantLock = this.lock_;
        synchronized (reentrantLock) {
            return this.initialLookupOccurred_;
        }
    }

    @Override
    public void updateCDS(String string, String string2, String string3, String string4, String string5) {
        this.logicalName_ = string;
        this.monitoredServerName_ = Configuration.resolveToIPAddress(string2);
        this.monitoredServerHostname_ = Configuration.resolveHostname(string2);
        this.monitoredPortNumber_ = string3;
        this.monitoredDatabaseName_ = string4;
        this.monitoredLocationName_ = string5;
    }

    @Override
    public int getMatchingKeySet() {
        return this.matchingKeySet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateVersion() {
        boolean bl2 = false;
        ReentrantLock reentrantLock = this.lock_;
        synchronized (reentrantLock) {
            Profile.Driver driver;
            Profile profile = driver = ControlDriver.getInstance().getDriverProfile();
            synchronized (profile) {
                if (!Utils.areStringsEqual(driver.getName(), this.lastKnownDriverProfileName_) || driver.getVersion() != this.lastKnownDriverProfileVersion_) {
                    this.lastKnownDriverProfileName_ = driver.getName();
                    this.lastKnownDriverProfileVersion_ = driver.getVersion();
                    bl2 = true;
                }
            }
            profile = this.dataSourceProfile_;
            synchronized (profile) {
                if (!Utils.areStringsEqual(this.dataSourceProfile_.getName(), this.lastKnownDataSourceProfileName_) || this.dataSourceProfile_.getVersion() != this.lastKnownDataSourceProfileVersion_) {
                    this.lastKnownDataSourceProfileName_ = this.dataSourceProfile_.getName();
                    this.lastKnownDataSourceProfileVersion_ = this.dataSourceProfile_.getVersion();
                    bl2 = true;
                }
                if (!(this.dataSourceProfile_.getTargetDatabase() == null || Utils.areStringsEqual(this.dataSourceProfile_.getTargetDatabase().getLogicalName(), this.lastKnownDatabaseLogicalName_) && this.dataSourceProfile_.getTargetDatabase().getVersion() == this.lastKnownDatabaseVersion_)) {
                    this.lastKnownDatabaseLogicalName_ = this.dataSourceProfile_.getTargetDatabase().getLogicalName();
                    this.lastKnownDatabaseVersion_ = this.dataSourceProfile_.getTargetDatabase().getVersion();
                    bl2 = true;
                }
                if (!(this.dataSourceProfile_.getTargetDatabase() == null || this.dataSourceProfile_.getTargetDatabase().getDatabaseProfile() == null || Utils.areStringsEqual(this.dataSourceProfile_.getTargetDatabase().getDatabaseProfile().getName(), this.lastKnownDatabaseProfileName_) && this.dataSourceProfile_.getTargetDatabase().getDatabaseProfile().getVersion() == this.lastKnownDatabaseProfileVersion_)) {
                    this.lastKnownDatabaseProfileName_ = this.dataSourceProfile_.getTargetDatabase().getDatabaseProfile().getName();
                    this.lastKnownDatabaseProfileVersion_ = this.dataSourceProfile_.getTargetDatabase().getDatabaseProfile().getVersion();
                    bl2 = true;
                }
            }
            if (bl2) {
                ++this.version_;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Properties properties, Properties properties2, int n2) {
        boolean bl2 = false;
        ReentrantLock reentrantLock = this.lock_;
        synchronized (reentrantLock) {
            if (properties != null && !properties.equals(this.defaults_)) {
                this.defaults_ = properties;
                bl2 = true;
            } else if (properties == null && this.defaults_ != null) {
                this.defaults_ = null;
                bl2 = true;
            }
            if (properties2 != null && !properties2.equals(this.overrides_)) {
                this.overrides_ = properties2;
                bl2 = true;
            } else if (properties2 == null && this.overrides_ != null) {
                this.overrides_ = null;
                bl2 = true;
            }
            if (bl2) {
                this.matchingKeySet_ = n2;
                int n3 = this.getPropertyValue("clientPollingInterval", this.defaults_, this.overrides_, -9999);
                if (n3 != -9999) {
                    this.setDataSourceLookupInterval(n3);
                }
                ++this.version_;
            }
        }
    }

    private static boolean parseMonitorProperties(String string, Properties properties) {
        if (string == null) {
            return false;
        }
        Matcher matcher = spResultMonitorURLPattern__.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            if (logger__.isLoggable(Level.FINEST)) {
                logger__.log(Level.FINEST, "Monitor URL Details: " + string2);
            }
            if (!(matcher = monitorServerPattern__.matcher(string2)).matches()) {
                if (logger__.isLoggable(Level.FINEST)) {
                    logger__.log(Level.FINEST, "monitorServer was not found in monitor URL details.");
                }
                return false;
            }
            String string3 = matcher.group(1);
            string3 = string3.replace(',', ';');
            matcher = monitorPortPattern__.matcher(string2);
            if (!matcher.matches()) {
                if (logger__.isLoggable(Level.FINEST)) {
                    logger__.log(Level.FINEST, "monitorPort was not found in monitor URL details.");
                }
                return false;
            }
            String string4 = matcher.group(1);
            matcher = keyTypesPattern__.matcher(string2);
            if (!matcher.matches()) {
                if (logger__.isLoggable(Level.FINEST)) {
                    logger__.log(Level.FINEST, "keyTypes was not found in monitor URL details.");
                }
                return false;
            }
            String string5 = matcher.group(1);
            matcher = dispatchTokenPattern__.matcher(string2);
            if (!matcher.matches()) {
                return false;
            }
            String string6 = matcher.group(1);
            properties.setProperty("dispatchToken", string6);
            matcher = monitorEnabledPattern__.matcher(string2);
            if (matcher.matches()) {
                String string7 = matcher.group(1);
                if (string7 != null) {
                    properties.setProperty("monitorEnabled", string7);
                }
            } else {
                properties.setProperty("monitorEnabled", "1");
                if (logger__.isLoggable(Level.FINE)) {
                    logger__.log(Level.FINE, "Deployed OPM.DB2MON_LOC Stored Procedure not configured to enable EI monitoring.  monitorEnabled flag not specified.");
                }
            }
            if (string3 != null) {
                properties.setProperty("monitorServerName", string3);
            }
            if (string4 != null) {
                properties.setProperty("monitorPort", string4);
            }
            if (string5 != null) {
                properties.setProperty("supportedKeyTypes", string5);
            }
            if (string6 != null) {
                properties.setProperty("dispatchToken", string6);
            }
            properties.setProperty("monitorCollectionInterval", "60");
            properties.setProperty("monitorLevel", "1");
            return true;
        }
        if (logger__.isLoggable(Level.FINE)) {
            logger__.log(Level.FINE, "Monitor URL does not match expected pattern: " + string);
        }
        return false;
    }

    public Properties getDefaults() {
        return this.defaults_;
    }

    public String getLogicalName() {
        return this.logicalName_;
    }

    public String getMonitoredServerName() {
        return this.monitoredServerName_;
    }

    public String getMonitoredServerHostname() {
        return this.monitoredServerHostname_;
    }

    public String getMonitoredPortNumber() {
        return this.monitoredPortNumber_;
    }

    public String getMonitoredDatabaseName() {
        return this.monitoredDatabaseName_;
    }

    public String getMonitoredLocationName() {
        return this.monitoredLocationName_;
    }

    public Map<String, Object> getDataSourceDescriptorMap() {
        return this.dataSourceDescriptorMap_;
    }

    Map<String, Object> getNewDataSourceDescriptorMap() {
        return this.registeredDatasource_ != null ? this.registeredDatasource_.getNewDataSourceDescriptorMap() : null;
    }

    @Override
    public Profile.DataSource getDataSourceProfile() {
        return this.dataSourceProfile_;
    }

    @Override
    public String getDataSourceId() {
        if (this.dataSourceDescriptorMap_ != null) {
            return (String)this.dataSourceDescriptorMap_.get("dataSourceId");
        }
        return null;
    }

    public Properties getOverrides() {
        return this.overrides_;
    }

    public boolean containsPropertyValue(String string) {
        return this.overrides_ != null ? this.overrides_.containsKey(string) : false;
    }

    @Override
    public String getPropertyValue(String string, String string2) {
        return this.getPropertyValue(string, this.defaults_, this.overrides_, string2);
    }

    @Override
    public int getPropertyValue(String string, int n2) {
        return this.getPropertyValue(string, this.defaults_, this.overrides_, n2);
    }

    private String getPropertyValue(String string, Properties properties, Properties properties2, String string2) {
        String string3;
        if (properties2 != null && (string3 = properties2.getProperty(string)) != null) {
            return string3;
        }
        if (string2 != null) {
            return string2;
        }
        if (properties != null && (string3 = properties.getProperty(string)) != null) {
            return string3;
        }
        return null;
    }

    private int getPropertyValue(String string, Properties properties, Properties properties2, int n2) {
        String string2;
        if (properties2 != null && (string2 = properties2.getProperty(string)) != null) {
            return Integer.parseInt(string2);
        }
        if (properties != null && (string2 = properties.getProperty(string)) != null) {
            return Integer.parseInt(string2);
        }
        return n2;
    }

    @Override
    public int getVersion() {
        return this.version_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialLookupOccurred() {
        ReentrantLock reentrantLock = this.lock_;
        synchronized (reentrantLock) {
            if (!this.initialLookupOccurred_) {
                this.initialLookupOccurred_ = true;
            }
        }
    }

    @Override
    public void doInitialLookup(boolean bl2) {
        this.refreshMonitoringProperties();
    }

    void refreshMonitoringProperties() {
        if (this.controllerAgent_ != null) {
            try {
                this.controllerAgent_.lookupOverNetwork(this);
            }
            catch (Exception exception) {
                this.init(null, null, -1);
                DataLogger.lowImpactLogger(logger__, this, "refreshMonitoringProperties", "unable to retrieve updated properties from controller ", exception);
            }
        }
        this.initialLookupOccurred();
    }

    @Override
    public ControllerAgent getControllerAgent() {
        return this.controllerAgent_;
    }

    @Override
    public int getOPMControllerVersion() {
        return this.controllerAgent_.getNegotiatedVersion();
    }

    private void setDataSourceLookupInterval(int n2) {
        if (n2 != this.lookupInterval_) {
            if (this.lookupInterval_ > 0 && this.dataSourceLookupTimerTask_ != null) {
                this.dataSourceLookupTimerTask_.cancel();
                this.dataSourceLookupTimerTask_ = null;
            }
            this.lookupInterval_ = n2;
            if (this.lookupInterval_ > 0) {
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, this, "setDataSourceLookupInterval", "Setting new datasource lookup interval: " + n2);
                }
                this.initializeDataSourceLookupTask();
            }
        }
    }

    public void registerDataSourceForUpdates(ProxiedJdbcDataSource proxiedJdbcDataSource) {
        if (this.registeredDatasource_ == null) {
            this.registeredDatasource_ = proxiedJdbcDataSource;
        }
    }

    HashSet<ClientInfo> getClientInfo() {
        return this.registeredDatasource_ != null ? this.registeredDatasource_.getClientInfo() : null;
    }

    ArrayList<PushDownError> getDynamicPushDownErrors() {
        return this.registeredDatasource_ != null ? this.registeredDatasource_.getDynamicPushDownErrors() : null;
    }

    void clearDynamicPushDownErrors(ArrayList<PushDownError> arrayList) {
        if (this.registeredDatasource_ != null && arrayList != null) {
            this.registeredDatasource_.clearDynamicPushDownError(arrayList);
        }
    }

    Object[] getWASPoolStatistics() {
        Object[] objectArray = null;
        if (this.registeredDatasource_ != null && this.registeredDatasource_.getListener() != null) {
            objectArray = this.registeredDatasource_.getListener().getBasicPoolActivity();
        }
        return objectArray;
    }

    HashMap<String, String> getAppliedStatusFromWAS() {
        HashMap<String, String> hashMap = null;
        if (this.registeredDatasource_ != null && this.registeredDatasource_.getListener() != null) {
            hashMap = this.registeredDatasource_.getAppliedPropsStatusFromWAS_();
        }
        return hashMap;
    }

    void clearApplicationExceptionSet() {
        if (this.registeredDatasource_ != null) {
            this.registeredDatasource_.clearApplicationExceptionSet();
        }
    }

    @Override
    public void lock() {
        this.lock_.lock();
    }

    @Override
    public void unlock() {
        this.lock_.unlock();
    }

    @Override
    public void sendDeregisterDataSource(String string) {
        if (this.controllerAgent_ != null) {
            try {
                this.controllerAgent_.sendDeregisterDataSource(string);
            }
            catch (Exception exception) {
                DataLogger.lowImpactLogger(logger__, this, "sendDeregisterDataSource", "unable to send deregister datasource to controller ", exception);
            }
        }
    }

    public void applyDynamicProperties() {
        if (this.registeredDatasource_ != null) {
            long l8 = this.registeredDatasource_.getDataSourceProfileVersion();
            long l9 = this.dataSourceProfile_.getVersion();
            if (l9 > l8 || l9 == -1L && l8 != -1L) {
                this.registeredDatasource_.applyDynamicProperties(this.dataSourceProfile_);
                this.registeredDatasource_.setDataSourceProfileVersion(l9);
            }
        }
    }

    public void rollbackDatasourceDynamicProperties() {
    }

    public void resetDataSourceProfileVersion() {
        this.registeredDatasource_.setDataSourceProfileVersion(-1L);
    }

    @Override
    public int getMonitorEnabledFromCmxDirectives(int n2) {
        HashMap<String, String> hashMap = this.getDataSourceProfile().getCmxDirectives();
        String string = null;
        if (hashMap != null) {
            string = null;
            string = hashMap.get("monitorEnabled");
            if (string != null && string.equals("true")) {
                n2 = 1;
            }
        }
        if (logger__.isLoggable(Level.FINEST)) {
            logger__.log(Level.FINEST, "monitorEnabled=" + n2);
        }
        return n2;
    }

    @Override
    public int getMonitorCollectionIntervalFromCmxDirectives(int n2) {
        HashMap<String, String> hashMap = this.getDataSourceProfile().getCmxDirectives();
        String string = null;
        if (hashMap != null) {
            string = null;
            string = hashMap.get("monitorCollectionInterval");
            if (string != null) {
                n2 = Integer.parseInt(string);
            }
        }
        if (logger__.isLoggable(Level.FINEST)) {
            logger__.log(Level.FINEST, "monitorCollectionInterval=" + n2);
        }
        return n2;
    }

    private class DataSourcePropertyLookup
    extends TimerTask
    implements Runnable {
        private DataSourcePropertyLookup() {
        }

        @Override
        public void run() {
            ControlDataSourceImpl.this.refreshMonitoringProperties();
        }
    }
}

