/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import oracle.xml.xti.XTIException;

public class XTIUtil {
    static byte[] intToByteArray(int n) {
        return new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
    }

    static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 7; i >= 0; --i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    static long byteArrayToLong(byte[] byArray, int n) {
        long l = byArray[n];
        for (int i = 1; i < 8; ++i) {
            l = l << 8 | (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    static void intToByteArray(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    static int byteArrayToInt(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        n2 <<= 8;
        n2 |= byArray[n++] & 0xFF;
        n2 <<= 8;
        n2 |= byArray[n++] & 0xFF;
        n2 <<= 8;
        return n2 |= byArray[n] & 0xFF;
    }

    static byte[] shortToByteArray(int n) {
        return new byte[]{(byte)(n >>> 8), (byte)n};
    }

    static int byteArrayToShort(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        n2 <<= 8;
        return n2 |= byArray[n] & 0xFF;
    }

    static boolean isPureWhiteSpace(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if (cArray[i] == ' ' || cArray[i] == '\n' || cArray[i] == '\r' || cArray[i] == '\t') continue;
            return false;
        }
        return true;
    }

    static boolean isFlag(int n, int n2) {
        return (n & n2) >= n2;
    }

    static int getXTICSizePerPage(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = 4091;
                break;
            }
            case 2: {
                n2 = 4091;
                break;
            }
            case 0: {
                n2 = 4089;
                break;
            }
            default: {
                n2 = 4091;
            }
        }
        return n2;
    }

    static void printBytesArrayinChars(byte[] byArray, int n, int n2) {
        System.out.println();
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            if (byArray[i] >= 32) {
                System.out.print((char)byArray[i] + " ");
            } else {
                System.out.print(byArray[i] + " ");
            }
            if (++n3 != 50) continue;
            System.out.println();
            n3 = 0;
        }
        System.out.println();
    }

    static String getStringFromArray(byte[] byArray, int n) throws XTIException {
        try {
            int n2 = 0;
            int n3 = n;
            if (n3 < 5) {
                n3 = 5;
            }
            while (byArray[n3] != 0) {
                ++n2;
                ++n3;
            }
            String string = XTIUtil.getXTICString(byArray, n, n2);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XTIException(unsupportedEncodingException);
        }
    }

    static String getQNameFromArray(byte[] byArray, int n) throws XTIException {
        try {
            int n2 = 0;
            int n3 = n;
            if (n3 < 5) {
                n3 = 5;
            }
            while (byArray[n3] != 0) {
                ++n2;
                ++n3;
            }
            String string = XTIUtil.getXTICString4QName(byArray, n, n2);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XTIException(unsupportedEncodingException);
        }
    }

    static String getXTICString(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        return new String(byArray, n, n2, "UTF-8");
    }

    static String getXTICString4QName(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        if (byArray[n] == 1 && byArray[n + 1] == 58) {
            return new String(byArray, n + 2, n2 - 2, "UTF-8");
        }
        byte by = byArray[n];
        if (by < n2 && by > 1 && byArray[n + by] == 58) {
            return new String(byArray, n + 1, n2 - 1, "UTF-8");
        }
        return new String(byArray, n, n2, "UTF-8");
    }

    public static void printVector(Vector vector) {
        System.out.println();
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.get(i).toString();
            System.out.print(string + "->");
        }
        System.out.println();
    }
}

