/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.NSResolver;
import oracle.xml.util.QxName;
import oracle.xml.xpath.ComparisonExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

class XPathCastExpr
extends XSLExprBase {
    private OXMLSequenceType stype;
    private boolean optional = false;
    private NSResolver nsr = null;

    XPathCastExpr() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(201, 0);
        }
        XSLExprBase xSLExprBase = ComparisonExpr.parse(xSLParseString);
        if (xSLParseString.peekToken(21)) {
            XPathCastExpr xPathCastExpr;
            if (xSLParseString.peekToken(114) && xSLParseString.getItemType() == 711) {
                xPathCastExpr = new XPathCastExpr();
                xPathCastExpr.leftExpr = xSLExprBase;
                xPathCastExpr.stype = OXMLSequenceType.createValueType(new QxName(xSLParseString.getNamespace(), xSLParseString.getLocalName()), 1);
                try {
                    xPathCastExpr.stype.getDataType();
                }
                catch (XQException xQException) {
                    throw new XPathException(1013, "cast as");
                }
                xPathCastExpr.optional = false;
                if (xSLParseString.peekToken(115)) {
                    if (xSLParseString.getOccurIndicator() == 722) {
                        xPathCastExpr.optional = true;
                    } else {
                        throw new XPathException(1013, "cast as");
                    }
                }
                if (xPathCastExpr.stype.getPrimitiveId() == 18) {
                    xPathCastExpr.nsr = xSLParseString.getNSResolver();
                }
            } else {
                throw new XPathException(1013, "cast as");
            }
            xSLExprBase = xPathCastExpr;
        }
        xSLExprBase.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(201, 1);
        }
        return xSLExprBase;
    }

    @Override
    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
    }

    @Override
    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr();
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(21);
        String string = this.stype.getDataType().getTargetNS();
        if (string != null && string.length() > 0) {
            stringBuffer.append("{");
            stringBuffer.append(string);
            stringBuffer.append("}");
        }
        stringBuffer.append(this.stype.getDataType().getName());
        stringBuffer.append(this.leftExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    @Override
    int checkPosLastFN() {
        if (this.flag < 0) {
            this.flag = this.leftExpr.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        xPathRuntimeContext.setNSResolver(this.nsr);
        this.leftExpr.evaluate(xPathRuntimeContext);
        OXMLSequence oXMLSequence = xPathRuntimeContext.peekExprValue();
        if (oXMLSequence.getItemOccurrence() == 0 && this.optional) {
            xPathRuntimeContext.pushExprValue();
        } else {
            oXMLSequence.atomizeInPlace();
            if (oXMLSequence.getItemOccurrence() == 2) {
                throw new XPathException(1019, "singleton", "sequence");
            }
            if (oXMLSequence.next()) {
                OXMLItem oXMLItem = oXMLSequence.getItem();
                oXMLItem.convert(this.stype);
                XPathSequence.restart(oXMLSequence);
            }
        }
    }
}

