/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.caret;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretEvent;
import com.jidesoft.editor.caret.CaretListener;
import com.jidesoft.editor.caret.CaretModel;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.DefaultFoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.selection.SelectionModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DefaultCaretModel
implements CaretModel {
    private EventListenerList \u0102 = null;
    private CaretPosition \u0103;
    private CaretPosition \u0104;
    private CodeEditor \u0105;
    private static final Logger \u0101 = Logger.getLogger(CaretEvent.class.getName());

    public DefaultCaretModel(CodeEditor codeEditor) {
        this.\u0105 = codeEditor;
        this.\u0103 = new CaretPosition(0, 0);
        this.\u0104 = new CaretPosition(0, 0);
    }

    @Override
    public CaretPosition getModelPosition() {
        return this.\u0103;
    }

    @Override
    public void setModelPosition(CaretPosition caretPosition) {
        int n2 = Math.max(caretPosition.line, 0);
        int n3 = Math.max(caretPosition.column, 0);
        int n4 = Math.max(this.\u0105.getLineCount() - 1, 0);
        if (n2 > n4) {
            n2 = n4;
        }
        CaretPosition caretPosition2 = this.\u0103;
        this.\u0103 = new CaretPosition(n2, n3);
        CaretPosition caretPosition3 = this.\u0104;
        this.updateViewPosition();
        this.fireCaretEvent(1, caretPosition3, this.\u0104);
        this.fireCaretEvent(0, caretPosition2, this.\u0103);
    }

    @Override
    public CaretPosition getViewPosition() {
        return this.\u0104;
    }

    @Override
    public void setViewPosition(CaretPosition caretPosition) {
        int n2 = Math.max(caretPosition.line, 0);
        int n3 = Math.max(caretPosition.column, 0);
        int n4 = Math.max(this.\u0105.getLineCount() - 1, 0);
        if (n2 > n4) {
            n2 = n4;
        }
        CaretPosition caretPosition2 = this.\u0104;
        this.\u0104 = new CaretPosition(n2, n3);
        CaretPosition caretPosition3 = this.\u0103;
        this.\u0103 = this.\u0105.viewToModelPosition(this.\u0104);
        this.fireCaretEvent(1, caretPosition2, this.\u0104);
        this.fireCaretEvent(0, caretPosition3, this.\u0103);
    }

    @Override
    public void setOffset(int n2) {
        if (\u0101.isLoggable(Level.FINE)) {
            \u0101.fine("Caret Offset " + n2);
        }
        CaretPosition caretPosition = this.\u0105.offsetToModelPosition(n2);
        this.setModelPosition(caretPosition);
    }

    @Override
    public int getOffset() {
        return this.\u0105.modelPositionToOffset(this.\u0103);
    }

    @Override
    public synchronized void addCaretListener(CaretListener caretListener) {
        if (this.\u0102 == null) {
            this.\u0102 = new EventListenerList();
        }
        this.\u0102.add(CaretListener.class, caretListener);
    }

    @Override
    public synchronized void removeCaretListener(CaretListener caretListener) {
        this.\u0102.remove(CaretListener.class, caretListener);
    }

    @Override
    public CaretListener[] getCaretListeners() {
        return (CaretListener[])this.\u0102.getListeners(CaretListener.class);
    }

    protected void fireCaretEvent(int n2, CaretPosition caretPosition, CaretPosition caretPosition2) {
        if (\u0101.isLoggable(Level.FINE)) {
            switch (n2) {
                case 1: {
                    \u0101.fine("Caret View Position " + caretPosition + " => " + caretPosition2);
                    break;
                }
                case 0: {
                    \u0101.fine("Caret Model Position " + caretPosition + " => " + caretPosition2);
                    break;
                }
            }
        }
        if (this.\u0102 == null) {
            return;
        }
        if (caretPosition2.equals(caretPosition)) {
            return;
        }
        Object[] objectArray = this.\u0102.getListenerList();
        CaretEvent caretEvent = new CaretEvent(this.\u0105, n2, caretPosition, caretPosition2);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != CaretListener.class) continue;
            ((CaretListener)objectArray[i2 + 1]).caretUpdated(caretEvent);
        }
    }

    private int \u0101(int n2) {
        char c2;
        int n3;
        String string = this.\u0105.getLineText(n2);
        if (string == null) {
            return 0;
        }
        for (n3 = string.length(); n3 > 0 && ((c2 = string.charAt(n3 - 1)) == '\r' || c2 == '\n'); --n3) {
        }
        return n3;
    }

    @Override
    public void moveCaret(int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        int n4;
        boolean bl4 = n3 > 0 || n3 == 0 && n2 > 0;
        int n5 = bl4 ? Math.min(this.\u0105.getLeadSelectionOffset(), this.\u0105.getAnchorSelectionOffset()) : Math.max(this.\u0105.getLeadSelectionOffset(), this.\u0105.getAnchorSelectionOffset());
        CaretPosition caretPosition = this.getViewPosition();
        CaretPosition caretPosition2 = this.getModelPosition();
        if (!this.\u0105.isVirtualSpaceAllowed()) {
            if (caretPosition.column == 0 && caretPosition.line > 0 && n2 < 0) {
                this.setOffset(this.\u0105.getLineStartOffset(caretPosition2.line - 1) + this.\u0101(caretPosition2.line - 1));
                if (n2 + 1 < 0) {
                    this.moveCaret(n2 + 1, n3, bl, bl2, bl3);
                } else {
                    this.\u0101(bl, bl3, n5);
                }
                return;
            }
            if (caretPosition2.column >= this.\u0101(caretPosition2.line) && n2 > 0 && this.getOffset() < this.\u0105.getDocumentLength()) {
                FoldingSpan foldingSpan;
                n4 = 0;
                if (this.\u0105.getFoldingModel() instanceof DefaultFoldingModel && (foldingSpan = ((DefaultFoldingModel)this.\u0105.getFoldingModel()).getOutermostSpanAtOffset(this.getOffset())) != null && this.\u0105.getLineNumber(foldingSpan.getStartOffset()) == caretPosition2.line) {
                    CaretPosition caretPosition3 = this.\u0105.offsetToViewPosition(foldingSpan.getStartOffset());
                    if (caretPosition3.column + (foldingSpan.getDescription() == null ? 0 : foldingSpan.getDescription().length()) > caretPosition.column) {
                        n4 = 1;
                    }
                }
                if (n4 == 0) {
                    this.setOffset(this.\u0105.getLineStartOffset(caretPosition2.line + 1));
                    if (n2 - 1 > 0) {
                        this.moveCaret(n2 - 1, n3, bl, bl2, bl3);
                    } else {
                        this.\u0101(bl, bl3, n5);
                    }
                    return;
                }
            }
        }
        n4 = Math.max(caretPosition.line + n3, 0);
        int n6 = this.\u0105.viewToModelLine(n4);
        int n7 = this.\u0105.getDocument().isLineLoaded(caretPosition2.line) && this.\u0105.getDocument().isLineLoaded(n6) ? Math.max(this.\u0105.getCorrespondingColumn(caretPosition.column, caretPosition2.line, n6) + n2, 0) : caretPosition.column + n2;
        CaretPosition caretPosition4 = new CaretPosition(n4, n7);
        if (!this.\u0105.isVirtualSpaceAllowed() && n3 != 0) {
            int n8;
            CaretPosition caretPosition5 = this.\u0105.viewToModelPosition(caretPosition4);
            int n9 = this.\u0105.modelPositionToOffset(caretPosition5);
            if (n9 >= (n8 = this.\u0105.getLineStartOffset(caretPosition5.line)) + this.\u0101(caretPosition5.line)) {
                this.setOffset(n9);
                this.\u0101(bl, bl3, n5);
                return;
            }
            int n10 = this.\u0105.getMagicCaretPosition() + this.\u0105.getHorizontalOffset();
            int n11 = this.\u0105.offsetToX(n9);
            if (n11 < n10) {
                this.setOffset(this.\u0105.xToOffset(caretPosition4.line, n10));
                this.\u0101(bl, bl3, n5);
                return;
            }
        }
        this.setViewPosition(caretPosition4);
        this.\u0101(bl, bl3, n5);
    }

    private void \u0101(boolean bl, boolean bl2, int n2) {
        SelectionModel selectionModel = this.\u0105.getSelectionModel();
        if (bl) {
            selectionModel.setSelection(n2, this.getOffset());
        } else {
            selectionModel.clearSelection();
        }
        if (bl2) {
            this.\u0105.scrollToCaret();
        }
        this.\u0105.setBlink(true);
    }

    @Override
    public void updateViewPosition() {
        this.\u0104 = this.\u0105.modelToViewPosition(this.\u0103);
    }
}

