/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DateChooserPanel;
import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DateModelEvent;
import com.jidesoft.combobox.DateModelListener;
import com.jidesoft.combobox.DateSelectionEvent;
import com.jidesoft.combobox.DateSelectionListener;
import com.jidesoft.combobox.DateSelectionModel;
import com.jidesoft.combobox.DefaultDateModel;
import com.jidesoft.combobox.DefaultDateSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CalendarViewer
extends JPanel {
    private Dimension \u0104 = new Dimension(3, 4);
    private boolean \u0103 = false;
    private DateSelectionModel \u0109;
    private DateModel \u0101;
    private DateChooserPanel[] \u0105;
    private DateSelectionListener \u0102;
    public static final String VIEWONLY_PROPERTY = "viewonly";
    public static final String PROPERTY_VIEWONLY = "viewonly";
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_CALENDAR_DIMENSION = "calendarDimension";
    private boolean \u010a = false;
    private boolean \u0106 = true;
    private static final int \u0107 = 6;
    private static final int \u0108 = 6;

    public CalendarViewer() {
        this.\u0102();
        this.\u0101();
    }

    public CalendarViewer(Dimension dimension) {
        this.\u0104 = dimension;
        this.\u0102();
        this.\u0101();
    }

    public CalendarViewer(DateModel dateModel) {
        this.\u0101 = dateModel;
        this.\u0102();
        this.\u0101();
    }

    public CalendarViewer(DateModel dateModel, Dimension dimension) {
        this.\u0101 = dateModel;
        this.\u0104 = dimension;
        this.\u0102();
        this.\u0101();
    }

    private void \u0102() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (CalendarViewer.this.isAutoChangeDimension()) {
                    CalendarViewer.this.recalculateCalendarDimension();
                }
            }
        });
    }

    public void recalculateCalendarDimension() {
        Dimension dimension = this.getSize();
        DateChooserPanel dateChooserPanel = new DateChooserPanel();
        this.customizeDateChooserPanel(dateChooserPanel, 0, 0);
        Dimension dimension2 = dateChooserPanel.getPreferredSize();
        int n2 = dimension.width / (dimension2.width + 6);
        int n3 = dimension.height / (dimension2.height + 6);
        Dimension dimension3 = this.getCalendarDimension();
        if (n3 != dimension3.height || n2 != dimension3.width) {
            this.\u0101(new Dimension(n2, n3));
        }
    }

    private void \u0101() {
        int n2;
        this.removeAll();
        int n3 = this.\u0104.width;
        int n4 = this.\u0104.height;
        if (n4 == 0 || n3 == 0) {
            return;
        }
        if (this.isAutoChangeDimension()) {
            this.setLayout(new FlowLayout(10, 6, 6));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        } else {
            this.setLayout(new GridLayout(n4, n3, 6, 6));
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        }
        if (this.getSelectionModel() == null) {
            this.\u0109 = new DefaultDateSelectionModel(2);
        }
        if (this.getDateModel() == null) {
            this.setDateModel(new DefaultDateModel());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DateChooserPanel dateChooserPanel = (DateChooserPanel)propertyChangeEvent.getSource();
                int n2 = dateChooserPanel.getDisplayIndex();
                Calendar calendar = (Calendar)propertyChangeEvent.getNewValue();
                calendar.add(2, -n2);
                for (int i2 = 0; i2 < CalendarViewer.this.\u0105.length; ++i2) {
                    DateChooserPanel dateChooserPanel2 = CalendarViewer.this.\u0105[i2];
                    if (dateChooserPanel2 != dateChooserPanel) {
                        dateChooserPanel2.removePropertyChangeListener("displayMonth", this);
                        dateChooserPanel2.setDisplayedMonth(calendar.get(1), calendar.get(2), true);
                        dateChooserPanel2.addPropertyChangeListener("displayMonth", this);
                    }
                    calendar.add(2, 1);
                }
            }
        };
        this.\u0102 = new DateSelectionListener(){

            @Override
            public void valueChanged(DateSelectionEvent dateSelectionEvent) {
                if (dateSelectionEvent.getSource() instanceof DateSelectionModel) {
                    CalendarViewer.this.\u0101((DateSelectionModel)dateSelectionEvent.getSource());
                } else {
                    CalendarViewer.this.\u0101(null);
                }
            }
        };
        this.getSelectionModel().addDateSelectionListener(this.\u0102);
        if (this.\u0105 != null) {
            for (n2 = 0; n2 < this.\u0105.length; ++n2) {
                DateChooserPanel dateChooserPanel = this.\u0105[n2];
                dateChooserPanel.addPropertyChangeListener("displayMonth", propertyChangeListener);
                this.\u0105[n2] = null;
            }
        }
        this.\u0105 = new DateChooserPanel[n4 * n3];
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                DateChooserPanel dateChooserPanel = this.createDateChooserPanel(this.getDateModel(), this.getSelectionModel());
                dateChooserPanel.setCalendarViewer(this);
                dateChooserPanel.setDisplayIndex(n2 * n3 + i2);
                this.customizeDateChooserPanel(dateChooserPanel, n2, i2);
                dateChooserPanel.setDisplayedMonth(calendar.get(1), calendar.get(2), true);
                dateChooserPanel.addPropertyChangeListener("displayMonth", propertyChangeListener);
                this.add(dateChooserPanel);
                this.\u0105[n2 * n3 + i2] = dateChooserPanel;
                calendar.add(2, 1);
            }
        }
        this.repaint();
    }

    protected void customizeDateChooserPanel(final DateChooserPanel dateChooserPanel, int n2, int n3) {
        int n4 = this.getCalendarDimension().height;
        int n5 = this.getCalendarDimension().width;
        dateChooserPanel.setShowPreviousButton(n2 == 0 && n3 == 0);
        dateChooserPanel.setShowPreviousYearButton(n2 == 0 && n3 == 0);
        dateChooserPanel.setShowNextButton(n2 == 0 && n3 == n5 - 1);
        dateChooserPanel.setShowNextYearButton(n2 == 0 && n3 == n5 - 1);
        dateChooserPanel.setShowPreviousMonthDays(n2 == 0 && n3 == 0);
        dateChooserPanel.setShowNextMonthDays(n2 == n4 - 1 && n3 == n5 - 1);
        dateChooserPanel.setShowTodayButton(false);
        dateChooserPanel.setShowNoneButton(false);
        this.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() instanceof Locale) {
                    dateChooserPanel.setLocale((Locale)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    protected DateChooserPanel createDateChooserPanel(DateModel dateModel, DateSelectionModel dateSelectionModel) {
        DateChooserPanel dateChooserPanel = new DateChooserPanel(dateModel);
        dateChooserPanel.setViewOnly(this.isViewOnly());
        dateChooserPanel.setSelectionModel(dateSelectionModel);
        return dateChooserPanel;
    }

    public DateChooserPanel[] getDateChooserPanels() {
        return this.\u0105;
    }

    private void \u0101(DateSelectionModel dateSelectionModel) {
        Serializable serializable;
        boolean[] blArray = null;
        if (dateSelectionModel instanceof DefaultDateSelectionModel && ((DefaultDateSelectionModel)dateSelectionModel).\u0105() != null) {
            Date[] dateArray = dateSelectionModel.getSelectedDates();
            serializable = new HashSet();
            if (dateArray != null) {
                serializable.addAll(Arrays.asList(dateArray));
            }
            Date[] dateArray2 = ((DefaultDateSelectionModel)dateSelectionModel).\u0105().getSelectedDates();
            HashSet<Date> hashSet = new HashSet<Date>();
            List<Date> list = null;
            if (dateArray2 != null) {
                list = Arrays.asList(dateArray2);
                hashSet.addAll(list);
            }
            hashSet.retainAll((Collection<?>)((Object)serializable));
            if (list != null) {
                serializable.addAll(list);
            }
            serializable.removeAll(hashSet);
            blArray = new boolean[this.\u0105.length];
            Object[] objectArray = new Object[this.\u0105.length];
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                blArray[i2] = false;
                objectArray[i2] = this.\u0105[i2].\u0139();
            }
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                Date date = (Date)iterator.next();
                if (date == null) continue;
                int n2 = JideSwingUtilities.binarySearch(objectArray, date);
                if (n2 < 0) {
                    n2 = 0 - n2 - 1;
                }
                if (n2 >= this.\u0105.length || blArray[n2] || n2 == 0 && date.before((Date)objectArray[0])) continue;
                blArray[n2] = true;
            }
        }
        for (int i3 = 0; i3 < this.\u0105.length; ++i3) {
            serializable = this.\u0105[i3];
            if (blArray != null && blArray[i3] == false) continue;
            ((DateChooserPanel)serializable).updateCalendar();
        }
    }

    public Dimension getCalendarDimension() {
        return this.\u0104;
    }

    public void setCalendarDimension(Dimension dimension) {
        if (this.isAutoChangeDimension()) {
            return;
        }
        this.\u0101(dimension);
    }

    private void \u0101(Dimension dimension) {
        Dimension dimension2 = this.\u0104;
        if (dimension != null && !dimension.equals(dimension2)) {
            this.\u0104 = dimension;
            this.\u0101();
            this.revalidate();
            this.repaint();
            this.firePropertyChange(PROPERTY_CALENDAR_DIMENSION, dimension2, this.\u0104);
        }
    }

    public boolean isAutoChangeDimension() {
        return this.\u0103;
    }

    public void setAutoChangeDimension(boolean bl) {
        boolean bl2 = this.\u0103;
        if (bl2 != bl) {
            this.\u0103 = bl;
            this.\u0101();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isAutoChangeDimension()) {
            DateChooserPanel dateChooserPanel = new DateChooserPanel();
            this.customizeDateChooserPanel(dateChooserPanel, 0, 0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(10, 6, 6));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(dateChooserPanel);
            return jPanel.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    public Calendar getMaxDisplayCalendar() {
        if (this.\u0105 != null && this.\u0105.length > 0) {
            return this.\u0105[this.\u0105.length - 1].getDisplayedCalendar();
        }
        return null;
    }

    public Calendar getMinDisplayCalendar() {
        if (this.\u0105 != null && this.\u0105.length > 0) {
            return this.\u0105[0].getDisplayedCalendar();
        }
        return null;
    }

    public DateSelectionModel getSelectionModel() {
        return this.\u0109;
    }

    public void setSelectionModel(DateSelectionModel dateSelectionModel) {
        if (this.\u0109 != dateSelectionModel) {
            if (this.\u0109 != null && this.\u0102 != null) {
                this.\u0109.removeDateSelectionListener(this.\u0102);
            }
            for (DateChooserPanel dateChooserPanel : this.\u0105) {
                dateChooserPanel.setSelectionModel(dateSelectionModel);
            }
            this.\u0109 = dateSelectionModel;
            if (this.\u0109 != null && this.\u0102 != null) {
                this.\u0109.addDateSelectionListener(this.\u0102);
            }
        }
    }

    public DateModel getDateModel() {
        return this.\u0101;
    }

    public void setDateModel(DateModel dateModel) {
        this.\u0101 = dateModel;
        this.\u0101.addDateModelListener(new DateModelListener(){

            @Override
            public void dateModelChanged(DateModelEvent dateModelEvent) {
                CalendarViewer.this.\u0101(null);
            }
        });
    }

    public boolean setDisplayedMonth(int n2, int n3) {
        return this.setDisplayedMonth(n2, n3, 0);
    }

    public boolean setDisplayedMonth(int n2, int n3, int n4) {
        if (this.\u0105 != null && this.\u0105.length > 0) {
            Calendar calendar;
            if (n4 < this.\u0105.length && (calendar = this.\u0105[n4].getDisplayedCalendar()).get(1) == n2 && calendar.get(2) == n3) {
                return true;
            }
            this.\u0101((DateSelectionModel)null);
            calendar = this.\u0105[0].getDisplayedCalendar();
            Calendar calendar2 = this.\u0105[this.\u0105.length - 1].getDisplayedCalendar();
            calendar2.add(2, 1);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.set(1, n2);
            calendar3.set(2, n3);
            calendar3.set(5, 1);
            if (this.getDateModel().monthInRange(calendar3)) {
                DateChooserPanel.convertToMidnight(calendar3);
                DateChooserPanel.convertToMidnight(calendar);
                DateChooserPanel.convertToMidnight(calendar2);
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 >= this.\u0105.length) {
                    n4 = this.\u0105.length - 1;
                }
                this.\u0105[n4].setDisplayedMonth(calendar3.get(1), calendar3.get(2), true);
                return true;
            }
        }
        return false;
    }

    public boolean isViewOnly() {
        return this.\u010a;
    }

    public void setViewOnly(boolean bl) {
        boolean bl2 = this.\u010a;
        if (bl2 != bl) {
            this.\u010a = bl;
            this.firePropertyChange("viewonly", this.\u010a, bl2);
            for (DateChooserPanel dateChooserPanel : this.\u0105) {
                dateChooserPanel.setViewOnly(this.\u010a);
            }
            if (!this.\u010a) {
                int n2 = this.\u0104.width;
                int n3 = this.\u0104.height;
                for (int i2 = 0; i2 < n3; ++i2) {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        this.customizeDateChooserPanel(this.\u0105[i2 * n2 + i3], i2, i3);
                    }
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.\u0106;
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.\u0106;
        if (bl2 != bl) {
            this.\u0106 = bl;
            this.firePropertyChange(PROPERTY_ENABLED, this.\u0106, bl2);
            for (DateChooserPanel dateChooserPanel : this.\u0105) {
                dateChooserPanel.setEnabled(this.\u0106);
            }
            if (!this.\u0106) {
                int n2 = this.\u0104.width;
                int n3 = this.\u0104.height;
                for (int i2 = 0; i2 < n3; ++i2) {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        this.customizeDateChooserPanel(this.\u0105[i2 * n2 + i3], i2, i3);
                    }
                }
            }
        }
    }

    public int getFirstDayOfWeek() {
        return this.\u0105 != null && this.\u0105.length >= 1 ? this.\u0105[0].getFirstDayOfWeek() : -1;
    }

    public void setFirstDayOfWeek(int n2) {
        if (this.\u0105 != null) {
            for (DateChooserPanel dateChooserPanel : this.\u0105) {
                dateChooserPanel.setFirstDayOfWeek(n2);
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(CalendarViewer.class.getName(), 4);
        }
    }
}

