/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.E;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.event.ImageChangeEvent;
import com.jidesoft.chart.event.ImageChangeListener;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.CopiedChartModel;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.swing.Timer;

public class SingleImageLazyChartRenderer
implements E<ChartModel>,
Frontable,
ActionListener {
    private static final Logger \u0145 = Logger.getLogger(SingleImageLazyChartRenderer.class.getName());
    private final Lock \u0144 = new ReentrantLock(false);
    private List<ChartModel> \u0139 = new ArrayList<ChartModel>();
    private BufferedImage \u0142;
    private Image \u013b;
    private long \u0146;
    private Chart \u013e;
    private Point2D \u0143;
    private Point2D \u013c;
    private Point \u013a;
    private Point \u0141;
    private Timer \u0140;
    private int \u013d = 100;
    private Thread \u0147;
    private A \u0138;
    private List<ImageChangeListener> \u013f = new CopyOnWriteArrayList<ImageChangeListener>();

    public SingleImageLazyChartRenderer(Chart chart) {
        this.\u013e = chart;
    }

    public Chart getChart() {
        return this.\u013e;
    }

    private void \u0101(List<ChartModel> list) {
        this.\u0144.lock();
        try {
            this.\u0139 = list;
        }
        finally {
            this.\u0144.unlock();
        }
    }

    public long lastModified() {
        return this.\u0146;
    }

    public ChartModel getModel() {
        if (this.\u0139.size() > 0) {
            return this.\u0139.get(0);
        }
        return null;
    }

    @Override
    public void addImageChangeListener(ImageChangeListener imageChangeListener) {
        this.\u013f.add(imageChangeListener);
    }

    @Override
    public void removeImageChangeListener(ImageChangeListener imageChangeListener) {
        this.\u013f.remove(imageChangeListener);
    }

    protected void fireImageChange() {
        ImageChangeEvent imageChangeEvent = new ImageChangeEvent(this);
        for (ImageChangeListener imageChangeListener : this.\u013f) {
            imageChangeListener.imageChanged(imageChangeEvent);
        }
    }

    @Override
    public void updateImage(ChartModel chartModel, boolean bl) {
        if (this.\u0139.contains(chartModel)) {
            this.\u0139.remove(chartModel);
        }
        if (!this.\u0139.contains(chartModel)) {
            this.\u0139.add(chartModel);
        }
        this.updateCharts(true);
    }

    @Override
    public void removeImage(ChartModel chartModel) {
    }

    @Override
    public void cancelDrawing() {
        if (this.\u0138 != null) {
            this.\u0138.\u0102();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.drawImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImmediately() {
        this.\u0144.lock();
        try {
            int n2 = this.\u013e.getXStart();
            int n3 = this.\u013e.getYEnd();
            int n4 = this.\u013e.getXEnd();
            int n5 = this.\u013e.getYStart();
            int n6 = n4 - n2;
            int n7 = n5 - n3;
            this.\u013a = new Point(n2, n3);
            this.\u0141 = new Point(n4, n5);
            Point2D point2D = this.\u013e.calculateUserPoint(this.\u013a);
            Point2D point2D2 = this.\u013e.calculateUserPoint(this.\u0141);
            if (n6 > 0 && n7 > 0 && point2D != null && point2D2 != null) {
                if (this.\u0142 != null) {
                    this.\u0142.flush();
                }
                this.\u0142 = new BufferedImage(n6, n7, 2);
                if (this.\u0147 != null && this.\u0147.isAlive()) {
                    if (this.\u0138 != null) {
                        this.\u0138.\u0102();
                    }
                    this.\u0147.interrupt();
                }
                this.\u0138 = new A(this, this.\u0142, this.\u0139, this.\u013e.\u010c(), point2D, point2D2);
                this.\u0147 = new Thread((Runnable)this.\u0138, "Plotter");
                this.\u0147.start();
            } else {
                this.\u013b = null;
            }
        }
        finally {
            this.\u0144.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImage(Image image, Point2D point2D, Point2D point2D2) {
        this.\u0144.lock();
        try {
            this.\u013b = image;
            this.\u0143 = point2D;
            this.\u013c = point2D2;
            this.\u0146 = System.currentTimeMillis();
            this.fireImageChange();
        }
        finally {
            this.\u0144.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharts(boolean bl) {
        \u0145.fine("updateCharts");
        this.\u0144.lock();
        try {
            this.\u0101(this.\u013e.getModels());
            int n2 = this.\u013e.getXStart();
            int n3 = this.\u013e.getYEnd();
            int n4 = this.\u013e.getXEnd();
            int n5 = this.\u013e.getYStart();
            int n6 = n4 - n2;
            int n7 = n5 - n3;
            if (n6 > 0 && n7 > 0) {
                if (this.\u013e.isLazyRendering()) {
                    if (this.\u0140 != null && this.\u0140.isRunning()) {
                        this.\u0140.restart();
                    } else {
                        this.\u0140 = new Timer(this.\u013d, this);
                        this.\u0140.setRepeats(false);
                        \u0145.fine("Starting timer");
                        this.\u0140.start();
                    }
                } else {
                    this.\u013b = null;
                }
            } else {
                this.\u013b = null;
            }
        }
        finally {
            this.\u0144.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics) {
        if (!this.\u013e.isLazyRendering()) {
            return;
        }
        this.\u0144.lock();
        try {
            if (this.\u013b == null) {
                return;
            }
            Point point = this.\u013e.calculatePixelPoint(this.\u0143);
            Point point2 = this.\u013e.calculatePixelPoint(this.\u013c);
            int n2 = point.x;
            int n3 = point.y;
            int n4 = point2.x;
            int n5 = point2.y;
            int n6 = n4 - n2;
            int n7 = Math.abs(n5 - n3);
            assert (n7 >= 0);
            graphics.drawImage(this.\u013b, n2, n3, n6, n7, this.\u013e);
        }
        finally {
            this.\u0144.unlock();
        }
    }

    @Override
    public boolean isAtFront() {
        return false;
    }

    @Override
    public void setAtFront(boolean bl) {
        throw new UnsupportedOperationException("Lazy Chart Renderer cannot be moved to the front");
    }

    static class A
    implements Runnable {
        private static final transient Logger \u010a = Logger.getLogger(A.class.getName());
        private static A \u0109;
        private Image \u0107;
        private List<ChartModel> \u0103;
        private Map<String, UserToPixelTransform> \u0106;
        private Point2D \u0104;
        private Point2D \u0101;
        private PropertyChangeSupport \u0108 = new PropertyChangeSupport(this);
        private SingleImageLazyChartRenderer \u0105;
        private volatile boolean \u0102 = false;

        A(SingleImageLazyChartRenderer singleImageLazyChartRenderer, Image image, List<ChartModel> list, Map<String, UserToPixelTransform> map, Point2D point2D, Point2D point2D2) {
            this.\u0101(list);
            this.\u0101(singleImageLazyChartRenderer);
            this.\u0101(image);
            this.\u0101(map);
            this.\u0101(point2D);
            this.\u0102(point2D2);
        }

        void \u0101(SingleImageLazyChartRenderer singleImageLazyChartRenderer) {
            this.\u0105 = singleImageLazyChartRenderer;
        }

        void \u0101(Image image) {
            this.\u0107 = image;
        }

        void \u0101(List<ChartModel> list) {
            this.\u0103 = new ArrayList<ChartModel>(list);
        }

        void \u0101(Map<String, UserToPixelTransform> map) {
            this.\u0106 = map;
        }

        void \u0101(Point2D point2D) {
            this.\u0104 = point2D;
        }

        void \u0102(Point2D point2D) {
            this.\u0101 = point2D;
        }

        public void \u0102(PropertyChangeListener propertyChangeListener) {
            this.\u0108.addPropertyChangeListener(propertyChangeListener);
        }

        public void \u0101(String string, PropertyChangeListener propertyChangeListener) {
            this.\u0108.addPropertyChangeListener(propertyChangeListener);
        }

        public void \u0101(PropertyChangeListener propertyChangeListener) {
            this.\u0108.removePropertyChangeListener(propertyChangeListener);
        }

        public void \u0102() {
            this.\u0102 = true;
        }

        @Override
        public void run() {
            long l2 = System.currentTimeMillis();
            Graphics2D graphics2D = (Graphics2D)this.\u0107.getGraphics();
            Chart chart = this.\u0105.getChart();
            if (chart.isAntiAliasing()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            chart.\u010b();
            for (int i2 = 0; this.\u0103 != null && i2 < this.\u0103.size(); ++i2) {
                CopiedChartModel copiedChartModel = new CopiedChartModel(this.\u0103.get(i2));
                ChartStyle chartStyle = chart.getStyle(copiedChartModel);
                UserToPixelTransform userToPixelTransform = this.\u0106.get(copiedChartModel.getName());
                if (chartStyle != null && chartStyle.isBarsVisible()) {
                    chart.\u0102(graphics2D, copiedChartModel, i2, userToPixelTransform);
                }
                if (this.\u0102 || Thread.interrupted()) {
                    this.\u0101();
                    break;
                }
                if (chartStyle == null || chartStyle.isLinesVisible()) {
                    chart.\u0101(graphics2D, copiedChartModel, i2, userToPixelTransform);
                }
                if (this.\u0102 || Thread.interrupted()) {
                    this.\u0101();
                    break;
                }
                if (chartStyle == null || chartStyle.isPointsVisible()) {
                    chart.\u0103(graphics2D, copiedChartModel, i2, userToPixelTransform);
                }
                if (!this.\u0102 && !Thread.interrupted()) continue;
                this.\u0101();
                break;
            }
            graphics2D.dispose();
            long l3 = System.currentTimeMillis();
            \u010a.fine(String.format("Buffer image for %s drawn in %.2fs", chart.getName(), (double)(l3 - l2) / 1000.0));
            if (!this.\u0102) {
                this.\u0105.updateImage(this.\u0107, this.\u0104, this.\u0101);
                this.\u0108.firePropertyChange("dirty", false, true);
                chart.repaint();
            }
        }

        private void \u0101() {
            this.\u0103 = null;
            this.\u0105 = null;
            this.\u0107 = null;
            this.\u0101 = null;
            this.\u0104 = null;
        }

        static A \u0101(SingleImageLazyChartRenderer singleImageLazyChartRenderer, Image image, List<ChartModel> list, Map<String, UserToPixelTransform> map, Point2D point2D, Point2D point2D2) {
            if (\u0109 == null) {
                \u0109 = new A(singleImageLazyChartRenderer, image, list, map, point2D, point2D2);
            } else {
                \u0109.\u0101(singleImageLazyChartRenderer);
                \u0109.\u0101(image);
                \u0109.\u0101(list);
                \u0109.\u0101(map);
                \u0109.\u0101(point2D);
                \u0109.\u0102(point2D2);
            }
            return \u0109;
        }
    }
}

