/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.JYTabbedPanePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.swing.IRotatableComponent;
import de.javasoft.swing.JYLabel;
import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.OverlapBoxLayout;
import de.javasoft.swing.SimpleDropDownButton;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.JYTabbedPaneUI;
import de.javasoft.swing.plaf.jytabbedpane.ButtonFactory;
import de.javasoft.swing.plaf.jytabbedpane.IButtonFactory;
import de.javasoft.swing.plaf.jytabbedpane.ICloseButtonStrategy;
import de.javasoft.swing.plaf.jytabbedpane.JYTabbedPaneLayout;
import de.javasoft.swing.plaf.jytabbedpane.Tab;
import de.javasoft.swing.plaf.jytabbedpane.TabOverviewDialog;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import org.jdesktop.swingx.icon.EmptyIcon;

public class BasicJYTabbedPaneUI
extends JYTabbedPaneUI {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private TabAreaPanel tabAreaPanel;
    private JPanel leadingTabsPanel;
    private JPanel trailingTabsPanel;
    private JPanel leadingTabControlsPanel;
    private JPanel trailingTabControlsPanel;
    private TabsPanelViewport tabsPanelViewport;
    private TabsPanel tabsPanel;
    private IButtonFactory buttonFactory;
    private int closeButtonGap;
    private boolean reversedCloseButtonPlacement;
    private int croppedEdgeSize;
    private Color croppedEdgeBackground;
    private Color croppedEdgeForeground;
    private boolean avoidTrailingCroppedTabs;
    private boolean avoidLeadingCroppedTabs;
    private int tabAutoScrollDelay;
    private boolean forcePopupMenuIconSpace;
    private TabPreviewHandler tabPreviewHandler;
    protected static WeakHashMap<JComponent, WeakReference<ComponentUI>> uis = new WeakHashMap();
    private WeakReference<TabOverviewDialog> tabOverviewDialog = new WeakReference<Object>(null);

    public void update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        WeakReference<ComponentUI> weakReference;
        ComponentUI componentUI;
        if (jComponent.getName() == null) {
            jComponent.setName("JYTabbedPane");
        }
        ComponentUI componentUI2 = componentUI = (weakReference = uis.get(jComponent)) == null ? null : (ComponentUI)weakReference.get();
        if (componentUI == null) {
            componentUI = new BasicJYTabbedPaneUI();
            uis.put(jComponent, new WeakReference<ComponentUI>(componentUI));
        }
        return componentUI;
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        if (jComponent.getLayout() == null) {
            jComponent.setLayout(this.createLayoutManager());
            this.installComponents();
        }
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
        this.installActions(jComponent);
        this.updateTabbedPaneBorder();
        this.updateAllTabBorders();
        ComponentOrientation componentOrientation = jComponent.getComponentOrientation();
        jComponent.applyComponentOrientation(componentOrientation);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.tabPane = null;
        this.uninstallDefaults(jComponent);
        this.uninstallListeners(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        Boolean bl;
        String string;
        JYTabbedPane jYTabbedPane = (JYTabbedPane)jComponent;
        this.tabAreaInsets = new Insets(0, 0, 0, 0);
        JPanel jPanel = jYTabbedPane.getContentPanel();
        jPanel.updateUI();
        if (jYTabbedPane.paintSelectedTabBoldIsUIResource()) {
            jYTabbedPane.setPaintSelectedTabBold(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tab.selectedBold", jComponent, true), true);
        }
        if (jYTabbedPane.tabGapIsUIResource()) {
            jYTabbedPane.setTabGap(SyntheticaLookAndFeel.getInt("JYTabbedPane.tabGap", jComponent), true);
        }
        if (jYTabbedPane.horizontalTabAlignmentIsUIResource()) {
            jYTabbedPane.setHorizontalTabAlignment(SyntheticaLookAndFeel.getInt("JYTabbedPane.horizontalTabAlignment", jComponent, 2), true);
        }
        if (jYTabbedPane.verticalTabAlignmentIsUIResource()) {
            jYTabbedPane.setVerticalTabAlignment(SyntheticaLookAndFeel.getInt("JYTabbedPane.verticalTabAlignment", jComponent, 1), true);
        }
        if (jYTabbedPane.closeButtonStrategyIsUIResource()) {
            string = SyntheticaLookAndFeel.getString("JYTabbedPane.closeButtonStrategy", jComponent);
            if (string == null) {
                string = JYTabbedPane.CloseButtonStrategy.NONE.name();
            }
            jYTabbedPane.setCloseButtonStrategy(JYTabbedPane.CloseButtonStrategy.valueOf(string), true);
        }
        if (jYTabbedPane.tabStyleIsUIResource()) {
            string = SyntheticaLookAndFeel.getString("JYTabbedPane.tabStyle", jComponent);
            if (string == null) {
                string = JYTabbedPane.TabStyle.COMMON.name();
            }
            jYTabbedPane.setTabStyle(JYTabbedPane.TabStyle.valueOf(string), true);
        }
        if (jYTabbedPane.showScrollButtonsIsUIResource()) {
            string = "JYTabbedPane.showScrollButtons";
            bl = SyntheticaLookAndFeel.getBoolean(string, jComponent, true);
            jYTabbedPane.setShowScrollButtons(bl, true);
        }
        if (jYTabbedPane.showPopupButtonIsUIResource()) {
            string = "JYTabbedPane.showPopupButton";
            bl = SyntheticaLookAndFeel.getBoolean(string, jComponent, true);
            jYTabbedPane.setShowPopupButton(bl, true);
        }
        if (jYTabbedPane.overlapTabsInversIsUIResource()) {
            string = "JYTabbedPane.overlapTabsInvers";
            jYTabbedPane.setOverlapTabsInvers(SyntheticaLookAndFeel.getBoolean(string, jComponent, false), true);
        }
        if (jYTabbedPane.tabControlsPositionIsUIResource()) {
            string = SyntheticaLookAndFeel.getString("JYTabbedPane.tabControlsPosition", jComponent);
            if (string == null) {
                string = JYTabbedPane.TabControlsPosition.TRAILING.name();
            }
            jYTabbedPane.setTabControlsPosition(JYTabbedPane.TabControlsPosition.valueOf(string), true);
        }
        if (jYTabbedPane.tabControlsShowStrategyIsUIResource()) {
            string = SyntheticaLookAndFeel.getString("JYTabbedPane.tabControlsShowStrategy", jComponent);
            if (string == null) {
                string = JYTabbedPane.TabControlsShowStrategy.AS_NEEDED.name();
            }
            jYTabbedPane.setTabControlsShowStrategy(JYTabbedPane.TabControlsShowStrategy.valueOf(string), true);
        }
        if (jYTabbedPane.tabScrollAnimationEnabledIsUIResource()) {
            string = "JYTabbedPane.tabScrollAnimationEnabled";
            bl = SyntheticaLookAndFeel.get(string, jComponent) == null ? Boolean.TRUE : SyntheticaLookAndFeel.getBoolean(string, jComponent);
            jYTabbedPane.setTabScrollAnimationEnabled(bl, true);
        }
        if (jYTabbedPane.tabReorderByDraggingEnabledIsUIResource()) {
            string = "JYTabbedPane.tabReorderByDraggingEnabled";
            bl = SyntheticaLookAndFeel.get(string, jComponent) == null ? Boolean.TRUE : SyntheticaLookAndFeel.getBoolean(string, jComponent);
            jYTabbedPane.setTabReorderByDraggingEnabled(bl, true);
        }
        if (jYTabbedPane.minimumTabSizeIsUIResource()) {
            jYTabbedPane.setMinimumTabSize(SyntheticaLookAndFeel.getInt("JYTabbedPane.tab.minimumSize", jComponent, -1), true);
        }
        if (jYTabbedPane.maximumTabSizeIsUIResource()) {
            jYTabbedPane.setMaximumTabSize(SyntheticaLookAndFeel.getInt("JYTabbedPane.tab.maximumSize", jComponent, -1), true);
        }
        if (jYTabbedPane.tabsStretchedEnabledIsUIResource()) {
            jYTabbedPane.setTabsStretchedEnabled(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabsStretchedEnabled", jComponent), true);
        }
        if (jYTabbedPane.tabRotationEnabledIsUIResource()) {
            jYTabbedPane.setTabRotationEnabled(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabRotationEnabled", jComponent, true), true);
        }
        if (jYTabbedPane.showPlusButtonIsUIResource()) {
            jYTabbedPane.setShowPlusButton(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.showPlusButton", jComponent, false), true);
        }
        if (jYTabbedPane.tabOverviewEnabledIsUIResource()) {
            jYTabbedPane.setTabOverviewEnabled(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabOverviewEnabled", jComponent, false), true);
        }
        if (jYTabbedPane.tabPreviewOnHoverEnabledIsUIResource()) {
            jYTabbedPane.setTabPreviewOnHoverEnabled(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabPreviewOnHoverEnabled", jComponent, false), true);
        }
        this.closeButtonGap = SyntheticaLookAndFeel.getInt("JYTabbedPane.tab.closeButtonGap", this.tabPane, 6);
        this.reversedCloseButtonPlacement = SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tab.reversedCloseButtonPlacement", this.tabPane, false);
        this.tabAutoScrollDelay = SyntheticaLookAndFeel.getInt("JYTabbedPane.tab.autoScrollDelay", this.tabPane, 250);
        this.croppedEdgeSize = SyntheticaLookAndFeel.getInt("JYTabbedPane.tabsPanel.croppedEdge.size", jComponent, 3);
        this.croppedEdgeBackground = SyntheticaLookAndFeel.getColor("JYTabbedPane.tabsPanel.croppedEdge.background", jComponent);
        this.forcePopupMenuIconSpace = SyntheticaLookAndFeel.getBoolean("JYTabbedPane.popupMenu.forceIconSpace", jComponent);
        if (this.croppedEdgeBackground == null) {
            this.croppedEdgeBackground = SyntheticaLookAndFeel.getColor("Panel.background", jComponent);
        }
        this.croppedEdgeForeground = SyntheticaLookAndFeel.getColor("JYTabbedPane.tabsPanel.croppedEdge.foreground", jComponent);
        if (this.croppedEdgeForeground == null) {
            this.croppedEdgeForeground = new Color(0x40000000, true);
        }
        this.avoidLeadingCroppedTabs = this.avoidTrailingCroppedTabs = SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabsPanel.avoidCroppedTabs", jComponent);
        ((OverlapBoxLayout)this.tabsPanel.getLayout()).setSpaceForInvisibleComponentsRetained(this.avoidTrailingCroppedTabs);
    }

    private void installActions(JComponent jComponent) {
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put("closeTab", new Tab.CloseTabAction());
        actionMap.put("addTab", this.tabsPanel.createAddTabAction());
        actionMap.put("setSelectedTabIndex", this.tabsPanel.createMnemonicAction());
        actionMap.put("scrollTabIndexToVisible", this.tabsPanel.createScrollTabIndexToVisibleAction());
    }

    protected void uninstallDefaults(JComponent jComponent) {
    }

    protected void installListeners(JComponent jComponent) {
        this.tabPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = ((DefaultSingleSelectionModel)changeEvent.getSource()).getSelectedIndex();
                if (SyntheticaLookAndFeel.getBoolean("JYTabbedPane.focusFollowsSelection", BasicJYTabbedPaneUI.this.tabPane, true) && ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabsFocusable() && BasicJYTabbedPaneUI.this.tabsPanel != null && BasicJYTabbedPaneUI.this.tabsPanel.getTab(n) != null && !BasicJYTabbedPaneUI.this.tabOverviewVisible()) {
                    BasicJYTabbedPaneUI.this.tabsPanel.getTab(n).requestFocus();
                }
            }
        });
    }

    private boolean tabOverviewVisible() {
        return this.tabOverviewDialog.get() != null && ((TabOverviewDialog)this.tabOverviewDialog.get()).isVisible();
    }

    protected void uninstallListeners(JComponent jComponent) {
    }

    private void installButtonFactory() {
        String string = SyntheticaLookAndFeel.getString("JYTabbedPane.buttonFactory.className", this.tabPane);
        if (string == null) {
            this.buttonFactory = new ButtonFactory();
        } else {
            try {
                this.buttonFactory = (IButtonFactory)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    protected void installComponents() {
        this.installButtonFactory();
        int n = this.tabPane.getTabPlacement();
        this.trailingTabControlsPanel = new JPanel();
        this.trailingTabControlsPanel.setLayout(new BoxLayout(this.trailingTabControlsPanel, n == 1 || n == 3 ? 2 : 3));
        this.trailingTabControlsPanel.setOpaque(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabControlsPanel.opaque", this.tabPane, true));
        this.trailingTabControlsPanel.add(this.createScrollBackwardButton());
        this.trailingTabControlsPanel.add(this.createScrollForwardButton());
        this.trailingTabControlsPanel.add(this.createPopupButton());
        this.trailingTabsPanel = new JPanel(new BorderLayout());
        this.trailingTabsPanel.setName("JYTabbedPane.TrailingTabsPanel");
        this.trailingTabsPanel.setOpaque(false);
        this.trailingTabsPanel.add((Component)this.trailingTabControlsPanel, this.getBLConstraints(1, n, "Before"));
        JComponent jComponent = ((JYTabbedPane)this.tabPane).getTrailingTabAreaComponent();
        if (jComponent != null) {
            this.trailingTabsPanel.add(jComponent);
        }
        this.leadingTabControlsPanel = new JPanel();
        this.leadingTabControlsPanel.setLayout(new BoxLayout(this.leadingTabControlsPanel, n == 1 || n == 3 ? 2 : 3));
        this.leadingTabControlsPanel.setOpaque(SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabControlsPanel.opaque", this.tabPane, true));
        this.leadingTabControlsPanel.add(this.createTabOverviewButton());
        this.leadingTabControlsPanel.add(this.createScrollBackwardButton());
        this.leadingTabControlsPanel.add(this.createScrollForwardButton());
        this.leadingTabControlsPanel.add(this.createPopupButton());
        this.leadingTabsPanel = new JPanel(new BorderLayout());
        this.leadingTabsPanel.setName("JYTabbedPane.LeadingTabsPanel");
        this.leadingTabsPanel.setOpaque(false);
        this.leadingTabsPanel.add((Component)this.leadingTabControlsPanel, this.getBLConstraints(1, n, "After"));
        JComponent jComponent2 = ((JYTabbedPane)this.tabPane).getLeadingTabAreaComponent();
        if (jComponent2 != null) {
            this.leadingTabsPanel.add(jComponent2);
        }
        this.tabsPanel = new TabsPanel();
        this.tabsPanelViewport = new TabsPanelViewport();
        this.tabsPanelViewport.setView(this.tabsPanel);
        this.tabAreaPanel = new TabAreaPanel();
        this.tabAreaPanel.add((Component)this.leadingTabsPanel, this.getBLConstraints(1, n, "Before"));
        this.tabAreaPanel.add(this.tabsPanelViewport);
        this.tabAreaPanel.add((Component)this.trailingTabsPanel, this.getBLConstraints(1, n, "After"));
        this.tabPane.add((Component)this.tabAreaPanel, this.getBLConstraints(1, n, "First"));
        this.tabPane.add((Component)((JYTabbedPane)this.tabPane).getContentPanel(), "Center");
        this.installTabs(this.tabPane);
    }

    protected void updateTabbedPaneBorder() {
    }

    protected void uninstallComponents() {
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (n == 2 || n == 4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n3 = n == 2 ? -90 : 90;
            double d = n == 2 ? -(rectangle.width - rectangle.height) / 2 : (rectangle.width - rectangle.height) / 2;
            graphics2D.translate(d, d);
            graphics2D.rotate(Math.toRadians(n3), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            super.paintIcon(graphics, n, n2, icon, rectangle, bl);
            graphics2D.rotate(-Math.toRadians(n3), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            graphics2D.translate(-d, -d);
        } else {
            super.paintIcon(graphics, n, n2, icon, rectangle, bl);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        int n2 = this.tabPane.getTabPlacement();
        if (this.isVerticalTabPlacement() && !this.tabPane.getComponentOrientation().isLeftToRight()) {
            n2 = n2 == 2 ? 4 : 2;
        }
        Rectangle rectangle = SwingUtilities.convertRectangle(this.tabsPanelViewport.getParent(), this.tabsPanelViewport.getBounds(), this.tabPane);
        if (this.tabsPanel.getShowPlusButton()) {
            this.tabsPanelViewport.calculatePlusButtonAwareViewRect(rectangle);
        }
        this.tabPane.putClientProperty("JTabbedPane.visibleSelectedTabRect", (n = this.tabPane.getSelectedIndex()) < 0 || n >= this.rects.length ? null : rectangle.intersection(this.rects[n]));
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
    }

    protected LayoutManager createLayoutManager() {
        return new JYTabbedPaneLayout((JYTabbedPane)this.tabPane, this);
    }

    protected JButton createScrollForwardButton() {
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = -4600543021015290032L;

            public void actionPerformed(ActionEvent actionEvent) {
                BasicJYTabbedPaneUI.this.tabsPanelViewport.scrollForward();
            }
        };
        abstractAction.putValue("ShortDescription", UIManager.get("JYTabbedPane.scrollButton.forward.toolTip"));
        JButton jButton = this.buttonFactory.createScrollForwardButton((JYTabbedPane)this.tabPane, abstractAction);
        if (SyntheticaLookAndFeel.getBoolean("JYTabbedPane.scrollButton.doubleClickSupport", this.tabPane, true)) {
            jButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        BasicJYTabbedPaneUI.this.tabsPanelViewport.setLeadingTabIndex(BasicJYTabbedPaneUI.this.tabPane.getTabCount() - 1);
                    }
                }
            });
        }
        return jButton;
    }

    protected JButton createScrollBackwardButton() {
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 5713855202221320228L;

            public void actionPerformed(ActionEvent actionEvent) {
                BasicJYTabbedPaneUI.this.tabsPanelViewport.scrollBackward();
            }
        };
        abstractAction.putValue("ShortDescription", UIManager.get("JYTabbedPane.scrollButton.backward.toolTip"));
        JButton jButton = this.buttonFactory.createScrollBackwardButton((JYTabbedPane)this.tabPane, abstractAction);
        if (SyntheticaLookAndFeel.getBoolean("JYTabbedPane.scrollButton.doubleClickSupport", this.tabPane, true)) {
            jButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        BasicJYTabbedPaneUI.this.tabsPanelViewport.setLeadingTabIndex(0);
                    }
                }
            });
        }
        return jButton;
    }

    protected JButton createPlusButton() {
        Action action = this.getTabbedPane().getActionMap().get("addTab");
        return this.buttonFactory.createPlusButton((JYTabbedPane)this.tabPane, action);
    }

    protected JButton createTabOverviewButton() {
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = -1692512757990693052L;

            public void actionPerformed(ActionEvent actionEvent) {
                BasicJYTabbedPaneUI.this.tabOverviewDialog = new WeakReference<TabOverviewDialog>(new TabOverviewDialog(BasicJYTabbedPaneUI.this.getTabbedPane(), BasicJYTabbedPaneUI.this.buttonFactory));
                ((TabOverviewDialog)BasicJYTabbedPaneUI.this.tabOverviewDialog.get()).setVisible(true);
            }
        };
        abstractAction.putValue("ShortDescription", UIManager.get("JYTabbedPane.tabOverviewButton.toolTip"));
        return this.buttonFactory.createTabOverviewButton((JYTabbedPane)this.tabPane, abstractAction);
    }

    protected JButton createPopupButton() {
        return this.buttonFactory.createPopupButton((JYTabbedPane)this.tabPane);
    }

    private JButton getScrollButton(boolean bl) {
        return this.findButton(bl ? "JYTabbedPane.ScrollForwardButton" : "JYTabbedPane.ScrollBackwardButton");
    }

    private JButton getPopupButton() {
        return this.findButton("JYTabbedPane.PopupButton");
    }

    private JButton findButton(String string) {
        JButton jButton = (JButton)SyntheticaLookAndFeel.findComponent(string, (Container)this.leadingTabControlsPanel);
        if (!jButton.isVisible()) {
            jButton = (JButton)SyntheticaLookAndFeel.findComponent(string, (Container)this.trailingTabControlsPanel);
        }
        return jButton;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        int n4 = 0;
        if (n == 2 || n == 4) {
            n4 = super.calculateTabAreaHeight(n, this.runCount, n3);
        }
        n4 = super.calculateTabAreaWidth(n, n2, n3);
        return n4;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        if (n == 2 || n == 4) {
            return super.calculateTabAreaWidth(n, this.runCount, n3);
        }
        return super.calculateTabAreaHeight(n, n2, n3);
    }

    public int calculateMaxTabWidth(int n) {
        if (n == 2 || n == 4) {
            return super.calculateMaxTabHeight(n);
        }
        return super.calculateMaxTabWidth(n);
    }

    public int calculateMaxTabHeight(int n) {
        if (n == 2 || n == 4) {
            return super.calculateMaxTabWidth(n);
        }
        return super.calculateMaxTabHeight(n);
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        if (n == 2 || n == 4) {
            return this.tabsPanel.getTab((int)n2).getPreferredSize().height;
        }
        return this.tabsPanel.getTab((int)n2).getPreferredSize().width;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        if (n == 2 || n == 4) {
            return this.tabsPanel.getTab((int)n2).getPreferredSize().width;
        }
        return this.tabsPanel.getTab((int)n2).getPreferredSize().height;
    }

    protected View getTextViewForTab(int n) {
        return null;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return this.tabPane.getFontMetrics(font);
    }

    protected void selectNextTab(int n) {
        int n2 = this.tabsPanel.getTabCount() - 1;
        int n3 = n >= n2 ? 0 : n + 1;
        Rectangle rectangle = SwingUtilities.convertRectangle(this.tabsPanelViewport.getParent(), this.tabsPanelViewport.getBounds(), this.tabPane);
        if (!rectangle.contains(this.rects[n3])) {
            if (n3 < n) {
                this.tabsPanelViewport.setLeadingTabIndex(n3);
            } else {
                this.tabsPanelViewport.scrollForward();
            }
        }
        super.selectNextTab(n);
    }

    protected void selectPreviousTab(int n) {
        int n2 = this.tabsPanel.getTabCount() - 1;
        int n3 = n <= 0 ? n2 : n - 1;
        Rectangle rectangle = SwingUtilities.convertRectangle(this.tabsPanelViewport.getParent(), this.tabsPanelViewport.getBounds(), this.tabPane);
        if (!rectangle.contains(this.rects[n3])) {
            if (n3 > n) {
                this.tabsPanelViewport.setLeadingTabIndex(n3);
            } else {
                this.tabsPanelViewport.scrollBackward();
            }
        }
        super.selectPreviousTab(n);
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        if (!this.tabsPanel.isValid()) {
            this.tabsPanel.validate();
            this.tabsPanel.updateTabRects();
        }
        return n < this.rects.length ? this.getTabBounds(n, new Rectangle()) : new Rectangle();
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BasicJYTabbedPaneUI.this.cancelTabEdit();
                BasicJYTabbedPaneUI.this.updateAllTabBorders();
                BasicJYTabbedPaneUI.this.updateTabCloseButtons();
                JYTabbedPane jYTabbedPane = (JYTabbedPane)changeEvent.getSource();
                int n = jYTabbedPane.getSelectedIndex();
                if (n >= 0 && jYTabbedPane.isEnabledAt(n) && BasicJYTabbedPaneUI.this.tabsPanel.getTab(n) != null) {
                    BasicJYTabbedPaneUI.this.updateTabFontStyle();
                    if (jYTabbedPane.hasFocus()) {
                        BasicJYTabbedPaneUI.this.tabsPanel.getTab(n).requestFocus();
                    }
                }
            }
        };
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JYTabbedPane jYTabbedPane = (JYTabbedPane)propertyChangeEvent.getSource();
                String string = propertyChangeEvent.getPropertyName();
                if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
                    BasicJYTabbedPaneUI.this.installDefaults(jYTabbedPane);
                }
                if ("insertTab".equals(string)) {
                    BasicJYTabbedPaneUI.this.cancelTabEdit();
                    int n = BasicJYTabbedPaneUI.this.tabPane.getTabCount();
                    BasicJYTabbedPaneUI.this.assureRectsCreated(n);
                    int n2 = (Integer)propertyChangeEvent.getNewValue();
                    BasicJYTabbedPaneUI.this.addTab(jYTabbedPane, n2);
                } else if ("removeTab".equals(string)) {
                    BasicJYTabbedPaneUI.this.cancelTabEdit();
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    BasicJYTabbedPaneUI.this.tabsPanel.removeTab(n);
                    BasicJYTabbedPaneUI.this.updateAllTabBorders();
                } else if ("title".equals(string)) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(n);
                    JComponent jComponent = tab.getComponent();
                    if (jComponent instanceof JLabel) {
                        ((JLabel)jComponent).setText(jYTabbedPane.getTitleAt(n));
                    }
                } else if ("icon".equals(string)) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(n);
                    JComponent jComponent = tab.getComponent();
                    if (jComponent instanceof JLabel) {
                        ((JLabel)jComponent).setIcon(BasicJYTabbedPaneUI.this.getIconForTab(n));
                    }
                } else if ("toolTipText".equals(string)) {
                    BasicJYTabbedPaneUI.this.tabsPanelViewport.setToolTipText("");
                } else if ("tabPlacement".equals(string)) {
                    int n = (Integer)propertyChangeEvent.getOldValue();
                    int n3 = (Integer)propertyChangeEvent.getNewValue();
                    BasicJYTabbedPaneUI.this.updateAllTabBorders();
                    BasicJYTabbedPaneUI.this.updateLayout(jYTabbedPane, n, n3);
                    if (!jYTabbedPane.getTabRotationEnabled().booleanValue()) {
                        for (Tab tab : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                            BasicJYTabbedPaneUI.this.updateLayout(tab, n3, n);
                        }
                        BasicJYTabbedPaneUI.this.updateAllTabBorders();
                    }
                    BasicJYTabbedPaneUI.this.trailingTabControlsPanel.revalidate();
                    BasicJYTabbedPaneUI.this.leadingTabControlsPanel.revalidate();
                    if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                        BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.updatePlusButtonMargin();
                        BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.revalidate();
                    }
                } else if ("indexForTabComponent".equals(string)) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    if (jYTabbedPane.getTabComponentAt(n) != null) {
                        BasicJYTabbedPaneUI.this.addTab(jYTabbedPane, n);
                    }
                } else if ("leadingTabAreaComponent".equals(string)) {
                    Component component = (Component)propertyChangeEvent.getOldValue();
                    if (component != null) {
                        BasicJYTabbedPaneUI.this.leadingTabsPanel.remove(component);
                    }
                    if ((component = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                        BasicJYTabbedPaneUI.this.leadingTabsPanel.add(component);
                        int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                        BasicJYTabbedPaneUI.this.updateLayout((Container)component, 1, n);
                    }
                    BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                    BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                } else if ("trailingTabAreaComponent".equals(string)) {
                    Component component = (Component)propertyChangeEvent.getOldValue();
                    if (component != null) {
                        BasicJYTabbedPaneUI.this.trailingTabsPanel.remove(component);
                    }
                    if ((component = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                        BasicJYTabbedPaneUI.this.trailingTabsPanel.add(component);
                        int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                        BasicJYTabbedPaneUI.this.updateLayout((Container)component, 1, n);
                    }
                    BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                    BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                } else if ("componentOrientation".equals(string)) {
                    BasicJYTabbedPaneUI.this.updateAllTabBorders();
                    if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                        BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.updatePlusButtonMargin();
                    }
                } else if (!"paintSelectedTabBold".equals(string)) {
                    if ("tabGap".equals(string)) {
                        ((OverlapBoxLayout)BasicJYTabbedPaneUI.this.tabsPanel.getLayout()).setOverlapSize((Integer)propertyChangeEvent.getNewValue());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("horizontalTabAlignment".equals(string)) {
                        ((OverlapBoxLayout)BasicJYTabbedPaneUI.this.tabsPanel.getLayout()).setHorizontalAlignment((Integer)propertyChangeEvent.getNewValue());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("verticalTabAlignment".equals(string)) {
                        ((OverlapBoxLayout)BasicJYTabbedPaneUI.this.tabsPanel.getLayout()).setVerticalAlignment((Integer)propertyChangeEvent.getNewValue());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabControlsPosition".equals(string) || "showScrollButtons".equals(string) || "showPopupButton".equals(string) || "tabOverviewEnabled".equals(string)) {
                        BasicJYTabbedPaneUI.this.updateTabControls(jYTabbedPane.getTabControlsPosition(), jYTabbedPane.getShowScrollButtons(), jYTabbedPane.getShowPopupButton(), jYTabbedPane.getTabOverviewEnabled());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabPreviewOnHoverEnabled".equals(string)) {
                        if (jYTabbedPane.getTabPreviewOnHoverEnabled().booleanValue() && BasicJYTabbedPaneUI.this.tabPreviewHandler == null) {
                            BasicJYTabbedPaneUI.this.tabPreviewHandler = new TabPreviewHandler();
                            BasicJYTabbedPaneUI.this.tabPreviewHandler.install();
                        } else if (BasicJYTabbedPaneUI.this.tabPreviewHandler != null) {
                            BasicJYTabbedPaneUI.this.tabPreviewHandler.uninstall();
                            BasicJYTabbedPaneUI.this.tabPreviewHandler = null;
                        }
                    } else if ("minimumTabSize".equals(string) || "maximumTabSize".equals(string)) {
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabsStretchedEnabled".equals(string)) {
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabRotationEnabled".equals(string)) {
                        BasicJYTabbedPaneUI.this.updateAllTabBorders();
                        boolean bl = propertyChangeEvent.getOldValue() == null ? true : (Boolean)propertyChangeEvent.getOldValue();
                        boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                        int n = bl ? jYTabbedPane.getTabPlacement() : 1;
                        int n4 = bl2 ? jYTabbedPane.getTabPlacement() : 1;
                        Component[] componentArray = BasicJYTabbedPaneUI.this.tabsPanel.getComponents();
                        int n5 = componentArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Component component = componentArray[n6];
                            if (component instanceof PlusComponentPanel) {
                                BasicJYTabbedPaneUI.this.updateLayout(((PlusComponentPanel)component).buttonPane, n, n4);
                            } else {
                                BasicJYTabbedPaneUI.this.updateLayout((Container)component, n, n4);
                            }
                            ++n6;
                        }
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if ("tabsEditable".equals(string)) {
                        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        for (Tab tab : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                            JComponent jComponent = tab.getComponent();
                            if (!(jComponent instanceof JYLabel)) continue;
                            ((JYLabel)jComponent).setEditable(bl);
                        }
                    } else if ("tabsFocusable".equals(string)) {
                        boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        for (Tab tab : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                            tab.setFocusable(bl);
                        }
                    } else if ("showPlusButton".equals(string)) {
                        BasicJYTabbedPaneUI.this.tabsPanel.setShowPlusButton((Boolean)propertyChangeEvent.getNewValue());
                        BasicJYTabbedPaneUI.this.tabsPanel.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.repaint();
                    } else if (!"tabControlsShowStrategy".equals(string) && !"closeButtonStrategy".equals(string) && string != "mnemonicAt") {
                        if (string == "displayedMnemonicIndexAt") {
                            jYTabbedPane.repaint();
                        } else if (string == "indexForTitle" || string == "tabLayoutPolicy" || string == "opaque" || string != "background") {
                            // empty if block
                        }
                    }
                }
            }
        };
    }

    public void updateTabControls(JYTabbedPane.TabControlsPosition tabControlsPosition, Boolean bl, Boolean bl2, Boolean bl3) {
        if (tabControlsPosition == null || bl == null || bl2 == null || bl3 == null) {
            return;
        }
        switch (tabControlsPosition) {
            case LEADING: {
                Component[] componentArray = this.trailingTabControlsPanel.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component component = componentArray[n2];
                    component.setVisible(false);
                    ++n2;
                }
                this.leadingTabControlsPanel.getComponent(1).setVisible(bl);
                this.leadingTabControlsPanel.getComponent(2).setVisible(bl);
                this.leadingTabControlsPanel.getComponent(3).setVisible(bl2);
                break;
            }
            case TRAILING: {
                Component[] componentArray = this.leadingTabControlsPanel.getComponents();
                int n = componentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Component component = componentArray[n3];
                    component.setVisible(false);
                    ++n3;
                }
                this.trailingTabControlsPanel.getComponent(0).setVisible(bl);
                this.trailingTabControlsPanel.getComponent(1).setVisible(bl);
                this.trailingTabControlsPanel.getComponent(2).setVisible(bl2);
                break;
            }
            case LEADING_TRAILING: {
                this.leadingTabControlsPanel.getComponent(2).setVisible(false);
                this.leadingTabControlsPanel.getComponent(3).setVisible(false);
                this.trailingTabControlsPanel.getComponent(0).setVisible(false);
                this.leadingTabControlsPanel.getComponent(1).setVisible(bl);
                this.trailingTabControlsPanel.getComponent(1).setVisible(bl);
                this.trailingTabControlsPanel.getComponent(2).setVisible(bl2);
            }
        }
        this.leadingTabControlsPanel.getComponent(0).setVisible(bl3);
    }

    private void installTabs(JTabbedPane jTabbedPane) {
        int n = 0;
        while (n < jTabbedPane.getTabCount()) {
            this.addTab(jTabbedPane, n);
            ++n;
        }
    }

    private void addTab(JTabbedPane jTabbedPane, int n) {
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3 = jComponent2 = JAVA5 ? null : (JComponent)jTabbedPane.getTabComponentAt(n);
        if (jComponent2 != null && n < this.tabsPanel.getTabCount()) {
            this.tabsPanel.removeTab(n);
        } else if (jComponent2 == null) {
            jComponent = this.createTabLabel();
            if (jComponent instanceof JYLabel) {
                ((JYLabel)jComponent).setEditable(this.getTabbedPane().getTabsEditable());
            }
            jComponent.setBorder(new Border(){

                public Insets getBorderInsets(Component component) {
                    Tab tab;
                    Insets insets = new Insets(0, 0, 0, 0);
                    Container container = component.getParent();
                    Tab tab2 = tab = container == null ? null : (Tab)container.getParent();
                    if (tab != null && !tab.getCloseButton().isVisible()) {
                        return insets;
                    }
                    int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                    if (!((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabRotationEnabled().booleanValue() && n != 3) {
                        n = 1;
                    }
                    if (BasicJYTabbedPaneUI.this.reversedCloseButtonPlacement) {
                        if (n == 2) {
                            insets.bottom = BasicJYTabbedPaneUI.this.closeButtonGap;
                        } else if (n == 4) {
                            insets.top = BasicJYTabbedPaneUI.this.closeButtonGap;
                        } else if (component.getComponentOrientation().isLeftToRight()) {
                            insets.left = BasicJYTabbedPaneUI.this.closeButtonGap;
                        } else {
                            insets.right = BasicJYTabbedPaneUI.this.closeButtonGap;
                        }
                    } else if (n == 2) {
                        insets.top = BasicJYTabbedPaneUI.this.closeButtonGap;
                    } else if (n == 4) {
                        insets.bottom = BasicJYTabbedPaneUI.this.closeButtonGap;
                    } else if (component.getComponentOrientation().isLeftToRight()) {
                        insets.right = BasicJYTabbedPaneUI.this.closeButtonGap;
                    } else {
                        insets.left = BasicJYTabbedPaneUI.this.closeButtonGap;
                    }
                    return insets;
                }

                public boolean isBorderOpaque() {
                    return false;
                }

                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                }
            });
            ((JLabel)jComponent).setText(jTabbedPane.getTitleAt(n));
            ((JLabel)jComponent).setIcon(this.getIconForTab(n));
            ((JLabel)jComponent).setDisplayedMnemonic(this.tabPane.getMnemonicAt(n));
            jComponent2 = jComponent;
        }
        jComponent = new Tab((JYTabbedPane)this.tabPane, jComponent2);
        this.tabsPanel.add((Tab)jComponent, n);
        this.setTabBorder(n);
        if (jComponent2 instanceof IRotatableComponent) {
            ((IRotatableComponent)((Object)jComponent2)).setRotation(this.placementToRotation(jComponent2, jTabbedPane.getTabPlacement()));
        }
        this.updateTabFontStyle();
    }

    protected JLabel createTabLabel() {
        return new TabLabel();
    }

    protected Color getDefaultTabForeground(int n) {
        Color color = Color.BLACK;
        return color;
    }

    private void setTabBorder(int n) {
        boolean bl = n == this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        if (!((JYTabbedPane)this.tabPane).getTabRotationEnabled().booleanValue() && n2 != 3) {
            n2 = 1;
        }
        EmptyBorder emptyBorder = new EmptyBorder(this.rotateInsets(this.getTabInsets(bl), n2, true));
        this.tabsPanel.getTab(n).setBorder(emptyBorder);
    }

    protected Insets getTabInsets(boolean bl) {
        Insets insets = new Insets(0, 0, 0, 0);
        insets.top += 3;
        insets.left += 10;
        insets.bottom += 2;
        insets.right += 10;
        return insets;
    }

    private Insets rotateInsets(Insets insets, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl ? this.tabPane.getComponentOrientation().isLeftToRight() : true;
        if (n == 1 && !bl2) {
            return new Insets(insets.top, insets.right, insets.bottom, insets.left);
        }
        if (n == 3) {
            return bl2 ? new Insets(insets.bottom, insets.left, insets.top, insets.right) : new Insets(insets.bottom, insets.right, insets.top, insets.left);
        }
        if (n == 4) {
            return bl2 ? new Insets(insets.left, insets.bottom, insets.right, insets.top) : new Insets(insets.left, insets.top, insets.right, insets.bottom);
        }
        if (n == 2) {
            return bl2 ? new Insets(insets.right, insets.top, insets.left, insets.bottom) : new Insets(insets.right, insets.bottom, insets.left, insets.top);
        }
        return insets;
    }

    private void updateLayout(Container container, int n, int n2) {
        Object object;
        if (container == ((JYTabbedPane)this.tabPane).getContentPanel()) {
            return;
        }
        Component[] componentArray = container.getComponents();
        int n3 = componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = componentArray[n4];
            if (object instanceof Container) {
                this.updateLayout((Container)object, n, n2);
            }
            ++n4;
        }
        this.updateLayoutFlat(container, n, n2);
        if (container instanceof IRotatableComponent) {
            ((IRotatableComponent)((Object)container)).setRotation(this.placementToRotation(container, n2));
        } else if (container instanceof JToolBar) {
            object = this.placementToRotation(container, n2);
            ((JToolBar)container).setOrientation(object == IRotatableComponent.Rotation.NONE ? 0 : 1);
        }
    }

    private void updateLayoutFlat(Container container, int n, int n2) {
        LayoutManager layoutManager = container.getLayout();
        if (layoutManager instanceof BorderLayout) {
            boolean bl;
            BorderLayout borderLayout = (BorderLayout)layoutManager;
            int n3 = n2 - n;
            boolean bl2 = bl = container == this.tabAreaPanel || container == this.leadingTabsPanel || container == this.trailingTabsPanel;
            if (n == 3 || n == 2 && bl) {
                this.flipBorderLayout(borderLayout, n == 3);
            }
            if (n3 != 0) {
                if (Math.abs(n3) == 2) {
                    this.rotateBorderLayout(borderLayout, false);
                    this.rotateBorderLayout(borderLayout, false);
                } else {
                    boolean bl3 = n3 == -1 || n3 == 3;
                    this.rotateBorderLayout(borderLayout, bl3);
                }
            }
            if (n2 == 3 || n2 == 2 && bl) {
                this.flipBorderLayout(borderLayout, n2 == 3);
            }
        } else if (layoutManager instanceof BoxLayout) {
            boolean bl;
            boolean bl4 = bl = !((n != 1 && n != 3 || n2 != 2 && n2 != 4) && (n != 2 && n != 4 || n2 != 1 && n2 != 3));
            if (bl) {
                int n4 = ((BoxLayout)layoutManager).getAxis();
                int n5 = n4 == 2 ? 3 : (n4 == 3 ? 2 : (n4 == 0 ? 1 : 0));
                container.setLayout(new BoxLayout(container, n5));
            }
        } else if (layoutManager instanceof OverlapBoxLayout) {
            OverlapBoxLayout.Axis axis = n2 == 1 || n2 == 3 ? OverlapBoxLayout.Axis.LINE : OverlapBoxLayout.Axis.PAGE;
            OverlapBoxLayout overlapBoxLayout = (OverlapBoxLayout)layoutManager;
            overlapBoxLayout.setAxis(axis);
        }
    }

    private void rotateBorderLayout(BorderLayout borderLayout, boolean bl) {
        String[] stringArray = new String[]{"First", bl ? "After" : "Before", "Last", bl ? "Before" : "After"};
        int n = stringArray.length - 2;
        while (n >= 0) {
            Component component;
            Component component2 = borderLayout.getLayoutComponent(stringArray[n]);
            if (component2 != null) {
                borderLayout.removeLayoutComponent(component2);
            }
            if ((component = borderLayout.getLayoutComponent(stringArray[n + 1])) != null) {
                borderLayout.removeLayoutComponent(component);
            }
            if (component2 != null) {
                borderLayout.addLayoutComponent(component2, stringArray[n + 1]);
            }
            if (component != null) {
                borderLayout.addLayoutComponent(component, stringArray[n]);
            }
            --n;
        }
    }

    private void flipBorderLayout(BorderLayout borderLayout, boolean bl) {
        Component component;
        String[] stringArray = new String[]{bl ? "Before" : "First", bl ? "After" : "Last"};
        Component component2 = borderLayout.getLayoutComponent(stringArray[0]);
        if (component2 != null) {
            borderLayout.removeLayoutComponent(component2);
        }
        if ((component = borderLayout.getLayoutComponent(stringArray[1])) != null) {
            borderLayout.removeLayoutComponent(component);
        }
        if (component2 != null) {
            borderLayout.addLayoutComponent(component2, stringArray[1]);
        }
        if (component != null) {
            borderLayout.addLayoutComponent(component, stringArray[0]);
        }
    }

    private String getBLConstraints(int n, int n2, String string) {
        boolean bl = true;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        int[][] nArrayArray = new int[][]{{1, 2, 1, 3}, {1, 2, 2, 4}, {1, 2, 3, 1}, {1, 2, 4, 2}, {1, 4, 1, 4}, {1, 4, 2, 3}, {1, 4, 3, 1}, {1, 4, 4, 2}, {2, 4, 3, 4}, {1, 3, 1, 2}};
        if (n == 3 && n2 != 1) {
            n = 1;
        }
        int n6 = string.equals("First") ? 1 : (string.equals("Last") ? 2 : (string.equals("Before") ? 3 : 4));
        int n7 = -1;
        int n8 = 0;
        while (n8 < nArrayArray.length) {
            if (n == nArrayArray[n8][0] && n2 == nArrayArray[n8][1] && n6 == nArrayArray[n8][2]) {
                n7 = nArrayArray[n8][3];
                break;
            }
            if (n2 == nArrayArray[n8][0] && n == nArrayArray[n8][1] && n6 == nArrayArray[n8][3]) {
                n7 = nArrayArray[n8][2];
                break;
            }
            ++n8;
        }
        String string2 = string;
        switch (n7) {
            case 1: {
                string2 = "First";
                break;
            }
            case 2: {
                string2 = "Last";
                break;
            }
            case 3: {
                string2 = "Before";
                break;
            }
            case 4: {
                string2 = "After";
            }
        }
        return string2;
    }

    public IRotatableComponent.Rotation placementToRotation(int n) {
        return this.placementToRotation(null, n);
    }

    public IRotatableComponent.Rotation placementToRotation(Container container, int n) {
        boolean bl;
        boolean bl2 = ((JYTabbedPane)this.tabPane).getTabRotationEnabled();
        boolean bl3 = container instanceof Tab || SwingUtilities.getAncestorOfClass(Tab.class, container) != null;
        boolean bl4 = bl = SwingUtilities.getAncestorOfClass(PlusComponentPanel.class, container) != null;
        if (!bl2 && (container == null || bl3 || bl)) {
            return IRotatableComponent.Rotation.NONE;
        }
        return n == 1 || n == 3 ? IRotatableComponent.Rotation.NONE : (n == 2 ? IRotatableComponent.Rotation.LEFT : IRotatableComponent.Rotation.RIGHT);
    }

    private void repaintContentBorderGap() {
        int n = this.tabPane.getSelectedIndex();
        if (n >= 0 && n < this.rects.length) {
            Rectangle rectangle = ((JYTabbedPane)this.tabPane).getContentPanel().getBounds();
            int n2 = this.tabPane.getTabPlacement();
            if (this.isVerticalTabPlacement() && !this.tabPane.getComponentOrientation().isLeftToRight()) {
                int n3 = n2 = n2 == 2 ? 4 : 2;
            }
            if (n2 == 1) {
                rectangle.y = this.rects[n].y + this.rects[n].height;
                rectangle.height = 1;
            } else if (n2 == 3) {
                rectangle.y = this.rects[n].y - 1;
                rectangle.height = 1;
            } else if (n2 == 2) {
                rectangle.x = this.rects[n].x + this.rects[n].width;
                rectangle.width = 1;
            } else if (n2 == 4) {
                rectangle.x = this.rects[n].x - 1;
                rectangle.width = 1;
            }
            this.tabPane.repaint(rectangle);
        }
    }

    public boolean isVerticalTabPlacement() {
        int n = this.tabPane.getTabPlacement();
        return n == 2 || n == 4;
    }

    public float getTabControlsAlignment(boolean bl) {
        int n = this.tabPane.getTabPlacement();
        float f = 0.5f;
        if (bl) {
            if (n == 2) {
                f = 1.0f;
            } else if (n == 4) {
                f = 0.0f;
            }
            String string = SyntheticaLookAndFeel.getString("JYTabbedPane.tabControls.xAlignment", this.tabPane);
            if (string != null) {
                f = Alignment.valueOf(string).asFloat();
            }
        } else {
            if (n == 1) {
                f = 1.0f;
            } else if (n == 3) {
                f = 0.0f;
            }
            String string = SyntheticaLookAndFeel.getString("JYTabbedPane.tabControls.yAlignment", this.tabPane);
            if (string != null) {
                f = Alignment.valueOf(string).asFloat();
            }
        }
        return f;
    }

    public void updateTabFontStyle() {
        block12: {
            Object object;
            Font font;
            block14: {
                int n;
                int n2;
                block13: {
                    block11: {
                        boolean bl;
                        n2 = this.tabPane.getSelectedIndex();
                        if (n2 < 0 || n2 >= this.tabsPanel.getTabCount()) {
                            return;
                        }
                        font = this.tabPane.getFont();
                        if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                            SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.tabPane, Region.TABBED_PANE_TAB);
                            object = new SynthContext(this.tabPane, Region.TABBED_PANE_TAB, synthStyle, 0);
                            font = synthStyle.getFont((SynthContext)object);
                            if (SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tab.useSynthFont", this.tabPane)) {
                                int n3 = 0;
                                while (n3 < this.tabsPanel.getTabCount()) {
                                    JComponent jComponent = this.tabsPanel.getTab(n3).getComponent();
                                    jComponent.setFont(font);
                                    ++n3;
                                }
                                return;
                            }
                        }
                        n = this.tabsPanel.getTab(n2).getComponent().getFont().getStyle();
                        object = ((JYTabbedPane)this.tabPane).getPaintSelectedTabBold();
                        boolean bl2 = this.tabPane.getFont() == null ? false : (bl = !this.tabPane.getFont().getFamily().equals(font.getFamily()) || this.tabPane.getFont().getSize() != font.getSize());
                        if (!bl || ((Boolean)object).booleanValue()) break block11;
                        int n4 = 0;
                        while (n4 < this.tabsPanel.getTabCount()) {
                            JComponent jComponent = this.tabsPanel.getTab(n4).getComponent();
                            if (jComponent.getClientProperty("html") != null) {
                                jComponent.setFont(font.deriveFont(2));
                            }
                            jComponent.setFont(font);
                            ++n4;
                        }
                        break block12;
                    }
                    if (!((Boolean)object).booleanValue() || (n & 1) == 1) break block13;
                    int n5 = 0;
                    while (n5 < this.tabsPanel.getTabCount()) {
                        JComponent jComponent = this.tabsPanel.getTab(n5).getComponent();
                        if (n5 == n2) {
                            jComponent.setFont(font.deriveFont(1));
                        } else {
                            jComponent.setFont(font.deriveFont(0));
                        }
                        ++n5;
                    }
                    break block12;
                }
                if (((Boolean)object).booleanValue() || (n & 1) != 1) break block14;
                Tab tab = this.tabsPanel.getTab(n2);
                JComponent jComponent = tab.getComponent();
                jComponent.setFont(font.deriveFont(0));
                break block12;
            }
            if (((Boolean)object).booleanValue()) break block12;
            int n = 0;
            while (n < this.tabsPanel.getTabCount()) {
                JComponent jComponent = this.tabsPanel.getTab(n).getComponent();
                if (jComponent.getClientProperty("html") != null) {
                    jComponent.setFont(font.deriveFont(2));
                    jComponent.setFont(font.deriveFont(0));
                }
                ++n;
            }
        }
    }

    public void updateTabCloseButtons() {
        ICloseButtonStrategy iCloseButtonStrategy = ((JYTabbedPane)this.tabPane).getCloseButtonStrategy();
        for (Tab tab : this.tabsPanel.getTabs()) {
            tab.getCloseButton().setVisible(iCloseButtonStrategy.isButtonVisible((JYTabbedPane)this.tabPane, tab, false));
        }
    }

    void updateAllTabBorders() {
        Insets insets = this.getTabInsets(false);
        Insets insets2 = this.getTabInsets(true);
        int n = this.tabPane.getTabPlacement();
        if (!((JYTabbedPane)this.tabPane).getTabRotationEnabled().booleanValue() && n != 3) {
            n = 1;
        }
        EmptyBorder emptyBorder = new EmptyBorder(this.rotateInsets(insets, n, true));
        EmptyBorder emptyBorder2 = new EmptyBorder(this.rotateInsets(insets2, n, true));
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = 0;
        while (n3 < this.tabsPanel.getTabCount()) {
            Tab tab = this.tabsPanel.getTab(n3);
            tab.setBorder(n3 == n2 ? emptyBorder2 : emptyBorder);
            ++n3;
        }
    }

    public IButtonFactory getButtonFactory() {
        return this.buttonFactory;
    }

    public JYTabbedPane getTabbedPane() {
        return (JYTabbedPane)this.tabPane;
    }

    public TabsPanel getTabsPanel() {
        return this.tabsPanel;
    }

    public JPanel getLeadingTabControlsPanel() {
        return this.leadingTabControlsPanel;
    }

    public JPanel getTrailingTabControlsPanel() {
        return this.trailingTabControlsPanel;
    }

    public TabsPanelViewport getTabsPanelViewport() {
        return this.tabsPanelViewport;
    }

    public boolean isPaintContentBorderGap4SelectedTabEnabled() {
        if (this.avoidTrailingCroppedTabs) {
            return this.tabsPanelViewport.getTrailingViewTabIndex() != this.tabPane.getSelectedIndex();
        }
        return true;
    }

    public void assureRectsCreated(int n) {
        super.assureRectsCreated(n);
    }

    public Insets getContentBorderInsets(int n) {
        return super.getContentBorderInsets(n);
    }

    public Insets getTabAreaInsets(int n) {
        return this.getTabAreaPanelInsets();
    }

    protected Insets getTabAreaPanelInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        return insets;
    }

    public void cancelTabEdit() {
        for (Tab tab : this.getTabsPanel().getTabs()) {
            JComponent jComponent = tab.getComponent();
            if (!(jComponent instanceof JYLabel)) continue;
            ((JYLabel)jComponent).stopEdit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Alignment {
        TOP_LEFT(0.0f),
        CENTER(0.5f),
        BOTTOM_RIGHT(1.0f);

        private float alignment;

        private Alignment(float f) {
            this.alignment = f;
        }

        public float asFloat() {
            return this.alignment;
        }
    }

    private class CroppedEdge
    extends JPanel {
        private static final long serialVersionUID = 5416935823810362916L;
        private boolean leading;

        public CroppedEdge(boolean bl) {
            this.leading = bl;
            this.setVisible(false);
            this.setOpaque(false);
            this.setLayout(null);
            this.setFocusable(false);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 0);
        }

        public int getCroppedEdgeSize() {
            return BasicJYTabbedPaneUI.this.croppedEdgeSize;
        }

        public Dimension getMaximumSize() {
            int n = this.getCroppedEdgeSize();
            int n2 = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                return new Dimension(n, BasicJYTabbedPaneUI.this.tabsPanel.getTabCount() == 0 ? 0 : ((BasicJYTabbedPaneUI)BasicJYTabbedPaneUI.this).tabsPanel.getFirstTab().getMaximumSize().height);
            }
            return new Dimension(BasicJYTabbedPaneUI.this.tabsPanel.getTabCount() == 0 ? 0 : ((BasicJYTabbedPaneUI)BasicJYTabbedPaneUI.this).tabsPanel.getFirstTab().getMaximumSize().width, n);
        }

        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            n3 = this.getMaximumSize().width;
            n4 = this.getMaximumSize().height;
            Rectangle rectangle = BasicJYTabbedPaneUI.this.tabsPanelViewport.getViewRect();
            int n5 = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean bl = this.getComponentOrientation().isLeftToRight();
            if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                if (n5 == 2 && bl || n5 == 4 && !bl) {
                    n = BasicJYTabbedPaneUI.this.tabsPanel.getWidth() - n3;
                }
                n2 = this.leading ? rectangle.y : rectangle.y + rectangle.height - n4;
            } else {
                int n6 = n = this.leading && bl || !this.leading && !bl ? rectangle.x : rectangle.x + rectangle.width - n3;
                if (n5 == 1) {
                    n2 = BasicJYTabbedPaneUI.this.tabsPanel.getHeight() - n4;
                }
            }
            this.setBounds_(n, n2, n3, n4);
        }

        protected void setBounds_(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
        }

        public float getAlignmentX() {
            return BasicJYTabbedPaneUI.this.getTabbedPane().getTabPlacement() == 2 ? 1.0f : 0.0f;
        }

        public float getAlignmentY() {
            return BasicJYTabbedPaneUI.this.getTabbedPane().getTabPlacement() == 1 ? 1.0f : 0.0f;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            SynthContext synthContext = null;
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                synthContext = new SynthContext(BasicJYTabbedPaneUI.this.tabPane, Region.TABBED_PANE, SynthLookAndFeel.getStyle(BasicJYTabbedPaneUI.this.tabPane, Region.TABBED_PANE), 0);
            }
            JYTabbedPanePainter.getInstance(synthContext).paintCroppedEdge(BasicJYTabbedPaneUI.this.tabPane, new SyntheticaState(), BasicJYTabbedPaneUI.this.tabPane.getTabPlacement(), this.leading, graphics, 0, 0, this.getWidth(), this.getHeight(), BasicJYTabbedPaneUI.this.croppedEdgeBackground, BasicJYTabbedPaneUI.this.croppedEdgeForeground);
        }
    }

    private class PlusComponentPanel
    extends JPanel {
        private static final long serialVersionUID = -9038268180426245492L;
        private int plusButtonGap;
        private JPanel croppedEdgePane;
        private JPanel gapPane;
        private JPanel buttonPane;

        public PlusComponentPanel() {
            this.setLayout(new BoxLayout(this, 2));
            this.setOpaque(false);
            this.croppedEdgePane = new CroppedEdge(BasicJYTabbedPaneUI.this, false){
                private static final long serialVersionUID = -5943710616103001376L;

                public Dimension getPreferredSize() {
                    return new Dimension(BasicJYTabbedPaneUI.this.croppedEdgeSize, BasicJYTabbedPaneUI.this.croppedEdgeSize);
                }

                public void setBounds(int n, int n2, int n3, int n4) {
                    if (!BasicJYTabbedPaneUI.this.tabsPanelViewport.isViewCompletelyVisible()) {
                        n3 = this.getMaximumSize().width;
                        n4 = this.getMaximumSize().height;
                        int n5 = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                        boolean bl = this.getComponentOrientation().isLeftToRight();
                        if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                            n = n5 == 2 && bl || n5 == 4 && !bl ? this.getParent().getWidth() - n3 : 0;
                        } else {
                            n2 = n5 == 1 ? this.getParent().getHeight() - n4 : 0;
                        }
                    }
                    this.setBounds_(n, n2, n3, n4);
                }
            };
            this.add(this.croppedEdgePane);
            Color color = SyntheticaLookAndFeel.getColor("JYTabbedPane.tabsPanel.croppedEdge.background", BasicJYTabbedPaneUI.this.tabPane);
            if (color == null) {
                color = SyntheticaLookAndFeel.getColor("Panel.background", BasicJYTabbedPaneUI.this.tabPane);
            }
            this.gapPane = new JPanel(null){
                private static final long serialVersionUID = 478728021825728313L;

                public Dimension getPreferredSize() {
                    return BasicJYTabbedPaneUI.this.isVerticalTabPlacement() ? new Dimension(0, PlusComponentPanel.this.plusButtonGap) : new Dimension(PlusComponentPanel.this.plusButtonGap, 0);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.gapPane.putClientProperty("Synthetica.panel.paintViewportAware", false);
            this.gapPane.setBackground(color);
            this.add(this.gapPane);
            this.buttonPane = new JPanel(new BorderLayout());
            this.buttonPane.setBackground(color);
            this.buttonPane.putClientProperty("Synthetica.panel.paintViewportAware", false);
            this.buttonPane.add(BasicJYTabbedPaneUI.this.createPlusButton());
            this.updatePlusButtonMargin();
            this.add(this.buttonPane);
            this.applyComponentOrientation(BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation());
            BasicJYTabbedPaneUI.this.updateLayout(this, 1, BasicJYTabbedPaneUI.this.tabPane.getTabPlacement());
            this.updateAppearance(BasicJYTabbedPaneUI.this.tabsPanelViewport.isViewCompletelyVisible(), BasicJYTabbedPaneUI.this.tabsPanelViewport.isScrollEndReached());
        }

        void updatePlusButtonMargin() {
            Insets insets = SyntheticaLookAndFeel.getInsets("JYTabbedPane.plusButton.margin", (Component)BasicJYTabbedPaneUI.this.tabPane, false);
            int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            if (n == 2) {
                insets = new Insets(insets.top, insets.right, insets.bottom, insets.left);
            }
            EmptyBorder emptyBorder = new EmptyBorder(BasicJYTabbedPaneUI.this.rotateInsets(insets, n, true));
            this.buttonPane.setBorder(emptyBorder);
        }

        public void updateUI() {
            super.updateUI();
            this.plusButtonGap = SyntheticaLookAndFeel.getInt("JYTabbedPane.plusButtonGap", BasicJYTabbedPaneUI.this.tabPane, 4);
            if (this.buttonPane != null) {
                this.updatePlusButtonMargin();
            }
        }

        public void updateAppearance(boolean bl, boolean bl2) {
            this.croppedEdgePane.setVisible(BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs ? false : !bl && !bl2);
            this.gapPane.setOpaque(this.croppedEdgePane.isVisible());
            this.buttonPane.setOpaque(this.croppedEdgePane.isVisible());
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (BasicJYTabbedPaneUI.this.tabsPanel == null) {
                return dimension;
            }
            if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                for (Component component : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                    dimension.width = Math.max(dimension.width, component.getPreferredSize().width);
                }
            } else {
                for (Component component : BasicJYTabbedPaneUI.this.tabsPanel.getTabs()) {
                    dimension.height = Math.max(dimension.height, component.getPreferredSize().height);
                }
            }
            return dimension;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public float getAlignmentX() {
            int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean bl = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            return n == 2 && bl || n == 4 && !bl ? 1.0f : 0.0f;
        }

        public float getAlignmentY() {
            return BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 1 ? 1.0f : 0.0f;
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (!BasicJYTabbedPaneUI.this.tabsPanelViewport.isViewCompletelyVisible()) {
                int n5 = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
                Rectangle rectangle = new Rectangle();
                int n6 = BasicJYTabbedPaneUI.this.tabsPanel.getTabCount() - 1;
                while (n6 >= 0) {
                    Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(n6);
                    if (tab.isVisible()) {
                        rectangle = tab.getBounds();
                        break;
                    }
                    --n6;
                }
                n3 = this.getPreferredSize().width;
                n4 = this.getPreferredSize().height;
                Rectangle rectangle2 = BasicJYTabbedPaneUI.this.tabsPanelViewport.getViewRect();
                if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                    n2 = Math.min(rectangle2.y + rectangle2.height - n4, rectangle.y + rectangle.height + n5);
                } else {
                    boolean bl = this.getComponentOrientation().isLeftToRight();
                    n = bl ? Math.min(rectangle2.x + rectangle2.width - n3, rectangle.x + rectangle.width + n5) : Math.max(rectangle2.x, rectangle.x - (n3 + n5));
                }
            }
            super.setBounds(n, n2, n3, n4);
        }
    }

    class TabAreaPanel
    extends JPanel
    implements UIResource {
        private static final long serialVersionUID = 7275702352762336232L;

        public TabAreaPanel() {
            super(new BorderLayout());
            this.setName("JYTabbedPane.TabAreaPanel");
            this.setOpaque(false);
            this.setBorder(new Border(){

                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                }

                public Insets getBorderInsets(Component component) {
                    return BasicJYTabbedPaneUI.this.rotateInsets(BasicJYTabbedPaneUI.this.getTabAreaPanelInsets(), BasicJYTabbedPaneUI.this.tabPane.getTabPlacement(), true);
                }

                public boolean isBorderOpaque() {
                    return false;
                }
            });
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            SynthContext synthContext = null;
            if (UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                synthContext = new SynthContext(BasicJYTabbedPaneUI.this.tabPane, Region.TABBED_PANE, SynthLookAndFeel.getStyle(BasicJYTabbedPaneUI.this.tabPane, Region.TABBED_PANE), 0);
            }
            JYTabbedPanePainter.getInstance(synthContext).paintTabbedPaneTabAreaBackground(BasicJYTabbedPaneUI.this.tabPane, new SyntheticaState(0), n, 0, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    private class TabLabel
    extends JYLabel {
        private static final long serialVersionUID = 695466598960280638L;

        public TabLabel() {
            TabLabelMouseHandler tabLabelMouseHandler = new TabLabelMouseHandler();
            this.addMouseListener(tabLabelMouseHandler);
            this.addMouseMotionListener(tabLabelMouseHandler);
            this.addMouseWheelListener(tabLabelMouseHandler);
        }

        public boolean isEditable() {
            return this.isEnabled() && super.isEditable();
        }

        public void commitEdit() {
            BasicJYTabbedPaneUI.this.tabPane.setTitleAt(this.getTabIndex(), this.editor.getText());
            this.stopEdit();
        }

        public boolean isEnabled() {
            int n = this.getTabIndex();
            return n >= 0 && n < BasicJYTabbedPaneUI.this.tabPane.getTabCount() ? BasicJYTabbedPaneUI.this.tabPane.isEnabledAt(n) : super.isEnabled();
        }

        public Color getForeground() {
            int n = this.getTabIndex();
            Color color = BasicJYTabbedPaneUI.this.getDefaultTabForeground(n);
            Color color2 = n < 0 || n >= BasicJYTabbedPaneUI.this.tabPane.getTabCount() ? null : BasicJYTabbedPaneUI.this.tabPane.getForegroundAt(n);
            return color2 == null || color2 instanceof ColorUIResource ? color : color2;
        }

        private int getTabIndex() {
            int n = -1;
            Container container = this.getParent();
            if (container != null && container.getParent() != null) {
                n = ((Tab)this.getParent().getParent()).getTabIndex();
            }
            return n;
        }
    }

    private class TabLabelMouseHandler
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Component target;

        private TabLabelMouseHandler() {
            this.target = BasicJYTabbedPaneUI.this.tabsPanelViewport;
        }

        private void dispatchMouseEvent(MouseEvent mouseEvent) {
            this.target.dispatchEvent(SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.target));
        }

        private void dispatchMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
            this.target.dispatchEvent(SwingUtilities.convertMouseEvent(mouseWheelEvent.getComponent(), mouseWheelEvent, this.target));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.dispatchMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.dispatchMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.dispatchMouseEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.dispatchMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.dispatchMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.dispatchMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.dispatchMouseEvent(mouseEvent);
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.dispatchMouseWheelEvent(mouseWheelEvent);
        }
    }

    private class TabPreviewHandler
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    PropertyChangeListener,
    ActionListener {
        private int oldIndex;
        private Timer timer;
        private TabPreviewPopup tabPreviewPopup;

        private TabPreviewHandler() {
        }

        public void install() {
            BasicJYTabbedPaneUI.this.tabPane.addMouseListener(this);
            BasicJYTabbedPaneUI.this.tabPane.addMouseMotionListener(this);
            BasicJYTabbedPaneUI.this.tabPane.addMouseWheelListener(this);
            BasicJYTabbedPaneUI.this.tabPane.addPropertyChangeListener(this);
        }

        public void uninstall() {
            BasicJYTabbedPaneUI.this.tabPane.removeMouseListener(this);
            BasicJYTabbedPaneUI.this.tabPane.removeMouseMotionListener(this);
            BasicJYTabbedPaneUI.this.tabPane.removeMouseWheelListener(this);
            BasicJYTabbedPaneUI.this.tabPane.removePropertyChangeListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.cancelPreview();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.update(BasicJYTabbedPaneUI.this.getRolloverTab());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (this.oldIndex >= 0) {
                this.cancelPreview();
            }
            this.update(BasicJYTabbedPaneUI.this.getRolloverTab());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("Synthetica.MOUSE_OVER".equals(propertyChangeEvent.getPropertyName())) {
                this.update((Integer)propertyChangeEvent.getNewValue());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (this.tabPreviewPopup == null) {
                return;
            }
            this.tabPreviewPopup.preparePreview();
            Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(this.tabPreviewPopup.getTabIndex());
            boolean bl = BasicJYTabbedPaneUI.this.getTabbedPane().getTabRotationEnabled();
            boolean bl2 = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            int n2 = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = n2 == (bl2 ? 2 : 4) && bl ? tab.getWidth() : (n = n2 == (bl2 ? 4 : 2) && bl ? -this.tabPreviewPopup.getPreferredSize().width : 0);
            int n4 = BasicJYTabbedPaneUI.this.isVerticalTabPlacement() && bl ? 0 : (n2 == 3 ? -this.tabPreviewPopup.getPreferredSize().height : tab.getHeight());
            this.tabPreviewPopup.show(tab, n, n4);
        }

        private void update(int n) {
            if (n < 0 || n >= BasicJYTabbedPaneUI.this.tabPane.getTabCount() || !BasicJYTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                return;
            }
            if (n == BasicJYTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                this.cancelPreview();
            } else if (n != this.oldIndex) {
                if (this.oldIndex >= 0) {
                    this.cancelPreview();
                }
                this.startPreview(n);
                this.oldIndex = n;
            }
        }

        private void startPreview(int n) {
            if (this.timer != null) {
                this.cancelPreview();
            }
            this.tabPreviewPopup = new TabPreviewPopup(BasicJYTabbedPaneUI.this.getTabbedPane(), n);
            this.tabPreviewPopup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    TabPreviewHandler.this.cancelPreview();
                }
            });
            this.timer = new Timer(SyntheticaLookAndFeel.getInt("JYTabbedPane.tabPreviewOnHover.delay", BasicJYTabbedPaneUI.this.tabPane, 1500), this);
            this.timer.setRepeats(false);
            this.timer.start();
        }

        private void cancelPreview() {
            if (this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
                this.timer = null;
            }
            if (this.tabPreviewPopup != null) {
                this.tabPreviewPopup.setVisible(false);
            }
            this.tabPreviewPopup = null;
            this.oldIndex = -1;
        }
    }

    private static class TabPreviewPopup
    extends JPopupMenu {
        private JYTabbedPane tabPane;
        private int tabIndex;
        private BufferedImage previewImage;

        public TabPreviewPopup(JYTabbedPane jYTabbedPane, int n) {
            this.setName("JYTabbedPane.TabPreviewPopup");
            this.tabPane = jYTabbedPane;
            this.tabIndex = n;
            this.setLayout(new BorderLayout());
            this.add(new PopupContent());
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        private Dimension getPreviewSize(Component component) {
            Dimension dimension = new Dimension(300, 200);
            int n = dimension.width;
            int n2 = dimension.height;
            if (component != null) {
                double d = (double)n / (double)n2;
                double d2 = (double)component.getWidth() / (double)component.getHeight();
                if (d > d2) {
                    n = (int)((double)n2 * d2);
                } else {
                    n2 = (int)((double)n / d2);
                }
            }
            return new Dimension(n, n2);
        }

        public void preparePreview() {
            Component component = this.tabPane.getComponentAt(this.tabIndex);
            double d = component == null ? 1 : component.getWidth();
            double d2 = component == null ? 1 : component.getHeight();
            Dimension dimension = this.getPreviewSize(component);
            double d3 = dimension.getWidth() / d;
            double d4 = dimension.getHeight() / d2;
            double d5 = Math.min(d3, d4);
            this.previewImage = WidgetUtils.createPreviewImage(component, d5, true);
        }

        private class PopupContent
        extends JComponent {
            private PopupContent() {
            }

            public Dimension getPreferredSize() {
                Insets insets = this.getInsets();
                int n = TabPreviewPopup.this.previewImage == null ? 0 : TabPreviewPopup.this.previewImage.getWidth(null);
                int n2 = TabPreviewPopup.this.previewImage == null ? 0 : TabPreviewPopup.this.previewImage.getHeight(null);
                return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
            }

            protected void paintComponent(Graphics graphics) {
                if (TabPreviewPopup.this.previewImage == null) {
                    return;
                }
                Insets insets = this.getInsets();
                graphics.drawImage(TabPreviewPopup.this.previewImage, insets.left, insets.top, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TabsPanel
    extends JPanel {
        private static final long serialVersionUID = -5953802488838816461L;
        private ArrayList<Tab> tabs;
        private CroppedEdge leadingCroppedEdge;
        private CroppedEdge trailingCroppedEdge;
        private PlusComponentPanel plusComponentPanel;

        public TabsPanel() {
            this.setName("JYTabbedPane.TabsPanel");
            int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
            OverlapBoxLayout.ComponentFilter componentFilter = new OverlapBoxLayout.ComponentFilter(){

                @Override
                public boolean accept(Component component, Class<?> clazz, Object object) {
                    return !(component instanceof CroppedEdge);
                }
            };
            OverlapBoxLayout<JComponent> overlapBoxLayout = new OverlapBoxLayout<JComponent>((Container)this, n == 1 || n == 3 ? OverlapBoxLayout.Axis.LINE : OverlapBoxLayout.Axis.PAGE, JComponent.class, componentFilter){

                @Override
                public void layoutContainer(Container container) {
                    super.layoutContainer(container);
                    BasicJYTabbedPaneUI.this.repaintContentBorderGap();
                }
            };
            Integer n2 = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
            overlapBoxLayout.setOverlapSize(n2 == null ? 0 : n2);
            this.setLayout(overlapBoxLayout);
            this.tabs = new ArrayList();
            this.leadingCroppedEdge = new CroppedEdge(true);
            this.leadingCroppedEdge.setName("JYTabbedPane.LeadingCroppedEdge");
            super.add(this.leadingCroppedEdge);
            this.setComponentZOrder(this.leadingCroppedEdge, 0);
            this.trailingCroppedEdge = new CroppedEdge(false);
            this.trailingCroppedEdge.setName("JYTabbedPane.TrailingCroppedEdge");
            super.add(this.trailingCroppedEdge);
            this.setComponentZOrder(this.trailingCroppedEdge, 1);
            this.setOpaque(false);
        }

        void setShowPlusButton(boolean bl) {
            if (bl) {
                this.plusComponentPanel = new PlusComponentPanel();
                super.add(this.plusComponentPanel);
            } else {
                if (this.plusComponentPanel != null) {
                    super.remove(this.plusComponentPanel);
                }
                this.plusComponentPanel = null;
            }
        }

        public boolean getShowPlusButton() {
            return this.plusComponentPanel != null;
        }

        @Override
        public Component add(Component component) {
            throw new UnsupportedOperationException("Use method #add(Tab tab)");
        }

        public Tab add(Tab tab) {
            return this.add(tab, -1);
        }

        @Override
        public Component add(Component component, int n) {
            throw new UnsupportedOperationException("Use method #add(Tab tab, int index)");
        }

        public Tab add(Tab tab, int n) {
            this.tabs.add(n, tab);
            super.add(tab, n, n);
            return tab;
        }

        public void remove(Tab tab) {
            this.tabs.remove(tab);
            super.remove(tab);
        }

        public void removeTab(int n) {
            Tab tab = this.tabs.get(n);
            this.tabs.remove(n);
            super.remove(tab);
        }

        public void removeAllTabs() {
            for (Tab tab : this.tabs) {
                super.remove(tab);
            }
            this.tabs.clear();
        }

        public List<Tab> getTabs() {
            return this.tabs;
        }

        public Tab getTab(int n) {
            if (n >= 0 && n < this.tabs.size()) {
                return this.tabs.get(n);
            }
            return null;
        }

        public int getTabIndex(Tab tab) {
            return this.tabs.indexOf(tab);
        }

        public int getTabCount() {
            return this.tabs.size();
        }

        public void updateTabRects() {
            BasicJYTabbedPaneUI.this.assureRectsCreated(this.getTabCount());
            int n = 0;
            while (n < this.getTabCount()) {
                Tab tab = this.getTab(n);
                Point point = SwingUtilities.convertPoint(tab, 0, 0, BasicJYTabbedPaneUI.this.tabPane);
                this.setTabRect(n, point.x, point.y, tab.getWidth(), tab.getHeight());
                ++n;
            }
        }

        public void setTabRect(int n, int n2, int n3, int n4, int n5) {
            Rectangle rectangle = BasicJYTabbedPaneUI.this.rects[n];
            rectangle.x = n2;
            rectangle.y = n3;
            rectangle.width = n4;
            rectangle.height = n5;
        }

        public Tab getFirstTab() {
            return this.getTab(0);
        }

        public Tab getLastTab() {
            return this.getTab(this.getTabCount() - 1);
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }

        @Override
        protected void paintChildren(Graphics graphics) {
            boolean bl = BasicJYTabbedPaneUI.this.tabsPanelViewport.isScrollEndReached();
            int n = BasicJYTabbedPaneUI.this.tabPane.getSelectedIndex();
            if (n >= 0) {
                if (!this.getShowPlusButton()) {
                    BasicJYTabbedPaneUI.this.tabsPanel.updateZOrder(2, n);
                } else {
                    BasicJYTabbedPaneUI.this.tabsPanel.updateZOrder(bl ? 2 : 3, n);
                    BasicJYTabbedPaneUI.this.tabsPanel.setComponentZOrder(this.plusComponentPanel, bl ? BasicJYTabbedPaneUI.this.tabsPanel.getComponentCount() - 1 : 2);
                }
            }
            super.paintChildren(graphics);
        }

        public void updateZOrder(int n, int n2) {
            boolean bl = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 2;
            boolean bl2 = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 4;
            boolean bl3 = !BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            boolean bl4 = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getOverlapTabsInvers();
            int n3 = 0;
            while (n3 < this.tabs.size()) {
                boolean bl5;
                Component component = this.tabs.get(n3);
                int n4 = n;
                if (n3 < n2) {
                    n4 += n3 + 1;
                } else if (n3 > n2) {
                    n4 += n3;
                }
                boolean bl6 = bl5 = bl || bl3 && !bl2;
                if (bl4) {
                    bl5 = !bl5;
                }
                n4 = n3 == n2 || bl5 ? n4 : this.tabs.size() + n * 2 - n4;
                this.setComponentZOrder(component, n4);
                ++n3;
            }
        }

        private Action createMnemonicAction() {
            return new SetSelectedTabAction();
        }

        private Action createScrollTabIndexToVisibleAction() {
            return new ScrollTabIndexToVisibleAction();
        }

        private Action createAddTabAction() {
            return new AddTabAction();
        }

        private class AddTabAction
        extends AbstractAction {
            private static final long serialVersionUID = 4096240284894333199L;

            private AddTabAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JYTabbedPane jYTabbedPane = BasicJYTabbedPaneUI.this.getTabbedPane();
                jYTabbedPane.addTab("New Tab", null);
                if (jYTabbedPane.getTabCount() > 1) {
                    int n = jYTabbedPane.getSelectedIndex() + 1;
                    jYTabbedPane.moveTab(jYTabbedPane.getTabCount() - 1, n);
                    jYTabbedPane.setSelectedIndex(n);
                }
            }
        }

        private class ScrollTabIndexToVisibleAction
        extends AbstractAction {
            private static final long serialVersionUID = -4206367017205908279L;

            private ScrollTabIndexToVisibleAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    int n = Integer.parseInt(string);
                    Rectangle rectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabsPanelViewport.getParent(), BasicJYTabbedPaneUI.this.tabsPanelViewport.getBounds(), BasicJYTabbedPaneUI.this.tabPane);
                    if (n < BasicJYTabbedPaneUI.this.rects.length && !rectangle.contains(BasicJYTabbedPaneUI.this.rects[n])) {
                        BasicJYTabbedPaneUI.this.tabsPanelViewport.setLeadingTabIndex(n);
                    }
                }
            }
        }

        private class SetSelectedTabAction
        extends AbstractAction {
            private static final long serialVersionUID = -40705378264240905L;

            private SetSelectedTabAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    char c = string.toUpperCase().charAt(0);
                    int n = 0;
                    while (n < TabsPanel.this.getTabCount()) {
                        char c2;
                        JComponent jComponent = TabsPanel.this.getTab(n).getComponent();
                        if (jComponent instanceof JLabel && (c2 = new String(new char[]{(char)((JLabel)jComponent).getDisplayedMnemonic()}).toUpperCase().charAt(0)) == c && BasicJYTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                            BasicJYTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                            BasicJYTabbedPaneUI.this.updateTabFontStyle();
                            Rectangle rectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabsPanelViewport.getParent(), BasicJYTabbedPaneUI.this.tabsPanelViewport.getBounds(), BasicJYTabbedPaneUI.this.tabPane);
                            if (rectangle.contains(BasicJYTabbedPaneUI.this.rects[n])) break;
                            BasicJYTabbedPaneUI.this.tabsPanelViewport.setLeadingTabIndex(n);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }
    }

    public class TabsPanelViewport
    extends JViewport {
        private static final long serialVersionUID = 3083737645685481572L;
        private boolean dragging;
        private Point dragStart;
        private int dragStartIndex;
        private int dragIndex;
        private int leadingTabIndex;
        private long lastAutoScroll;
        private int autoScrollArea = 16;
        private MouseEventGenerator mouseEventGenerator = new MouseEventGenerator();
        private ScrollAnimator scrollAnimator = new ScrollAnimator();
        private Point mouseWheelPosition;
        private Component oldGlassPane;

        public TabsPanelViewport() {
            this.setName("JYTabbedPane.TabsPanelViewport");
            this.setOpaque(false);
            this.addMouseWheelListener(new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    TabsPanelViewport.this.mouseWheelPosition = mouseWheelEvent.getPoint();
                    if (mouseWheelEvent.getWheelRotation() > 0) {
                        TabsPanelViewport.this.scrollForward();
                    } else {
                        TabsPanelViewport.this.scrollBackward();
                    }
                }
            });
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    TabsPanelViewport.this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    TabsPanelViewport.this.mouseWheelPosition = null;
                    TabsPanelViewport.this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    TabsPanelViewport.this.dispatchMouseEvent(mouseEvent);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    TabsPanelViewport.this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabReorderByDraggingEnabled().booleanValue()) {
                        TabsPanelViewport.this.enableDragging(false);
                        TabsPanelViewport.this.doDrag(mouseEvent);
                    }
                    TabsPanelViewport.this.dispatchMouseEvent(mouseEvent);
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabReorderByDraggingEnabled().booleanValue()) {
                        TabsPanelViewport.this.dragIndex = TabsPanelViewport.this.mousePos2TabIndex(mouseEvent.getX(), mouseEvent.getY());
                        if (!TabsPanelViewport.this.dragging && TabsPanelViewport.this.dragIndex >= 0) {
                            TabsPanelViewport.this.dragStartIndex = Math.max(0, TabsPanelViewport.this.dragIndex);
                            TabsPanelViewport.this.dragStart = mouseEvent.getPoint().getLocation();
                            TabsPanelViewport.this.enableDragging(true);
                        }
                        TabsPanelViewport.this.doDrag(mouseEvent);
                    }
                    TabsPanelViewport.this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    TabsPanelViewport.this.mouseWheelPosition = null;
                    TabsPanelViewport.this.dispatchMouseEvent(mouseEvent);
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    TabsPanelViewport.this.dispatchMouseEvent(mouseWheelEvent);
                }
            });
        }

        private void dispatchMouseEvent(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), BasicJYTabbedPaneUI.this.tabPane);
            if (BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs && this.mousePos2TabIndex(point.x, point.y) == this.getTrailingViewTabIndex()) {
                return;
            }
            MouseEvent mouseEvent2 = mouseEvent instanceof MouseWheelEvent ? new MouseWheelEvent((Component)BasicJYTabbedPaneUI.this.tabPane, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), ((MouseWheelEvent)mouseEvent).getScrollType(), ((MouseWheelEvent)mouseEvent).getScrollAmount(), ((MouseWheelEvent)mouseEvent).getWheelRotation()) : new MouseEvent(BasicJYTabbedPaneUI.this.tabPane, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            BasicJYTabbedPaneUI.this.tabPane.dispatchEvent(mouseEvent2);
        }

        private int mousePos2TabIndex(int n, int n2) {
            Point point = SwingUtilities.convertPoint(BasicJYTabbedPaneUI.this.tabsPanelViewport, n, n2, this.getView());
            int n3 = 0;
            while (n3 < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle rectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[n3], this.getView());
                if (rectangle.contains(point)) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }

        private int mousePos2DragStopIndex(int n, int n2) {
            Point point = SwingUtilities.convertPoint(BasicJYTabbedPaneUI.this.tabsPanelViewport, n, n2, this.getView());
            boolean bl = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            boolean bl2 = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
            int n3 = this.dragIndex - this.dragStartIndex;
            int n4 = 0;
            while (n4 < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle rectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[n4], this.getView());
                if (rectangle.contains(point)) {
                    boolean bl3;
                    if (bl2) {
                        rectangle.height /= 2;
                    } else {
                        rectangle.width /= 2;
                    }
                    boolean bl4 = bl || bl2 ? rectangle.contains(point) : (bl3 = !rectangle.contains(point));
                    if (n3 < 0 && !bl3) {
                        ++n4;
                    } else if (n3 > 0 && bl3) {
                        --n4;
                    }
                    return n4;
                }
                ++n4;
            }
            return -1;
        }

        private void doDrag(MouseEvent mouseEvent) {
            if (!this.dragging && this.mouseEventGenerator.isAlive()) {
                this.mouseEventGenerator.stop();
            }
            JRootPane jRootPane = this.getRootPane();
            Component component = jRootPane.getGlassPane();
            if (this.dragging) {
                if (component instanceof DragGlassPane) {
                    if (this.mousePos2DragStopIndex(mouseEvent.getX(), mouseEvent.getY()) >= 0) {
                        jRootPane.setCursor(WidgetUtils.getDragCursor());
                    } else {
                        jRootPane.setCursor(WidgetUtils.getStopCursor());
                    }
                    ((DragGlassPane)component).update(mouseEvent.getPoint());
                }
                if (BasicJYTabbedPaneUI.this.tabPane.getClientProperty("Synthetica.MOUSE_OVER") != null && this.dragIndex != (Integer)BasicJYTabbedPaneUI.this.tabPane.getClientProperty("Synthetica.MOUSE_OVER")) {
                    BasicJYTabbedPaneUI.this.tabPane.putClientProperty("Synthetica.MOUSE_OVER", this.dragIndex);
                    mouseEvent.getComponent().repaint();
                }
                Rectangle rectangle = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), BasicJYTabbedPaneUI.this.tabPane);
                Rectangle rectangle2 = new Rectangle(rectangle);
                if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                    rectangle.y += rectangle.height - this.autoScrollArea;
                    rectangle.height = this.autoScrollArea * 2;
                    rectangle2.y += -this.autoScrollArea;
                    rectangle2.height = this.autoScrollArea * 2;
                } else {
                    rectangle.x += rectangle.width - this.autoScrollArea;
                    rectangle.width = this.autoScrollArea * 2;
                    rectangle2.x += -this.autoScrollArea;
                    rectangle2.width = this.autoScrollArea * 2;
                    if (!BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight()) {
                        Rectangle rectangle3 = rectangle;
                        rectangle = rectangle2;
                        rectangle2 = rectangle3;
                    }
                }
                this.mouseEventGenerator.updateMousePosition(mouseEvent.getX(), mouseEvent.getY());
                long l = mouseEvent.getWhen();
                if (l - this.lastAutoScroll > (long)BasicJYTabbedPaneUI.this.tabAutoScrollDelay) {
                    Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), BasicJYTabbedPaneUI.this.tabPane);
                    if (rectangle.contains(point) && !this.isScrollEndReached()) {
                        this.scrollForward();
                        if (!this.mouseEventGenerator.isAlive()) {
                            this.mouseEventGenerator.start(mouseEvent);
                        }
                    } else if (rectangle2.contains(point) && !this.isScrollStartReached()) {
                        this.scrollBackward();
                        if (!this.mouseEventGenerator.isAlive()) {
                            this.mouseEventGenerator.start(mouseEvent);
                        }
                    } else {
                        this.mouseEventGenerator.stop();
                    }
                    this.lastAutoScroll = l;
                }
            } else if (!this.dragging && this.dragIndex != this.dragStartIndex && this.dragIndex >= 0) {
                int n = this.mousePos2DragStopIndex(mouseEvent.getX(), mouseEvent.getY());
                ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).moveTab(this.dragStartIndex, n);
                this.dragIndex = -1;
            }
        }

        private void enableDragging(boolean bl) {
            JRootPane jRootPane = this.getRootPane();
            if (bl) {
                this.dragging = true;
                this.oldGlassPane = jRootPane.getGlassPane();
                jRootPane.setGlassPane(new DragGlassPane());
            } else if (this.dragging) {
                this.dragging = false;
                if (jRootPane.getGlassPane() instanceof DragGlassPane) {
                    jRootPane.getGlassPane().setVisible(false);
                    jRootPane.setGlassPane(this.oldGlassPane);
                }
                jRootPane.setCursor(null);
                this.oldGlassPane = null;
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            Point point = SwingUtilities.convertPoint(BasicJYTabbedPaneUI.this.tabsPanelViewport, mouseEvent.getPoint(), BasicJYTabbedPaneUI.this.tabPane);
            int n = BasicJYTabbedPaneUI.this.tabForCoordinate(BasicJYTabbedPaneUI.this.tabPane, point.x, point.y);
            if (n >= 0 && n < BasicJYTabbedPaneUI.this.tabPane.getTabCount()) {
                string = BasicJYTabbedPaneUI.this.tabPane.getToolTipTextAt(n);
            }
            return string;
        }

        public void scrollForward() {
            this.setLeadingTabIndex(this.leadingTabIndex + 1);
        }

        public void scrollBackward() {
            this.setLeadingTabIndex(this.leadingTabIndex - 1);
        }

        private void setLeadingTabIndex(int n) {
            boolean bl;
            boolean bl2 = bl = n > this.leadingTabIndex;
            if (this.isViewCompletelyVisible() || bl && this.isScrollEndReached() || !bl && this.isScrollStartReached()) {
                return;
            }
            BasicJYTabbedPaneUI.this.cancelTabEdit();
            this.leadingTabIndex = Math.min(Math.max(0, n), BasicJYTabbedPaneUI.this.tabPane.getTabCount() - 1);
            Point point = this.getViewPositionForLeadingTabIndex();
            if (((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabScrollAnimationEnabled().booleanValue()) {
                this.scrollAnimator.updateEndPosition(point.x, point.y);
                if (!this.scrollAnimator.isAlive()) {
                    this.scrollAnimator.start();
                }
            } else {
                this.setViewPosition(point);
            }
            if (!this.scrollAnimator.isAlive()) {
                this.revalidate();
            }
        }

        private Point getViewPositionForLeadingTabIndex() {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Rectangle rectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[this.leadingTabIndex], this.getView());
            int n3 = this.getView().getPreferredSize().width - n;
            int n4 = this.getView().getPreferredSize().height - this.getHeight();
            boolean bl = !BasicJYTabbedPaneUI.this.isVerticalTabPlacement() & !BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            int n5 = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
            if (BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs) {
                int n6;
                if (!BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                    n6 = BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton() ? BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getWidth() + n5 : 0;
                    int n7 = BasicJYTabbedPaneUI.this.rects.length - 1;
                    while (n7 >= 0) {
                        if ((n6 += ((BasicJYTabbedPaneUI)BasicJYTabbedPaneUI.this).rects[n7].width + (n6 > 0 ? n5 : 0)) > n && n7 + 1 < BasicJYTabbedPaneUI.this.rects.length) {
                            Rectangle rectangle2 = BasicJYTabbedPaneUI.this.rects[n7 + 1];
                            rectangle2 = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, rectangle2, this.getView());
                            n3 = bl ? -n + rectangle2.x + rectangle2.width : rectangle2.x;
                            break;
                        }
                        --n7;
                    }
                } else {
                    n6 = BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton() ? BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getHeight() + n5 : 0;
                    int n8 = BasicJYTabbedPaneUI.this.rects.length - 1;
                    while (n8 >= 0) {
                        if ((n6 += ((BasicJYTabbedPaneUI)BasicJYTabbedPaneUI.this).rects[n8].height + (n6 > 0 ? n5 : 0)) > n2 && n8 + 1 < BasicJYTabbedPaneUI.this.rects.length) {
                            Rectangle rectangle3 = BasicJYTabbedPaneUI.this.rects[n8 + 1];
                            rectangle3 = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, rectangle3, this.getView());
                            n4 = rectangle3.y;
                            break;
                        }
                        --n8;
                    }
                }
            }
            rectangle.x = BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs && bl ? Math.max(n3, -n + rectangle.x + rectangle.width) : Math.max(0, Math.min(n3, this.getComponentOrientation().isLeftToRight() ? rectangle.x : rectangle.x - n + rectangle.width));
            rectangle.y = Math.max(0, Math.min(n4, rectangle.y));
            Point point = this.getViewPosition().getLocation();
            if (!BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                point.x = rectangle.x;
            } else {
                point.y = rectangle.y;
            }
            return point;
        }

        private void updateLeadingTabIndex() {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            Point point = this.getViewPosition();
            int n = 0;
            while (n < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle rectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[n], this.getView());
                if (BasicJYTabbedPaneUI.this.isVerticalTabPlacement()) {
                    if (rectangle.contains(rectangle.x, point.y)) {
                        this.leadingTabIndex = rectangle.y == point.y ? n : Math.min(BasicJYTabbedPaneUI.this.rects.length, n + 1);
                        break;
                    }
                } else if (bl) {
                    if (rectangle.contains(point.x, rectangle.y)) {
                        this.leadingTabIndex = rectangle.x == point.x ? n : Math.min(BasicJYTabbedPaneUI.this.rects.length, n + 1);
                        break;
                    }
                } else {
                    int n2 = point.x + this.getSize().width - 1;
                    if (rectangle.contains(n2, rectangle.y)) {
                        this.leadingTabIndex = rectangle.x + rectangle.width - 1 == n2 ? n : Math.min(BasicJYTabbedPaneUI.this.rects.length, n + 1);
                        break;
                    }
                }
                ++n;
            }
        }

        protected LayoutManager createLayoutManager() {
            return new ViewportLayout(){
                private static final long serialVersionUID = 6666117029720189745L;

                public void layoutContainer(Container container) {
                    int n;
                    int n2;
                    int n3;
                    JViewport jViewport = (JViewport)container;
                    Component component = jViewport.getView();
                    if (component == null) {
                        return;
                    }
                    boolean bl = TabsPanelViewport.this.getComponentOrientation().isLeftToRight();
                    boolean bl2 = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
                    Dimension dimension = jViewport.getSize();
                    Dimension dimension2 = new Dimension(component.getPreferredSize());
                    if (bl2) {
                        dimension2.width = dimension.width;
                    } else {
                        dimension2.height = dimension.height;
                    }
                    TabsPanelViewport.this.leadingTabIndex = Math.min(Math.max(0, TabsPanelViewport.this.leadingTabIndex), BasicJYTabbedPaneUI.this.tabPane.getTabCount() - 1);
                    if (dimension.width > dimension2.width || dimension.height > dimension2.height) {
                        TabsPanelViewport.this.leadingTabIndex = 0;
                    }
                    Point point = jViewport.getViewPosition().getLocation();
                    if (bl2) {
                        point.x = 0;
                        point.y = dimension.height >= dimension2.height ? 0 : (!BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs ? Math.min(dimension2.height - dimension.height, point.y) : Math.min(((TabsPanelViewport)TabsPanelViewport.this).getViewPositionForLeadingTabIndex().y, point.y));
                    } else {
                        point.y = 0;
                        if (bl) {
                            point.x = dimension.width >= dimension2.width ? 0 : (!BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs ? Math.min(dimension2.width - dimension.width, point.x) : Math.min(((TabsPanelViewport)TabsPanelViewport.this).getViewPositionForLeadingTabIndex().x, point.x));
                        } else {
                            n3 = 0;
                            n2 = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
                            n = 0;
                            while (n < TabsPanelViewport.this.leadingTabIndex) {
                                n3 += ((BasicJYTabbedPaneUI)((TabsPanelViewport)TabsPanelViewport.this).BasicJYTabbedPaneUI.this).rects[n].width + n2;
                                ++n;
                            }
                            point.x = dimension.width >= dimension2.width ? dimension2.width - dimension.width : (!BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs ? Math.max(0, dimension2.width - dimension.width - n3) : Math.max(((TabsPanelViewport)TabsPanelViewport.this).getViewPositionForLeadingTabIndex().x, dimension2.width - dimension.width - n3));
                        }
                    }
                    if (dimension.width > dimension2.width) {
                        point.x = 0;
                        dimension2.width = dimension.width;
                    }
                    if (dimension.height > dimension2.height) {
                        point.y = 0;
                        dimension2.height = dimension.height;
                    }
                    if (!TabsPanelViewport.this.scrollAnimator.isAlive()) {
                        jViewport.setViewPosition(point);
                    }
                    jViewport.setViewSize(dimension2);
                    BasicJYTabbedPaneUI.this.tabsPanel.updateTabRects();
                    if (!TabsPanelViewport.this.isViewCompletelyVisible()) {
                        BasicJYTabbedPaneUI.this.tabsPanel.leadingCroppedEdge.revalidate();
                        BasicJYTabbedPaneUI.this.tabsPanel.trailingCroppedEdge.revalidate();
                    }
                    if (BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs) {
                        n3 = TabsPanelViewport.this.getLeadingViewTabIndex();
                        n2 = TabsPanelViewport.this.getTrailingViewTabIndex();
                        n = 0;
                        while (n < BasicJYTabbedPaneUI.this.tabsPanel.getTabs().size()) {
                            boolean bl3 = n >= n3 && n < n2 | n2 < 0;
                            BasicJYTabbedPaneUI.this.tabsPanel.getTab(n).setVisible(bl3);
                            ++n;
                        }
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            TabsPanelViewport.this.updateLeadingTabIndex();
                            TabsPanelViewport.this.updatePopupItems();
                            boolean bl = TabsPanelViewport.this.isViewCompletelyVisible();
                            JButton jButton = BasicJYTabbedPaneUI.this.getScrollButton(true);
                            if (!BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs) {
                                jButton.setEnabled(!(TabsPanelViewport.this.isScrollEndReached() | bl | TabsPanelViewport.this.leadingTabIndex == BasicJYTabbedPaneUI.this.tabPane.getTabCount() - 1));
                            } else {
                                jButton.setEnabled(TabsPanelViewport.this.getTrailingViewTabIndex() != -1);
                            }
                            if (!jButton.isEnabled() && jButton.hasFocus()) {
                                FocusManager.getCurrentManager().focusNextComponent();
                            }
                            JButton jButton2 = BasicJYTabbedPaneUI.this.getScrollButton(false);
                            if (!BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs) {
                                jButton2.setEnabled(TabsPanelViewport.this.leadingTabIndex != 0);
                            } else {
                                jButton2.setEnabled(TabsPanelViewport.this.getLeadingViewTabIndex() > 0);
                            }
                            if (!jButton2.isEnabled() && jButton2.hasFocus()) {
                                FocusManager.getCurrentManager().focusNextComponent();
                            }
                            JButton jButton3 = BasicJYTabbedPaneUI.this.getPopupButton();
                            jButton3.setEnabled(!bl);
                            if (BasicJYTabbedPaneUI.this.croppedEdgeSize > 0) {
                                BasicJYTabbedPaneUI.this.tabsPanel.leadingCroppedEdge.setVisible(!bl && !TabsPanelViewport.this.isScrollStartReached() && !BasicJYTabbedPaneUI.this.avoidLeadingCroppedTabs);
                                BasicJYTabbedPaneUI.this.tabsPanel.trailingCroppedEdge.setVisible(!bl && !TabsPanelViewport.this.isScrollEndReached() && !BasicJYTabbedPaneUI.this.avoidTrailingCroppedTabs && !BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton());
                            }
                            if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                                BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.updateAppearance(bl, TabsPanelViewport.this.isScrollEndReached());
                            }
                        }
                    });
                }
            };
        }

        private boolean isScrollEndReached() {
            Dimension dimension = this.getViewSize();
            Rectangle rectangle = this.getViewRect();
            boolean bl = BasicJYTabbedPaneUI.this.isVerticalTabPlacement() ? rectangle.y == dimension.height - rectangle.height : (this.getComponentOrientation().isLeftToRight() ? rectangle.x == dimension.width - rectangle.width : rectangle.x == 0);
            return bl;
        }

        private boolean isScrollStartReached() {
            Dimension dimension = this.getViewSize();
            Rectangle rectangle = this.getViewRect();
            boolean bl = BasicJYTabbedPaneUI.this.isVerticalTabPlacement() ? rectangle.y == 0 : (this.getComponentOrientation().isLeftToRight() ? rectangle.x == 0 : rectangle.x == dimension.width - rectangle.width);
            return bl;
        }

        private boolean isViewCompletelyVisible() {
            Dimension dimension = this.getViewSize();
            Rectangle rectangle = this.getViewRect();
            return BasicJYTabbedPaneUI.this.isVerticalTabPlacement() ? rectangle.height >= dimension.height : rectangle.width >= dimension.width;
        }

        private int getTrailingViewTabIndex() {
            Rectangle rectangle = this.getViewRect();
            boolean bl = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            boolean bl2 = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
            int n = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
            if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                this.calculatePlusButtonAwareViewRect(rectangle, bl, bl2, n);
            }
            int n2 = 0;
            while (n2 < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle rectangle2 = BasicJYTabbedPaneUI.this.rects[n2];
                Rectangle rectangle3 = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, rectangle2, this);
                if (bl2) {
                    rectangle3.height += n;
                    if (rectangle3.contains(rectangle3.x, rectangle.height + n - 1)) {
                        return n2;
                    }
                } else {
                    rectangle3.width += n;
                    if (rectangle3.contains(bl ? rectangle.width + n - 1 : (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton() ? BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getWidth() : 0), rectangle3.y)) {
                        return n2;
                    }
                }
                ++n2;
            }
            return -1;
        }

        private int getLeadingViewTabIndex() {
            Rectangle rectangle = this.getViewRect();
            boolean bl = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            boolean bl2 = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
            int n = BasicJYTabbedPaneUI.this.getTabbedPane().getTabGap();
            if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                this.calculatePlusButtonAwareViewRect(rectangle, bl, bl2, n);
            }
            int n2 = 0;
            while (n2 < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle rectangle2 = BasicJYTabbedPaneUI.this.rects[n2];
                Rectangle rectangle3 = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, rectangle2, this);
                if (bl2) {
                    rectangle3.height += n;
                    if (rectangle3.contains(rectangle3.x, 0)) {
                        return n2;
                    }
                } else {
                    rectangle3.width += n;
                    if (rectangle3.contains(bl ? 0 : rectangle.width + n - 1, rectangle3.y)) {
                        return n2;
                    }
                }
                ++n2;
            }
            return -1;
        }

        private void updatePopupItems() {
            Rectangle rectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabsPanelViewport.getParent(), BasicJYTabbedPaneUI.this.tabsPanelViewport.getBounds(), BasicJYTabbedPaneUI.this.tabPane);
            if (BasicJYTabbedPaneUI.this.tabsPanel.getShowPlusButton()) {
                this.calculatePlusButtonAwareViewRect(rectangle);
            }
            JPopupMenu jPopupMenu = ((SimpleDropDownButton)BasicJYTabbedPaneUI.this.leadingTabControlsPanel.getComponents()[3]).getPopupMenu();
            jPopupMenu.removeAll();
            JPopupMenu jPopupMenu2 = ((SimpleDropDownButton)BasicJYTabbedPaneUI.this.trailingTabControlsPanel.getComponents()[2]).getPopupMenu();
            jPopupMenu2.removeAll();
            int n = 0;
            while (n < BasicJYTabbedPaneUI.this.rects.length) {
                Rectangle rectangle2 = BasicJYTabbedPaneUI.this.rects[n];
                if (!rectangle.contains(rectangle2)) {
                    if (n >= BasicJYTabbedPaneUI.this.tabPane.getTabCount()) break;
                    Icon icon = BasicJYTabbedPaneUI.this.tabPane.getIconAt(n);
                    if (BasicJYTabbedPaneUI.this.forcePopupMenuIconSpace) {
                        icon = new EmptyIcon(16, 4);
                    }
                    SelectTabByMenuItemAction selectTabByMenuItemAction = new SelectTabByMenuItemAction(n, BasicJYTabbedPaneUI.this.tabPane.getTitleAt(n), icon);
                    selectTabByMenuItemAction.setEnabled(BasicJYTabbedPaneUI.this.tabPane.isEnabledAt(n));
                    JMenuItem jMenuItem = new JMenuItem(selectTabByMenuItemAction);
                    jMenuItem.setComponentOrientation(BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation());
                    jPopupMenu.add(jMenuItem);
                    jMenuItem = new JMenuItem(selectTabByMenuItemAction);
                    jMenuItem.setComponentOrientation(BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation());
                    jPopupMenu2.add(jMenuItem);
                }
                ++n;
            }
        }

        private void calculatePlusButtonAwareViewRect(Rectangle rectangle, boolean bl, boolean bl2, int n) {
            if (bl2) {
                rectangle.height -= BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getHeight() + n;
            } else {
                if (!bl) {
                    rectangle.x += BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getWidth() + n;
                }
                rectangle.width -= BasicJYTabbedPaneUI.this.tabsPanel.plusComponentPanel.getWidth() + n;
            }
        }

        public void calculatePlusButtonAwareViewRect(Rectangle rectangle) {
            int n = ((JYTabbedPane)BasicJYTabbedPaneUI.this.tabPane).getTabGap();
            this.calculatePlusButtonAwareViewRect(rectangle, this.getComponentOrientation().isLeftToRight(), BasicJYTabbedPaneUI.this.isVerticalTabPlacement(), n);
        }

        private class DragGlassPane
        extends JPanel {
            private static final long serialVersionUID = -344140311958471859L;
            private int x;
            private int y;
            private Rectangle draggingTabRectangle;
            private BufferedImage draggingTab;
            private Icon dragArrowIcon;

            public DragGlassPane() {
                this.setOpaque(false);
                this.draggingTabRectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[TabsPanelViewport.this.dragStartIndex], this.getRootPane());
                this.draggingTab = new BufferedImage(this.draggingTabRectangle.width, this.draggingTabRectangle.height, 2);
                Tab tab = BasicJYTabbedPaneUI.this.tabsPanel.getTab(TabsPanelViewport.this.dragStartIndex);
                Graphics2D graphics2D = this.draggingTab.createGraphics();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.75f);
                graphics2D.setComposite(alphaComposite);
                tab.print(graphics2D);
                graphics2D.dispose();
                int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                String string = "JYTabbedPane.dragArrowIcon." + (n == 1 ? "up" : (n == 3 ? "down" : (n == 2 ? "left" : "right")));
                this.dragArrowIcon = SyntheticaLookAndFeel.loadIcon(string, BasicJYTabbedPaneUI.this.tabPane);
                if (this.dragArrowIcon == null) {
                    this.dragArrowIcon = new FallbackDragArrowIcon();
                }
            }

            public void update(Point point) {
                this.x = point.x;
                this.y = point.y;
                this.setVisible(true);
                if (!this.getSize().equals(this.getRootPane().getSize())) {
                    this.setSize(this.getRootPane().getSize());
                }
                this.repaint();
            }

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.setColor(new Color(0x20FF0000, true));
                graphics.drawImage(this.draggingTab, this.draggingTabRectangle.x - ((TabsPanelViewport)TabsPanelViewport.this).dragStart.x + this.x, this.draggingTabRectangle.y - ((TabsPanelViewport)TabsPanelViewport.this).dragStart.y + this.y, null);
                Rectangle rectangle = this.calcDragArrowBounds();
                if (rectangle != null) {
                    this.dragArrowIcon.paintIcon(null, graphics, rectangle.x, rectangle.y);
                }
            }

            private Rectangle calcDragArrowBounds() {
                int n = TabsPanelViewport.this.mousePos2DragStopIndex(this.x, this.y);
                if (n < 0) {
                    return null;
                }
                Rectangle rectangle = SwingUtilities.convertRectangle(BasicJYTabbedPaneUI.this.tabPane, BasicJYTabbedPaneUI.this.rects[n], this);
                boolean bl = BasicJYTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
                boolean bl2 = BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
                int n2 = TabsPanelViewport.this.dragIndex - TabsPanelViewport.this.dragStartIndex;
                Rectangle rectangle2 = new Rectangle(rectangle);
                if (bl2) {
                    rectangle2.height /= 2;
                } else {
                    rectangle2.width /= 2;
                }
                Point point = SwingUtilities.convertPoint(BasicJYTabbedPaneUI.this.tabsPanelViewport, this.x, this.y, this);
                boolean bl3 = rectangle2.contains(point);
                if (bl2 && n2 >= 0 && !bl3) {
                    rectangle.y += rectangle.height;
                } else if (bl && n2 >= 0 && !bl3 || !bl && n2 <= 0 && !bl3) {
                    rectangle.x += rectangle.width;
                }
                int n3 = this.dragArrowIcon.getIconWidth();
                int n4 = this.dragArrowIcon.getIconHeight();
                if (bl2) {
                    rectangle.x = rectangle.x + (BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 2 ? rectangle.width : -n3);
                    rectangle.y -= n4 / 2;
                } else {
                    rectangle.x -= n3 / 2;
                    rectangle.y = rectangle.y + (BasicJYTabbedPaneUI.this.tabPane.getTabPlacement() == 1 ? rectangle.height : -n4);
                }
                rectangle.width = n3;
                rectangle.height = n4;
                return rectangle;
            }
        }

        private class FallbackDragArrowIcon
        extends SyntheticaBasicIconPainter {
            public FallbackDragArrowIcon() {
                super(null, 20, 20);
            }

            public void paint2D(SynthContext synthContext, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                f2 = 2.0f;
                f = 2.0f;
                Shape shape = new Ellipse2D.Float(f, f2, f3 - 4.0f, f4 - 4.0f);
                graphics2D.setPaint(new Color(-1428102944, true));
                graphics2D.fill(shape);
                graphics2D.setPaint(new Color(-863993728, true));
                graphics2D.draw(shape);
                int n = BasicJYTabbedPaneUI.this.tabPane.getTabPlacement();
                if (n != 1) {
                    int n2 = n == 3 ? 180 : (n == 2 ? 270 : 90);
                    AffineTransform affineTransform = new AffineTransform(graphics2D.getTransform());
                    affineTransform.rotate(Math.toRadians(n2), f3 / 2.0f, f4 / 2.0f);
                    graphics2D.setTransform(affineTransform);
                }
                graphics2D.setPaint(new Color(-532660160, true));
                shape = this.createArrowUpShape(f + 3.0f, f2 + 3.0f, f3 - 10.0f, f4 - 11.0f);
                graphics2D.fill(shape);
                graphics2D.draw(shape);
            }

            private Shape createArrowUpShape(float f, float f2, float f3, float f4) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(f + f3 / 2.0f, f2 + 0.0f);
                generalPath.lineTo(f + f3, f2 + f4 / 2.0f);
                generalPath.lineTo(f + f3 - 2.0f, f2 + f4 / 2.0f);
                generalPath.lineTo(f + f3 - 2.0f, f2 + f4);
                generalPath.lineTo(f + 2.0f, f2 + f4);
                generalPath.lineTo(f + 2.0f, f2 + f4 / 2.0f);
                generalPath.lineTo(f + 0.0f, f2 + f4 / 2.0f);
                generalPath.closePath();
                return generalPath;
            }
        }

        private class MouseEventGenerator {
            private Thread t;
            private int x;
            private int y;

            public void updateMousePosition(int n, int n2) {
                this.x = n;
                this.y = n2;
            }

            public boolean isAlive() {
                return this.t != null && this.t.isAlive();
            }

            public void start(final MouseEvent mouseEvent) {
                this.t = new Thread(){

                    public void run() {
                        while (!this.isInterrupted()) {
                            try {
                                1.sleep(BasicJYTabbedPaneUI.this.tabAutoScrollDelay);
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        long l = System.currentTimeMillis();
                                        MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), l, mouseEvent.getModifiers(), MouseEventGenerator.this.x, MouseEventGenerator.this.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                                        BasicJYTabbedPaneUI.this.tabsPanelViewport.dispatchEvent(mouseEvent2);
                                    }
                                });
                            }
                            catch (InterruptedException interruptedException) {
                                this.interrupt();
                            }
                        }
                    }
                };
                this.t.setDaemon(true);
                this.t.start();
            }

            public void stop() {
                if (this.t != null) {
                    this.t.interrupt();
                }
            }
        }

        private class ScrollAnimator {
            private Thread t;
            private int x;
            private int y;

            private ScrollAnimator() {
            }

            public void updateEndPosition(int n, int n2) {
                this.x = n;
                this.y = n2;
            }

            public boolean isAlive() {
                return this.t != null && this.t.isAlive();
            }

            public void start() {
                this.t = new Thread(){

                    public void run() {
                        while (!this.isInterrupted()) {
                            try {
                                1.sleep(25L);
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        int n;
                                        Point point = BasicJYTabbedPaneUI.this.tabsPanelViewport.getViewPosition().getLocation();
                                        boolean bl = !BasicJYTabbedPaneUI.this.isVerticalTabPlacement();
                                        boolean bl2 = BasicJYTabbedPaneUI.this.tabsPanelViewport.getComponentOrientation().isLeftToRight();
                                        boolean bl3 = ScrollAnimator.this.x > point.x || ScrollAnimator.this.y > point.y;
                                        int n2 = n = bl ? (ScrollAnimator.this.x - point.x) / 2 : (ScrollAnimator.this.y - point.y) / 2;
                                        if (n == 0 || (bl3 ^= bl && !bl2) && TabsPanelViewport.this.isScrollEndReached() || !bl3 && TabsPanelViewport.this.isScrollStartReached()) {
                                            this.interrupt();
                                        } else {
                                            int n3;
                                            if (n == 1 || n == -1) {
                                                n = 0;
                                            }
                                            Point point2 = bl ? new Point(ScrollAnimator.this.x - n, ScrollAnimator.this.y) : new Point(ScrollAnimator.this.x, ScrollAnimator.this.y - n);
                                            BasicJYTabbedPaneUI.this.tabsPanelViewport.setViewPosition(point2);
                                            int n4 = n3 = TabsPanelViewport.this.mouseWheelPosition == null ? -1 : BasicJYTabbedPaneUI.this.tabsPanelViewport.mousePos2TabIndex(((TabsPanelViewport)((ScrollAnimator)(this).ScrollAnimator.this).TabsPanelViewport.this).mouseWheelPosition.x, ((TabsPanelViewport)((ScrollAnimator)(this).ScrollAnimator.this).TabsPanelViewport.this).mouseWheelPosition.y);
                                            if (!TabsPanelViewport.this.mouseEventGenerator.isAlive()) {
                                                BasicJYTabbedPaneUI.this.tabPane.putClientProperty("Synthetica.MOUSE_OVER", n3);
                                            }
                                            BasicJYTabbedPaneUI.this.tabsPanelViewport.revalidate();
                                            BasicJYTabbedPaneUI.this.tabsPanelViewport.repaint();
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException interruptedException) {
                                this.interrupt();
                            }
                        }
                        if (!BasicJYTabbedPaneUI.this.tabsPanelViewport.isValid()) {
                            BasicJYTabbedPaneUI.this.tabsPanelViewport.validate();
                        }
                    }
                };
                this.t.setDaemon(true);
                this.t.start();
            }

            public void stop() {
                if (this.t != null) {
                    this.t.interrupt();
                }
            }
        }

        private class SelectTabByMenuItemAction
        extends AbstractAction {
            private static final long serialVersionUID = -6549076595331184802L;
            private int tabIndex;

            public SelectTabByMenuItemAction(int n, String string, Icon icon) {
                this.tabIndex = n;
                this.putValue("Name", string);
                this.putValue("SmallIcon", this.scaleIcon(icon));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BasicJYTabbedPaneUI.this.tabPane.setSelectedIndex(this.tabIndex);
                BasicJYTabbedPaneUI.this.updateTabFontStyle();
                TabsPanelViewport.this.setLeadingTabIndex(this.tabIndex);
            }

            private Icon scaleIcon(Icon icon) {
                if (icon == null) {
                    return null;
                }
                int n = 16;
                if (icon.getIconWidth() <= n && icon.getIconHeight() <= n) {
                    return icon;
                }
                return SyntheticaAddonsUtilities.resizeIcon(icon, n, n);
            }
        }
    }
}

