/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.swing.IRotatableComponent;
import de.javasoft.swing.JYLabel;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.JYLabelUI;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class BasicJYLabelUI
extends JYLabelUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJYLabelUI();
    }

    protected void installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
            this.installDefaults((JLabel)jComponent);
        }
        if ("rotation".equals(string)) {
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JYLabel jYLabel = (JYLabel)jComponent;
        Font font = jYLabel.getFont();
        FontMetrics fontMetrics = jYLabel.getFontMetrics(font);
        int n = jYLabel.getWidth();
        int n2 = jYLabel.getHeight();
        String string = jYLabel.getText();
        Icon icon2 = icon = jYLabel.isEnabled() ? jYLabel.getIcon() : jYLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        IRotatableComponent.Rotation rotation = jYLabel.getRotation();
        Insets insets = jYLabel.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        string = this.layoutCL(jYLabel, fontMetrics, string, icon, rectangle, rectangle3, rectangle2);
        if (icon != null) {
            this.paintIcon(jYLabel, graphics, icon, rectangle3, rotation);
        }
        this.paintText(jYLabel, graphics, font, fontMetrics, string, rectangle2, rotation);
    }

    private void paintText(JLabel jLabel, Graphics graphics, Font font, FontMetrics fontMetrics, String string, Rectangle rectangle, IRotatableComponent.Rotation rotation) {
        boolean bl;
        boolean bl2 = bl = jLabel.getClientProperty("html") != null;
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            if (!bl) {
                rectangle.x = rectangle.x + (rotation == IRotatableComponent.Rotation.RIGHT ? -fontMetrics.getAscent() : fontMetrics.getAscent());
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = rotation == IRotatableComponent.Rotation.RIGHT ? (rectangle.width - rectangle.height) / 2 : -(rectangle.width - rectangle.height) / 2;
            graphics2D.translate(d, d);
            graphics2D.rotate(Math.toRadians(rotation.toAngle()), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            this.paintLabelText(jLabel, string, graphics, rectangle);
            graphics2D.rotate(-Math.toRadians(rotation.toAngle()), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            graphics2D.translate(-d, -d);
        } else {
            if (!bl) {
                rectangle.y += fontMetrics.getAscent();
            }
            this.paintLabelText(jLabel, string, graphics, rectangle);
        }
    }

    protected void paintLabelText(JLabel jLabel, String string, Graphics graphics, Rectangle rectangle) {
        View view = (View)jLabel.getClientProperty("html");
        if (view != null) {
            view.paint(graphics, rectangle);
        } else if (jLabel.isEnabled()) {
            this.paintEnabledText(jLabel, graphics, string, rectangle.x, rectangle.y);
        } else {
            this.paintDisabledText(jLabel, graphics, string, rectangle.x, rectangle.y);
        }
    }

    private void paintIcon(JComponent jComponent, Graphics graphics, Icon icon, Rectangle rectangle, IRotatableComponent.Rotation rotation) {
        if (rotation == IRotatableComponent.Rotation.LEFT || rotation == IRotatableComponent.Rotation.RIGHT) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = rotation == IRotatableComponent.Rotation.LEFT ? -(rectangle.width - rectangle.height) / 2 : (rectangle.width - rectangle.height) / 2;
            graphics2D.translate(d, d);
            graphics2D.rotate(Math.toRadians(rotation.toAngle()), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
            graphics2D.rotate(-Math.toRadians(rotation.toAngle()), rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            graphics2D.translate(-d, -d);
        } else {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        IRotatableComponent.Rotation rotation = ((JYLabel)jLabel).getRotation();
        WidgetUtils.rotateRectangle(rectangle, rotation);
        string = this.layoutLabel_(jLabel, fontMetrics, string, icon, rectangle, rectangle2, rectangle3, rotation);
        WidgetUtils.rotateRectangle(rectangle, rotation);
        this.rotatePosition(rectangle, rectangle3, rotation);
        WidgetUtils.rotateRectangle(rectangle3, rotation);
        this.rotatePosition(rectangle, rectangle2, rotation);
        WidgetUtils.rotateRectangle(rectangle2, rotation);
        return string;
    }

    private String layoutLabel_(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, IRotatableComponent.Rotation rotation) {
        int n = jLabel.getVerticalAlignment();
        int n2 = jLabel.getHorizontalAlignment();
        int n3 = jLabel.getVerticalTextPosition();
        int n4 = jLabel.getHorizontalTextPosition();
        string = SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
        return string;
    }

    private void rotatePosition(Rectangle rectangle, Rectangle rectangle2, IRotatableComponent.Rotation rotation) {
        int n = rectangle2.x - rectangle.x;
        int n2 = rectangle2.y - rectangle.y;
        if (rotation == IRotatableComponent.Rotation.LEFT) {
            rectangle2.x = rectangle.x + n2;
            rectangle2.y = rectangle.y - n + rectangle.height - rectangle2.width;
        } else if (rotation == IRotatableComponent.Rotation.RIGHT) {
            rectangle2.x = rectangle.x - n2 + rectangle.width - rectangle2.height;
            rectangle2.y = rectangle.y + n;
        }
    }
}

