/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.DockbarSlidePanel;
import de.javasoft.swing.jydocking.RootWindow;
import de.javasoft.swing.jydocking.StatusDockbarLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JDialog;

class StatusDockbarManager
extends DockbarManager {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private static boolean leftBarInner = false;
    private static boolean rightBarInner = false;
    private static boolean bottomBarInner = true;

    public StatusDockbarManager(RootWindow rootWindow) {
        super(rootWindow);
        this.dockbarLayout = new StatusDockbarLayout(this);
        this.leftBar = new Dockbar(this, 2);
        this.rightBar = new Dockbar(this, 4);
        this.bottomBar = new Dockbar(this, 3);
        this.slidePanel = new DockbarSlidePanel(this);
    }

    public static void setDockbarPlacement(int n, boolean bl) {
        if (n == 2) {
            leftBarInner = bl;
        } else if (n == 4) {
            rightBarInner = bl;
        } else if (n == 3) {
            bottomBarInner = bl;
        }
    }

    public void validate() {
        this.dockbarLayout.layout();
        this.slidePanel.revalidate();
    }

    protected void install() {
        RootWindow rootWindow = this.getWindow();
        if (rootWindow == null) {
            return;
        }
        if (rootWindow.getRootComponent() instanceof JDialog && ((JDialog)rootWindow.getRootComponent()).isModal()) {
            return;
        }
        if (rootWindow.getContentPane().getLayout() instanceof BorderLayout) {
            rootWindow.getLayeredPane().add((Component)this.slidePanel, DOCKBAR_LAYER);
            this.installDockbar(this.leftBar, "West", leftBarInner);
            this.installDockbar(this.bottomBar, "South", bottomBarInner);
            this.installDockbar(this.rightBar, "East", rightBarInner);
        }
    }

    private boolean installDockbar(Dockbar dockbar, String string, boolean bl) {
        Container container = this.getWindow().getContentPane();
        LayoutManager layoutManager = container.getLayout();
        if (!(layoutManager instanceof BorderLayout)) {
            throw new IllegalStateException("Only BorderLayout for ContentPane is supported!");
        }
        BorderLayout borderLayout = (BorderLayout)layoutManager;
        Component component = borderLayout.getLayoutComponent(string);
        if (component instanceof DockbarContainer) {
            return false;
        }
        if (component != null) {
            container.remove(component);
        }
        String string2 = string;
        if (string.equals("North") && bl) {
            string2 = "South";
        } else if (string.equals("South") && bl) {
            string2 = "North";
        } else if (string.equals("West") && bl) {
            string2 = "East";
        } else if (string.equals("East") && bl) {
            string2 = "West";
        }
        DockbarContainer dockbarContainer = new DockbarContainer();
        if (component != null) {
            dockbarContainer.add(component, "Center");
        }
        dockbarContainer.add((Component)dockbar, string2);
        container.add((Component)dockbarContainer, string);
        if (component != null) {
            container.validate();
        }
        if (JAVA5) {
            dockbarContainer.validate();
        }
        return true;
    }

    public Container getContainer(int n) {
        BorderLayout borderLayout = (BorderLayout)this.getDockbar(n).getParent().getLayout();
        return (Container)borderLayout.getLayoutComponent("Center");
    }

    private static class DockbarContainer
    extends Container {
        private static final long serialVersionUID = 2621037069903125435L;

        public DockbarContainer() {
            this.setLayout(new BorderLayout());
        }
    }
}

