/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DragManager;
import de.javasoft.swing.jydocking.IDockable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTabbedPane;

class DragTabListener
extends MouseAdapter
implements MouseMotionListener {
    private DragManager dragListener;

    DragTabListener() {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragListener != null) {
            this.dragListener.mouseDragged(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragListener != null) {
            this.dragListener.mouseReleased(mouseEvent);
        }
        this.dragListener = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
        int n = jTabbedPane.getSelectedIndex();
        if (n < 0) {
            this.dragListener = null;
        } else {
            IDockable iDockable = DockingManager.getDockable(jTabbedPane.getComponentAt(n));
            this.dragListener = DockingManager.getDragListener(iDockable);
            if (this.dragListener != null) {
                this.dragListener.mousePressed(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

