/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.IDockingPort;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

class DockingSplitPane
extends JSplitPane {
    private static final long serialVersionUID = -1165035020321526941L;
    protected IDockingPort dockingPort;
    protected String region;
    protected boolean dividerLocDetermined;
    protected boolean controllerInTopLeft;
    protected double initialDividerRatio = 0.5;

    public DockingSplitPane(IDockingPort iDockingPort, String string) {
        if (iDockingPort == null) {
            throw new IllegalArgumentException("'port' cannot be null.");
        }
        if (!DockingManager.isValidDockingRegion(string)) {
            throw new IllegalArgumentException("'" + string + "' is not a valid region.");
        }
        this.region = string;
        this.dockingPort = iDockingPort;
        this.controllerInTopLeft = !DockingUtility.isRegionTopLeft(string);
        boolean bl = this.controllerInTopLeft;
        this.setResizeWeight((double)bl);
        final BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        if (basicSplitPaneDivider != null) {
            basicSplitPaneDivider.setBorder(null);
            basicSplitPaneDivider.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                        ((JSplitPane)basicSplitPaneDivider.getParent()).resetToPreferredSizes();
                    }
                }
            });
        }
    }

    public void resetToPreferredSizes() {
        Insets insets = this.getInsets();
        if (this.getOrientation() == 0) {
            int n;
            int n2;
            int n3 = this.getHeight() - insets.top - insets.bottom - this.getDividerSize();
            int n4 = n3 - (n2 = this.getTopComponent().getPreferredSize().height) - (n = this.getBottomComponent().getPreferredSize().height);
            if (n4 >= 0) {
                this.setDividerLocation(insets.top + n2 + (int)((double)n4 * this.getResizeWeight() + 0.5));
            }
        } else {
            int n;
            int n5;
            int n6 = this.getWidth() - insets.left - insets.right - this.getDividerSize();
            int n7 = n6 - (n5 = this.getLeftComponent().getPreferredSize().width) - (n = this.getRightComponent().getPreferredSize().width);
            if (n7 >= 0) {
                this.setDividerLocation(insets.left + n5 + (int)((double)n7 * this.getResizeWeight() + 0.5));
            }
        }
    }

    protected boolean isDividerSizeProperlyDetermined() {
        if (this.getDividerLocation() != 0) {
            return true;
        }
        return this.dividerLocDetermined;
    }

    public Component getElderComponent() {
        Component component;
        Component component2 = component = this.controllerInTopLeft ? this.getLeftComponent() : this.getRightComponent();
        if (component instanceof IDockingPort) {
            component = ((IDockingPort)((Object)component)).getDockedComponent();
        }
        return component;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean isElderTopLeft() {
        return this.controllerInTopLeft;
    }

    void cleanup() {
        this.dockingPort = null;
    }

    public void setInitialDividerRatio(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("ratio (" + d + ") must be between [0.0, 1.0] inclusive");
        }
        this.initialDividerRatio = d;
    }

    public void doLayout() {
        if (!this.isDividerSizeProperlyDetermined()) {
            this.dividerLocDetermined = true;
            this.setDividerLocation(this.initialDividerRatio);
        }
        super.doLayout();
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }
}

