/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.DockingUtility;
import java.awt.EventQueue;
import java.awt.Point;
import javax.swing.SwingUtilities;

class DockbarDeactivator {
    private DockbarManager manager;
    private Deactivator deactivator;
    private boolean mouseOver;

    public DockbarDeactivator(DockbarManager dockbarManager) {
        this.manager = dockbarManager;
    }

    public void mouseEntered(Point point) {
        if (this.mouseOver) {
            return;
        }
        this.mouseOver = true;
        if (this.deactivator != null) {
            this.deactivator.interrupt();
        }
        this.deactivator = null;
    }

    public void mouseExited(Point point) {
        if (!this.mouseOver) {
            return;
        }
        this.mouseOver = false;
        if (!this.isOverDockbars(point)) {
            this.deactivator = new Deactivator(this.manager.getActiveDockableId());
            this.deactivator.start();
        }
    }

    public void mousePressed(Point point, boolean bl) {
        if (bl) {
            if (!this.manager.isSlidePanelLocked()) {
                this.manager.lockSlidePanel();
            }
        } else if (!this.isOverDockbars(point)) {
            if (this.deactivator != null) {
                this.deactivator.interrupt();
            }
            this.manager.setActiveDockable((String)null);
        }
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    private boolean isOverDockbars(Point point) {
        Dockbar dockbar = this.manager.getLeftBar();
        Dockbar dockbar2 = this.manager.getBottomBar();
        Dockbar dockbar3 = this.manager.getRightBar();
        return SwingUtilities.convertRectangle(dockbar.getParent(), dockbar.getBounds(), dockbar.getRootPane()).contains(point) || SwingUtilities.convertRectangle(dockbar2.getParent(), dockbar2.getBounds(), dockbar2.getRootPane()).contains(point) || SwingUtilities.convertRectangle(dockbar3.getParent(), dockbar3.getBounds(), dockbar3.getRootPane()).contains(point);
    }

    private class Deactivator
    extends Thread {
        private String dockableID;

        private Deactivator(String string) {
            this.dockableID = string;
            this.setDaemon(true);
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
            if (!this.isInterrupted()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        String string = DockbarDeactivator.this.manager.getActiveDockableId();
                        if (!(DockingUtility.isChanged(string, Deactivator.this.dockableID) || DockbarDeactivator.this.manager.isSlidePanelLocked() || DockbarDeactivator.this.manager.isAnimating())) {
                            DockbarDeactivator.this.manager.setActiveDockable((String)null);
                        }
                    }
                });
            }
        }
    }
}

