/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingPort;
import de.javasoft.swing.jydocking.IBorderManager;
import de.javasoft.swing.jydocking.IDockingPort;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BorderManager
implements IBorderManager {
    private Border assignedBorder;

    public BorderManager() {
    }

    public BorderManager(Border border) {
        this.setBorder(border);
    }

    public Border getBorder() {
        return this.assignedBorder;
    }

    public void setBorder(Border border) {
        this.assignedBorder = border;
    }

    public void managePortNullChild(IDockingPort iDockingPort) {
        this.setBorder(iDockingPort, this.assignedBorder);
    }

    public void managePortSimpleChild(IDockingPort iDockingPort) {
        this.setBorder(iDockingPort.getDockedComponent(), null);
        this.setBorder(iDockingPort, this.assignedBorder);
    }

    public void managePortSplitChild(IDockingPort iDockingPort) {
        BasicSplitPaneDivider basicSplitPaneDivider;
        if (iDockingPort == null || !(iDockingPort.getDockedComponent() instanceof JSplitPane)) {
            return;
        }
        this.setBorder(iDockingPort, null);
        JSplitPane jSplitPane = (JSplitPane)iDockingPort.getDockedComponent();
        if (jSplitPane.getUI() instanceof BasicSplitPaneUI && (basicSplitPaneDivider = ((BasicSplitPaneUI)jSplitPane.getUI()).getDivider()) != null && basicSplitPaneDivider.getBorder() != null) {
            basicSplitPaneDivider.setBorder(null);
        }
        this.setBorder(jSplitPane, null);
        this.setSubComponentBorder(jSplitPane.getLeftComponent(), this.assignedBorder);
        this.setSubComponentBorder(jSplitPane.getRightComponent(), this.assignedBorder);
    }

    private void setSubComponentBorder(Component component, Border border) {
        if (component instanceof DockingPort) {
            ((DockingPort)component).evaluateDockingBorderStatus();
        } else {
            this.setBorder(component, border);
        }
    }

    public void managePortTabbedChild(IDockingPort iDockingPort) {
        this.managePortSimpleChild(iDockingPort);
        if (!(iDockingPort.getDockedComponent() instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)iDockingPort.getDockedComponent();
        int n = jTabbedPane.getTabCount();
        Component component = null;
        int n2 = 0;
        while (n2 < n) {
            component = jTabbedPane.getComponentAt(n2);
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(null);
            }
            ++n2;
        }
    }

    private void setBorder(Component component, Border border) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(border);
        }
    }

    private void setBorder(IDockingPort iDockingPort, Border border) {
        if (iDockingPort instanceof JComponent) {
            ((JComponent)((Object)iDockingPort)).setBorder(border);
        }
    }
}

