/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jycombobox;

import de.javasoft.swing.JYComboBox;
import de.javasoft.swing.jycombobox.IPopupComponentInitializer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontPopupPanel
extends JPanel
implements IPopupComponentInitializer {
    private JYComboBox comboBox;
    protected PreviewPanel previewPanel;
    private JComboBox familyCombo;
    private JComboBox styleCombo;
    private JSpinner sizeSpinner;
    private static String delimiter = ",";

    public FontPopupPanel(JYComboBox jYComboBox) {
        this.comboBox = jYComboBox;
        if (jYComboBox != null) {
            this.comboBox.setPopupResizable(true);
        }
        this.setLayout(new GridBagLayout());
        this.previewPanel = new PreviewPanel();
        this.add((Component)this.previewPanel, new GridBagConstraints(0, 0, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 4, 0), 0, 0));
        JLabel jLabel = new JLabel(UIManager.getString("JYComboBox.fontPopup.family"));
        this.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 4, 5), 0, 0));
        jLabel = new JLabel(UIManager.getString("JYComboBox.fontPopup.style"));
        this.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 4, 5), 0, 0));
        jLabel = new JLabel(UIManager.getString("JYComboBox.fontPopup.size"));
        this.add((Component)jLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 4, 0), 0, 0));
        this.familyCombo = this.createFamilyCombo();
        this.add((Component)this.familyCombo, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.styleCombo = this.createStyleCombo();
        this.add((Component)this.styleCombo, new GridBagConstraints(1, 2, 1, 1, 0.05, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.sizeSpinner = this.createSizeSpinner();
        this.add((Component)this.sizeSpinner, new GridBagConstraints(2, 2, 1, 1, 0.05, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.createButtonPanel(), new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.setBorder(new EmptyBorder(10, 10, 5, 10));
    }

    public void initializePopupComponent(JYComboBox jYComboBox) {
        Object object = jYComboBox.getItem();
        this.setPreviewFont(object == null ? UIManager.getFont("Label.font") : (Font)object);
    }

    public void setPreviewFont(Font font) {
        this.familyCombo.setSelectedItem(font.getFamily());
        this.styleCombo.setSelectedItem(font.getStyle());
        this.sizeSpinner.setValue(font.getSize());
    }

    private JComboBox createFamilyCombo() {
        JYComboBox jYComboBox = new JYComboBox(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        jYComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)itemEvent.getItem();
                    Font font = FontPopupPanel.this.previewPanel.getPreviewFont();
                    FontPopupPanel.this.previewPanel.setPreviewFont(new Font(string, font.getStyle(), font.getSize()));
                }
            }
        });
        return jYComboBox;
    }

    private JComboBox createStyleCombo() {
        JYComboBox jYComboBox = new JYComboBox();
        jYComboBox.addItem(0);
        jYComboBox.addItem(1);
        jYComboBox.addItem(2);
        jYComboBox.addItem(3);
        final ListCellRenderer listCellRenderer = jYComboBox.getRenderer();
        jYComboBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
                int n2 = (Integer)object;
                jLabel.setText(FontPopupPanel.fontStyleAsText(n2));
                return jLabel;
            }
        });
        jYComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n = (Integer)itemEvent.getItem();
                    FontPopupPanel.this.previewPanel.setPreviewFont(FontPopupPanel.this.previewPanel.getPreviewFont().deriveFont(n));
                }
            }
        });
        return jYComboBox;
    }

    private JSpinner createSizeSpinner() {
        JSpinner jSpinner = new JSpinner();
        jSpinner.setModel(new SpinnerNumberModel(10, 4, 256, 1));
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                int n = (Integer)jSpinner.getValue();
                FontPopupPanel.this.previewPanel.setPreviewFont(FontPopupPanel.this.previewPanel.getPreviewFont().deriveFont((float)n));
            }
        });
        return jSpinner;
    }

    private JPanel createButtonPanel() {
        Component component;
        JButton jButton = new JButton(this.createApproveAction());
        JButton jButton2 = new JButton(this.createCancelAction());
        int n = 10;
        SpringLayout springLayout = new SpringLayout(){

            public Dimension preferredLayoutSize(Container container) {
                return container.getComponent(0).getPreferredSize();
            }
        };
        JPanel jPanel = new JPanel(springLayout);
        jPanel.setOpaque(false);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        springLayout.putConstraint("East", (Component)jButton2, 0, "East", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jButton, -n, "West", (Component)jButton2);
        Spring spring = Spring.constant(0);
        Component[] componentArray = jPanel.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            component = componentArray[n3];
            spring = Spring.max(spring, springLayout.getConstraints(component).getWidth());
            ++n3;
        }
        componentArray = jPanel.getComponents();
        n2 = componentArray.length;
        n3 = 0;
        while (n3 < n2) {
            component = componentArray[n3];
            SpringLayout.Constraints constraints = springLayout.getConstraints(component);
            constraints.setWidth(spring);
            ++n3;
        }
        return jPanel;
    }

    protected Action createApproveAction() {
        AbstractAction abstractAction = new AbstractAction(){
            {
                this.putValue("Name", UIManager.getString("JYComboBox.fontPopup.approve.text"));
                String string = UIManager.getString("JYComboBox.fontPopup.approve.mnemonic");
                this.putValue("MnemonicKey", string == null ? 79 : (int)string.charAt(0));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JYComboBox jYComboBox = FontPopupPanel.this.comboBox;
                jYComboBox.setItem(FontPopupPanel.this.previewPanel.getPreviewFont());
                jYComboBox.closePopup();
            }
        };
        return abstractAction;
    }

    protected Action createCancelAction() {
        AbstractAction abstractAction = new AbstractAction(){
            {
                this.putValue("Name", UIManager.getString("JYComboBox.fontPopup.cancel.text"));
                String string = UIManager.getString("JYComboBox.fontPopup.cancel.mnemonic");
                this.putValue("MnemonicKey", string == null ? 67 : (int)string.charAt(0));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JYComboBox jYComboBox = FontPopupPanel.this.comboBox;
                jYComboBox.cancelPopup();
            }
        };
        return abstractAction;
    }

    static String fontStyleAsText(int n) {
        String string = null;
        if (n == 0) {
            string = UIManager.getString("JYComboBox.fontPopup.style.plain");
        } else if (n == 1) {
            string = UIManager.getString("JYComboBox.fontPopup.style.bold");
        } else if (n == 2) {
            string = UIManager.getString("JYComboBox.fontPopup.style.italic");
        } else if (n == 3) {
            string = UIManager.getString("JYComboBox.fontPopup.style.boldItalic");
        }
        return string;
    }

    static int parseFontStyle(String string) {
        int n = 0;
        if ((string = string.toLowerCase()).equals(UIManager.getString("JYComboBox.fontPopup.style.plain").toLowerCase())) {
            n = 0;
        } else if (string.equals(UIManager.getString("JYComboBox.fontPopup.style.bold").toLowerCase())) {
            n = 1;
        } else if (string.equals(UIManager.getString("JYComboBox.fontPopup.style.italic").toLowerCase())) {
            n = 2;
        } else if (string.equals(UIManager.getString("JYComboBox.fontPopup.style.boldItalic").toLowerCase())) {
            n = 3;
        }
        return n;
    }

    static String fontAsText(Font font) {
        return font == null ? "" : String.valueOf(font.getFamily()) + delimiter + " " + FontPopupPanel.fontStyleAsText(font.getStyle()) + delimiter + " " + font.getSize();
    }

    static Font parseFont(String string) throws ParseException {
        int n = 3;
        String[] stringArray = string.split(delimiter);
        Object[] objectArray = new Object[n];
        if (stringArray.length != n) {
            throw new ParseException("Required number: " + n, -1);
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (n2 == 0) {
                objectArray[n2] = stringArray[n2].trim();
            } else if (n2 == 1) {
                objectArray[n2] = FontPopupPanel.parseFontStyle(stringArray[n2].trim());
            } else if (n2 == 2) {
                try {
                    int n3 = Integer.parseInt(stringArray[n2].trim());
                    if (n3 < 4 || n3 > 256) {
                        throw new NumberFormatException("Size has to be between 4 and 256");
                    }
                    objectArray[n2] = n3;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(numberFormatException.getMessage(), -1);
                }
            }
            ++n2;
        }
        Font font = null;
        try {
            font = new Font((String)objectArray[0], (int)((Integer)objectArray[1]), (Integer)objectArray[2]);
        }
        catch (RuntimeException runtimeException) {
            throw new ParseException(runtimeException.getMessage(), -1);
        }
        return font;
    }

    protected static class PreviewPanel
    extends JPanel {
        JLabel previewText;

        public PreviewPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder(UIManager.getString("JYComboBox.fontPopup.preview.text")));
            this.previewText = new JLabel(UIManager.getString("JYComboBox.fontPopup.preview.string"));
            this.previewText.setHorizontalAlignment(0);
            this.setPreferredSize(new Dimension(200, 80));
            this.setMinimumSize(new Dimension(0, 0));
            this.add(this.previewText);
        }

        public void setPreviewFont(Font font) {
            this.previewText.setFont(font);
        }

        public Font getPreviewFont() {
            return this.previewText.getFont();
        }
    }
}

