/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jycombobox;

import de.javasoft.swing.JYComboBox;
import de.javasoft.swing.jycombobox.ColorComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorPopupPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ListSelectionListener {
    private JYComboBox comboBox;
    private JList list;
    private JSeparator separator;
    private AbstractButton nonColorButton;
    private AbstractButton otherColorButton;
    private Dimension colorCellDimension;
    private static String delimiter = ",";

    public ColorPopupPanel(JYComboBox jYComboBox) {
        this.comboBox = jYComboBox;
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "enterPressed");
        this.getActionMap().put("enterPressed", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorPopupPanel.this.setSelectedListItemAsComboBoxItem();
            }
        });
        this.setLayout(new GridBagLayout());
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(2);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        this.list.addMouseMotionListener(this);
        this.setColorCellDimension(new Dimension(14, 14));
        this.setColorRows(7);
        this.setColors(this.createNaturalColorPalette());
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                Color color = (Color)object;
                this.setIcon(new ColorIcon(color, ((ColorPopupPanel)ColorPopupPanel.this).colorCellDimension.width, ((ColorPopupPanel)ColorPopupPanel.this).colorCellDimension.height));
                this.setText("");
                ListCellRenderer listCellRenderer = ColorPopupPanel.this.comboBox.getRenderer();
                if (listCellRenderer instanceof ColorComboBoxRenderer && ((ColorComboBoxRenderer)listCellRenderer).isAlphaValueIncluded()) {
                    this.setToolTipText(color == null ? null : Integer.toHexString(color.getRGB()).substring(0).toUpperCase());
                } else {
                    this.setToolTipText(color == null ? null : Integer.toHexString(color.getRGB()).substring(2).toUpperCase());
                }
                return this;
            }
        });
        this.add((Component)this.list, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.separator = new JSeparator(0);
        this.add((Component)this.separator, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(4, 0, 4, 0), 0, 0));
        this.nonColorButton = new JButton(new AbstractAction(UIManager.getString("JYComboBox.colorPopup.noColor")){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorPopupPanel.this.comboBox.closePopup();
                ColorPopupPanel.this.setSelectedComboBoxItem(null);
            }
        });
        this.nonColorButton.setName("ColorPopupPanel.NonColorButton");
        this.insertComponentAt(this.nonColorButton, 2);
        this.otherColorButton = new JButton(new AbstractAction(UIManager.getString("JYComboBox.colorPopup.otherColor")){
            private static final long serialVersionUID = -5960946612368469089L;

            public void actionPerformed(ActionEvent actionEvent) {
                ColorPopupPanel.this.comboBox.closePopup();
                Color color = (Color)ColorPopupPanel.this.comboBox.getSelectedItem();
                Window window = SwingUtilities.getWindowAncestor(ColorPopupPanel.this.comboBox);
                Color color2 = JColorChooser.showDialog(window, "Select a color...", color);
                if (color2 != null) {
                    ColorPopupPanel.this.setSelectedComboBoxItem(color2);
                }
            }
        });
        this.otherColorButton.setName("ColorPopupPanel.OtherColorButton");
        this.insertComponentAt(this.otherColorButton, 3);
        this.setNonColorButtonVisible(true);
        this.setOtherColorButtonVisible(true);
    }

    public void insertComponentAt(Component component, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 10, 2, new Insets(n == 0 ? 4 : 0, 4, 4, 4), 0, 0);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        int n2 = gridBagConstraints.gridy;
        while (n2 < this.getComponentCount()) {
            Component component2 = this.getComponent(n2);
            GridBagConstraints gridBagConstraints2 = gridBagLayout.getConstraints(component2);
            ++gridBagConstraints2.gridy;
            gridBagLayout.setConstraints(component2, gridBagConstraints2);
            ++n2;
        }
        this.add(component, gridBagConstraints);
    }

    private void updateSeparatorVisibility() {
        this.separator.setVisible(this.otherColorButton.isVisible() || this.nonColorButton.isVisible());
    }

    public void setColorRows(int n) {
        this.list.setVisibleRowCount(n);
    }

    public int getColorRows() {
        return this.list.getVisibleRowCount();
    }

    public void setColorCellDimension(Dimension dimension) {
        this.colorCellDimension = dimension;
    }

    public Dimension getColorCellDimension() {
        return this.colorCellDimension;
    }

    public void setNonColorButtonVisible(boolean bl) {
        this.nonColorButton.setVisible(bl);
        this.updateSeparatorVisibility();
    }

    public boolean isNonColorButtonVisible() {
        return this.nonColorButton.isVisible();
    }

    public void setOtherColorButtonVisible(boolean bl) {
        this.otherColorButton.setVisible(bl);
        this.updateSeparatorVisibility();
    }

    public boolean isOtherColorButtonVisible() {
        return this.otherColorButton.isVisible();
    }

    public void setColors(Color[] colorArray) {
        DefaultListModel<Color> defaultListModel = new DefaultListModel<Color>();
        Color[] colorArray2 = colorArray;
        int n = colorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray2[n2];
            defaultListModel.addElement(color);
            ++n2;
        }
        this.list.setModel(defaultListModel);
    }

    public Color[] getColors() {
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        Color[] colorArray = new Color[defaultListModel.getSize()];
        int n = 0;
        while (n < colorArray.length) {
            colorArray[n] = (Color)defaultListModel.get(n);
            ++n;
        }
        return colorArray;
    }

    public Color[] createLinearColorPalette(int n) {
        int n2 = this.getColorRows();
        int[] nArray = new int[256 / n + 1];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = n3 * n;
            ++n3;
        }
        int n4 = nArray.length - 1;
        nArray[n4] = nArray[n4] - 1;
        Color[] colorArray = new Color[nArray.length * n2];
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < nArray.length) {
                int n7 = (n2 - n5 & 4) == 0 ? 0 : nArray[n6] << 16;
                int n8 = (n2 - n5 & 2) == 0 ? 0 : nArray[n6] << 8;
                int n9 = (n2 - n5 & 1) == 0 ? 0 : nArray[n6];
                colorArray[n5 * nArray.length + n6] = new Color(n7 | n8 | n9);
                ++n6;
            }
            ++n5;
        }
        return colorArray;
    }

    public Color[] createWebColorPalette() {
        int[] nArray = new int[6];
        nArray[1] = 51;
        nArray[2] = 102;
        nArray[3] = 153;
        nArray[4] = 204;
        nArray[5] = 255;
        int[] nArray2 = nArray;
        int n = nArray2.length;
        Color[] colorArray = new Color[n * n * n];
        int n2 = 0;
        while (n2 < nArray2.length) {
            int n3 = 0;
            while (n3 < nArray2.length) {
                int n4 = 0;
                while (n4 < nArray2.length) {
                    int n5 = nArray2[n2] << 16 | nArray2[n3] << 8 | nArray2[n4];
                    colorArray[n2 * n * n + n3 * n + n4] = new Color(n5);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return colorArray;
    }

    public Color[] createNaturalColorPalette() {
        Color[] colorArray = new Color[]{new Color(0xFFFFFF), new Color(0), new Color(0xFF0000), new Color(0xFF0099), new Color(0xFF00FF), new Color(0x9900FF), new Color(255), new Color(39423), new Color(65535), new Color(65433), new Color(65280), new Color(0x99FF00), new Color(0xFFFF00), new Color(0xFF9900)};
        return this.createColorVariants(colorArray);
    }

    public Color[] createColorVariants(Color[] colorArray) {
        float f = 1.4f;
        int n = this.getColorRows();
        Color[] colorArray2 = new Color[colorArray.length * n];
        int n2 = 0;
        while (n2 < colorArray.length) {
            Color color = colorArray[n2];
            float[] fArray = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
            colorArray2[n2] = colorArray[n2];
            int n3 = 1;
            while (n3 < n) {
                float f2 = (float)(n3 - 1) / (float)n;
                f2 = (float)Math.pow(f2, f);
                float f3 = 1.0f - f2;
                if (fArray[1] == 0.0f) {
                    float f4 = 0.5f + 0.5f * fArray[2];
                    f3 = f4 * (float)(n - n3 + 1) / (float)n;
                }
                colorArray2[n2 + n3 * colorArray.length] = new Color(Color.HSBtoRGB(fArray[0], fArray[1] * (float)(n3 + 1) / (float)(n + 1), f3));
                ++n3;
            }
            ++n2;
        }
        return colorArray2;
    }

    private void setSelectedListItemAsComboBoxItem() {
        if (this.list.getSelectedIndex() < 0) {
            return;
        }
        this.setSelectedComboBoxItem(this.list.getModel().getElementAt(this.list.getSelectedIndex()));
    }

    private void setSelectedComboBoxItem(Object object) {
        this.comboBox.setItem(object);
        this.comboBox.closePopup();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.list.setSelectedIndex(this.list.locationToIndex(mouseEvent.getPoint()));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setSelectedListItemAsComboBoxItem();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static Color parseColor(String string, boolean bl) throws ParseException {
        int n = bl ? 4 : 3;
        String[] stringArray = string.split(delimiter);
        int[] nArray = new int[n];
        if (stringArray.length != n) {
            throw new ParseException("Required number: " + n, -1);
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            try {
                nArray[n2] = Integer.parseInt(stringArray[n2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage(), -1);
            }
            ++n2;
        }
        Color color = null;
        try {
            color = nArray.length == 3 ? new Color(nArray[0], nArray[1], nArray[2]) : new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), -1);
        }
        return color;
    }

    static String colorAsText(Color color, boolean bl, boolean bl2) {
        String string = null;
        if (bl) {
            string = bl2 ? Integer.toHexString(color.getRGB()).toUpperCase() : Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
        } else {
            string = String.valueOf(color.getRed()) + delimiter + " " + color.getGreen() + delimiter + " " + color.getBlue();
            if (bl2) {
                string = String.valueOf(string) + delimiter + " " + color.getAlpha();
            }
        }
        return string;
    }

    public static class ColorIcon
    extends Color
    implements Icon {
        private boolean nullColor;
        private int width;
        private int height;

        public ColorIcon(Color color, int n, int n2) {
            super(color == null ? 0 : color.getRGB(), true);
            this.nullColor = color == null;
            this.width = n;
            this.height = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.paint(component, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
        }

        private void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this);
            if (!this.nullColor) {
                if (this.getAlpha() < 255) {
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillRect(n, n2, n3, n4);
                    graphics2D.setColor(new Color(0x808080));
                    graphics2D.fillRect(n, n2, n3 / 2, n4 / 2);
                    graphics2D.fillRect(n + n3 / 2, n2 + n4 / 2, n3 / 2, n4 / 2);
                    graphics2D.setColor(this);
                }
                graphics2D.fillRect(n, n2, n3, n4);
            }
            if (this.nullColor) {
                Color color;
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color color2 = color = component.getParent().getParent().hasFocus() ? UIManager.getColor("Synthetica.comboBox.focused.textColor") : UIManager.getColor("Synthetica.comboBox.locked.textColor");
                if (color == null) {
                    color = component.getForeground();
                }
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 192);
                graphics2D.setColor(color);
                graphics2D.drawLine(n, n2, n + n3 - 1, n2 + n4 - 1);
                graphics2D.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            } else {
                graphics2D.setColor(new Color(0x40000000, true));
            }
            graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }
}

