/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.filter.AbstractRowFilterModel;
import de.javasoft.swing.filter.Boundaries;
import de.javasoft.swing.sort.RowFilters;
import java.util.ArrayList;
import java.util.List;
import javax.swing.RowFilter;

public class ComparableRowFilterModel<M>
extends AbstractRowFilterModel<M> {
    public ComparableRowFilterModel() {
        this(0);
    }

    public ComparableRowFilterModel(int columnIndex) {
        this(columnIndex, null);
    }

    public ComparableRowFilterModel(int columnIndex, Object matchRule) {
        super(columnIndex);
        this.setInitialMatchRule(matchRule);
    }

    @Override
    protected RowFilter<? super M, ? super Integer> createRowFilter() {
        RowFilter filter = null;
        Object value = this.getMatchValue();
        if (this.getMatchRule() instanceof RowFilters.ComparisonTypeExt) {
            if (value instanceof Comparable) {
                filter = RowFilters.compareToFilter((RowFilters.ComparisonTypeExt)((Object)this.getMatchRule()), (Comparable)value, this.getColumnIndex());
            }
        } else if (this.getMatchRule() instanceof RowFilters.RangeType && value instanceof Boundaries) {
            Boundaries range = (Boundaries)value;
            if (range.from instanceof Comparable && range.to instanceof Comparable) {
                filter = RowFilters.rangeFilter((RowFilters.RangeType)((Object)this.getMatchRule()), (Comparable)range.from, (Comparable)range.to, this.getColumnIndex());
            }
        }
        return filter;
    }

    @Override
    public List<?> getMatchRules() {
        Enum rule;
        ArrayList<Enum> rules = new ArrayList<Enum>();
        Enum[] enumArray = RowFilters.ComparisonTypeExt.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            rule = enumArray[n2];
            rules.add(rule);
            ++n2;
        }
        enumArray = RowFilters.RangeType.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            rule = enumArray[n2];
            rules.add(rule);
            ++n2;
        }
        return rules;
    }
}

