/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.swing.plaf.MultiLevelBarUI;
import de.javasoft.swing.plaf.addons.MultiLevelBarAddon;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLevelBar
extends JPanel {
    private static final long serialVersionUID = 7397679706123802445L;
    public static final String uiClassID = "MultiLevelBarUI";
    private ArrayList<BarLevel> levels;
    private String text;
    private Insets textInsets = new Insets(4, 4, 4, 4);
    private int verticalAlignment = 0;
    private int horizontalAlignment = 0;
    private boolean useTextDropShadow;
    protected static AbstractComponentAddon addon = new MultiLevelBarAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public MultiLevelBar(String string, String string2, Insets insets, int n, boolean bl) {
        this.text = string;
        this.useTextDropShadow = bl;
        this.levels = new ArrayList();
        this.addBar(this.getClass().getName(), string2, insets, n);
        this.setPreferredSize(new Dimension(146, 24));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, MultiLevelBarUI.class));
    }

    public void addBar(String string, String string2, Insets insets, int n) {
        this.levels.add(new BarLevel(string, string2, insets, n));
    }

    public void setValue(String string, int n) {
        this.getLevelByName(string).level = n;
    }

    public BarLevel getLevelByName(String string) {
        for (BarLevel barLevel : this.levels) {
            if (!barLevel.name.equals(string)) continue;
            return barLevel;
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Insets getTextInsets() {
        return this.textInsets;
    }

    public void setTextInsets(Insets insets) {
        this.textInsets = insets;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public boolean getUseTextDropShadow() {
        return this.useTextDropShadow;
    }

    public void setUseTextDropShadow(boolean bl) {
        this.useTextDropShadow = bl;
    }

    public List<BarLevel> getLevels() {
        return this.levels;
    }

    public static class BarLevel {
        private String name;
        private String imagePath;
        private Insets insets;
        private int level;

        BarLevel(String string, String string2, Insets insets, int n) {
            this.name = string;
            this.imagePath = string2;
            this.insets = insets;
            this.level = n;
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public void setImagePath(String string) {
            this.imagePath = string;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void setInsets(Insets insets) {
            this.insets = insets;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int n) {
            this.level = n;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

