/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.swing.IRotatableComponent;
import de.javasoft.swing.plaf.JYLabelUI;
import de.javasoft.swing.plaf.addons.JYLabelAddon;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JYLabel
extends JLabel
implements IRotatableComponent {
    private static final long serialVersionUID = -5848260115739353584L;
    public static final String uiClassID = "JYLabelUI";
    protected JTextField editor;
    private MouseListener editMouseListener;
    private int minimumEditorColumns = 8;
    private IRotatableComponent.Rotation rotation = IRotatableComponent.Rotation.NONE;
    private boolean editable;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYLabelAddon());
    }

    public JYLabel() {
        this((String)null);
    }

    public JYLabel(String string) {
        super(string);
        this.editMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && JYLabel.this.isEditable() && JYLabel.this.isEnabled()) {
                    JYLabel.this.startEdit();
                    JYLabel.this.firePropertyChange("editorStart", null, JYLabel.this.editor.getText());
                }
            }
        };
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, JYLabelUI.class));
    }

    public Color getForeground() {
        Color color = super.getForeground();
        if ((color == null || color instanceof UIResource) && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(this, Region.LABEL);
            SynthContext synthContext = new SynthContext(this, Region.LABEL, synthStyle, this.isEnabled() ? 0 : 8);
            color = this.isEnabled() ? color : synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND);
        }
        return color;
    }

    public void startEdit() {
        if (this.editor != null) {
            return;
        }
        this.editor = this.createEditor();
        JLayeredPane jLayeredPane = this.getRootPane().getLayeredPane();
        jLayeredPane.setLayer(this.editor, JLayeredPane.DEFAULT_LAYER + 1);
        jLayeredPane.add(this.editor);
        Insets insets = this.editor.getInsets();
        Rectangle rectangle = this.getBounds();
        if (this.getRotation() == IRotatableComponent.Rotation.LEFT || this.getRotation() == IRotatableComponent.Rotation.RIGHT) {
            int n = rectangle.width;
            rectangle.width = rectangle.height;
            rectangle.height = n;
        }
        rectangle = SwingUtilities.convertRectangle(this.getParent(), rectangle, jLayeredPane);
        rectangle.x -= insets.left;
        rectangle.y -= insets.top;
        rectangle.height += insets.top + insets.bottom;
        rectangle.width = Math.max(this.editor.getPreferredSize().width, rectangle.width + insets.left + insets.right + 10);
        this.editor.setBounds(rectangle);
        this.editor.setText(this.getText());
        this.editor.requestFocus();
    }

    protected JTextField createEditor() {
        JTextField jTextField = new JTextField(this.minimumEditorColumns);
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "cancelEdit");
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "commitEdit");
        jTextField.getActionMap().put("cancelEdit", new AbstractAction(){
            private static final long serialVersionUID = 6493436037599401405L;

            public void actionPerformed(ActionEvent actionEvent) {
                JYLabel.this.stopEdit();
                JYLabel.this.firePropertyChange("editorStop", JYLabel.this.getText(), null);
            }
        });
        jTextField.getActionMap().put("commitEdit", new AbstractAction(){
            private static final long serialVersionUID = -6358104323591921133L;

            public void actionPerformed(ActionEvent actionEvent) {
                InputVerifier inputVerifier = JYLabel.this.getInputVerifier();
                if (inputVerifier == null && !JYLabel.this.getDefaultInputVerifier().verify(JYLabel.this.editor) || inputVerifier != null && !inputVerifier.verify(JYLabel.this.editor)) {
                    return;
                }
                String string = JYLabel.this.getText();
                JYLabel.this.commitEdit();
                JYLabel.this.firePropertyChange("editorCommit", string, JYLabel.this.getText());
            }
        });
        jTextField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                JYLabel.this.stopEdit();
                JYLabel.this.firePropertyChange("editorStop", JYLabel.this.getText(), null);
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        return jTextField;
    }

    private InputVerifier getDefaultInputVerifier() {
        return new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                String string = ((JTextField)jComponent).getText();
                boolean bl = string == null || string.trim().length() == 0;
                return !bl;
            }
        };
    }

    public void stopEdit() {
        if (this.editor == null) {
            return;
        }
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            Window window = FocusManager.getCurrentManager().getActiveWindow();
            if (window instanceof JFrame) {
                jRootPane = ((JFrame)window).getRootPane();
            } else if (window instanceof JDialog) {
                jRootPane = ((JDialog)window).getRootPane();
            }
        }
        jRootPane.getLayeredPane().remove(this.editor);
        jRootPane.getLayeredPane().repaint();
        this.editor = null;
    }

    public void commitEdit() {
        if (this.editor == null) {
            return;
        }
        this.setText(this.editor.getText());
        this.stopEdit();
    }

    public IRotatableComponent.Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(IRotatableComponent.Rotation rotation) {
        IRotatableComponent.Rotation rotation2 = this.rotation;
        this.rotation = rotation;
        this.firePropertyChange("rotation", (Object)rotation2, (Object)rotation);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        if (bl) {
            this.addMouseListener(this.editMouseListener);
        } else {
            this.removeMouseListener(this.editMouseListener);
        }
    }
}

