/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.freehep.graphicsio.pdf.PDFDelayUtils;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFRef;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFAlphaDelayQueue {
    private final PDFWriter pdf;
    private final List patterns;

    public PDFAlphaDelayQueue(PDFWriter pDFWriter) {
        this.pdf = pDFWriter;
        this.patterns = new ArrayList(2);
    }

    public void writeTransparencyGroups(String[] stringArray) throws IOException {
        PDFDictionary pDFDictionary = this.pdf.openDictionary("DefaultTransparencyGroup");
        pDFDictionary.entry("S", this.pdf.name("Transparency"));
        pDFDictionary.entry("CS", this.pdf.name("DeviceRGB"));
        pDFDictionary.entry("I", true);
        pDFDictionary.entry("K", false);
        this.pdf.close(pDFDictionary);
        AlphaWriteContext alphaWriteContext = new AlphaWriteContext(this.pdf, stringArray);
        Iterator iterator = this.patterns.iterator();
        while (iterator.hasNext()) {
            PDFDelayUtils.Entry entry = (PDFDelayUtils.Entry)iterator.next();
            if ((entry.state & 1) != 0) continue;
            entry.state = (byte)(entry.state | 1);
            this.writeTransparencyGroup(entry, alphaWriteContext);
        }
    }

    private void writeTransparencyGroup(PDFDelayUtils.Entry entry, AlphaWriteContext alphaWriteContext) throws IOException {
        if (entry.paint.isCyclic()) {
            PDFDelayUtils.FunctionData functionData = PDFDelayUtils.FunctionData.newInstance(entry.paint, entry.bnds);
            if (functionData.count > 1 && functionData.ds_bnds != null) {
                this.writeCyclicGroup(entry, alphaWriteContext, functionData);
            } else {
                this.writeLinearGroup(entry, alphaWriteContext, !functionData.startInDirection);
            }
        } else {
            this.writeLinearGroup(entry, alphaWriteContext, false);
        }
    }

    private void writeCyclicGroup(PDFDelayUtils.Entry entry, AlphaWriteContext alphaWriteContext, PDFDelayUtils.FunctionData functionData) throws IOException {
        PDFRef pDFRef = alphaWriteContext.addFunction(entry, true);
        String string = entry.name + "Shading";
        String string2 = entry.name + "TransparencyGroup";
        PDFStream pDFStream = this.pdf.openStream(string2, alphaWriteContext.filters);
        pDFStream.entry("Type", this.pdf.name("XObject"));
        pDFStream.entry("Subtype", this.pdf.name("Form"));
        pDFStream.entry("BBox", functionData.ds_bnds);
        pDFStream.entry("Group", this.pdf.ref("DefaultTransparencyGroup"));
        PDFDictionary pDFDictionary = pDFStream.openDictionary("Resources");
        PDFDictionary pDFDictionary2 = pDFDictionary.openDictionary("Shading");
        PDFDelayUtils.writeCyclicShading(string, alphaWriteContext, functionData, pDFRef, pDFDictionary2);
        pDFDictionary.close(pDFDictionary2);
        pDFStream.close(pDFDictionary);
        pDFStream.println("/" + string + " sh");
        this.pdf.close(pDFStream);
    }

    private void writeLinearGroup(PDFDelayUtils.Entry entry, AlphaWriteContext alphaWriteContext, boolean bl) throws IOException {
        PDFDictionary pDFDictionary;
        Object object;
        String string = entry.name + "Shading";
        ShadingKey shadingKey = new ShadingKey(entry.paint, bl);
        PDFRef pDFRef = (PDFRef)alphaWriteContext.shadings.get(shadingKey);
        if (pDFRef == null) {
            object = this.pdf.openDictionary(string);
            ((PDFDictionary)object).entry("ShadingType", 2);
            ((PDFDictionary)object).entry("ColorSpace", this.pdf.name("DeviceGray"));
            ((PDFDictionary)object).entry("Coords", alphaWriteContext.getCoords(entry));
            pDFDictionary = ((PDFDictionary)object).openDictionary("Function");
            pDFDictionary.entry("FunctionType", 2);
            pDFDictionary.entry("Domain", PDFDelayUtils.DEFAULT_DOMAIN);
            if (bl) {
                pDFDictionary.entry("C0", alphaWriteContext.getC1(entry));
                pDFDictionary.entry("C1", alphaWriteContext.getC0(entry));
            } else {
                pDFDictionary.entry("C0", alphaWriteContext.getC0(entry));
                pDFDictionary.entry("C1", alphaWriteContext.getC1(entry));
            }
            pDFDictionary.entry("N", 1);
            ((PDFDictionary)object).close(pDFDictionary);
            ((PDFDictionary)object).entry("Extend", new boolean[]{true, true});
            this.pdf.close((PDFDictionary)object);
            pDFRef = this.pdf.ref(string);
            alphaWriteContext.shadings.put(shadingKey, pDFRef);
        }
        object = entry.name + "TransparencyGroup";
        pDFDictionary = this.pdf.openStream((String)object, alphaWriteContext.filters);
        pDFDictionary.entry("Type", this.pdf.name("XObject"));
        pDFDictionary.entry("Subtype", this.pdf.name("Form"));
        pDFDictionary.entry("BBox", alphaWriteContext.getBBox(entry));
        pDFDictionary.entry("Group", this.pdf.ref("DefaultTransparencyGroup"));
        PDFDictionary pDFDictionary2 = pDFDictionary.openDictionary("Resources");
        PDFDictionary pDFDictionary3 = pDFDictionary2.openDictionary("Shading");
        pDFDictionary3.entry(string, pDFRef);
        pDFDictionary2.close(pDFDictionary3);
        pDFDictionary.close(pDFDictionary2);
        ((PDFStream)pDFDictionary).println("/" + string + " sh");
        this.pdf.close((PDFStream)pDFDictionary);
    }

    public void writeSoftMasks(PDFDictionary pDFDictionary) throws IOException {
        Iterator iterator = this.patterns.iterator();
        while (iterator.hasNext()) {
            PDFDelayUtils.Entry entry = (PDFDelayUtils.Entry)iterator.next();
            if ((entry.state & 2) != 0) continue;
            entry.state = (byte)(entry.state | 2);
            this.writeSoftMask(entry, pDFDictionary);
        }
    }

    private void writeSoftMask(PDFDelayUtils.Entry entry, PDFDictionary pDFDictionary) throws IOException {
        String string = entry.name + "TransparencyGroup";
        PDFDictionary pDFDictionary2 = pDFDictionary.openDictionary(entry.name);
        PDFDictionary pDFDictionary3 = pDFDictionary2.openDictionary("SMask");
        pDFDictionary3.entry("Type", this.pdf.name("Mask"));
        pDFDictionary3.entry("S", this.pdf.name("Luminosity"));
        pDFDictionary3.entry("G", this.pdf.ref(string));
        pDFDictionary2.close(pDFDictionary3);
        pDFDictionary.close(pDFDictionary2);
    }

    public PDFName delayAlpha(GradientPaint gradientPaint, Rectangle rectangle) {
        PDFDelayUtils.Entry entry = new PDFDelayUtils.Entry("AlphaPattern" + (this.patterns.size() + 1), gradientPaint, rectangle, null);
        this.patterns.add(entry);
        return this.pdf.name(entry.name);
    }

    public boolean isEmpty() {
        return this.patterns.isEmpty();
    }

    private static final class AlphaWriteContext
    extends PDFDelayUtils.WriteContext {
        final Map shadings = new HashMap();
        final double[] shared1 = new double[1];
        final int[] sharedInt4 = new int[4];
        final String[] filters;

        AlphaWriteContext(PDFWriter pDFWriter, String[] stringArray) {
            super(pDFWriter);
            this.filters = stringArray;
        }

        double[] asArray(Color color) {
            this.shared1[0] = (float)color.getAlpha() / 255.0f;
            return this.shared1;
        }

        double[] getRange() {
            return PDFDelayUtils.DEFAULT_DOMAIN;
        }

        String getColorSpace() {
            return "DeviceGray";
        }

        double[] getC0(PDFDelayUtils.Entry entry) {
            return this.asArray(entry.paint.getColor1());
        }

        double[] getC1(PDFDelayUtils.Entry entry) {
            return this.asArray(entry.paint.getColor2());
        }

        int[] getBBox(PDFDelayUtils.Entry entry) {
            Rectangle rectangle = entry.bnds;
            this.sharedInt4[0] = rectangle.x;
            this.sharedInt4[1] = rectangle.y;
            this.sharedInt4[2] = rectangle.x + rectangle.width;
            this.sharedInt4[3] = rectangle.y + rectangle.height;
            return this.sharedInt4;
        }
    }

    private static final class ShadingKey {
        private final int alpha1;
        private final int alpha2;
        private final double p1x;
        private final double p1y;
        private final double p2x;
        private final double p2y;
        private final int hashCode;

        ShadingKey(GradientPaint gradientPaint, boolean bl) {
            Color color;
            Color color2;
            if (bl) {
                color2 = gradientPaint.getColor2();
                color = gradientPaint.getColor1();
            } else {
                color2 = gradientPaint.getColor1();
                color = gradientPaint.getColor2();
            }
            this.alpha1 = color2.getAlpha();
            this.alpha2 = color.getAlpha();
            Point2D point2D = gradientPaint.getPoint1();
            this.p1x = point2D.getX();
            this.p1y = point2D.getY();
            Point2D point2D2 = gradientPaint.getPoint2();
            this.p2x = point2D2.getX();
            this.p2y = point2D2.getY();
            this.hashCode = this.hashCodeImpl();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ShadingKey shadingKey = (ShadingKey)object;
            if (this.alpha1 != shadingKey.alpha1) {
                return false;
            }
            if (this.alpha2 != shadingKey.alpha2) {
                return false;
            }
            if (Double.compare(shadingKey.p1x, this.p1x) != 0) {
                return false;
            }
            if (Double.compare(shadingKey.p1y, this.p1y) != 0) {
                return false;
            }
            if (Double.compare(shadingKey.p2x, this.p2x) != 0) {
                return false;
            }
            return Double.compare(shadingKey.p2y, this.p2y) == 0;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int hashCodeImpl() {
            int n = this.alpha1;
            n = 31 * n + this.alpha2;
            long l = this.p1x != 0.0 ? Double.doubleToLongBits(this.p1x) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            l = this.p1y != 0.0 ? Double.doubleToLongBits(this.p1y) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            l = this.p2x != 0.0 ? Double.doubleToLongBits(this.p2x) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            l = this.p2y != 0.0 ? Double.doubleToLongBits(this.p2y) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }
    }
}

