/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.proxy;

import com.ibm.db2.cmx.client.ManageableProxy;
import com.ibm.db2.cmx.internal.metadata.DataBeanStatementExecution;
import com.ibm.db2.cmx.internal.monitor.MonitorAgentImpl;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.proxy.PDQProxy;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcConnectionInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcParameterMetaDataInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcResultSetInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxyCache;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.JDBCDynamicExecutionHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProxiedJdbcStatementInvocationHandler
implements ManageableProxy,
InvocationHandler,
PDQProxy {
    public boolean isMonitoringEnabled_;
    boolean managed_;
    protected ProxiedJdbcConnectionInvocationHandler connectionInvocationHandler_;
    protected DataBeanStatementExecution statementBean_;
    protected static Logger logger__ = Log.getCMXClientLogger();
    protected ExecutionHandler statementExecutionHandler_;
    protected int resultSetHoldability_;
    protected int resultSetType_;
    boolean hasResultSet_ = false;
    protected boolean isStatement_;
    protected Object statementProxy_;
    private boolean clearParametersJustDone_ = false;

    public ProxiedJdbcStatementInvocationHandler(ProxiedJdbcConnectionInvocationHandler proxiedJdbcConnectionInvocationHandler, ExecutionHandler executionHandler, boolean bl2, boolean bl3) {
        this.connectionInvocationHandler_ = proxiedJdbcConnectionInvocationHandler;
        this.statementExecutionHandler_ = executionHandler;
        try {
            this.resultSetHoldability_ = ((Statement)this.statementExecutionHandler_.getUnderlyingObject()).getResultSetHoldability();
            this.resultSetType_ = ((Statement)this.statementExecutionHandler_.getUnderlyingObject()).getResultSetType();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.statementBean_ = new DataBeanStatementExecution(this.connectionInvocationHandler_.monitorAgent_, this.connectionInvocationHandler_.getMaxBytesUsedforHash_());
        this.isMonitoringEnabled_ = bl2;
        this.isStatement_ = bl3;
    }

    protected abstract void resetDriverTimer_();

    protected abstract void getDriverData_();

    protected abstract void resetStatementData_();

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Object invoke(Object var1_1, Method var2_2, Object[] var3_3) throws Throwable {
        block49: {
            var4_4 /* !! */  = null;
            var5_5 = var2_2.getName();
            if (ProxiedJdbcStatementInvocationHandler.logger__.isLoggable(Level.FINER) && !"toString".equals(var5_5) && !"hashCode".equals(var5_5) && !"equals".equals(var5_5)) {
                DataLogger.logAtLevelFiner(ProxiedJdbcStatementInvocationHandler.logger__, this, "invoke: " + var5_5, "ENTRY " + Arrays.deepToString(var3_3));
                var6_6 = true;
            } else {
                var6_6 = false;
            }
            var7_7 = false;
            try {
                if (this.clearParametersJustDone_) {
                    this.statementExecutionHandler_ = this.statementExecutionHandler_.checkAndReplaceExecutionHandler();
                    this.clearParametersJustDone_ = false;
                }
                var8_8 = var5_5.charAt(0);
                var9_11 = false;
                if (var8_8 == 'c') {
                    if (var5_5.equals("close")) {
                        var9_11 = true;
                        if (this.statementBean_.statementTimerStarted()) {
                            this.completeAndReportStatement();
                        }
                        this.invokeOnDriver(var5_5, var2_2, var3_3);
                    } else if (var5_5.startsWith("clear")) {
                        var9_11 = true;
                        if (var5_5.equals("clearParameters")) {
                            this.clearParametersJustDone_ = true;
                        }
                        var4_4 /* !! */  = this.invokeOnDriver(var5_5, var2_2, var3_3);
                    }
                }
                if (var9_11) break block49;
                this.connectionInvocationHandler_.startTransactionIfNotStartedAndMonitoringIsEnabled();
                switch (var8_8) {
                    case 'e': {
                        if (var5_5.equals("executeQuery")) {
                            this.updateMonitorSettingsAndBeginStatementExecution();
                            this.connectionInvocationHandler_.applyDynamicPushDownProperties();
                            var7_7 = true;
                            this.hasResultSet_ = false;
                            var4_4 /* !! */  = this.invokeAndGetResultSet(var5_5, var2_2, var3_3);
                            this.hasResultSet_ = true;
                            if (this.isMonitoringEnabled_) {
                                this.connectionInvocationHandler_.commitAndRollbackListeners_.add(this);
                                ** break;
                            }
lbl43:
                            // 3 sources

                        } else if (var5_5.equals("execute")) {
                            this.updateMonitorSettingsAndBeginStatementExecution();
                            this.connectionInvocationHandler_.applyDynamicPushDownProperties();
                            var7_7 = true;
                            this.hasResultSet_ = false;
                            var4_4 /* !! */  = this.invokeOnDriver(var5_5, var2_2, var3_3);
                            this.hasResultSet_ = (Boolean)var4_4 /* !! */ ;
                            if (this.isMonitoringEnabled_ && this.hasResultSet_) {
                                this.connectionInvocationHandler_.commitAndRollbackListeners_.add(this);
                                ** break;
                            }
lbl55:
                            // 3 sources

                        } else if (var5_5.equals("executeUpdate")) {
                            this.updateMonitorSettingsAndBeginStatementExecution();
                            this.connectionInvocationHandler_.applyDynamicPushDownProperties();
                            var7_7 = true;
                            var4_4 /* !! */  = this.invokeOnDriver(var5_5, var2_2, var3_3);
                            this.hasResultSet_ = false;
                            ** break;
lbl63:
                            // 1 sources

                        } else if (!this.isStatement_ && var5_5.equals("executeBatch")) {
                            this.updateMonitorSettingsAndBeginStatementExecution();
                            this.connectionInvocationHandler_.applyDynamicPushDownProperties();
                            var7_7 = true;
                            var4_4 /* !! */  = this.invokeOnDriver(var5_5, var2_2, var3_3);
                            this.hasResultSet_ = false;
                            ** break;
lbl71:
                            // 1 sources

                        } else if (var5_5.equals("equals")) {
                            var4_4 /* !! */  = this.equals(var3_3[0]);
                            ** break;
lbl75:
                            // 1 sources

                        } else {
                            var4_4 /* !! */  = this.invokeOnDriver(var5_5, var2_2, var3_3);
                            ** break;
                        }
lbl78:
                        // 1 sources

                        break;
                    }
                    case 'g': {
                        if (this.connectionInvocationHandler_.proxiedDataSource_.driverNameOverride_ != null) {
                            this.connectionInvocationHandler_.resetTransaction_();
                        }
                        if (var5_5.startsWith("getConnection")) {
                            var4_4 /* !! */  = this.connectionInvocationHandler_.getConnectionProxy();
                            ** break;
lbl85:
                            // 1 sources

                        } else if (var5_5.equals("getResultSet")) {
                            var4_4 /* !! */  = this.invokeAndGetResultSet(var5_5, var2_2, var3_3);
                            ** break;
lbl89:
                            // 1 sources

                        } else if (var5_5.equals("getReturnResultSet")) {
                            var4_4 /* !! */  = this.invokeAndGetResultSet(var5_5, var2_2, var3_3);
                            ** break;
lbl93:
                            // 1 sources

                        } else if (var5_5.equals("getParameterMetaData")) {
                            var4_4 /* !! */  = this.invokeAndGetParemeterMetaData(var5_5, var2_2, var3_3);
                            ** break;
lbl97:
                            // 1 sources

                        } else {
                            var4_4 /* !! */  = this.invokeOnDriver(var5_5, var2_2, var3_3);
                            ** break;
                        }
lbl100:
                        // 1 sources

                        break;
                    }
                    case 'p': {
                        if (var5_5.startsWith("pushData")) {
                            this.pushData((Integer)var3_3[0], (Object[])var3_3[1], true);
                            ** break;
lbl105:
                            // 1 sources

                        } else if (var5_5.startsWith("pullData")) {
                            var4_4 /* !! */  = this.pullData((Integer)var3_3[0]);
                            ** break;
lbl109:
                            // 1 sources

                        } else {
                            var4_4 /* !! */  = this.invokeOnDriver(var5_5, var2_2, var3_3);
                            ** break;
                        }
lbl112:
                        // 1 sources

                        break;
                    }
                    default: {
                        var4_4 /* !! */  = this.invokeOnDriver(var5_5, var2_2, var3_3);
                        break;
                    }
                }
            }
            catch (InvocationTargetException var8_9) {
                var9_12 = var8_9.getTargetException();
                if (var9_12 instanceof SQLException) {
                    this.statementBean_.setFirstErrorCode(((SQLException)var9_12).getErrorCode());
                    this.connectionInvocationHandler_.proxiedDataSource_.checkAndReportApplnException((SQLException)var9_12);
                }
                DataLogger.logThrowable(ProxiedJdbcStatementInvocationHandler.logger__, var9_12);
                throw var9_12;
            }
            catch (IllegalAccessException var8_10) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", new Object[]{var2_2.getName(), var8_10.getMessage()}), var8_10, 10602);
            }
            finally {
                if (var7_7 && !this.hasResultSet_) {
                    this.completeAndReportStatement();
                    if (this.connectionInvocationHandler_.autoCommit_) {
                        this.connectionInvocationHandler_.markEndTransaction();
                    }
                }
            }
        }
        if (var6_6) {
            DataLogger.exit(ProxiedJdbcStatementInvocationHandler.logger__, this, "invoke: " + var5_5, var4_4 /* !! */ );
        }
        return var4_4 /* !! */ ;
    }

    protected Object invokeOnDriver(String string, Method method, Object[] objectArray) throws Throwable {
        Object object = this.statementExecutionHandler_.invoke(string, method, objectArray);
        return object;
    }

    private void updateMonitorSettingsAndBeginStatementExecution() {
        if (this.connectionInvocationHandler_.autoCommit_) {
            this.connectionInvocationHandler_.updateMonitorSettings();
        }
        this.isMonitoringEnabled_ = this.connectionInvocationHandler_.isMonitoringEnabled_;
        this.statementBean_.monitorAgent_ = (MonitorAgentImpl)this.connectionInvocationHandler_.monitorAgent_;
        if (this.isMonitoringEnabled_) {
            if (this.statementBean_.statementTimerStarted()) {
                this.completeAndReportStatement();
            }
            this.connectionInvocationHandler_.startTransactionIfNotStartedAndMonitoringIsEnabled();
            this.statementBean_.startTimer();
            this.resetDriverTimer_();
            this.resetStatementData_();
        }
    }

    protected void completeAndReportStatement() {
        if (!this.managed_ && this.isMonitoringEnabled_ && this.statementBean_.statementTimerStarted()) {
            this.connectionInvocationHandler_.commitAndRollbackListeners_.remove(this);
            this.statementBean_.stopTimer(this.hasResultSet_);
            this.getDriverData_();
            this.getPureQueryData();
            this.connectionInvocationHandler_.reportStatementExecution(this.statementBean_);
            this.statementBean_ = new DataBeanStatementExecution(this.statementBean_);
        }
        if (this.connectionInvocationHandler_.proxiedDataSource_.driverNameOverride_ != null && !this.connectionInvocationHandler_.autoCommit_ && !this.connectionInvocationHandler_.isInsideTransaction()) {
            this.connectionInvocationHandler_.doTransactionBoundaryLogic(false);
            this.connectionInvocationHandler_.markEndTransaction();
        }
    }

    private Object invokeAndGetResultSet(String string, Method method, Object[] objectArray) throws Throwable {
        Object object = this.statementExecutionHandler_.invoke(string, method, objectArray);
        ExecutionHandler executionHandler = null;
        if (object != null) {
            if (object instanceof ExecutionHandler) {
                executionHandler = (ExecutionHandler)object;
                object = executionHandler.getUnderlyingObject();
            } else {
                if (!this.isMonitoringEnabled_) {
                    return object;
                }
                executionHandler = this.createResultSetExecutionHandler_(object);
            }
            ProxiedJdbcResultSetInvocationHandler proxiedJdbcResultSetInvocationHandler = this.createResultSetHandler_(executionHandler, this, this.isMonitoringEnabled_);
            Object object2 = ProxyCache.createInstance(object, proxiedJdbcResultSetInvocationHandler);
            proxiedJdbcResultSetInvocationHandler.setResultSetProxy(object2);
            return object2;
        }
        return null;
    }

    private Object invokeAndGetParemeterMetaData(String string, Method method, Object[] objectArray) throws Throwable {
        Object object = this.statementExecutionHandler_.invoke(string, method, objectArray);
        if (object != null) {
            if (!(object instanceof ExecutionHandler)) {
                return object;
            }
            ExecutionHandler executionHandler = (ExecutionHandler)object;
            object = executionHandler.getUnderlyingObject();
            ProxiedJdbcParameterMetaDataInvocationHandler proxiedJdbcParameterMetaDataInvocationHandler = this.createParameterMetaDataHandler_(executionHandler, this);
            Object object2 = ProxyCache.createInstance(object, proxiedJdbcParameterMetaDataInvocationHandler);
            proxiedJdbcParameterMetaDataInvocationHandler.setParameterMetaDataProxy(object2);
            return object2;
        }
        return null;
    }

    protected abstract ProxiedJdbcResultSetInvocationHandler createResultSetHandler_(ExecutionHandler var1, ProxiedJdbcStatementInvocationHandler var2, boolean var3);

    protected abstract ProxiedJdbcParameterMetaDataInvocationHandler createParameterMetaDataHandler_(ExecutionHandler var1, ProxiedJdbcStatementInvocationHandler var2);

    protected ExecutionHandler createResultSetExecutionHandler_(Object object) {
        return new JDBCDynamicExecutionHandler(object);
    }

    @Override
    public void pushData(int n2, Object[] objectArray, boolean bl2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "pushData", "ENTRY " + Arrays.deepToString(new Object[]{n2, objectArray, bl2}));
        }
        if (this.isMonitoringEnabled_) {
            this.statementBean_.wasData_ = objectArray;
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "pushData", null);
        }
    }

    public ExecutionHandler getExecutionHandler() {
        return this.statementExecutionHandler_;
    }

    public void getPureQueryData() {
        Object[] objectArray;
        if (!this.statementBean_.hasDataLayerCorrelator_ && null != (objectArray = this.statementExecutionHandler_.pullData(310))) {
            this.statementBean_.setMetadataCorrelatorString((String)objectArray[0]);
        }
    }

    public Object getStatementProxy() {
        return this.statementProxy_;
    }

    public void setStatementProxy(Object object) {
        this.statementProxy_ = object;
    }

    public boolean equals(Object object) {
        return this == object || this.statementProxy_ == object;
    }
}

