/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Translator;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class DebugLog {
    private BufferedWriter w;
    private static String OS = System.getProperty("os.name").toLowerCase();

    public DebugLog(String string, String string2) throws IOException {
        try {
            Calendar calendar = Calendar.getInstance();
            String string3 = "jdbc_" + calendar.get(1);
            string3 = calendar.get(2) + 1 < 10 ? string3 + "0" + (calendar.get(2) + 1) : string3 + (calendar.get(2) + 1);
            string3 = calendar.get(5) < 10 ? string3 + "0" + calendar.get(5) + "_" : string3 + calendar.get(5) + "_";
            string3 = calendar.get(11) < 10 ? string3 + "0" + calendar.get(11) : string3 + calendar.get(11);
            string3 = calendar.get(12) < 10 ? string3 + "0" + calendar.get(12) : string3 + calendar.get(12);
            string3 = calendar.get(13) < 10 ? string3 + "0" + calendar.get(13) : string3 + calendar.get(13);
            String string4 = string3 = string3 + ".log";
            File file = new File(string, string4);
            int n = 1;
            int n2 = 0;
            while (!file.createNewFile()) {
                string4 = string3 + "." + n++;
                file = new File(string, string4);
                if (++n2 < 100) continue;
            }
            if (n2 >= 100) {
                throw new IOException(Translator.Cannot_create_logfile_at_this_location());
            }
            this.w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), true), string2));
            this.w.write("Log opened: " + calendar.getTime());
            this.w.newLine();
            if (null != OS) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(OS + " - ");
                stringBuffer.append(System.getProperty("os.version", "unknown version"));
                stringBuffer.append(" - ");
                stringBuffer.append(System.getProperty("os.arch", "unknown arch"));
                this.w.write("Running on " + stringBuffer.toString());
                this.w.newLine();
            }
            this.w.write("-------------------------------------------------------");
            this.w.newLine();
            this.w.flush();
        }
        catch (IOException iOException) {
            throw new IOException(Translator.Opening_log_failed() + iOException.getMessage());
        }
    }

    public void log(String string, int n) {
        this.log(string);
    }

    private String getCurrentTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date();
        String string = simpleDateFormat.format(date);
        return string;
    }

    public void log(String string) {
        try {
            this.w.write(this.getCurrentTimeStamp() + " - " + Thread.currentThread().getId() + " - " + string + "\n");
            this.w.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void log(Properties properties) {
        try {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = properties.get(object);
                this.w.write(object.toString() + ": " + object2.toString());
                this.w.newLine();
                this.w.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void log(Throwable throwable) {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            throwable.printStackTrace(new PrintWriter(charArrayWriter));
            this.log(this.w.toString(), 0);
        }
        catch (Throwable throwable2) {
            this.log(Translator.Error_writing_log() + throwable2.toString(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            this.w.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {}
        }
    }
}

