/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.image.BufferedImage;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.pobjects.graphics.ImageReference;

public abstract class CachedImageReference
extends ImageReference {
    private ImagePool imagePool;
    private boolean isNull;

    protected CachedImageReference(ImageStream imageStream, GraphicsState graphicsState, Resources resources, int imageIndex, Page page) {
        super(imageStream, graphicsState, resources, imageIndex, page);
        this.imagePool = imageStream.getLibrary().getImagePool();
        this.reference = imageStream.getPObjectReference();
    }

    public BufferedImage getImage() {
        if (this.isNull) {
            return null;
        }
        if (this.image != null && this.reference != null) {
            this.imagePool.put(this.reference, this.image);
            return this.image;
        }
        BufferedImage cached = this.imagePool.get(this.reference);
        if (cached != null) {
            return cached;
        }
        BufferedImage im = this.createImage();
        if (im != null && this.reference != null) {
            this.imagePool.put(this.reference, im);
        } else if (this.reference != null) {
            this.isNull = true;
        }
        return im;
    }
}

