/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.AlphaDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.FillDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.GraphicsStateCmd;
import org.icepdf.core.pobjects.graphics.commands.PostScriptEncoder;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.util.Library;

public class CircleAnnotation
extends MarkupAnnotation {
    private static final Logger logger = Logger.getLogger(CircleAnnotation.class.toString());
    public static final Name IC_KEY = new Name("IC");
    private Color fillColor;
    private boolean isFillColor;
    private Rectangle rectangle;

    public CircleAnnotation(Library l, HashMap h) {
        super(l, h);
    }

    public void init() throws InterruptedException {
        super.init();
        this.fillColor = Color.WHITE;
        List C = (List)this.getObject(IC_KEY);
        if (C != null && C.size() >= 3) {
            float red = ((Number)C.get(0)).floatValue();
            float green = ((Number)C.get(1)).floatValue();
            float blue = ((Number)C.get(2)).floatValue();
            red = Math.max(0.0f, Math.min(1.0f, red));
            green = Math.max(0.0f, Math.min(1.0f, green));
            blue = Math.max(0.0f, Math.min(1.0f, blue));
            this.fillColor = new Color(red, green, blue);
            this.isFillColor = true;
        }
        this.resetNullAppearanceStream();
    }

    public static CircleAnnotation getInstance(Library library, Rectangle rect) {
        StateManager stateManager = library.getStateManager();
        HashMap<Name, Object> entries = new HashMap<Name, Object>();
        entries.put(Dictionary.TYPE_KEY, Annotation.TYPE_VALUE);
        entries.put(Dictionary.SUBTYPE_KEY, Annotation.SUBTYPE_CIRCLE);
        if (rect != null) {
            entries.put(Annotation.RECTANGLE_KEY, PRectangle.getPRectangleVector(rect));
        } else {
            entries.put(Annotation.RECTANGLE_KEY, new Rectangle(10, 10, 50, 100));
        }
        CircleAnnotation circleAnnotation = null;
        try {
            circleAnnotation = new CircleAnnotation(library, entries);
            circleAnnotation.init();
            circleAnnotation.setPObjectReference(stateManager.getNewReferencNumber());
            circleAnnotation.setNew(true);
            circleAnnotation.setFlag(64, false);
            circleAnnotation.setFlag(16, false);
            circleAnnotation.setFlag(8, false);
            circleAnnotation.setFlag(4, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.fine("CircletAnnotation initialization interrupted.");
        }
        return circleAnnotation;
    }

    public void resetAppearanceStream(double dx, double dy, AffineTransform pageTransform) {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        appearanceState.setMatrix(new AffineTransform());
        appearanceState.setShapes(new Shapes());
        AffineTransform matrix = appearanceState.getMatrix();
        Shapes shapes = appearanceState.getShapes();
        Rectangle2D bbox = appearanceState.getBbox();
        bbox.setRect(0.0, 0.0, bbox.getWidth(), bbox.getHeight());
        this.setModifiedDate(PDate.formatDateTime(new Date()));
        this.rectangle = this.getUserSpaceRectangle().getBounds();
        if (this.borderStyle.getStrokeWidth() == 0.0f) {
            this.borderStyle.setStrokeWidth(1.0f);
        }
        BasicStroke stroke = this.getBorderStyleStroke();
        int strokeWidth = (int)stroke.getLineWidth();
        Rectangle rectangleToDraw = new Rectangle(strokeWidth, strokeWidth, (int)bbox.getWidth() - strokeWidth * 2, (int)bbox.getHeight() - strokeWidth * 2);
        Ellipse2D.Double circle = new Ellipse2D.Double(strokeWidth, strokeWidth, rectangleToDraw.getWidth(), rectangleToDraw.getHeight());
        shapes.add(new GraphicsStateCmd(EXT_GSTATE_NAME));
        shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, this.opacity)));
        shapes.add(new StrokeDrawCmd(stroke));
        shapes.add(new ShapeDrawCmd(circle));
        if (this.isFillColor) {
            shapes.add(new ColorDrawCmd(this.fillColor));
            shapes.add(new FillDrawCmd());
        }
        if (this.borderStyle.getStrokeWidth() > 0.0f) {
            shapes.add(new ColorDrawCmd(this.color));
            shapes.add(new DrawDrawCmd());
        }
        shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, 1.0f)));
        Form form = this.updateAppearanceStream(shapes, bbox, matrix, PostScriptEncoder.generatePostScript(shapes.getShapes()));
        CircleAnnotation.generateExternalGraphicsState(form, this.opacity);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        float[] compArray = new float[3];
        this.fillColor.getColorComponents(compArray);
        ArrayList<Float> colorValues = new ArrayList<Float>(compArray.length);
        for (float comp : compArray) {
            colorValues.add(Float.valueOf(comp));
        }
        this.entries.put(IC_KEY, colorValues);
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public boolean isFillColor() {
        return this.isFillColor;
    }

    public void setFillColor(boolean fillColor) {
        this.isFillColor = fillColor;
        if (!this.isFillColor) {
            this.entries.remove(IC_KEY);
        }
    }
}

