/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform.signature;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.jce.provider.X509CertParser;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.signature.AbstractPkcsValidator;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.util.Utils;

public class Pkcs1Validator
extends AbstractPkcsValidator {
    public Pkcs1Validator(SignatureFieldDictionary signatureFieldDictionary) throws SignatureIntegrityException {
        super(signatureFieldDictionary);
    }

    public void init() throws SignatureIntegrityException {
        SignatureDictionary signatureDictionary = this.signatureFieldDictionary.getSignatureDictionary();
        this.announceSignatureType(signatureDictionary);
        StringObject stringObject = signatureDictionary.getContents();
        byte[] cmsData = Utils.convertByteCharSequenceToByteArray(stringObject.getLiteralString());
        stringObject = signatureDictionary.getCertString();
        byte[] certsKey = Utils.convertByteCharSequenceToByteArray(stringObject.getLiteralString());
        try {
            X509CertParser x509CertParser = new X509CertParser();
            x509CertParser.engineInit((InputStream)new ByteArrayInputStream(certsKey));
            this.certificateChain = x509CertParser.engineReadAll();
            this.signerCertificate = (X509Certificate)this.certificateChain.iterator().next();
            ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(cmsData));
            ASN1Primitive tmp = asn1InputStream.readObject();
            this.messageDigest = ((ASN1OctetString)tmp).getOctets();
            String provider = signatureDictionary.getFilter().getName();
            this.digestAlgorithmIdentifier = OIWObjectIdentifiers.idSHA1.getId();
            this.signatureAlgorithmIdentifier = PKCSObjectIdentifiers.rsaEncryption.getId();
            this.createSignature(this.signerCertificate.getPublicKey(), provider, this.signatureAlgorithmIdentifier, this.digestAlgorithmIdentifier);
            Cipher asymmetricCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            asymmetricCipher.init(2, this.signerCertificate.getPublicKey());
            this.messageDigest = asymmetricCipher.doFinal(this.messageDigest);
            if (this.messageDigest.length > 20) {
                byte[] trunkedMD = new byte[20];
                System.arraycopy(this.messageDigest, 15, trunkedMD, 0, 20);
                this.messageDigest = trunkedMD;
            }
        }
        catch (Exception e) {
            throw new SignatureIntegrityException(e);
        }
        this.initialized = true;
    }

    public void validate() throws SignatureIntegrityException {
        this.validateDocument();
    }
}

