/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.HexStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.SignatureReferenceDictionary;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureDictionary
extends Dictionary {
    public static final Name FILTER_KEY = new Name("Filter");
    public static final Name SUB_FILTER_KEY = new Name("SubFilter");
    public static final Name CONTENTS_KEY = new Name("Contents");
    public static final Name CERT_KEY = new Name("Cert");
    public static final Name BYTE_RANGE_KEY = new Name("ByteRange");
    public static final Name REFERENCE_KEY = new Name("Reference");
    public static final Name CHANGES_KEY = new Name("Changes");
    public static final Name NAME_KEY = new Name("Name");
    public static final Name M_KEY = new Name("M");
    public static final Name LOCATION_KEY = new Name("Location");
    public static final Name REASON_KEY = new Name("Reason");
    public static final Name R_KEY = new Name("R");
    public static final Name V_KEY = new Name("V");
    public static final Name PROP_BUILD_KEY = new Name("Prop_Build");
    public static final Name PROP_AUTH_TYPE_KEY = new Name("Prop_AuthType");
    public static final Name PROP_AUTH_TIME_KEY = new Name("Prop_AuthTime");
    public static final Name CONTACT_INFO_KEY = new Name("ContactInfo");

    public SignatureDictionary(Library library, HashMap entries) {
        super(library, entries);
    }

    public Name getFilter() {
        return this.library.getName(this.entries, FILTER_KEY);
    }

    public void setFilter(Name filterName) {
        this.entries.put(FILTER_KEY, filterName);
    }

    public Name getSubFilter() {
        return this.library.getName(this.entries, SUB_FILTER_KEY);
    }

    public void setSubFilter(Name filterName) {
        this.entries.put(SUB_FILTER_KEY, filterName);
    }

    public HexStringObject getContents() {
        Object tmp = this.library.getObject(this.entries, CONTENTS_KEY);
        if (tmp instanceof HexStringObject) {
            return (HexStringObject)tmp;
        }
        return null;
    }

    public void setContents(HexStringObject hexString) {
        this.entries.put(CONTENTS_KEY, hexString);
    }

    public boolean isCertArray() {
        return this.library.getObject(this.entries, CERT_KEY) instanceof List;
    }

    public boolean isCertString() {
        return this.library.getObject(this.entries, CERT_KEY) instanceof StringObject;
    }

    public ArrayList<StringObject> getCertArray() {
        Object tmp = this.library.getObject(this.entries, CERT_KEY);
        if (tmp instanceof List) {
            return (ArrayList)tmp;
        }
        return null;
    }

    public StringObject getCertString() {
        Object tmp = this.library.getObject(this.entries, CERT_KEY);
        if (tmp instanceof StringObject) {
            return (StringObject)tmp;
        }
        return null;
    }

    public void setCert(Object cert) {
        this.entries.put(CERT_KEY, cert);
    }

    public ArrayList<Integer> getByteRange() {
        Object tmp = this.library.getObject(this.entries, BYTE_RANGE_KEY);
        if (tmp instanceof List) {
            return (ArrayList)tmp;
        }
        return null;
    }

    public void setByteRangeKey(ArrayList<Integer> range) {
        this.entries.put(BYTE_RANGE_KEY, range);
    }

    public ArrayList<SignatureReferenceDictionary> getReferences() {
        List tmp = this.library.getArray(this.entries, REFERENCE_KEY);
        if (tmp != null && tmp.size() > 0) {
            ArrayList<SignatureReferenceDictionary> references = new ArrayList<SignatureReferenceDictionary>(tmp.size());
            for (HashMap reference : tmp) {
                references.add(new SignatureReferenceDictionary(this.library, reference));
            }
            return references;
        }
        return null;
    }

    public ArrayList<Integer> getChanges() {
        List tmp = this.library.getArray(this.entries, CHANGES_KEY);
        if (tmp instanceof ArrayList) {
            return (ArrayList)tmp;
        }
        return null;
    }

    public String getName() {
        Object tmp = this.library.getObject(this.entries, NAME_KEY);
        if (tmp instanceof StringObject) {
            return Utils.convertStringObject(this.library, (StringObject)tmp);
        }
        return null;
    }

    public String getDate() {
        return this.library.getString(this.entries, M_KEY);
    }

    public String getLocation() {
        Object tmp = this.library.getObject(this.entries, LOCATION_KEY);
        if (tmp instanceof StringObject) {
            return Utils.convertStringObject(this.library, (StringObject)tmp);
        }
        return null;
    }

    public String getReason() {
        Object tmp = this.library.getObject(this.entries, REASON_KEY);
        if (tmp instanceof StringObject) {
            return Utils.convertStringObject(this.library, (StringObject)tmp);
        }
        return null;
    }

    public String getContactInfo() {
        Object tmp = this.library.getObject(this.entries, CONTACT_INFO_KEY);
        if (tmp instanceof StringObject) {
            return Utils.convertStringObject(this.library, (StringObject)tmp);
        }
        return null;
    }

    public int getHandlerVersion() {
        return this.library.getInt(this.entries, R_KEY);
    }

    public int getDictionaryVersion() {
        return this.library.getInt(this.entries, V_KEY);
    }

    public HashMap getBuildDictionary() {
        return this.library.getDictionary(this.entries, PROP_BUILD_KEY);
    }

    public int getAuthTime() {
        return this.library.getInt(this.entries, PROP_AUTH_TIME_KEY);
    }

    public Name getAuthType() {
        return this.library.getName(this.entries, PROP_AUTH_TYPE_KEY);
    }
}

