/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.aggregatefn;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.util.CompressionUtil;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.AbstractAggregator;
import com.amazon.sqlengine.executor.etree.value.aggregatefn.AbstractAggregatorFactory;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.conv.ConversionResult;
import com.amazon.support.conv.IntegralConverter;
import com.amazon.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;

public class AvgAggregatorFactory
extends AbstractAggregatorFactory {
    public AvgAggregatorFactory(IColumn[] iColumnArray, IColumn iColumn) {
        super(iColumnArray, iColumn);
    }

    @Override
    public AbstractAggregator createAggregator() {
        short s = this.getInputMetadata(0).getTypeMetadata().getType();
        switch (s) {
            case 2: 
            case 3: {
                return new AvgExactNumAggregator(this);
            }
        }
        assert (TypeUtilities.isNumberType(s) || -7 == s);
        return new AvgDoubleAggregator(this);
    }

    private static class AvgExactNumAggregator
    extends AbstractAggregator {
        private BigDecimal m_sum = BigDecimal.ZERO;
        private long m_count;

        protected AvgExactNumAggregator(AvgAggregatorFactory avgAggregatorFactory) {
            super(avgAggregatorFactory);
        }

        @Override
        public void load(byte[] byArray) throws ErrorException {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                this.m_sum = (BigDecimal)objectInputStream.readObject();
                this.m_count = objectInputStream.readLong();
            }
            catch (Exception exception) {
                throw SQLEngineExceptionFactory.failedToReadData(exception);
            }
        }

        @Override
        public byte[] serialize() throws ErrorException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(this.m_sum);
                objectOutputStream.writeLong(this.m_count);
            }
            catch (Exception exception) {
                throw SQLEngineExceptionFactory.failedToWriteData(exception);
            }
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public void reset() {
            this.m_sum = BigDecimal.ZERO;
            this.m_count = 0L;
        }

        @Override
        public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
            ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
            if (0L == this.m_count) {
                iSqlDataWrapper.setNull();
            } else if (0L < this.m_count) {
                iSqlDataWrapper.setExactNumber(this.m_sum.divide(BigDecimal.valueOf(this.m_count), RoundingMode.DOWN));
            } else {
                BigInteger bigInteger = CompressionUtil.getlongAsBigInteger(this.m_count, false);
                iSqlDataWrapper.setExactNumber(this.m_sum.divide(new BigDecimal(bigInteger), RoundingMode.DOWN));
            }
            return false;
        }

        @Override
        public void close() {
            this.m_sum = null;
        }

        @Override
        protected void update() throws ErrorException {
            ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
            if (!iSqlDataWrapper.isNull()) {
                ++this.m_count;
                switch (iSqlDataWrapper.getType()) {
                    case 2: 
                    case 3: {
                        this.m_sum = this.m_sum.add(iSqlDataWrapper.getExactNumber());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(this.getInputMetadata(0).getTypeMetadata().getTypeName());
                    }
                }
            }
        }

        @Override
        protected long getMemoryUsage() {
            return AbstractAggregatorFactory.BIGDECIMAL_SIZE + 8L;
        }
    }

    private static class AvgDoubleAggregator
    extends AbstractAggregator {
        private double m_sum = 0.0;
        private long m_count = 0L;

        protected AvgDoubleAggregator(AvgAggregatorFactory avgAggregatorFactory) {
            super(avgAggregatorFactory);
        }

        @Override
        public void load(byte[] byArray) throws ErrorException {
            try {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                this.m_sum = byteBuffer.getDouble();
                this.m_count = byteBuffer.getLong();
            }
            catch (Exception exception) {
                throw SQLEngineExceptionFactory.failedToReadData(exception);
            }
        }

        @Override
        public byte[] serialize() {
            return ByteBuffer.allocate(16).putDouble(this.m_sum).putLong(this.m_count).array();
        }

        @Override
        public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
            ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
            if (0L == this.m_count) {
                iSqlDataWrapper.setNull();
            } else {
                iSqlDataWrapper.setDouble(this.m_sum / (double)this.m_count);
            }
            return false;
        }

        @Override
        public void reset() {
            this.m_sum = 0.0;
            this.m_count = 0L;
        }

        @Override
        public void close() {
        }

        @Override
        protected void update() throws ErrorException {
            ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
            if (!iSqlDataWrapper.isNull()) {
                ++this.m_count;
                switch (iSqlDataWrapper.getType()) {
                    case -7: 
                    case 16: {
                        if (!iSqlDataWrapper.getBoolean()) break;
                        this.m_sum += 1.0;
                        break;
                    }
                    case -6: {
                        this.m_sum += (double)iSqlDataWrapper.getTinyInt();
                        break;
                    }
                    case 5: {
                        this.m_sum += (double)iSqlDataWrapper.getSmallInt();
                        break;
                    }
                    case 4: {
                        this.m_sum += (double)iSqlDataWrapper.getInteger();
                        break;
                    }
                    case -5: {
                        ConversionResult conversionResult = new ConversionResult();
                        double d = IntegralConverter.toDouble(iSqlDataWrapper.getBigInt(), conversionResult);
                        this.m_sum += d;
                        if (ConversionResult.TypeConversionState.INTEGRAL_PRECISION_LOSS != conversionResult.getState()) break;
                        this.m_listener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 7, SQLEngineMessageKey.INTEGRAL_PRECISION_LOSS.name(), this.m_count > Integer.MAX_VALUE ? -1L : (long)((int)this.m_count), -1));
                        break;
                    }
                    case 7: {
                        this.m_sum += (double)iSqlDataWrapper.getReal();
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.m_sum += iSqlDataWrapper.getDouble();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(this.getInputMetadata(0).getTypeMetadata().getTypeName());
                    }
                }
            }
        }

        @Override
        protected long getMemoryUsage() {
            return 16L;
        }
    }
}

