/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        this.fireTreeNodesChanged(this, treePath.getPath(), null, null);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    public void nodeChanged(TreeNode treeNode) {
        if (this.listenerList != null && treeNode != null) {
            TreeNode treeNode2 = treeNode.getParent();
            if (treeNode2 != null) {
                int n2 = this.getIndexOfChild(treeNode2, treeNode);
                if (n2 != -1) {
                    int[] nArray = new int[]{n2};
                    this.nodesChanged(treeNode2, nArray);
                }
            } else if (treeNode == this.getRoot()) {
                this.nodesChanged(treeNode, null);
            }
        }
    }

    public void nodesChanged(TreeNode treeNode, int[] nArray) {
        if (treeNode != null) {
            if (nArray != null) {
                int n2 = nArray.length;
                if (n2 > 0) {
                    Object[] objectArray = new Object[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        objectArray[i2] = this.getChild(treeNode, nArray[i2]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), nArray, objectArray);
                }
            } else if (treeNode == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), null, null);
            }
        }
    }

    public TreeNode[] getPathToRoot(TreeNode treeNode) {
        return this.getPathToRoot(treeNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n2) {
        TreeNode[] treeNodeArray;
        if (treeNode == null) {
            if (n2 == 0) {
                return null;
            }
            treeNodeArray = new TreeNode[n2];
        } else {
            treeNodeArray = treeNode == this.getRoot() ? new TreeNode[n2] : this.getPathToRoot(treeNode.getParent(), ++n2);
            treeNodeArray[treeNodeArray.length - n2] = treeNode;
        }
        return treeNodeArray;
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray3.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray3[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i2 + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray3.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray3[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i2 + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray3.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray3[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i2 + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray3.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray3[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i2 + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, treePath);
            }
            ((TreeModelListener)objectArray[i2 + 1]).treeStructureChanged(treeModelEvent);
        }
    }
}

