/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import com.jidesoft.thirdparty.prefuse.util.collections.AbstractLiteralIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.DefaultLiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.IntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public abstract class AbstractTreeMap
implements IntSortedMap {
    protected static final boolean RED = false;
    protected static final boolean BLACK = true;
    protected static final Entry NIL;
    protected LiteralComparator cmp = null;
    protected Entry root = NIL;
    protected boolean allowDuplicates;
    protected int size = 0;
    protected int unique = 0;
    protected int modCount = 0;
    protected int lastOrder = 0;

    public AbstractTreeMap(LiteralComparator literalComparator, boolean bl) {
        this.cmp = literalComparator == null ? DefaultLiteralComparator.getInstance() : literalComparator;
        this.allowDuplicates = bl;
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.root == NIL;
    }

    @Override
    public Comparator comparator() {
        return this.cmp;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public int getMinimum() {
        return this.minimum(this.root).getValue();
    }

    @Override
    public int getMaximum() {
        return this.maximum(this.root).getValue();
    }

    @Override
    public int getMedian() {
        Entry entry = this.minimum(this.root);
        for (int i2 = 0; i2 < this.size / 2; ++i2) {
            entry = this.successor(entry);
        }
        return entry.getValue();
    }

    @Override
    public int getUniqueCount() {
        return this.unique;
    }

    @Override
    public boolean containsValue(int n2) {
        return this.root == NIL ? false : this.\u0101(this.root, n2);
    }

    private boolean \u0101(Entry entry, int n2) {
        if (entry.\u0106 == n2) {
            return true;
        }
        return entry.\u0105 != NIL && this.\u0101(entry.\u0105, n2) || entry.\u0103 != NIL && this.\u0101(entry.\u0103, n2);
    }

    @Override
    public IntIterator valueIterator(boolean bl) {
        return new ValueIterator(new EntryIterator(!bl));
    }

    protected void incrementSize(boolean bl) {
        ++this.size;
        ++this.modCount;
        if (bl) {
            ++this.unique;
        }
    }

    protected void decrementSize(boolean bl) {
        --this.size;
        ++this.modCount;
        if (bl) {
            --this.unique;
        }
    }

    protected abstract int compare(Entry var1, Entry var2);

    protected Entry find(Entry entry) {
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            int n2 = this.compare(entry, entry2);
            if (n2 == 0) {
                return entry2;
            }
            if (n2 < 0) {
                entry2 = entry2.\u0105;
                continue;
            }
            entry2 = entry2.\u0103;
        }
        return entry2;
    }

    protected Entry findPredecessor(Entry entry) {
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            int n2 = this.compare(entry, entry2);
            if (n2 > 0) {
                if (entry2.\u0103 == NIL) {
                    return entry2;
                }
                entry2 = entry2.\u0103;
                continue;
            }
            if (entry2.\u0105 != NIL) {
                entry2 = entry2.\u0105;
                continue;
            }
            Entry entry3 = entry2.\u0104;
            Entry entry4 = entry2;
            while (entry3 != NIL && entry4 == entry3.\u0105) {
                entry4 = entry3;
                entry3 = entry3.\u0104;
            }
            return entry3;
        }
        return entry2;
    }

    protected Entry findCeiling(Entry entry) {
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            int n2 = this.compare(entry, entry2);
            if (n2 == 0) {
                return entry2;
            }
            if (n2 < 0) {
                if (entry2.\u0105 != NIL) {
                    entry2 = entry2.\u0105;
                    continue;
                }
                return entry2;
            }
            if (entry2.\u0103 != NIL) {
                entry2 = entry2.\u0103;
                continue;
            }
            Entry entry3 = entry2.\u0104;
            Entry entry4 = entry2;
            while (entry3 != NIL && entry4 == entry3.\u0103) {
                entry4 = entry3;
                entry3 = entry3.\u0104;
            }
            return entry3;
        }
        return entry2;
    }

    protected Entry minimum(Entry entry) {
        while (entry.\u0105 != NIL) {
            entry = entry.\u0105;
        }
        return entry;
    }

    protected Entry maximum(Entry entry) {
        while (entry.\u0103 != NIL) {
            entry = entry.\u0103;
        }
        return entry;
    }

    protected Entry successor(Entry entry) {
        if (entry.\u0103 != NIL) {
            return this.minimum(entry.\u0103);
        }
        Entry entry2 = entry.\u0104;
        while (entry2 != NIL && entry == entry2.\u0103) {
            entry = entry2;
            entry2 = entry2.\u0104;
        }
        return entry2;
    }

    protected Entry predecessor(Entry entry) {
        if (entry.\u0105 != NIL) {
            return this.maximum(entry.\u0105);
        }
        Entry entry2 = entry.\u0104;
        while (entry2 != NIL && entry == entry2.\u0105) {
            entry = entry2;
            entry2 = entry2.\u0104;
        }
        return entry2;
    }

    protected void rotateLeft(Entry entry) {
        Entry entry2 = entry.\u0103;
        entry.\u0103 = entry2.\u0105;
        if (entry2.\u0105 != NIL) {
            entry2.\u0105.\u0104 = entry;
        }
        entry2.\u0104 = entry.\u0104;
        if (entry.\u0104 == NIL) {
            this.root = entry2;
        } else if (entry.\u0104.\u0105 == entry) {
            entry.\u0104.\u0105 = entry2;
        } else {
            entry.\u0104.\u0103 = entry2;
        }
        entry2.\u0105 = entry;
        entry.\u0104 = entry2;
    }

    protected void rotateRight(Entry entry) {
        Entry entry2 = entry.\u0105;
        entry.\u0105 = entry2.\u0103;
        if (entry2.\u0103 != NIL) {
            entry2.\u0103.\u0104 = entry;
        }
        entry2.\u0104 = entry.\u0104;
        if (entry.\u0104 == NIL) {
            this.root = entry2;
        } else if (entry.\u0104.\u0103 == entry) {
            entry.\u0104.\u0103 = entry2;
        } else {
            entry.\u0104.\u0105 = entry2;
        }
        entry2.\u0103 = entry;
        entry.\u0104 = entry2;
    }

    protected void fixUpInsert(Entry entry) {
        entry.\u0102 = false;
        while (entry != NIL && entry != this.root && !entry.\u0104.\u0102) {
            Entry entry2;
            if (entry.\u0104 == entry.\u0104.\u0104.\u0105) {
                entry2 = entry.\u0104.\u0104.\u0103;
                if (!entry2.\u0102) {
                    entry.\u0104.\u0102 = true;
                    entry2.\u0102 = true;
                    entry.\u0104.\u0104.\u0102 = false;
                    entry = entry.\u0104.\u0104;
                    continue;
                }
                if (entry == entry.\u0104.\u0103) {
                    entry = entry.\u0104;
                    this.rotateLeft(entry);
                }
                entry.\u0104.\u0102 = true;
                entry.\u0104.\u0104.\u0102 = false;
                if (entry.\u0104.\u0104 == NIL) continue;
                this.rotateRight(entry.\u0104.\u0104);
                continue;
            }
            entry2 = entry.\u0104.\u0104.\u0105;
            if (!entry2.\u0102) {
                entry.\u0104.\u0102 = true;
                entry2.\u0102 = true;
                entry.\u0104.\u0104.\u0102 = false;
                entry = entry.\u0104.\u0104;
                continue;
            }
            if (entry == entry.\u0104.\u0105) {
                entry = entry.\u0104;
                this.rotateRight(entry);
            }
            entry.\u0104.\u0102 = true;
            entry.\u0104.\u0104.\u0102 = false;
            if (entry.\u0104.\u0104 == NIL) continue;
            this.rotateLeft(entry.\u0104.\u0104);
        }
        this.root.\u0102 = true;
    }

    protected void fixUpRemove(Entry entry) {
        while (entry != this.root && entry.\u0102) {
            Entry entry2;
            if (entry == entry.\u0104.\u0105) {
                entry2 = entry.\u0104.\u0103;
                if (!entry2.\u0102) {
                    entry2.\u0102 = true;
                    entry.\u0104.\u0102 = false;
                    this.rotateLeft(entry.\u0104);
                    entry2 = entry.\u0104.\u0103;
                }
                if (entry2.\u0105.\u0102 && entry2.\u0103.\u0102) {
                    entry2.\u0102 = false;
                    entry = entry.\u0104;
                    continue;
                }
                if (entry2.\u0103.\u0102) {
                    entry2.\u0105.\u0102 = true;
                    entry2.\u0102 = false;
                    this.rotateRight(entry2);
                    entry2 = entry.\u0104.\u0103;
                }
                entry2.\u0102 = entry.\u0104.\u0102;
                entry.\u0104.\u0102 = true;
                entry2.\u0103.\u0102 = true;
                this.rotateLeft(entry.\u0104);
                entry = this.root;
                continue;
            }
            entry2 = entry.\u0104.\u0105;
            if (!entry2.\u0102) {
                entry2.\u0102 = true;
                entry.\u0104.\u0102 = false;
                this.rotateRight(entry.\u0104);
                entry2 = entry.\u0104.\u0105;
            }
            if (entry2.\u0103.\u0102 && entry2.\u0105.\u0102) {
                entry2.\u0102 = false;
                entry = entry.\u0104;
                continue;
            }
            if (entry2.\u0105.\u0102) {
                entry2.\u0103.\u0102 = true;
                entry2.\u0102 = false;
                this.rotateLeft(entry2);
                entry2 = entry.\u0104.\u0105;
            }
            entry2.\u0102 = entry.\u0104.\u0102;
            entry.\u0104.\u0102 = true;
            entry2.\u0105.\u0102 = true;
            this.rotateRight(entry.\u0104);
            entry = this.root;
        }
        entry.\u0102 = true;
    }

    protected void remove(Entry entry) {
        boolean bl = !entry.keyEquals(entry.\u0105) && !entry.keyEquals(entry.\u0103) && !entry.keyEquals(entry.\u0104);
        Entry entry2 = entry.\u0105 != NIL && entry.\u0103 != NIL ? this.successor(entry) : entry;
        Entry entry3 = entry2.\u0105 != NIL ? entry2.\u0105 : entry2.\u0103;
        entry3.\u0104 = entry2.\u0104;
        if (entry2.\u0104 == NIL) {
            this.root = entry3;
        } else if (entry2 == entry2.\u0104.\u0105) {
            entry2.\u0104.\u0105 = entry3;
        } else {
            entry2.\u0104.\u0103 = entry3;
        }
        if (entry2 != entry) {
            entry.copyFields(entry2);
        }
        if (entry2.\u0102) {
            this.fixUpRemove(entry3);
        }
        this.decrementSize(bl);
    }

    static {
        AbstractTreeMap.NIL.\u0103 = AbstractTreeMap.NIL.\u0104 = (NIL = new Entry(Integer.MIN_VALUE));
        AbstractTreeMap.NIL.\u0105 = AbstractTreeMap.NIL.\u0104;
    }

    protected class ValueIterator
    extends IntIterator {
        EntryIterator \u0109;

        public ValueIterator(EntryIterator entryIterator) {
            this.\u0109 = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this.\u0109.hasNext();
        }

        @Override
        public int nextInt() {
            return this.\u0109.\u0104().\u0106;
        }

        @Override
        public void remove() {
            this.\u0109.remove();
        }
    }

    protected class KeyIterator
    extends EntryIterator {
        public KeyIterator() {
            super(false);
        }

        public KeyIterator(Entry entry, Entry entry2) {
            super(entry, entry2);
        }

        @Override
        public Object next() {
            return this.\u0104().getKey();
        }
    }

    protected class EntryIterator
    extends AbstractLiteralIterator {
        private int \u0122;
        private Entry \u0123;
        private boolean \u0120;
        Entry \u0121;
        Entry \u011f;

        EntryIterator(boolean bl) {
            this.\u0122 = AbstractTreeMap.this.modCount;
            this.\u0123 = NIL;
            this.\u0120 = false;
            this.\u0121 = bl ? AbstractTreeMap.this.maximum(AbstractTreeMap.this.root) : AbstractTreeMap.this.minimum(AbstractTreeMap.this.root);
            this.\u011f = NIL;
        }

        EntryIterator(Entry entry, Entry entry2) {
            this.\u0122 = AbstractTreeMap.this.modCount;
            this.\u0123 = NIL;
            this.\u0120 = false;
            this.\u0121 = entry;
            this.\u011f = entry2;
            this.\u0120 = entry == NIL ? true : (entry2 == NIL ? false : AbstractTreeMap.this.compare(entry, entry2) > 0);
        }

        @Override
        public boolean hasNext() {
            return this.\u0121 != this.\u011f;
        }

        final Entry \u0104() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (AbstractTreeMap.this.modCount != this.\u0122) {
                throw new ConcurrentModificationException();
            }
            this.\u0123 = this.\u0121;
            Entry entry = this.\u0121 = this.\u0120 ? AbstractTreeMap.this.predecessor(this.\u0121) : AbstractTreeMap.this.successor(this.\u0121);
            if (this.\u0123 == NIL) {
                System.err.println("Encountered NIL in iteration!");
            }
            return this.\u0123;
        }

        public Object next() {
            return this.\u0104();
        }

        @Override
        public void remove() {
            if (this.\u0123 == NIL) {
                throw new IllegalStateException();
            }
            if (AbstractTreeMap.this.modCount != this.\u0122) {
                throw new ConcurrentModificationException();
            }
            if (this.\u0123.\u0105 != NIL && this.\u0123.\u0103 != NIL) {
                this.\u0121 = this.\u0123;
            }
            AbstractTreeMap.this.remove(this.\u0123);
            ++this.\u0122;
            this.\u0123 = NIL;
        }
    }

    public static class Entry {
        int \u0106;
        int \u0101;
        Entry \u0105 = null;
        Entry \u0103 = null;
        Entry \u0104;
        boolean \u0102 = true;

        public Entry(int n2) {
            this.\u0106 = n2;
        }

        public Entry(int n2, Entry entry, int n3) {
            this.\u0106 = n2;
            this.\u0104 = entry;
            this.\u0101 = n3;
            this.\u0105 = NIL;
            this.\u0103 = NIL;
        }

        public int getIntKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public long getLongKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public float getFloatKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public double getDoubleKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public Object getKey() {
            return null;
        }

        public int getValue() {
            return this.\u0106;
        }

        public int getOrder() {
            return this.\u0101;
        }

        public int setValue(int n2) {
            int n3 = this.\u0106;
            this.\u0106 = n2;
            return n3;
        }

        public boolean keyEquals(Entry entry) {
            Object object = this.getKey();
            return object == null ? object == entry.getKey() : object.equals(entry.getKey());
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.\u0106 == entry.\u0106 && this.getKey() == entry.getKey();
        }

        public int hashCode() {
            int n2 = this.getKey().hashCode();
            int n3 = this.\u0106;
            return n2 ^ n3;
        }

        public String toString() {
            return this.getKey() + "=" + this.\u0106;
        }

        public void copyFields(Entry entry) {
            this.\u0106 = entry.\u0106;
            this.\u0101 = entry.\u0101;
        }
    }
}

