/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.DataSource;
import com.nuodb.jdbc.RemXAConnection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class NuoXADataSource
extends DataSource
implements XADataSource {
    private String url;
    private String username;
    private String password;
    private String schema;

    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (this.url == null) {
            throw new SQLException("Must call setUrl before creating a connection.");
        }
        Properties properties = new Properties();
        if (this.username != null) {
            properties.put("user", this.username);
        }
        if (this.password != null) {
            properties.put("password", this.password);
        }
        if (this.schema != null) {
            properties.put("schema", this.schema);
        }
        return new RemXAConnection(this.url, properties);
    }

    @Override
    public XAConnection getXAConnection(String user, String pwd) throws SQLException {
        if (this.url == null) {
            throw new SQLException("Must call setUrl before creating a connection.");
        }
        Properties properties = new Properties();
        if (user != null) {
            properties.put("user", user);
        }
        if (pwd != null) {
            properties.put("password", pwd);
        }
        if (this.schema != null) {
            properties.put("schema", this.schema);
        }
        return new RemXAConnection(this.url, properties);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

