/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.impl.net.CryptoInputStream;
import com.nuodb.impl.util.DataStream;
import com.nuodb.jdbc.Blob;
import com.nuodb.jdbc.Clob;
import com.nuodb.jdbc.NuoDBTime;
import com.nuodb.jdbc.RemCallableStatement;
import com.nuodb.jdbc.Struct;
import com.nuodb.jdbc.TimeValues;
import com.nuodb.jdbc.Value;
import com.nuodb.jdbc.ValueBoolean;
import com.nuodb.jdbc.ValueBytes;
import com.nuodb.jdbc.ValueDate;
import com.nuodb.jdbc.ValueDouble;
import com.nuodb.jdbc.ValueInt;
import com.nuodb.jdbc.ValueLong;
import com.nuodb.jdbc.ValueNull;
import com.nuodb.jdbc.ValueNumber;
import com.nuodb.jdbc.ValueStream;
import com.nuodb.jdbc.ValueString;
import com.nuodb.jdbc.ValueTime;
import com.nuodb.jdbc.ValueTimestamp;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public class EncodedDataStream
extends DataStream
implements TimeValues {
    protected int type;
    protected String string;
    protected long integer64;
    protected int integer32;
    protected int blobId;
    protected int scale;
    protected double dbl;
    protected UUID uuid;
    protected byte[] bytes;
    protected boolean bool;
    protected BigDecimal bigDecimal;
    protected int streamHandle;
    protected int streamType;
    protected long chunkSize;
    protected long streamSize;
    protected int messageType;
    protected byte[] buffer;
    protected int offset;
    protected int priorCode;
    protected int protocolVersion;
    static final int edsTypeUnknown = 0;
    static final int edsTypeNull = 1;
    static final int edsTypeBlob = 2;
    static final int edsTypeOpaque = 3;
    static final int edsTypeClob = 4;
    static final int edsTypeUtf8 = 5;
    static final int edsTypeInt32 = 6;
    static final int edsTypeInt64 = 7;
    static final int edsTypeScaled = 8;
    static final int edsTypeDouble = 9;
    static final int edsTypeBigInt = 10;
    static final int edsTypeTime = 11;
    static final int edsTypeMilliseconds = 12;
    static final int edsTypeNanoseconds = 13;
    static final int edsTypeUUID = 14;
    static final int edsTypeBoolean = 15;
    static final int edsTypeScaledTime = 16;
    static final int edsTypeScaledDate = 17;
    static final int edsTypeScaledTimestamp = 18;
    static final int edsTypeStream = 19;
    static final int edsTypeArray = 20;
    static final int edsNull = 1;
    static final int edsTrue = 2;
    static final int edsFalse = 3;
    static final int edsIntMinus10 = 10;
    static final int edsIntMinus9 = 11;
    static final int edsIntMinus8 = 12;
    static final int edsIntMinus7 = 13;
    static final int edsIntMinus6 = 14;
    static final int edsIntMinus5 = 15;
    static final int edsIntMinus4 = 16;
    static final int edsIntMinus3 = 17;
    static final int edsIntMinus2 = 18;
    static final int edsIntMinus1 = 19;
    static final int edsInt0 = 20;
    static final int edsInt1 = 21;
    static final int edsInt2 = 22;
    static final int edsInt3 = 23;
    static final int edsInt4 = 24;
    static final int edsInt5 = 25;
    static final int edsInt6 = 26;
    static final int edsInt7 = 27;
    static final int edsInt8 = 28;
    static final int edsInt9 = 29;
    static final int edsInt10 = 30;
    static final int edsInt11 = 31;
    static final int edsInt12 = 32;
    static final int edsInt13 = 33;
    static final int edsInt14 = 34;
    static final int edsInt15 = 35;
    static final int edsInt16 = 36;
    static final int edsInt17 = 37;
    static final int edsInt18 = 38;
    static final int edsInt19 = 39;
    static final int edsInt20 = 40;
    static final int edsInt21 = 41;
    static final int edsInt22 = 42;
    static final int edsInt23 = 43;
    static final int edsInt24 = 44;
    static final int edsInt25 = 45;
    static final int edsInt26 = 46;
    static final int edsInt27 = 47;
    static final int edsInt28 = 48;
    static final int edsInt29 = 49;
    static final int edsInt30 = 50;
    static final int edsInt31 = 51;
    static final int edsIntLen1 = 52;
    static final int edsIntLen2 = 53;
    static final int edsIntLen3 = 54;
    static final int edsIntLen4 = 55;
    static final int edsIntLen5 = 56;
    static final int edsIntLen6 = 57;
    static final int edsIntLen7 = 58;
    static final int edsIntLen8 = 59;
    static final int edsScaledLen0 = 60;
    static final int edsScaledLen1 = 61;
    static final int edsScaledLen2 = 62;
    static final int edsScaledLen3 = 63;
    static final int edsScaledLen4 = 64;
    static final int edsScaledLen5 = 65;
    static final int edsScaledLen6 = 66;
    static final int edsScaledLen7 = 67;
    static final int edsScaledLen8 = 68;
    static final int edsUtf8Count1 = 69;
    static final int edsUtf8Count2 = 70;
    static final int edsUtf8Count3 = 71;
    static final int edsUtf8Count4 = 72;
    static final int edsOpaqueCount1 = 73;
    static final int edsOpaqueCount2 = 74;
    static final int edsOpaqueCount3 = 75;
    static final int edsOpaqueCount4 = 76;
    static final int edsDoubleLen0 = 77;
    static final int edsDoubleLen1 = 78;
    static final int edsDoubleLen2 = 79;
    static final int edsDoubleLen3 = 80;
    static final int edsDoubleLen4 = 81;
    static final int edsDoubleLen5 = 82;
    static final int edsDoubleLen6 = 83;
    static final int edsDoubleLen7 = 84;
    static final int edsDoubleLen8 = 85;
    static final int edsMilliSecLen0 = 86;
    static final int edsMilliSecLen1 = 87;
    static final int edsMilliSecLen2 = 88;
    static final int edsMilliSecLen3 = 89;
    static final int edsMilliSecLen4 = 90;
    static final int edsMilliSecLen5 = 91;
    static final int edsMilliSecLen6 = 92;
    static final int edsMilliSecLen7 = 93;
    static final int edsMilliSecLen8 = 94;
    static final int edsNanoSecLen0 = 95;
    static final int edsNanoSecLen1 = 96;
    static final int edsNanoSecLen2 = 97;
    static final int edsNanoSecLen3 = 98;
    static final int edsNanoSecLen4 = 99;
    static final int edsNanoSecLen5 = 100;
    static final int edsNanoSecLen6 = 101;
    static final int edsNanoSecLen7 = 102;
    static final int edsNanoSecLen8 = 103;
    static final int edsTimeLen0 = 104;
    static final int edsTimeLen1 = 105;
    static final int edsTimeLen2 = 106;
    static final int edsTimeLen3 = 107;
    static final int edsTimeLen4 = 108;
    static final int edsUtf8Len0 = 109;
    static final int edsUtf8Len1 = 110;
    static final int edsUtf8Len2 = 111;
    static final int edsUtf8Len3 = 112;
    static final int edsUtf8Len4 = 113;
    static final int edsUtf8Len5 = 114;
    static final int edsUtf8Len6 = 115;
    static final int edsUtf8Len7 = 116;
    static final int edsUtf8Len8 = 117;
    static final int edsUtf8Len9 = 118;
    static final int edsUtf8Len10 = 119;
    static final int edsUtf8Len11 = 120;
    static final int edsUtf8Len12 = 121;
    static final int edsUtf8Len13 = 122;
    static final int edsUtf8Len14 = 123;
    static final int edsUtf8Len15 = 124;
    static final int edsUtf8Len16 = 125;
    static final int edsUtf8Len17 = 126;
    static final int edsUtf8Len18 = 127;
    static final int edsUtf8Len19 = 128;
    static final int edsUtf8Len20 = 129;
    static final int edsUtf8Len21 = 130;
    static final int edsUtf8Len22 = 131;
    static final int edsUtf8Len23 = 132;
    static final int edsUtf8Len24 = 133;
    static final int edsUtf8Len25 = 134;
    static final int edsUtf8Len26 = 135;
    static final int edsUtf8Len27 = 136;
    static final int edsUtf8Len28 = 137;
    static final int edsUtf8Len29 = 138;
    static final int edsUtf8Len30 = 139;
    static final int edsUtf8Len31 = 140;
    static final int edsUtf8Len32 = 141;
    static final int edsUtf8Len33 = 142;
    static final int edsUtf8Len34 = 143;
    static final int edsUtf8Len35 = 144;
    static final int edsUtf8Len36 = 145;
    static final int edsUtf8Len37 = 146;
    static final int edsUtf8Len38 = 147;
    static final int edsUtf8Len39 = 148;
    static final int edsUft8LenMax = 148;
    static final int edsOpaqueLen0 = 149;
    static final int edsOpaqueLen1 = 150;
    static final int edsOpaqueLen2 = 151;
    static final int edsOpaqueLen3 = 152;
    static final int edsOpaqueLen4 = 153;
    static final int edsOpaqueLen5 = 154;
    static final int edsOpaqueLen6 = 155;
    static final int edsOpaqueLen7 = 156;
    static final int edsOpaqueLen8 = 157;
    static final int edsOpaqueLen9 = 158;
    static final int edsOpaqueLen10 = 159;
    static final int edsOpaqueLen11 = 160;
    static final int edsOpaqueLen12 = 161;
    static final int edsOpaqueLen13 = 162;
    static final int edsOpaqueLen14 = 163;
    static final int edsOpaqueLen15 = 164;
    static final int edsOpaqueLen16 = 165;
    static final int edsOpaqueLen17 = 166;
    static final int edsOpaqueLen18 = 167;
    static final int edsOpaqueLen19 = 168;
    static final int edsOpaqueLen20 = 169;
    static final int edsOpaqueLen21 = 170;
    static final int edsOpaqueLen22 = 171;
    static final int edsOpaqueLen23 = 172;
    static final int edsOpaqueLen24 = 173;
    static final int edsOpaqueLen25 = 174;
    static final int edsOpaqueLen26 = 175;
    static final int edsOpaqueLen27 = 176;
    static final int edsOpaqueLen28 = 177;
    static final int edsOpaqueLen29 = 178;
    static final int edsOpaqueLen30 = 179;
    static final int edsOpaqueLen31 = 180;
    static final int edsOpaqueLen32 = 181;
    static final int edsOpaqueLen33 = 182;
    static final int edsOpaqueLen34 = 183;
    static final int edsOpaqueLen35 = 184;
    static final int edsOpaqueLen36 = 185;
    static final int edsOpaqueLen37 = 186;
    static final int edsOpaqueLen38 = 187;
    static final int edsOpaqueLen39 = 188;
    static final int edsOpaqueLenMax = 188;
    static final int edsBlobLen0 = 189;
    static final int edsBlobLen1 = 190;
    static final int edsBlobLen2 = 191;
    static final int edsBlobLen3 = 192;
    static final int edsBlobLen4 = 193;
    static final int edsClobLen0 = 194;
    static final int edsClobLen1 = 195;
    static final int edsClobLen2 = 196;
    static final int edsClobLen3 = 197;
    static final int edsClobLen4 = 198;
    static final int edsScaledCount1 = 199;
    static final int edsUUID = 200;
    static final int edsScaledDateLen1 = 201;
    static final int edsScaledDateLen2 = 202;
    static final int edsScaledDateLen3 = 203;
    static final int edsScaledDateLen4 = 204;
    static final int edsScaledDateLen5 = 205;
    static final int edsScaledDateLen6 = 206;
    static final int edsScaledDateLen7 = 207;
    static final int edsScaledDateLen8 = 208;
    static final int edsScaledTimeLen1 = 209;
    static final int edsScaledTimeLen2 = 210;
    static final int edsScaledTimeLen3 = 211;
    static final int edsScaledTimeLen4 = 212;
    static final int edsScaledTimeLen5 = 213;
    static final int edsScaledTimeLen6 = 214;
    static final int edsScaledTimeLen7 = 215;
    static final int edsScaledTimeLen8 = 216;
    static final int edsScaledTimestampLen1 = 217;
    static final int edsScaledTimestampLen2 = 218;
    static final int edsScaledTimestampLen3 = 219;
    static final int edsScaledTimestampLen4 = 220;
    static final int edsScaledTimestampLen5 = 221;
    static final int edsScaledTimestampLen6 = 222;
    static final int edsScaledTimestampLen7 = 223;
    static final int edsScaledTimestampLen8 = 224;
    static final int edsScaledCount2 = 225;
    static final int edsLobStream0 = 226;
    static final int edsLobStream1 = 227;
    static final int edsLobStream2 = 228;
    static final int edsLobStream3 = 229;
    static final int edsLobStream4 = 230;
    static final int edsArrayLen1 = 231;
    static final int edsArrayLen2 = 232;
    static final int edsArrayLen3 = 233;
    static final int edsArrayLen4 = 234;
    static final int edsArrayLen5 = 235;
    static final int edsArrayLen6 = 236;
    static final int edsArrayLen7 = 237;
    static final int edsArrayLen8 = 238;
    static final int edsScaledCount3 = 239;
    static final int edsCurrentMax = 240;
    static final int edsExtended = 254;
    static final int edsSingleByteMax = 255;
    static final int edsIntMin = -10;
    static final int edsIntMax = 31;
    private static final ThreadLocal<Calendar> LOCAL_CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }

        @Override
        public Calendar get() {
            Calendar local = (Calendar)super.get();
            local.setTimeZone(TimeZone.getDefault());
            return local;
        }
    };
    private static final ThreadLocal<Calendar> UTC_CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"));
        }
    };

    public EncodedDataStream() {
        this.protocolVersion = 21;
    }

    public EncodedDataStream(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void startMessage(int messageType) {
        this.messageType = messageType;
        this.reset();
        this.encodeInt(messageType);
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    int byteCount(int n) {
        if (n > 0) {
            if (n == 0) {
                return 0;
            }
            if (n < 128) {
                return 1;
            }
            if (n < 32768) {
                return 2;
            }
            if (n < 0x800000) {
                return 3;
            }
            return 4;
        }
        if (n >= -128) {
            return 1;
        }
        if (n >= Short.MIN_VALUE) {
            return 2;
        }
        if (n >= -8388608) {
            return 3;
        }
        return 4;
    }

    int byteCount(long n) {
        if (n > 0L) {
            if (n == 0L) {
                return 0;
            }
            if (n < 128L) {
                return 1;
            }
            if (n < 32768L) {
                return 2;
            }
            if (n < 0x800000L) {
                return 3;
            }
            if (n < 0x80000000L) {
                return 4;
            }
            if (n < 0x8000000000L) {
                return 5;
            }
            if (n < 0x800000000000L) {
                return 6;
            }
            if (n < 0x80000000000000L) {
                return 7;
            }
            return 8;
        }
        if (n >= -128L) {
            return 1;
        }
        if (n >= -32768L) {
            return 2;
        }
        if (n >= -8388608L) {
            return 3;
        }
        if (n >= Integer.MIN_VALUE) {
            return 4;
        }
        if (n >= -549755813888L) {
            return 5;
        }
        if (n >= -140737488355328L) {
            return 6;
        }
        if (n >= -36028797018963968L) {
            return 7;
        }
        return 8;
    }

    public void encodeOutParameter(int index, RemCallableStatement.OutParameter param) {
        this.encodeInt(index);
        this.encodeInt(param.type);
        this.encodeInt(param.scale);
    }

    public void encodeInt(int value) {
        int count = this.byteCount(value);
        if (value >= -10 && value <= 31) {
            this.write(20 + value);
            return;
        }
        this.write(52 + count - 1);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write(value >> shift);
        }
    }

    public void encodeBoolean(boolean value) {
        this.write(value ? 2 : 3);
    }

    public void encodeLong(long value) {
        int count = this.byteCount(value);
        if (value >= -10L && value <= 31L) {
            this.write(20 + (int)value);
            return;
        }
        this.write(52 + count - 1);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write((int)(value >> shift));
        }
    }

    public void encodeLong(long value, int scale) {
        if (scale == 0) {
            this.encodeLong(value);
            return;
        }
        int count = this.byteCount(value);
        this.write(60 + count);
        this.write(scale);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write((int)(value >> shift));
        }
    }

    void encodeInt(int count, int value) {
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write(value >> shift);
        }
    }

    public void encodeString(String string) throws SQLException {
        if (string == null) {
            this.write(1);
            return;
        }
        int length = this.captureString(string);
        if (length <= 39) {
            this.write(109 + length);
        } else {
            int count = this.byteCount(length);
            this.write(69 + count - 1);
            this.encodeInt(count, length);
        }
        this.writeCapturedString();
    }

    public void encodeBytes(byte[] value) throws SQLException {
        if (value == null) {
            this.write(1);
            return;
        }
        int length = value.length;
        if (length <= 39) {
            this.write(149 + length);
        } else {
            int count = this.byteCount(length);
            this.write(73 + count - 1);
            this.encodeInt(count, length);
        }
        this.write(value);
    }

    public void encodeObject(Object obj) throws SQLException {
        if (obj instanceof BigDecimal) {
            this.encodeBigDecimal((BigDecimal)obj);
        } else if (obj instanceof Byte) {
            this.encodeByte((Byte)obj);
        } else if (obj instanceof Integer) {
            this.encodeInt((Integer)obj);
        } else if (obj instanceof Long) {
            this.encodeLong((Long)obj);
        } else if (obj instanceof Boolean) {
            this.encodeBoolean((Boolean)obj);
        } else if (obj instanceof Float) {
            this.encodeDouble(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            this.encodeDouble((Double)obj);
        } else if (obj instanceof String) {
            this.encodeString((String)obj);
        } else if (obj instanceof Timestamp) {
            this.encodeTimestamp((Timestamp)obj);
        } else if (obj instanceof Time) {
            this.encodeTime((Time)obj);
        } else if (obj instanceof Date) {
            this.encodeDate((Date)obj);
        } else if (obj instanceof byte[]) {
            this.encodeBytes((byte[])obj);
        } else if (obj instanceof Blob) {
            this.encodeBytes(((Blob)obj).getBytes());
        } else if (obj instanceof Clob) {
            this.encodeString(((Clob)obj).getString());
        } else if (obj instanceof java.sql.Struct) {
            Object[] attributes = ((Struct)obj).getAttributes();
            int count = this.byteCount(attributes.length);
            this.write(231 + count - 1);
            for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
                this.write(attributes.length >> shift);
            }
            for (Object attr : attributes) {
                this.encodeObject(attr);
            }
        } else {
            throw new SQLException("Unsupported Java object " + obj.getClass().getName());
        }
    }

    public void encodeArray(Array value) throws SQLException {
        if (value == null) {
            this.write(1);
            return;
        }
        Object arrayValue = value.getArray();
        if (arrayValue instanceof Object[]) {
            Object[] rows = (Object[])value.getArray();
            int count = this.byteCount(rows.length);
            this.write(231 + count - 1);
            for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
                this.write(rows.length >> shift);
            }
            for (Object obj : rows) {
                this.encodeObject(obj);
            }
        } else {
            this.write(231);
            this.write(1);
            this.encodeObject(arrayValue);
        }
    }

    public void encodeByte(byte value) {
        this.write(150);
        this.write(value);
    }

    public void encodeTimestamp(Timestamp val) throws SQLException {
        if (val == null) {
            this.write(1);
            return;
        }
        long value = val.getTime() / 1000L * 1000000000L;
        int count = this.byteCount(value += (long)val.getNanos());
        if (value >= -10L && value <= 31L) {
            this.write(95 + (int)value);
            return;
        }
        this.write(96 + count - 1);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write((int)(value >> shift));
        }
    }

    public void encodeScaledTimestamp(Timestamp val) throws SQLException {
        if (val == null) {
            this.write(1);
            return;
        }
        int nanos = val.getNanos();
        int scale = 9;
        if (nanos == 0) {
            scale = 0;
        } else {
            int pow = 10;
            while (nanos % pow == 0 && scale > 3) {
                --scale;
                pow *= 10;
            }
        }
        long value = scale == 3 ? val.getTime() : Value.reScale(val.getTime() / 1000L, 0, scale) + Value.reScale(nanos, 9, scale);
        int count = this.byteCount(value);
        this.write(217 + count - 1);
        this.write(scale);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write((int)(value >> shift));
        }
    }

    public void decode() throws SQLException {
        if (this.offset >= this.totalLength) {
            throw new SQLException("buffer overrun running message decode");
        }
        this.offset = this.decode(this.buffer, this.offset);
    }

    public int decode(byte[] source, int sourceOffset) throws SQLException {
        int offset = sourceOffset;
        int code = source[offset++] & 0xFF;
        switch (code) {
            case 1: {
                this.type = 1;
                break;
            }
            case 2: {
                this.type = 15;
                this.bool = true;
                break;
            }
            case 3: {
                this.type = 15;
                this.bool = false;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                this.integer32 = code - 20;
                this.scale = 0;
                this.type = 6;
                break;
            }
            case 52: {
                this.type = 6;
                this.scale = 0;
                this.integer32 = source[offset++];
                break;
            }
            case 53: {
                this.type = 6;
                this.scale = 0;
                this.integer32 = source[offset] << 8 | source[offset + 1] & 0xFF;
                offset += 2;
                break;
            }
            case 54: {
                this.type = 6;
                this.scale = 0;
                this.integer32 = source[offset] << 16 | (source[offset + 1] & 0xFF) << 8 | source[offset + 2] & 0xFF;
                offset += 3;
                break;
            }
            case 55: {
                this.type = 6;
                this.scale = 0;
                this.integer32 = source[offset] << 24 | (source[offset + 1] & 0xFF) << 16 | (source[offset + 2] & 0xFF) << 8 | source[offset + 3] & 0xFF;
                offset += 4;
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                int l = code - 52;
                this.integer64 = source[offset++];
                for (int n = 0; n < l; ++n) {
                    this.integer64 = this.integer64 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.scale = 0;
                this.type = 7;
                break;
            }
            case 60: {
                this.scale = source[offset++];
                this.integer64 = 0L;
                this.type = 8;
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                this.scale = source[offset++];
                int l = code - 61;
                this.integer64 = source[offset++];
                for (int n = 0; n < l; ++n) {
                    this.integer64 = this.integer64 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.type = 8;
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                int l = code - 109;
                this.string = this.getString(source, offset, l);
                offset += l;
                this.type = 5;
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                int count = code - 69;
                int length = source[offset++] & 0xFF;
                for (int n = 0; n < count; ++n) {
                    length = length << 8 | source[offset++] & 0xFF;
                }
                this.string = this.getString(source, offset, length);
                offset += length;
                this.type = 5;
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                int l = code - 149;
                this.bytes = new byte[l];
                System.arraycopy(source, offset, this.bytes, 0, l);
                offset += l;
                this.type = 3;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                int count = code - 73 + 1;
                int l = source[offset++] & 0xFF;
                for (int n = 1; n < count; ++n) {
                    l = l << 8 | source[offset++] & 0xFF;
                }
                this.bytes = new byte[l];
                System.arraycopy(source, offset, this.bytes, 0, l);
                offset += l;
                this.type = 3;
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                int count = code - 77;
                long lvalue = 0L;
                for (int n = 0; n < count; ++n) {
                    lvalue = lvalue << 8 | (long)(source[offset++] & 0xFF);
                }
                this.dbl = Double.longBitsToDouble(lvalue <<= (8 - count) * 8);
                this.type = 9;
                break;
            }
            case 104: {
                this.integer64 = 0L;
                this.scale = 0;
                this.type = 11;
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                int l = code - 105;
                this.integer64 = source[offset++];
                for (int n = 0; n < l; ++n) {
                    this.integer64 = this.integer64 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.scale = 0;
                this.type = 11;
                break;
            }
            case 86: {
                this.integer64 = 0L;
                this.scale = 0;
                this.type = 12;
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                int l = code - 87;
                this.integer64 = source[offset++];
                for (int n = 0; n < l; ++n) {
                    this.integer64 = this.integer64 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.scale = 0;
                this.type = 12;
                break;
            }
            case 95: {
                this.integer64 = 0L;
                this.scale = 0;
                this.type = 13;
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                int l = code - 96;
                this.integer64 = source[offset++];
                for (int n = 0; n < l; ++n) {
                    this.integer64 = this.integer64 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.scale = 0;
                this.type = 13;
                break;
            }
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                this.scale = source[offset++];
                int l = code - 209 + 1;
                this.integer64 = source[offset++];
                for (int n = 1; n < l; ++n) {
                    this.integer64 = this.integer64 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.type = 16;
                break;
            }
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: {
                this.scale = source[offset++];
                int l = code - 201 + 1;
                this.integer64 = source[offset++];
                for (int n = 1; n < l; ++n) {
                    this.integer64 = this.integer64 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.type = 17;
                break;
            }
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: {
                this.scale = source[offset++];
                int l = code - 217 + 1;
                this.integer64 = source[offset++];
                for (int n = 1; n < l; ++n) {
                    this.integer64 = this.integer64 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.type = 18;
                break;
            }
            case 194: {
                this.blobId = 0;
                this.type = 4;
                break;
            }
            case 195: 
            case 196: 
            case 197: 
            case 198: {
                int l = code - 195;
                this.blobId = source[offset++];
                for (int n = 0; n < l; ++n) {
                    this.blobId = this.blobId << 8 | source[offset++] & 0xFF;
                }
                this.type = 4;
                break;
            }
            case 189: {
                this.blobId = 0;
                this.type = 2;
                break;
            }
            case 190: 
            case 191: 
            case 192: 
            case 193: {
                int l = code - 190;
                this.blobId = source[offset++];
                for (int n = 0; n < l; ++n) {
                    this.blobId = this.blobId << 8 | source[offset++] & 0xFF;
                }
                this.type = 2;
                break;
            }
            case 226: {
                this.streamHandle = 0;
                offset = this.decode(source, offset);
                this.streamType = this.intValue();
                offset = this.decode(source, offset);
                this.chunkSize = this.longValue();
                offset = this.decode(source, offset);
                this.streamSize = this.longValue();
                this.type = 19;
                break;
            }
            case 227: 
            case 228: 
            case 229: 
            case 230: {
                int l = code - 227;
                this.streamHandle = source[offset++];
                for (int n = 0; n < l; ++n) {
                    this.streamHandle = this.streamHandle << 8 | source[offset++] & 0xFF;
                }
                offset = this.decode(source, offset);
                this.streamType = this.intValue();
                offset = this.decode(source, offset);
                this.chunkSize = this.longValue();
                offset = this.decode(source, offset);
                this.streamSize = this.longValue();
                this.type = 19;
                break;
            }
            case 199: {
                int sign;
                int length = (source[offset++] & 0xFF) - 1;
                byte scale = source[offset++];
                this.type = 10;
                this.bytes = new byte[length];
                System.arraycopy(source, offset, this.bytes, 0, length);
                offset += length;
                int n = sign = (this.bytes[0] & 0x80) > 0 ? -1 : 1;
                if (sign == -1) {
                    this.bytes[0] = (byte)(this.bytes[0] & 0x7F);
                }
                BigInteger bi = new BigInteger(sign, this.bytes);
                this.bigDecimal = new BigDecimal(bi, scale);
                break;
            }
            case 225: {
                byte scale = source[offset++];
                byte sign = source[offset++];
                int length = source[offset++] & 0xFF;
                this.type = 10;
                this.bytes = new byte[length];
                System.arraycopy(source, offset, this.bytes, 0, length);
                offset += length;
                if (sign == -1) {
                    this.bytes[0] = (byte)(this.bytes[0] & 0x7F);
                } else {
                    sign = 1;
                }
                BigInteger bi = new BigInteger((int)sign, this.bytes);
                this.bigDecimal = new BigDecimal(bi, scale);
                break;
            }
            case 239: {
                int length;
                int scale;
                byte scaleByteCount = source[offset++];
                switch (scaleByteCount) {
                    case 0: {
                        scale = 0;
                        break;
                    }
                    case 1: {
                        scale = source[offset++];
                        break;
                    }
                    case 2: {
                        scale = source[offset] << 8 | source[offset + 1];
                        offset += 2;
                        break;
                    }
                    case 3: {
                        scale = source[offset] << 16 | source[offset + 1] << 8 | source[offset + 2];
                        offset += 3;
                        break;
                    }
                    case 4: {
                        scale = source[offset] << 24 | source[offset + 1] << 16 | source[offset + 2] << 8 | source[offset + 3];
                        offset += 4;
                        break;
                    }
                    default: {
                        throw new SQLException("Unable to decode : " + code);
                    }
                }
                byte sign = source[offset++];
                byte lengthCount = source[offset++];
                switch (lengthCount) {
                    case 0: {
                        length = 0;
                        break;
                    }
                    case 1: {
                        length = source[offset++];
                        break;
                    }
                    case 2: {
                        length = source[offset] << 8 | source[offset + 1];
                        offset += 2;
                        break;
                    }
                    case 3: {
                        length = source[offset] << 16 | source[offset + 1] << 8 | source[offset + 2];
                        offset += 3;
                        break;
                    }
                    case 4: {
                        length = source[offset] << 24 | source[offset + 1] << 16 | source[offset + 2] << 8 | source[offset + 3];
                        offset += 4;
                        break;
                    }
                    default: {
                        throw new SQLException("Unable to decode : " + code);
                    }
                }
                this.type = 10;
                this.bytes = new byte[length];
                System.arraycopy(source, offset, this.bytes, 0, length);
                offset += length;
                if (sign == -1) {
                    this.bytes[0] = (byte)(this.bytes[0] & 0x7F);
                } else {
                    sign = 1;
                }
                BigInteger bi = new BigInteger((int)sign, this.bytes);
                this.bigDecimal = new BigDecimal(bi, scale);
                break;
            }
            case 200: {
                long l1 = source[offset++];
                for (int n = 0; n < 7; ++n) {
                    l1 = l1 << 8 | (long)(source[offset++] & 0xFF);
                }
                long l2 = source[offset++];
                for (int n = 0; n < 7; ++n) {
                    l2 = l2 << 8 | (long)(source[offset++] & 0xFF);
                }
                this.uuid = new UUID(l1, l2);
                this.type = 14;
                break;
            }
            default: {
                this.type = 0;
            }
        }
        this.priorCode = code;
        return offset;
    }

    private int intValue() throws SQLException {
        int value = 0;
        switch (this.type) {
            case 6: {
                value = this.integer32;
                break;
            }
            case 7: {
                value = (int)this.integer64;
                break;
            }
            default: {
                this.throwUnexpectedType("int");
            }
        }
        return value;
    }

    private long longValue() throws SQLException {
        long value = 0L;
        switch (this.type) {
            case 6: {
                value = this.integer32;
                break;
            }
            case 7: {
                value = this.integer64;
                break;
            }
            default: {
                this.throwUnexpectedType("long");
            }
        }
        return value;
    }

    private void throwUnexpectedType(String expected) throws SQLException {
        throw new SQLException(String.format("Expected %s type on message %d, but actual is %s", expected, this.messageType, this.type));
    }

    public String getString() throws SQLException {
        this.decode();
        switch (this.type) {
            case 1: {
                return null;
            }
            case 5: {
                return this.string;
            }
        }
        throw new SQLException("On message type " + this.messageType + ":NuoDB jdbc expected string, got type: " + this.type);
    }

    public UUID getUUId() throws SQLException {
        this.decode();
        switch (this.type) {
            case 14: {
                return this.uuid;
            }
        }
        throw new SQLException("On message type " + this.messageType + ":NuoDB jdbc expected UUID, got type: " + this.type);
    }

    int getInt() throws SQLException {
        this.decode();
        return this.intValue();
    }

    long getLong() throws SQLException {
        this.decode();
        return this.longValue();
    }

    double getDouble() throws SQLException {
        this.decode();
        if (this.type == 9) {
            return this.dbl;
        }
        throw new SQLException("On message type " + this.messageType + ":NuoDB jdbc expected double got type: " + this.type);
    }

    BigDecimal getBigDecimal() throws SQLException {
        this.decode();
        if (this.type == 10) {
            return this.bigDecimal;
        }
        throw new SQLException("On message type " + this.messageType + ":NuoDB jdbc expected BigDecimal got type: " + this.type);
    }

    public boolean getBoolean() throws SQLException {
        this.decode();
        if (this.type == 15) {
            return this.bool;
        }
        throw new SQLException("On message type " + this.messageType + ":NuoDB jdbc expected boolean, got type: " + this.type);
    }

    public byte[] getBytes() throws SQLException {
        this.decode();
        if (this.type == 3) {
            return this.bytes;
        }
        throw new SQLException("On message type " + this.messageType + ":NuoDB jdbc expected bytes, got type: " + this.type);
    }

    public void encodeNull() {
        this.write(1);
    }

    Value getValue() throws SQLException {
        this.decode();
        switch (this.type) {
            case 1: {
                return new ValueNull();
            }
            case 5: {
                return new ValueString(this.string);
            }
            case 3: {
                return new ValueBytes(this.bytes);
            }
            case 8: {
                return new ValueNumber(this.integer64, this.scale);
            }
            case 6: {
                return new ValueInt(this.integer32);
            }
            case 19: {
                return new ValueStream(this.streamHandle, this.streamType, this.chunkSize, this.streamSize);
            }
            case 7: {
                return new ValueLong(this.integer64);
            }
            case 15: {
                return new ValueBoolean(this.bool);
            }
            case 9: {
                return new ValueDouble(this.dbl);
            }
            case 16: {
                long inMillis = Value.reScale(this.integer64, this.scale, 3);
                int nanos = this.getNanos(this.integer64, this.scale);
                return new ValueTime(new NuoDBTime(inMillis, nanos));
            }
            case 11: {
                return new ValueTime(new Time(this.integer64));
            }
            case 17: {
                long inMillis = Value.reScale(this.integer64, this.scale, 3);
                return new ValueDate(new Date(inMillis));
            }
            case 12: {
                return new ValueDate(new Date(this.integer64));
            }
            case 18: {
                long inMillis = Value.reScale(this.integer64, this.scale, 3);
                int nanos = this.getNanos(this.integer64, this.scale);
                Timestamp timestamp = new Timestamp(inMillis);
                timestamp.setNanos(Math.abs(nanos));
                return new ValueTimestamp(timestamp);
            }
            case 13: {
                Timestamp timestamp = new Timestamp(this.integer64 / 1000000L);
                timestamp.setNanos(Math.abs((int)(this.integer64 % 1000000000L)));
                return new ValueTimestamp(timestamp);
            }
            case 10: {
                return new ValueNumber(this.bigDecimal);
            }
        }
        throw new SQLException("On message type " + this.messageType + ":NuoDB jdbc decode value type not yet implemented");
    }

    int getNanos(long number, int scale) {
        if (scale == 0) {
            return 0;
        }
        int power = (int)Math.pow(10.0, scale);
        int temp = (int)(number % (long)power);
        if (temp < 0) {
            temp += power;
        }
        power = (int)Math.pow(10.0, 9 - scale);
        return temp * power;
    }

    public boolean isEndOfMessage() {
        return this.offset >= this.totalLength;
    }

    public void encodeDate(Date date) {
        if (date == null) {
            this.write(1);
            return;
        }
        long value = date.getTime();
        int count = this.byteCount(value);
        this.write(86 + count);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write((int)(value >> shift));
        }
    }

    public void encodeScaledDate(Date date) {
        if (date == null) {
            this.write(1);
            return;
        }
        long value = 0L;
        Calendar cLocal = LOCAL_CALENDAR.get();
        cLocal.setTime(date);
        Calendar cUTC = UTC_CALENDAR.get();
        cUTC.clear();
        cUTC.set(cLocal.get(1), cLocal.get(2), cLocal.get(5));
        value = cUTC.getTimeInMillis();
        int count = this.byteCount(value /= 1000L);
        this.write(201 + count - 1);
        this.write(0);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write((int)(value >> shift));
        }
    }

    public void encodeDouble(double dbl) {
        long value = Double.doubleToLongBits(dbl);
        int count = 8;
        long l = value;
        while ((l & 0xFFL) == 0L && count > 0) {
            --count;
            l >>= 8;
        }
        this.write(85);
        for (int n = 56; n >= 0; n -= 8) {
            this.write((int)(value >> n) & 0xFF);
        }
    }

    public void encodeBigDecimal(BigDecimal bd) {
        BigInteger bi = bd.scale() < 0 ? bd.abs().toBigInteger() : bd.abs().unscaledValue();
        byte[] byteArray = bi.toByteArray();
        if (this.getProtocolVersion() >= 20) {
            int shift;
            this.write(239);
            int val = bd.scale() < 0 ? 0 : bd.scale();
            int count = this.byteCount(val);
            this.write(count);
            for (shift = (count - 1) * 8; shift >= 0; shift -= 8) {
                this.write(val >> shift);
            }
            this.write(bd.compareTo(BigDecimal.ZERO));
            val = byteArray.length;
            count = this.byteCount(val);
            this.write(count);
            for (shift = (count - 1) * 8; shift >= 0; shift -= 8) {
                this.write(val >> shift);
            }
            this.write(byteArray);
        } else {
            this.write(225);
            this.write(bd.scale() < 0 ? 0 : bd.scale());
            this.write(bd.compareTo(BigDecimal.ZERO));
            this.write(byteArray.length);
            this.write(byteArray);
        }
    }

    public void encodeOldBigDecimal(BigDecimal bd) {
        int scale = bd.scale();
        boolean neg = bd.compareTo(BigDecimal.ZERO) == -1;
        BigInteger bi = bd.abs().unscaledValue();
        byte[] byteArray = bi.toByteArray();
        if (neg) {
            byteArray[0] = (byte)(byteArray[0] | 0x80);
        }
        this.write(199);
        this.write(byteArray.length + 1);
        this.write(scale);
        this.write(byteArray);
    }

    public void encodeTime(Time time) throws SQLException {
        int count;
        if (time == null) {
            this.write(1);
            return;
        }
        long milliSecondsSinceMidnight = time.getTime() % 86400000L;
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(time)) {
            milliSecondsSinceMidnight += (long)tz.getDSTSavings();
        }
        if ((count = this.byteCount(milliSecondsSinceMidnight)) > 4) {
            throw new SQLException(MessageFormat.format("Unable to encode \"{0}\".  Need {1} bytes to encode but only have {2} bytes.", time, count, 4));
        }
        this.write(104 + count);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write((int)(milliSecondsSinceMidnight >> shift));
        }
    }

    public void encodeScaledTime(Time time) {
        if (time == null) {
            this.write(1);
            return;
        }
        long value = time.getTime();
        int scale = 3;
        if (time instanceof NuoDBTime) {
            scale = 9;
            value = ((NuoDBTime)time).getTimeInNanos();
        }
        int count = this.byteCount(value);
        this.write(209 + count - 1);
        this.write(scale);
        for (int shift = (count - 1) * 8; shift >= 0; shift -= 8) {
            this.write((int)(value >> shift));
        }
    }

    @Override
    public void getMessage(CryptoInputStream stream) throws IOException {
        this.getMessage(stream, null);
    }

    @Override
    public void getMessage(CryptoInputStream stream, Long maxLength) throws IOException {
        super.getMessage(stream, maxLength);
        this.buffer = this.getBuffer();
        this.offset = 0;
    }

    @Override
    public void setData(byte[] data, int offset, int length) {
        super.setData(data, offset, length);
        this.buffer = this.getBuffer();
        offset = 0;
    }

    @Override
    public int setBase64(char[] data, int dataOffset, int length) {
        int ret = super.setBase64(data, dataOffset, length);
        this.buffer = this.getBuffer();
        this.offset = 0;
        return ret;
    }
}

