/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.agent;

import com.nuodb.agent.IdentityUtils;
import com.nuodb.agent.TLSUtils;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class KeyGenerator {
    public static final String KEY_ALIAS_PROP = "keyAlias";
    public static final String KEYFILE_NAME_PROP = "keyFileName";
    public static final String IDFILE_NAME_PROP = "idFileName";
    public static final String FORCE_PROP = "force";
    public static final String DN_PROP = "dnName";
    private static final Logger logger = Logger.getLogger(KeyGenerator.class.getName());
    private final String keyType;
    private final String keyPass;
    private final String storeAlias;
    private final File keyFile;
    private final File idFile;
    private final boolean override;
    private final String providedDN;

    public KeyGenerator(Properties properties) {
        this.keyType = properties.getProperty("keyStoreType");
        this.keyPass = properties.getProperty("keyStorePassword");
        this.storeAlias = properties.getProperty(KEY_ALIAS_PROP);
        this.override = Boolean.valueOf(properties.getProperty(FORCE_PROP));
        String keyFileName = properties.getProperty(KEYFILE_NAME_PROP);
        String idFileName = properties.getProperty(IDFILE_NAME_PROP);
        Preconditions.checkArgument(this.keyType != null, "%s has to be specified", "keyStoreType");
        Preconditions.checkArgument(this.keyPass != null, "%s has to be specified", "keyStorePassword");
        Preconditions.checkArgument(this.storeAlias != null, "%s has to be specified", KEY_ALIAS_PROP);
        Preconditions.checkArgument(keyFileName != null, "%s has to be specified", KEYFILE_NAME_PROP);
        Preconditions.checkArgument(idFileName != null, "%s has to be specified", IDFILE_NAME_PROP);
        this.keyFile = new File(keyFileName);
        this.idFile = new File(idFileName);
        this.providedDN = properties.getProperty(DN_PROP);
    }

    void writeToDisk(KeyPair keyPair, Certificate cert) throws Exception {
        TLSUtils.writeCertToDisk(this.keyFile, this.keyType, this.keyPass, this.storeAlias, cert, keyPair);
        logger.config("created keystore file " + this.keyFile.getAbsolutePath());
    }

    Tag createHostProvisioningTag(String stableId, String type, String text) {
        Tag message = TagFactory.createTag("HostProvisioning");
        message.addAttribute("version", 1);
        message.addAttribute("stableId", stableId);
        message.addAttribute("format", type);
        message.setText(text);
        return message;
    }

    String generateBase64XMLCertString(Certificate cert, String stableId) throws Exception {
        byte[] rawBytes = cert.getEncoded();
        String base64str = DatatypeConverter.printBase64Binary((byte[])rawBytes);
        Tag message = this.createHostProvisioningTag(stableId, cert.getType(), base64str);
        logger.config(message.toString());
        return DatatypeConverter.printBase64Binary((byte[])message.toString().getBytes());
    }

    Certificate generateCert() throws Exception {
        String certName;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        if (this.providedDN != null) {
            certName = this.providedDN;
        } else {
            String defaultDN;
            UUID randomCN = UUID.randomUUID();
            certName = defaultDN = String.format("CN=%s, O=%s, L=%s, C=%s", randomCN, "NuoDB", "Cambridge", "US");
        }
        X509Certificate cert = TLSUtils.generateCertificate(certName, 365, "SHA1withRSA", keyPair);
        this.writeToDisk(keyPair, cert);
        return cert;
    }

    public String execute() throws Exception {
        String stableId = IdentityUtils.generateStableID(this.idFile, this.override);
        logger.config("stableID: " + stableId);
        Certificate cert = !this.keyFile.exists() || this.override ? this.generateCert() : TLSUtils.readCert(this.keyFile, this.keyType, this.keyPass);
        return this.generateBase64XMLCertString(cert, stableId);
    }
}

