/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.util;

import com.install4j.runtime.launcher.LauncherHelper;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class LauncherUtil {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static final boolean JAVA_9_PLUS = !System.getProperty("java.version").startsWith("1.");
    private static final boolean MACOS = OS_NAME.startsWith("mac");
    private static final boolean WINDOWS = OS_NAME.startsWith("win");
    private static final boolean LINUX = OS_NAME.startsWith("linux");

    public static Properties replaceVariables(Properties properties) {
        Properties replacedProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            String value = LauncherHelper.INSTANCE.replaceVariables((String)entry.getValue());
            replacedProperties.put(name, value);
        }
        return replacedProperties;
    }

    public static boolean isJava9Plus() {
        return JAVA_9_PLUS;
    }

    public static boolean isMacOS() {
        return MACOS;
    }

    public static boolean isLinux() {
        return LINUX;
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static long getPidFromMBean() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            int atPos = name.indexOf(64);
            if (atPos > 0) {
                return Long.parseLong(name.substring(0, atPos));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0L;
    }
}

