/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.beans.actions.registry.PreferencesWriteAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.VariableEncoding;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SaveInstallerVariablesAction
extends PreferencesWriteAction {
    private String[] installerVariables;

    public String[] getInstallerVariables() {
        return SaveInstallerVariablesAction.replaceVariables(this.installerVariables);
    }

    public void setInstallerVariables(String[] installerVariables) {
        this.installerVariables = installerVariables;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        String[] installerVariables = this.getInstallerVariables();
        if (installerVariables == null || installerVariables.length == 0) {
            return false;
        }
        HashMap<String, String> encodedVariables = new HashMap<String, String>();
        for (String variableName : installerVariables) {
            Object variableValue = context.getVariable(variableName);
            if (VariableEncoding.encodeVariable(encodedVariables, variableName, variableValue) || variableValue == null) continue;
            Logger.getInstance().log(this, "The variable " + variableName + " of type " + variableValue.getClass().getName() + " cannot be encoded to a string", false);
            return false;
        }
        return this.executePreferencesWriter(new SaveInstallerVariablesPreferencesWriter(encodedVariables), context);
    }

    private static class SaveInstallerVariablesPreferencesWriter
    implements PreferencesWriteAction.PreferencesWriter {
        private final Map<String, String> encodedVariables;

        public SaveInstallerVariablesPreferencesWriter(Map<String, String> encodedVariables) {
            this.encodedVariables = encodedVariables;
        }

        @Override
        public boolean writeToPreferences(PreferencesAction.PackageNodeProvider packageNodeProvider, Context context, List<PreferencesAction.PreferencesRollbackAction> rollbackActions) {
            for (Map.Entry<String, String> entry : this.encodedVariables.entrySet()) {
                PreferencesWriteAction.writeValue(packageNodeProvider, entry.getKey(), entry.getValue(), rollbackActions);
            }
            return true;
        }
    }
}

