/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.framework.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class UnsafeUtil {
    private static final String JAVA_VERSION = System.getProperty("java.version", "");
    private static final boolean JAVA9_PLUS = !JAVA_VERSION.startsWith("1.");
    public static final Unsafe UNSAFE = UnsafeUtil.initUnsafe();
    private static volatile long overrideFieldOffset = -1L;
    private static volatile Method moduleMethod;
    private static volatile Method isOpenMethod;
    private static volatile Method implAddExportsToAllUnnamed;
    private static volatile Method implAddOpensToAllUnnamed;
    private static volatile Method findModule;
    private static volatile Method optionalGet;
    private static volatile Object bootModuleLayer;

    private static Unsafe initUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject == null) {
            throw new NullPointerException();
        }
        try {
            if (UnsafeUtil.isOpen(accessibleObject)) {
                accessibleObject.setAccessible(true);
            } else {
                UnsafeUtil.unsafeSetAccessible(accessibleObject);
            }
        }
        catch (Throwable t) {
            UnsafeUtil.unsafeSetAccessible(accessibleObject);
        }
    }

    private static boolean isOpen(AccessibleObject accessibleObject) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        if (JAVA9_PLUS && accessibleObject instanceof Member) {
            Class<?> declaringClass = ((Member)((Object)accessibleObject)).getDeclaringClass();
            String packageName = declaringClass.getPackage().getName();
            if (isOpenMethod == null) {
                isOpenMethod = UnsafeUtil.getModuleClass().getMethod("isOpen", String.class);
            }
            return (Boolean)isOpenMethod.invoke(UnsafeUtil.getModule(declaringClass), packageName);
        }
        return true;
    }

    private static void unsafeSetAccessible(AccessibleObject accessibleObject) {
        try {
            if (overrideFieldOffset == -1L) {
                Field overrideField = AccessibleObject.class.getDeclaredField("override");
                overrideFieldOffset = UNSAFE.objectFieldOffset(overrideField);
            }
            UNSAFE.putBoolean(accessibleObject, overrideFieldOffset, true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void addExportsToAllUnnamed(String moduleName, String ... packageNames) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (JAVA9_PLUS) {
            Object optional;
            Object module;
            if (findModule == null) {
                Class<?> moduleLayerClass = Class.forName("java.lang.ModuleLayer");
                bootModuleLayer = moduleLayerClass.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
                findModule = moduleLayerClass.getMethod("findModule", String.class);
                optionalGet = Class.forName("java.util.Optional").getMethod("get", new Class[0]);
            }
            if ((module = optionalGet.invoke(optional = findModule.invoke(bootModuleLayer, moduleName), new Object[0])) != null) {
                UnsafeUtil.addExportsToAllUnnamed(module, packageNames);
            }
        }
    }

    public static void addExportsToAllUnnamed(Class clazz, String ... packageNames) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (JAVA9_PLUS) {
            UnsafeUtil.addExportsToAllUnnamed(UnsafeUtil.getModule(clazz), packageNames);
        }
    }

    private static void addExportsToAllUnnamed(Object module, String[] packageNames) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        if (implAddExportsToAllUnnamed == null) {
            implAddExportsToAllUnnamed = UnsafeUtil.getExportMethod("implAddExportsToAllUnnamed");
        }
        for (String packageName : packageNames) {
            implAddExportsToAllUnnamed.invoke(module, packageName);
        }
    }

    public static void addOpensToAllUnnamed(Class clazz, String ... packageNames) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (JAVA9_PLUS) {
            if (implAddOpensToAllUnnamed == null) {
                implAddOpensToAllUnnamed = UnsafeUtil.getExportMethod("implAddOpensToAllUnnamed");
            }
            Object module = UnsafeUtil.getModule(clazz);
            for (String packageName : packageNames) {
                implAddOpensToAllUnnamed.invoke(module, packageName);
            }
        }
    }

    @NotNull
    private static Method getExportMethod(String implAddExportsToAllUnnamed2) throws NoSuchMethodException, ClassNotFoundException {
        Method implAddExportsToAllUnnamed = UnsafeUtil.getModuleClass().getDeclaredMethod(implAddExportsToAllUnnamed2, String.class);
        UnsafeUtil.setAccessible(implAddExportsToAllUnnamed);
        return implAddExportsToAllUnnamed;
    }

    @NotNull
    private static Class<?> getModuleClass() throws ClassNotFoundException {
        return Class.forName("java.lang.Module");
    }

    @NotNull
    private static Object getModule(Class declaringClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (moduleMethod == null) {
            moduleMethod = Class.class.getMethod("getModule", new Class[0]);
        }
        return moduleMethod.invoke((Object)declaringClass, new Object[0]);
    }
}

