/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.DataRow;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class PGMultiMessagingContextResultSet
extends PGResultSet {
    private int m_numberOfMessagesInResultSet = 1;
    private int m_indexOfCurrentMessage = 0;
    private List<PGMessagingContext> m_contextList = new ArrayList<PGMessagingContext>();
    private long m_totalRowCount = -1L;

    public PGMultiMessagingContextResultSet(List<PGMessagingContext> list, ILogger iLogger) {
        super(list.get(0), iLogger);
        this.m_contextList = list;
        if (1 < this.m_contextList.size()) {
            this.m_numberOfMessagesInResultSet = this.m_contextList.size();
            for (int i = 1; i < this.m_numberOfMessagesInResultSet; ++i) {
                this.m_contextList.get(i).addSocketCloseListener(this);
            }
        }
    }

    @Override
    public boolean moveToNextRow() {
        boolean bl = false;
        try {
            bl = 1 == this.m_numberOfMessagesInResultSet ? super.moveToNextRow() : this.moveToNextRowOnMultipleMessages();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            if (1 == this.m_numberOfMessagesInResultSet) {
                return this.m_currentMessagingContext.m_dataRowCount;
            }
            if (-1L == this.m_totalRowCount) {
                this.m_totalRowCount = 0L;
                for (int i = 0; i < this.m_numberOfMessagesInResultSet; ++i) {
                    this.m_totalRowCount += this.m_contextList.get((int)i).m_dataRowCount;
                }
            }
            return this.m_totalRowCount;
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
    }

    private boolean moveToNextRowOnMultipleMessages() throws ErrorException {
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
            this.m_currentRow = 0L;
        } else {
            ++this.m_currentRow;
        }
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            if (this.getRowCount() > this.getCurrentRow()) {
                if (this.m_currentMessagingContext.peekNextMessage(0) instanceof DataRow) {
                    return this.m_currentMessagingContext.doMoveToNextRow();
                }
                this.m_currentMessagingContext = this.m_contextList.get(++this.m_indexOfCurrentMessage);
                return this.m_currentMessagingContext.doMoveToNextRow();
            }
            return false;
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            throw this.buildError(exception);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        for (PGMessagingContext pGMessagingContext : this.m_contextList) {
            pGMessagingContext.closeOperation();
            pGMessagingContext.removeSocketCloseListener(this);
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_hasStartedFetch = false;
        this.m_currentRow = 0L;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        for (PGMessagingContext pGMessagingContext : this.m_contextList) {
            pGMessagingContext.closeOperation();
            pGMessagingContext.removeSocketCloseListener(this);
        }
    }
}

