/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.JYTaskPane;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.JYTaskPaneUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.SwingXUtilities;

public class BasicJYTaskPaneUI
extends JYTaskPaneUI
implements PropertyChangeListener,
ContainerListener {
    private static final String CONTENT_PANE_DEFAULT_NAME = "JYTaskPane.contentPane";
    protected JYTaskPane taskPane;
    protected JComponent titlePane;
    protected JLabel titleLabel;
    protected JLabel iconLabel;
    protected JButton arrowButton;
    private ArrowIcon arrowIcon;
    private Icon arrowIconHover;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJYTaskPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.taskPane = (JYTaskPane)jComponent;
        if (!(this.taskPane.getTaskPaneLayout() instanceof BorderLayout)) {
            this.taskPane.setTaskPaneLayout(new BorderLayout());
        }
        super.installUI(jComponent);
        this.taskPane.getActionMap().put("toggleCollapsed", new ToggleCollapsedAction());
        if (this.titlePane instanceof TitlePanel) {
            this.titlePane.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "toggleCollapsed");
            this.titlePane.getActionMap().put("toggleCollapsed", new ToggleCollapsedAction());
        }
    }

    protected void installDefaults(JPanel jPanel) {
        this.arrowIcon = new ArrowIcon(false);
        this.arrowIconHover = new ArrowIcon(true);
        if (this.taskPane.getTitlePane() == null) {
            this.taskPane.setTitlePane(this.createTitlePane());
        }
        this.taskPane.addPropertyChangeListener(this);
        this.taskPane.addContainerListener(this);
        this.taskPane.setOpaque(false);
        if (this.taskPane.titleForegroundIsUIResource()) {
            this.taskPane.setTitleForeground(SyntheticaLookAndFeel.getColor("JYTaskPane.titlePane.title.foreground", this.taskPane, UIManager.getColor("TaskPane.titleForeground")), true);
        } else if (this.titleLabel != null && !this.taskPane.titleForegroundIsUIResource() && !this.taskPane.isSpecial()) {
            this.titleLabel.setForeground(this.taskPane.getTitleForeground());
        }
        if (this.taskPane.specialTitleForegroundIsUIResource()) {
            this.taskPane.setSpecialTitleForeground(SyntheticaLookAndFeel.getColor("JYTaskPane.titlePane.title.specialForeground", this.taskPane, UIManager.getColor("TaskPane.specialTitleForeground")), true);
        } else if (this.titleLabel != null && !this.taskPane.specialTitleForegroundIsUIResource() && this.taskPane.isSpecial()) {
            this.titleLabel.setForeground(this.taskPane.getSpecialTitleForeground());
        }
        if (this.taskPane.titleFontIsUIResource()) {
            this.taskPane.setTitleFont((Font)SyntheticaLookAndFeel.get("JYTaskPane.font", this.taskPane), true);
        } else if (this.titleLabel != null) {
            this.titleLabel.setFont(this.taskPane.getTitleFont());
        }
        if (this.taskPane.titlePaneMouseSensitiveIsUIResource()) {
            this.taskPane.setTitlePaneMouseSensitive(SyntheticaLookAndFeel.getBoolean("JYTaskPane.titlePane.mouseSensitive", this.taskPane, true), true);
        }
        if (this.taskPane.animationEnabledIsUIResource()) {
            this.taskPane.setAnimationEnabled(SyntheticaLookAndFeel.getBoolean("JYTaskPane.animation.enabled", this.taskPane, true), true);
        }
        if (this.taskPane.collapsedIconIsUIResource()) {
            this.taskPane.setCollapsedIcon(SyntheticaLookAndFeel.loadIcon("JYTaskPane.titlePane.collapsedIcon", this.taskPane), true);
        }
        if (this.taskPane.expandedIconIsUIResource()) {
            this.taskPane.setExpandedIcon(SyntheticaLookAndFeel.loadIcon("JYTaskPane.titlePane.expandedIcon", this.taskPane), true);
        }
    }

    protected void uninstallDefaults(JPanel jPanel) {
        JComponent jComponent = this.taskPane.getTitlePane();
        if (jComponent instanceof UIResource) {
            this.taskPane.setTitlePane(null);
        }
        this.taskPane.removePropertyChangeListener(this);
        this.taskPane.removeContainerListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
            this.installDefaults((JPanel)jComponent);
        }
        if (!(this.titlePane instanceof TitlePanel)) {
            return;
        }
        if ("title".equals(string)) {
            this.titleLabel.setText("" + propertyChangeEvent.getNewValue());
        } else if ("titleForeground".equals(string) && !this.taskPane.isSpecial() || "specialTitleForeground".equals(string) && this.taskPane.isSpecial()) {
            this.setTitleForeground((Color)propertyChangeEvent.getNewValue());
        } else if ("titleFont".equals(string)) {
            Font font = (Font)propertyChangeEvent.getNewValue();
            this.titleLabel.setFont(font == null ? null : font.deriveFont(font.getStyle()));
        } else if ("mnemonic".equals(propertyChangeEvent.getPropertyName())) {
            SwingXUtilities.updateMnemonicBinding((JComponent)this.taskPane, (String)"toggleCollapsed");
            this.titleLabel.setDisplayedMnemonic((Integer)propertyChangeEvent.getNewValue());
        } else if ("icon".equals(string)) {
            this.iconLabel.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if ("special".equals(string)) {
            this.setTitleForeground(this.taskPane.isSpecial() ? this.taskPane.getSpecialTitleForeground() : this.taskPane.getTitleForeground());
            this.titlePane.repaint();
        } else if ("titlePaneMouseSensitive".equals(string) && this.titlePane instanceof TitlePanel) {
            ((TitlePanel)this.titlePane).setMouseSensitive((Boolean)propertyChangeEvent.getNewValue());
        } else if ("name".equals(string)) {
            this.taskPane.getContentPane().setName("JYTaskPane.contentPane." + propertyChangeEvent.getNewValue());
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof JXCollapsiblePane) {
            this.taskPane.getContentPane().setName(CONTENT_PANE_DEFAULT_NAME);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
    }

    private void setTitleForeground(Color color) {
        this.titleLabel.setForeground(color == null ? null : new Color(color.getRGB()));
    }

    public Component createAction(Action action) {
        JXHyperlink jXHyperlink = new JXHyperlink(action){
            private static final long serialVersionUID = 411631211475663711L;

            public void updateUI() {
                super.updateUI();
                BasicJYTaskPaneUI.this.configureHyperlink(this);
            }
        };
        this.configureHyperlink(jXHyperlink);
        return jXHyperlink;
    }

    protected void configureHyperlink(JXHyperlink jXHyperlink) {
        jXHyperlink.setOpaque(false);
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.taskPane.link.insets", (Component)this.taskPane, new Insets(2, 2, 2, 2));
        jXHyperlink.setBorder((Border)new EmptyBorder(insets));
        jXHyperlink.setBorderPainted(false);
        jXHyperlink.setFocusPainted(true);
        Color color = SyntheticaLookAndFeel.getColor("Synthetica.taskPane.link.foreground", this.taskPane, UIManager.getColor("TaskPane.titleForeground"));
        jXHyperlink.setForeground(color);
    }

    protected JComponent createTitlePane() {
        this.titlePane = new TitlePanel();
        this.titleLabel = new JLabel(this.taskPane.getTitle());
        this.titleLabel.setFocusable(false);
        this.titleLabel.setIconTextGap(0);
        this.titleLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.titleLabel.setDisplayedMnemonic(this.taskPane.getMnemonic());
        this.titleLabel.setName("JYTaskPane.titleLabel");
        this.iconLabel = new JLabel(this.taskPane.getIcon());
        this.iconLabel.setFocusable(false);
        this.iconLabel.setIconTextGap(0);
        this.iconLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.iconLabel.setName("JYTaskPane.iconLabel");
        this.arrowButton = new ArrowButton();
        int n = SyntheticaLookAndFeel.getInt("JYTaskPane.titlePane.gap", this.taskPane, 8);
        this.titlePane.add((Component)this.iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, this.getIconLabelInsets(), 0, 0));
        this.titlePane.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, this.getTitleLabelInsets(n), 0, 0));
        this.titlePane.add((Component)this.arrowButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, this.getArrowButtonInsets(), 0, 0));
        return this.titlePane;
    }

    private Insets getIconLabelInsets() {
        return SyntheticaLookAndFeel.getInsets("JYTaskPane.titlePane.icon.insets", (Component)this.taskPane, false);
    }

    private Insets getTitleLabelInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("JYTaskPane.titlePane.title.insets", (Component)this.taskPane, false);
        return new Insets(insets.top, insets.left + n, insets.bottom, insets.right + n);
    }

    private Insets getArrowButtonInsets() {
        return SyntheticaLookAndFeel.getInsets("JYTaskPane.titlePane.arrowButton.insets", (Component)this.taskPane, new Insets(2, 0, 2, 6));
    }

    protected void paintTitlePaneBackground(Graphics graphics, SyntheticaState syntheticaState, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = this.createTitleShape(n, n2, n3, n4, 4.0f, bl2);
        graphics2D.setPaint(new Color(0xDDDDDD));
        graphics2D.fill(shape);
    }

    protected void paintTitlePaneFocus(Graphics graphics, SyntheticaState syntheticaState, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
    }

    protected void paintArrowIcon(Graphics graphics, SyntheticaState syntheticaState, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = bl2 ? this.createUpShape(n3 / 2, n4 / 2 - 2) : this.createDownShape(n3 / 2, n4 / 2 - 2);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.draw(shape);
    }

    private Shape createTitleShape(float f, float f2, float f3, float f4, float f5, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2 + f4);
        generalPath.lineTo(f, f5 /= 2.0f);
        generalPath.quadTo(f, f2, f + f5, f2);
        generalPath.lineTo(f + f3 - f5, f2);
        generalPath.quadTo(f + f3, f2, f + f3, f2 + f5);
        generalPath.lineTo(f + f3, f2 + f4);
        if (!bl) {
            generalPath.closePath();
        }
        return generalPath;
    }

    private Shape createUpShape(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2 + 3.0f);
        generalPath.lineTo(f + 3.0f, f2);
        generalPath.lineTo(f + 6.0f, f2 + 3.0f);
        generalPath.moveTo(f, f2 + 6.0f);
        generalPath.lineTo(f + 3.0f, f2 + 3.0f);
        generalPath.lineTo(f + 6.0f, f2 + 6.0f);
        return generalPath;
    }

    private Shape createDownShape(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f + 3.0f, f2 + 3.0f);
        generalPath.lineTo(f + 6.0f, f2);
        generalPath.moveTo(f, f2 + 3.0f);
        generalPath.lineTo(f + 3.0f, f2 + 6.0f);
        generalPath.lineTo(f + 6.0f, f2 + 3.0f);
        return generalPath;
    }

    private class ArrowButton
    extends JButton {
        private static final long serialVersionUID = 3382579741465887725L;

        public ArrowButton() {
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setName("JYTaskPane.arrowButton");
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(null);
                    this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.isEnabled() && !this.collapseOnMousePressed()) {
                        ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.setCollapsed(!((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.isCollapsed());
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.isEnabled() && this.collapseOnMousePressed()) {
                        ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.setCollapsed(!((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane.isCollapsed());
                    }
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    this.dispatchMouseEvent(mouseEvent);
                }

                private void dispatchMouseEvent(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & Integer.MIN_VALUE) != 0) {
                        return;
                    }
                    Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.titlePane);
                    MouseEvent mouseEvent2 = new MouseEvent(((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.titlePane, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.titlePane.dispatchEvent(mouseEvent2);
                }

                private boolean collapseOnMousePressed() {
                    return SyntheticaLookAndFeel.getBoolean("JYTaskPane.collapseOnMousePressed", ((ArrowButton)ArrowButton.this).BasicJYTaskPaneUI.this.taskPane, false);
                }
            });
        }

        public Icon getIcon() {
            return super.getIcon() == null ? BasicJYTaskPaneUI.this.arrowIcon : super.getIcon();
        }

        public Icon getRolloverIcon() {
            return super.getRolloverIcon() == null ? BasicJYTaskPaneUI.this.arrowIconHover : super.getRolloverIcon();
        }
    }

    private class ArrowIcon
    implements Icon {
        private boolean hover;

        public ArrowIcon(boolean bl) {
            this.hover = bl;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Icon icon = this.getArrowIcon();
            if (icon == null) {
                SyntheticaState syntheticaState = new SyntheticaState(this.hover && BasicJYTaskPaneUI.this.taskPane.isEnabled() ? SyntheticaState.State.HOVER.toInt() : 0);
                BasicJYTaskPaneUI.this.paintArrowIcon(graphics, syntheticaState, BasicJYTaskPaneUI.this.taskPane.isSpecial(), !BasicJYTaskPaneUI.this.taskPane.isCollapsed(), n, n2, this.getIconWidth(), this.getIconHeight());
            } else {
                icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            Icon icon = this.getArrowIcon();
            return icon == null ? 16 : icon.getIconWidth();
        }

        public int getIconHeight() {
            Icon icon = this.getArrowIcon();
            return icon == null ? 16 : icon.getIconHeight();
        }

        private Icon getArrowIcon() {
            return BasicJYTaskPaneUI.this.taskPane.isCollapsed() ? BasicJYTaskPaneUI.this.taskPane.getCollapsedIcon() : BasicJYTaskPaneUI.this.taskPane.getExpandedIcon();
        }
    }

    private class TitlePanel
    extends JPanel
    implements UIResource {
        private static final long serialVersionUID = -3491688257438764832L;
        private MouseAdapter mouseListener;

        public TitlePanel() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(SyntheticaLookAndFeel.getInsets("JYTaskPane.titlePane.insets", (Component)BasicJYTaskPaneUI.this.taskPane, new Insets(2, 4, 2, 4))));
            this.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent focusEvent) {
                    TitlePanel.this.repaint();
                }

                public void focusGained(FocusEvent focusEvent) {
                    TitlePanel.this.repaint();
                }
            });
            this.mouseListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    this.dispatchMouseEvent(mouseEvent);
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                    BasicJYTaskPaneUI.this.setTitleForeground(this.getTitleColor(true));
                    this.dispatchMouseEvent(mouseEvent);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    mouseEvent.getComponent().setCursor(null);
                    BasicJYTaskPaneUI.this.setTitleForeground(this.getTitleColor(false));
                    this.dispatchMouseEvent(mouseEvent);
                }

                private void dispatchMouseEvent(MouseEvent mouseEvent) {
                    Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.arrowButton);
                    MouseEvent mouseEvent2 = new MouseEvent(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.arrowButton, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() | Integer.MIN_VALUE, point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                    ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.arrowButton.dispatchEvent(mouseEvent2);
                }

                private Color getTitleColor(boolean bl) {
                    Color color;
                    if (!((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.isEnabled()) {
                        bl = false;
                    }
                    Color color2 = ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.titleForegroundIsUIResource() ? SyntheticaLookAndFeel.getColor("TaskPane.titleOver", ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane, this.getHoverColor(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getTitleForeground())) : this.getHoverColor(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getTitleForeground());
                    Color color3 = color = ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.specialTitleForegroundIsUIResource() ? SyntheticaLookAndFeel.getColor("TaskPane.specialTitleOver", ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane, this.getHoverColor(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getSpecialTitleForeground())) : this.getHoverColor(((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getSpecialTitleForeground());
                    Color color4 = ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.isSpecial() ? (bl ? color : ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getSpecialTitleForeground()) : (bl ? color2 : ((TitlePanel)TitlePanel.this).BasicJYTaskPaneUI.this.taskPane.getTitleForeground());
                    return color4;
                }

                private Color getHoverColor(Color color) {
                    return color == null ? Color.BLACK.brighter() : color.brighter();
                }
            };
        }

        public void setMouseSensitive(boolean bl) {
            if (bl) {
                this.addMouseListener(this.mouseListener);
            } else {
                this.removeMouseListener(this.mouseListener);
            }
        }

        protected void paintComponent(Graphics graphics) {
            int n = 0;
            int n2 = 0;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            SyntheticaState syntheticaState = new SyntheticaState();
            BasicJYTaskPaneUI.this.paintTitlePaneBackground(graphics, syntheticaState, BasicJYTaskPaneUI.this.taskPane.isSpecial(), !BasicJYTaskPaneUI.this.taskPane.isCollapsed(), n, n2, n3, n4);
            if (this.hasFocus()) {
                syntheticaState.setState(SyntheticaState.State.FOCUSED);
                BasicJYTaskPaneUI.this.paintTitlePaneFocus(graphics, syntheticaState, BasicJYTaskPaneUI.this.taskPane.isSpecial(), !BasicJYTaskPaneUI.this.taskPane.isCollapsed(), n, n2, n3, n4);
            }
        }
    }

    private class ToggleCollapsedAction
    extends AbstractAction {
        private static final long serialVersionUID = 6975483484274221317L;

        public ToggleCollapsedAction() {
            super("toggleCollapsed");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicJYTaskPaneUI.this.taskPane.setCollapsed(!BasicJYTaskPaneUI.this.taskPane.isCollapsed());
        }

        public boolean isEnabled() {
            return BasicJYTaskPaneUI.this.taskPane.isEnabled();
        }
    }
}

