/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ButtonStyle
extends StyleWrapper {
    private static ButtonStyle instance = new ButtonStyle();

    private ButtonStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        ButtonStyle buttonStyle = new ButtonStyle();
        buttonStyle.setStyle(synthStyle);
        return buttonStyle;
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        JComponent jComponent = synthContext.getComponent();
        if (colorType == ColorType.TEXT_FOREGROUND && !(jComponent.getForeground() instanceof ColorUIResource)) {
            return jComponent.getForeground();
        }
        return super.getColor(synthContext, colorType);
    }

    public Font getFont(SynthContext synthContext) {
        Font font = this.synthStyle.getFont(synthContext);
        JComponent jComponent = synthContext.getComponent();
        String string = "Synthetica.button.font";
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultButton()) {
            string = "Synthetica.button.default.font";
        }
        if (SyntheticaLookAndFeel.get(String.valueOf(string) + ".style", jComponent) != null) {
            float f;
            int n = 0;
            String string2 = SyntheticaLookAndFeel.getString(String.valueOf(string) + ".style", jComponent);
            if (string2.contains("BOLD")) {
                n |= 1;
            }
            if (string2.contains("ITALIC")) {
                n |= 2;
            }
            if ((f = SyntheticaLookAndFeel.scaleFontSize(SyntheticaLookAndFeel.getInt(String.valueOf(string) + ".size", jComponent, 0))) == 0.0f) {
                f = font.getSize2D();
            }
            font = new FontUIResource(font.deriveFont(n, f));
        }
        return font;
    }
}

