/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;

public class SeparatorPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SeparatorPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected SeparatorPainter() {
    }

    public static SeparatorPainter getInstance() {
        return SeparatorPainter.getInstance(null);
    }

    public static SeparatorPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(SeparatorPainter.getPainterClassName(synthContext, SeparatorPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = SeparatorPainter.getInstance(synthContext, SeparatorPainter.class, UI_KEY);
        }
        return (SeparatorPainter)syntheticaComponentPainter;
    }

    public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.getParent() instanceof JPopupMenu || jComponent instanceof JPopupMenu.Separator) {
            Object object;
            int n5;
            int n6;
            Insets insets;
            JPopupMenu jPopupMenu = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, jComponent);
            String string = "Synthetica.popupMenuSeparator";
            string = SyntheticaLookAndFeel.getString(string, jPopupMenu);
            boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.iconSeparator.clip", jPopupMenu, true);
            if (jPopupMenu != null && bl && (SyntheticaLookAndFeel.preservePopupIconSpace(jPopupMenu) || SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu)) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(jPopupMenu)) {
                insets = jPopupMenu.getInsets();
                boolean bl2 = jPopupMenu.getComponentOrientation().isLeftToRight();
                n6 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenuSeparator.iconSeparatorGap", jPopupMenu);
                n5 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.gap", jPopupMenu, 24);
                object = (Integer)jPopupMenu.getClientProperty("Synthetica.menuItem.maxIconWidth");
                if (object != null && (Integer)object > 16) {
                    n5 += (Integer)object - 16;
                }
                int n7 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.width", jPopupMenu, 1);
                int n8 = n5 + n7 + n6 - insets.left;
                n += bl2 ? n8 : 0;
                n3 -= n8;
            }
            Insets insets2 = insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenuSeparator.insets", (Component)jPopupMenu, false);
            n6 = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenuSeparator.horizontalTiled", jPopupMenu)) {
                n6 = 1;
            }
            n5 = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenuSeparator.verticalTiled", jPopupMenu)) {
                n5 = 1;
            }
            object = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets2, n6, n5);
            ((ImagePainter)object).draw();
        }
    }

    public void paintSeparatorForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Insets insets;
        Object object;
        String string = "Synthetica.separator";
        JComponent jComponent = synthContext.getComponent();
        Insets insets2 = synthContext.getStyle().getInsets(synthContext, null);
        Insets insets3 = jComponent.getInsets();
        n3 -= insets3.left + insets3.right - insets2.left - insets2.right;
        n4 -= insets3.top + insets3.bottom - insets2.top - insets2.bottom;
        n += insets3.left - insets2.left;
        n2 += insets3.top - insets2.top;
        boolean bl = jComponent instanceof JToolBar.Separator;
        if (bl) {
            string = String.valueOf(string) + ".toolBar";
        } else if (jComponent.getParent() instanceof JComponent && (((JComponent)jComponent.getParent()).getUIClassID().equals("StatusBarUI") || "StatusBar".equals(SyntheticaLookAndFeel.getStyleName(jComponent.getParent())))) {
            string = String.valueOf(string) + ".statusBar";
        }
        string = String.valueOf(string) + ".image";
        string = n5 == 0 ? String.valueOf(string) + ".x" : String.valueOf(string) + ".y";
        if (bl) {
            object = jComponent.getRootPane().getParent();
            boolean bl2 = true;
            if (object instanceof Window) {
                bl2 = ((Window)object).isActive();
            } else if (object instanceof JInternalFrame) {
                bl2 = ((JInternalFrame)object).isSelected();
            }
            if (!bl2 && SyntheticaLookAndFeel.get(String.valueOf(string) + ".inactive", jComponent) != null) {
                string = String.valueOf(string) + ".inactive";
            }
        }
        object = new UIKey(string, new SyntheticaState(0), "");
        Insets insets4 = insets = (Insets)((UIKey)object).findProperty(synthContext, "insets", true, 2);
        string = SyntheticaLookAndFeel.getString(string, jComponent);
        if (bl) {
            if (string == null) {
                return;
            }
            Image image = imgCache.get(string);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(string)).getImage();
                imgCache.put(string, image);
            }
            this.adjustToolBarSeparatorSize((JToolBar.Separator)jComponent, image.getWidth(null), image.getHeight(null));
        }
        int n7 = bl ? 0 : (Integer)synthContext.getStyle().get(synthContext, "Separator.thickness");
        int n8 = n5 == 0 || bl ? n3 : n7;
        int n9 = n6 = n5 == 1 || bl ? n4 : n7;
        if (string == null) {
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(n, n2, n8, n6);
        } else {
            ImagePainter imagePainter = new ImagePainter(jComponent, 1, 50, 0, 0, graphics, n, n2, n3, n4, string, insets, insets4, 0, 0);
            imagePainter.draw();
        }
    }

    protected void adjustToolBarSeparatorSize(JToolBar.Separator separator, int n, int n2) {
        if (SyntheticaLookAndFeel.getToolbarSeparatorDimension() == null) {
            Serializable serializable;
            int n3 = 0;
            int n4 = 0;
            Component[] componentArray = separator.getParent().getComponents();
            int n5 = componentArray.length;
            int n6 = 0;
            while (n6 < n5) {
                serializable = componentArray[n6];
                if (!(serializable instanceof JToolBar.Separator)) {
                    if (((Component)serializable).getMinimumSize().width > n3) {
                        n3 = ((Component)serializable).getMinimumSize().width;
                    }
                    if (((Component)serializable).getMinimumSize().height > n4) {
                        n4 = ((Component)serializable).getMinimumSize().height;
                    }
                }
                ++n6;
            }
            serializable = null;
            serializable = separator.getOrientation() == 1 ? new DimensionUIResource(n, n4) : new DimensionUIResource(n3, n2);
            if (!((Dimension)serializable).equals(separator.getSize())) {
                separator.setSeparatorSize((Dimension)serializable);
                separator.revalidate();
            }
        }
    }
}

