/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

public class FastVector {
    private Object[] array;
    private int curCount;

    public FastVector() {
        this(5);
    }

    public FastVector(int n) {
        this.array = new Object[n];
    }

    public void addElement(Object object) {
        int n = this.array.length;
        if (n <= this.curCount) {
            Object[] objectArray = new Object[n * 2];
            System.arraycopy(this.array, 0, objectArray, 0, n);
            this.array = objectArray;
        }
        this.array[this.curCount++] = object;
    }

    public Object popElement() {
        return this.array[--this.curCount];
    }

    public Object elementAt(int n) {
        return this.array[n];
    }

    public boolean equals(FastVector fastVector) {
        if (fastVector == null) {
            return false;
        }
        if (this.size() != fastVector.size()) {
            return false;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2 = this.elementAt(i);
            if (object2.equals(object = fastVector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.curCount; ++i) {
            if (this.array[i] != object) continue;
            return i;
        }
        return -1;
    }

    public void setElementAt(Object object, int n) {
        this.array[n] = object;
    }

    public void setSize(int n) {
        this.curCount = n;
    }

    public int size() {
        return this.curCount;
    }

    public void insertAfter(FastVector fastVector, Object object) {
        if (fastVector.curCount == 0) {
            return;
        }
        for (int i = 0; i < this.curCount; ++i) {
            if (this.array[i] != object) continue;
            int n = this.array.length;
            if (n <= this.curCount + fastVector.curCount) {
                int n2 = n * 2;
                if (n2 <= this.curCount + fastVector.curCount) {
                    n2 = this.curCount + fastVector.curCount;
                }
                Object[] objectArray = new Object[n2];
                System.arraycopy(this.array, 0, objectArray, 0, i + 1);
                System.arraycopy(fastVector.array, 0, objectArray, i + 1, fastVector.curCount);
                System.arraycopy(this.array, i + 1, objectArray, i + 1 + fastVector.curCount, this.curCount - i - 1);
                this.array = objectArray;
                this.curCount += fastVector.curCount;
                continue;
            }
            System.arraycopy(this.array, i + 1, this.array, i + 1 + fastVector.curCount, this.curCount - i - 1);
            System.arraycopy(fastVector.array, 0, this.array, i + 1, fastVector.curCount);
            this.curCount += fastVector.curCount;
        }
    }
}

